/*
 * Decompiled with CFR 0.152.
 */
package com.ubalube.scifiaddon.world.gen;

import com.ubalube.scifiaddon.world.gen.WorldGenStructures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenOceanStructures
implements IWorldGenerator {
    public static final WorldGenStructures RIG = new WorldGenStructures("oilrig");
    public static final WorldGenStructures RIGSTANDS = new WorldGenStructures("oilrigstands");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                this.generateStructure(new WorldGenStructures("oilrig"), world, random, chunkX, chunkZ, 500, (Block)Blocks.field_150355_j, BiomeOcean.class);
                break;
            }
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        int z;
        int y;
        int x;
        BlockPos pos;
        Class<?> biome;
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        if (classesList.contains(biome = world.field_73011_w.getBiomeForCoords(pos = new BlockPos(x = chunkX * 16 + random.nextInt(15), y = WorldGenOceanStructures.calculateGenerationHeight(world, x, z = chunkZ * 16 + random.nextInt(15), topBlock), z)).getClass()) && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private static void generateRigLegs(WorldGenerator legs, World world, int x, int y, int z, Random rand) {
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            BlockPos pos = new BlockPos(x, y, z);
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            legs.func_180709_b(world, rand, pos);
            if (block == Blocks.field_150355_j) continue;
            foundGround = true;
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos underpos = new BlockPos(x, y - 1, z);
            if (world.func_180495_p(underpos).func_177230_c() != Blocks.field_150355_j || world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) continue;
            y -= 2;
            foundGround = true;
            break;
        }
        return y;
    }
}

