/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.voxel;

import com.dooglamoo.voxel.noise.NoiseGenerator;
import com.dooglamoo.voxel.noise.NoiseGeneratorPerlin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TerrainTester {
    static Image img;
    static int imgWidth;
    static int imgHeight;

    public static void main(String[] args) {
        JFrame frame = new JFrame("VoxelEngine Terrain Tester");
        frame.setDefaultCloseOperation(3);
        JPanel canvas = new JPanel(){

            @Override
            public void paint(Graphics g) {
                g.drawImage(img, 0, 0, null);
            }
        };
        JScrollPane pane = new JScrollPane(canvas);
        canvas.setPreferredSize(new Dimension(imgWidth, imgHeight));
        frame.getContentPane().add(pane);
        frame.pack();
        frame.setSize(1900, 1000);
        frame.setVisible(true);
        img = canvas.createImage(imgWidth, imgHeight);
        System.out.println("running ...");
        TerrainTester.run();
        System.out.println("finished");
        canvas.repaint();
    }

    private static void run() {
        if (img == null) {
            System.out.println("null image");
            return;
        }
        Graphics g = img.getGraphics();
        Random rand = new Random();
        NoiseGenerator noise1 = new NoiseGeneratorPerlin(rand, 2).setScale(0.001);
        double plateScale = 1.0E-6;
        double liftScale = 1.0E-5;
        double stoneScale = 1.0E-4;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int x = 0; x < imgWidth; ++x) {
            for (int z = 0; z < imgHeight; ++z) {
                double plates = noise1.noise(x, z);
                double noise = plates;
                if (noise > max) {
                    max = noise;
                }
                if (noise < min) {
                    min = noise;
                }
                if ((noise = (noise + 1.0) / 2.0) < 0.0) {
                    noise = 0.0;
                }
                if (noise > 1.0) {
                    noise = 1.0;
                }
                g.setColor(new Color((float)noise, (float)noise, (float)noise));
                g.fillRect(x, z, 1, 1);
            }
        }
        System.out.println("min: " + min);
        System.out.println("max: " + max);
    }

    static {
        imgWidth = 3750;
        imgHeight = 3750;
    }
}

