/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.voxel.data;

import com.dooglamoo.voxel.api.BlockDictionary;
import com.dooglamoo.voxel.api.Terrain;
import com.dooglamoo.voxel.api.TerrainFeatureDictionary;
import com.dooglamoo.voxel.api.World;

public class FlatTerrain
implements Terrain {
    private BlockDictionary dict;
    private int chunkSizeX;
    private int chunkSizeY;
    private int chunkSizeZ;

    @Override
    public void initialize(World world, String Options, int chunkSizeX, int chunkSizeY, int chunkSizeZ, BlockDictionary blockDict, TerrainFeatureDictionary featureDict) {
        this.chunkSizeX = chunkSizeX;
        this.chunkSizeY = chunkSizeY;
        this.chunkSizeZ = chunkSizeZ;
        this.dict = blockDict;
    }

    @Override
    public void generateChunk(World world, int blockX, int blockY, int blockZ) {
        if (world == null) {
            return;
        }
        if (blockY >= 0 && blockY < this.chunkSizeY) {
            for (int x = 0; x < this.chunkSizeX; ++x) {
                for (int z = 0; z < this.chunkSizeZ; ++z) {
                    world.setBlock(blockX + x, 0, blockZ + z, this.dict.getBlock("bedrock").getId(), false);
                    world.setBlock(blockX + x, 1, blockZ + z, this.dict.getBlock("dirt").getId(), false);
                    world.setBlock(blockX + x, 2, blockZ + z, this.dict.getBlock("grass").getId(), false);
                }
            }
        }
    }

    @Override
    public void populateChunk(World world, int blockX, int blockY, int blockZ) {
    }

    @Override
    public void getSpawn(int[] position) {
        position[1] = 16;
    }
}

