/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.voxel.data;

import java.util.Random;

public class ImprovedNoiseRandom {
    private int[] p = new int[512];
    private static final double[] hashSignX = new double[]{1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0};
    private static final double[] hashSignY = new double[]{1.0, 1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0};
    private static final double[] hashSignZ = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, -1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 0.0, 1.0, 0.0, -1.0};

    public ImprovedNoiseRandom(Random rand) {
        int i = 0;
        while (i < 256) {
            this.p[i] = i++;
        }
        for (i = 0; i < 256; ++i) {
            int j = rand.nextInt(256 - i) + i;
            int k = this.p[i];
            this.p[i] = this.p[j];
            this.p[j] = k;
            this.p[i + 256] = this.p[i];
        }
    }

    public final double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    public final double grad(int hash, double x, double z) {
        int h = hash & 0xF;
        return hashSignX[h] * x + hashSignZ[h] * z;
    }

    public final double grad(int hash, double x, double y, double z) {
        int h = hash & 0xF;
        return hashSignX[h] * x + hashSignY[h] * y + hashSignZ[h] * z;
    }

    public double noise(double x, double y, double z) {
        int X = (int)Math.floor(x) & 0xFF;
        int Y = (int)Math.floor(y) & 0xFF;
        int Z = (int)Math.floor(z) & 0xFF;
        x -= Math.floor(x);
        y -= Math.floor(y);
        z -= Math.floor(z);
        double u = ImprovedNoiseRandom.fade(x);
        double v = ImprovedNoiseRandom.fade(y);
        double w = ImprovedNoiseRandom.fade(z);
        int A = this.p[X] + Y;
        int AA = this.p[A] + Z;
        int AB = this.p[A + 1] + Z;
        int B = this.p[X + 1] + Y;
        int BA = this.p[B] + Z;
        int BB = this.p[B + 1] + Z;
        return this.lerp(w, this.lerp(v, this.lerp(u, this.grad(this.p[AA], x, y, z), this.grad(this.p[BA], x - 1.0, y, z)), this.lerp(u, this.grad(this.p[AB], x, y - 1.0, z), this.grad(this.p[BB], x - 1.0, y - 1.0, z))), this.lerp(v, this.lerp(u, this.grad(this.p[AA + 1], x, y, z - 1.0), this.grad(this.p[BA + 1], x - 1.0, y, z - 1.0)), this.lerp(u, this.grad(this.p[AB + 1], x, y - 1.0, z - 1.0), this.grad(this.p[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }

    private static double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }
}

