/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.voxel.data;

import java.util.Random;

public class TiledPerlinNoise {
    private int[] perm = new int[1024];

    public TiledPerlinNoise(long seed) {
        Random rand = new Random(seed);
        for (int i = 0; i < 512; ++i) {
            int p;
            int n = p = rand.nextInt() & 0x1FF;
            this.perm[i + 512] = n;
            this.perm[i] = n;
        }
    }

    public double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    public int wrap(int x, int m) {
        return (x % m + m) % m;
    }

    public double grad(int hash, double x, double y) {
        switch (hash & 0xF) {
            case 0: {
                return x + y;
            }
            case 1: {
                return -x + y;
            }
            case 2: {
                return x - y;
            }
            case 3: {
                return -x - y;
            }
            case 4: {
                return x + 1.0;
            }
            case 5: {
                return -x + 1.0;
            }
            case 6: {
                return x - 1.0;
            }
            case 7: {
                return -x - 1.0;
            }
            case 8: {
                return y + 1.0;
            }
            case 9: {
                return -y + 1.0;
            }
            case 10: {
                return y - 1.0;
            }
            case 11: {
                return -y - 1.0;
            }
            case 12: {
                return y + x;
            }
            case 13: {
                return -y + 1.0;
            }
            case 14: {
                return y - x;
            }
            case 15: {
                return -y - 1.0;
            }
        }
        return 0.0;
    }

    public double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    public double noise(double wrapSize, double scale, double x, double y) {
        int gridSize = (int)Math.max(1L, Math.round(wrapSize * scale));
        scale = (double)gridSize / wrapSize;
        int X = (int)Math.floor(x *= scale);
        int Y = (int)Math.floor(y *= scale);
        double u = this.fade(x -= (double)X);
        double v = this.fade(y -= (double)Y);
        int X0 = 0x1FF & this.wrap(X, gridSize);
        int X1 = 0x1FF & this.wrap(X + 1, gridSize);
        int Y0 = 0x1FF & this.wrap(Y, gridSize);
        int Y1 = 0x1FF & this.wrap(Y + 1, gridSize);
        int AA = this.perm[this.perm[X0] + Y0];
        int AB = this.perm[this.perm[X0] + Y1];
        int BA = this.perm[this.perm[X1] + Y0];
        int BB = this.perm[this.perm[X1] + Y1];
        double ret = this.lerp(v, this.lerp(u, this.grad(AA, x, y), this.grad(BA, x - 1.0, y)), this.lerp(u, this.grad(AB, x, y - 1.0), this.grad(BB, x - 1.0, y - 1.0))) * 0.85;
        return ret;
    }

    public double octavedNoise(double x, double y, int octaves, double roughness, double scale) {
        double noiseSum = 0.0;
        double layerFrequency = scale;
        double layerWeight = 1.0;
        double weightSum = 0.0;
        for (int octave = 0; octave < octaves; ++octave) {
            noiseSum += this.noise(3750.0, layerFrequency, x, y) * layerWeight;
            layerFrequency *= 2.0;
            weightSum += layerWeight;
            layerWeight *= roughness;
        }
        double ret = noiseSum / weightSum;
        return ret;
    }
}

