/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.voxel.data;

import com.dooglamoo.voxel.api.Block;
import com.dooglamoo.voxel.api.BlockDictionary;
import com.dooglamoo.voxel.api.Terrain;
import com.dooglamoo.voxel.api.TerrainFeature;
import com.dooglamoo.voxel.api.TerrainFeatureDictionary;
import com.dooglamoo.voxel.api.World;
import com.dooglamoo.voxel.data.ImprovedNoiseRandom;
import com.dooglamoo.voxel.noise.NoiseGenerator;
import com.dooglamoo.voxel.noise.NoiseGeneratorPerlin;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

public class VoxelTerrain
implements Terrain {
    public static final double LOG2 = Math.log(2.0);
    public static final int TEMP_COLD = 0;
    public static final int TEMP_COOL = 16384;
    public static final int TEMP_WARM = 32768;
    public static final int TEMP_HOT = 49152;
    public static final int TEMP_MASK = 49152;
    public static final int PRECIP_DRY = 0;
    public static final int PRECIP_MOIST = 4096;
    public static final int PRECIP_HUMID = 8192;
    public static final int PRECIP_WET = 12288;
    public static final int PRECIP_MASK = 12288;
    public static final int LIFT_SUNK = 0;
    public static final int LIFT_LEVEL = 1024;
    public static final int LIFT_HILLS = 2048;
    public static final int LIFT_MOUNTAINS = 3072;
    public static final int LIFT_MASK = 3072;
    public static final int EROSION_NONE = 0;
    public static final int EROSION_SOME = 256;
    public static final int EROSION_MOST = 512;
    public static final int EROSION_FULL = 768;
    public static final int EROSION_MASK = 768;
    public static final int THERMAL_NONE = 0;
    public static final int THERMAL_SOME = 64;
    public static final int THERMAL_MOST = 128;
    public static final int THERMAL_FULL = 192;
    public static final int THERMAL_MASK = 192;
    public static final int AGE_YOUNGEST = 0;
    public static final int AGE_YOUNG = 16;
    public static final int AGE_OLD = 32;
    public static final int AGE_OLDEST = 48;
    public static final int AGE_MASK = 48;
    public static final int PLATES_OCEAN = 0;
    public static final int PLATES_SHALLOWS = 4;
    public static final int PLATES_PLAINS = 8;
    public static final int PLATES_PLATEAU = 12;
    public static final int PLATES_MASK = 12;
    public static final int ROCK_SEDIMENTARY = 0;
    public static final int ROCK_SOFT = 1;
    public static final int ROCK_HARD = 2;
    public static final int ROCK_IGNEOUS = 3;
    public static final int ROCK_MASK = 3;
    private static final long ME_OFFSET_X = 824L;
    private static final long ME_OFFSET_Y = 732L;
    private static final long SHIRE = 3539053052636L;
    private static final long MORDOR = 6313601926252L;
    private static final long MISTY_MNTS = 4934917424021L;
    private static final long NORTH = 3182570766665L;
    private static final long RAUROS = 5815385719918L;
    private static final long MORIA_WEST = 4870492914536L;
    private static final long ISENGARD = 4737348928541L;
    private static final long GONDOR = 6098853561567L;
    private static final long LONELY_MNT = 6292127089250L;
    private TerrainFeatureDictionary featureDict;
    private BlockDictionary blockDict;
    private Random rand;
    private int chunkSizeX;
    private int chunkSizeY;
    private int chunkSizeZ;
    public ImprovedNoiseRandom noiseGen;
    public NoiseGenerator noiseGen7;
    public NoiseGenerator noiseGen1;
    public NoiseGenerator noiseGen2;
    public NoiseGenerator noiseGen3;
    public NoiseGenerator noiseGen4;
    public NoiseGenerator noiseGen5;
    public NoiseGenerator noiseGen6;
    public NoiseGenerator noiseGen8;
    public NoiseGenerator noiseGen9;
    private String options;
    private Properties properties;
    private static Map<Integer, List<Material>> blocks = new HashMap<Integer, List<Material>>();
    private static Map<Integer, List<Material>> features = new HashMap<Integer, List<Material>>();

    private TerrainFeature getFeature(String name, String options) {
        return this.featureDict.getTerrainFeature(this.blockDict, this.rand, name, options);
    }

    @Override
    public void initialize(World world, String options, int chunkSizeX, int chunkSizeY, int chunkSizeZ, BlockDictionary blockDict, TerrainFeatureDictionary featureDict) {
        this.rand = new Random(world.getSeed());
        this.chunkSizeX = chunkSizeX;
        this.chunkSizeY = chunkSizeY;
        this.chunkSizeZ = chunkSizeZ;
        this.blockDict = blockDict;
        this.featureDict = featureDict;
        this.noiseGen = new ImprovedNoiseRandom(this.rand);
        this.noiseGen7 = new NoiseGeneratorPerlin(this.rand, 5).setScale(0.05);
        this.noiseGen1 = new NoiseGeneratorPerlin(this.rand, 5).setScale(5.0E-5);
        this.noiseGen2 = new NoiseGeneratorPerlin(this.rand, 2).setScale(6.0E-4);
        this.noiseGen3 = new NoiseGeneratorPerlin(this.rand, 6).setScale(0.004);
        this.noiseGen4 = new NoiseGeneratorPerlin(this.rand, 3).setScale(1.0E-4);
        this.noiseGen5 = new NoiseGeneratorPerlin(this.rand, 4).setScale(5.0E-4);
        this.noiseGen6 = new NoiseGeneratorPerlin(this.rand, 5).setScale(0.006);
        this.noiseGen8 = new NoiseGeneratorPerlin(this.rand, 2).setScale(2.0E-4);
        this.noiseGen9 = new NoiseGeneratorPerlin(this.rand, 2).setScale(2.0E-4);
        new Material(blockDict.getBlock("snow").getId()).maxTemp(0).minPrecip(8192).minPlates(8).encode();
        new Material(blockDict.getBlock("ice").getId()).maxTemp(0).minPrecip(8192).maxThermal(64).encode();
        new Material(blockDict.getBlock("ice_packed").getId()).maxTemp(0).minPrecip(8192).maxThermal(64).minAge(32).encode();
        new Material(blockDict.getBlock("grass").getId()).minTemp(16384).minPrecip(4096).minAge(16).encode();
        new Material(blockDict.getBlock("water").getId()).minTemp(16384).minPrecip(12288).maxLift(0).maxErosion(0).encode();
        new Material(blockDict.getBlock("dirt_podzol").getId()).minAge(32).minPrecip(8192).encode();
        new Material(blockDict.getBlock("mycelium").getId()).minAge(32).maxPlates(4).minPrecip(12288).minTemp(32768).encode();
        new Material(blockDict.getBlock("dirt").getId()).maxTemp(16384).minPrecip(8192).minAge(48).encode();
        new Material(blockDict.getBlock("dirt_coarse").getId()).maxTemp(16384).minPrecip(4096).minAge(32).encode();
        new Material(blockDict.getBlock("sand").getId()).maxPrecip(4096).minTemp(32768).encode();
        new Material(blockDict.getBlock("sand_red").getId()).minAge(32).maxPrecip(0).minTemp(32768).minThermal(128).encode();
        new Material(blockDict.getBlock("obsidian").getId()).minThermal(192).encode();
        new Material(blockDict.getBlock("gravel").getId()).maxAge(16).maxTemp(16384).minLift(2048).maxPrecip(4096).encode();
        new Material(this.getFeature("tree_oak", null), 0.01f).minPrecip(8192).minTemp(32768).encode();
        new Material(this.getFeature("tree_birch", null), 0.005f).minPrecip(8192).maxPrecip(8192).minTemp(16384).encode();
        new Material(this.getFeature("tree_spruce", null), 0.03f).minPrecip(8192).maxPrecip(8192).maxTemp(16384).minLift(2048).encode();
        new Material(this.getFeature("tree_spruce_tall", null), 0.02f).minPrecip(8192).maxPrecip(8192).maxTemp(16384).minLift(2048).encode();
        new Material(this.getFeature("tree_acacia", null), 5.0E-4f).minPrecip(4096).maxPrecip(4096).minTemp(32768).encode();
        new Material(this.getFeature("tree_oak_dark", null), 0.03f).minPrecip(8192).maxPrecip(8192).minTemp(32768).minAge(32).encode();
        new Material(this.getFeature("tree_jungle_mega", null), 0.04f).minPrecip(12288).minTemp(49152).minAge(48).encode();
        new Material(this.getFeature("tree_jungle", null), 0.03f).minPrecip(8192).minTemp(49152).encode();
        new Material(this.getFeature("tree_jungle", "vines"), 0.03f).minPrecip(12288).minTemp(49152).minAge(32).encode();
        new Material(this.getFeature("shrub_jungle", null), 0.05f).minPrecip(12288).minTemp(49152).minAge(32).encode();
        new Material(this.getFeature("tree_oak_swamp", null), 0.01f).minPrecip(12288).minTemp(16384).maxLift(0).encode();
        new Material(this.getFeature("tree_spruce_mega", null), 0.02f).minPrecip(8192).maxPrecip(8192).maxTemp(16384).minAge(48).encode();
        new Material(this.getFeature("tree_oak_big", null), 1.0E-5f).minPrecip(4096).maxTemp(32768).minAge(32).encode();
        new Material(this.getFeature("grass", null), 0.03f).minPrecip(4096).maxPrecip(8192).minTemp(16384).maxTemp(32768).maxLift(2048).encode();
        new Material(this.getFeature("fern", null), 0.03f).minPrecip(8192).maxPrecip(12288).minTemp(16384).maxLift(2048).minAge(32).encode();
        new Material(this.getFeature("cactus", null), 5.0E-4f).maxPrecip(0).minTemp(32768).encode();
        new Material(this.getFeature("bush_dead", null), 0.005f).maxPrecip(0).encode();
        new Material(this.getFeature("blob", null), 0.008f).minPrecip(8192).minLift(2048).minRock(1).encode();
        new Material(this.getFeature("reed", null), 0.03f).minTemp(32768).maxLift(1024).encode();
        new Material(this.getFeature("flower", String.valueOf(blockDict.getBlock("flower_dandelion").getId())), 0.001f).minLift(1024).maxLift(1024).encode();
        new Material(this.getFeature("waterlily", null), 0.003f).minTemp(32768).minPrecip(12288).maxLift(1024).minAge(32).encode();
        new Material(this.getFeature("flower", String.valueOf(blockDict.getBlock("flower_tulip_white").getId())), 5.0E-4f).maxTemp(0).encode();
        new Material(this.getFeature("flower", String.valueOf(blockDict.getBlock("flower_tulip_pink").getId())), 5.0E-4f).minTemp(16384).maxTemp(16384).encode();
        new Material(this.getFeature("flower", String.valueOf(blockDict.getBlock("flower_tulip_orange").getId())), 5.0E-4f).minTemp(32768).maxTemp(32768).encode();
        new Material(this.getFeature("flower", String.valueOf(blockDict.getBlock("flower_tulip_red").getId())), 5.0E-4f).minTemp(49152).encode();
        new Material(this.getFeature("flower", String.valueOf(blockDict.getBlock("flower_oxeye_daisy").getId())), 5.0E-4f).minPrecip(8192).maxPrecip(8192).encode();
        new Material(this.getFeature("flower", String.valueOf(blockDict.getBlock("flower_orchid_blue").getId())), 5.0E-4f).minPrecip(12288).encode();
        new Material(this.getFeature("flower", String.valueOf(blockDict.getBlock("flower_allium").getId())), 5.0E-4f).maxLift(0).encode();
        new Material(this.getFeature("flower", String.valueOf(blockDict.getBlock("flower_poppy").getId())), 5.0E-4f).minLift(2048).maxLift(2048).encode();
        new Material(this.getFeature("pumpkin", null), 2.0E-5f).minThermal(64).maxThermal(64).encode();
        new Material(this.getFeature("melon", null), 2.0E-5f).minThermal(128).maxThermal(128).encode();
        new Material(this.getFeature("flower", String.valueOf(blockDict.getBlock("flower_azure_bluet").getId())), 5.0E-4f).minAge(16).maxAge(16).encode();
        new Material(this.getFeature("mushroom_red", null), 6.0E-5f).minAge(32).maxAge(32).encode();
        new Material(this.getFeature("mushroom_brown", null), 6.0E-5f).minAge(48).encode();
        new Material(this.getFeature("rock", "sandstone"), 8.0E-6f).maxRock(0).encode();
        new Material(this.getFeature("rock", "stone"), 8.0E-6f).maxRock(1).minRock(1).encode();
        new Material(this.getFeature("rock", "stone_granite"), 8.0E-6f).maxRock(2).minRock(2).encode();
        new Material(this.getFeature("rock", "stone_diorite"), 8.0E-6f).minRock(3).encode();
        new Material(this.getFeature("rock", "ice_packed"), 1.0E-5f).maxTemp(0).encode();
        new Material(this.getFeature("flint", null), 5.0E-4f).encode();
        new Material(this.getFeature("wheat", null), 5.0E-4f).minTemp(16384).maxTemp(32768).minPrecip(4096).maxPrecip(4096).encode();
        new Material(this.getFeature("potato", null), 5.0E-4f).maxTemp(16384).minPrecip(4096).maxPrecip(8192).encode();
        new Material(this.getFeature("tomato", null), 5.0E-4f).minTemp(32768).minPrecip(4096).maxPrecip(8192).encode();
        new Material(this.getFeature("grape", null), 5.0E-4f).minTemp(16384).maxTemp(16384).maxPrecip(4096).encode();
        new Material(this.getFeature("blueberry", null), 2.0E-4f).maxTemp(16384).minPrecip(8192).encode();
        new Material(this.getFeature("cantaloupe", null), 5.0E-4f).minTemp(49152).minPrecip(4096).maxPrecip(8192).encode();
        new Material(this.getFeature("corn", null), 5.0E-4f).minTemp(32768).maxTemp(32768).minPrecip(4096).maxPrecip(8192).encode();
        new Material(this.getFeature("rhubarb", null), 2.0E-4f).maxTemp(16384).minPrecip(8192).encode();
        new Material(this.getFeature("rice", null), 5.0E-4f).minTemp(32768).minPrecip(12288).maxLift(1024).encode();
        new Material(this.getFeature("soybean", null), 5.0E-4f).minTemp(16384).maxTemp(32768).minPrecip(4096).maxPrecip(8192).encode();
        new Material(this.getFeature("mushroom_white", null), 5.0E-4f).minTemp(16384).maxTemp(32768).minPrecip(8192).encode();
        new Material(this.getFeature("tree_almond", null), 1.0E-5f).maxPrecip(4096).minTemp(16384).maxTemp(32768).encode();
        new Material(this.getFeature("tree_apple", null), 2.0E-5f).minTemp(32768).maxTemp(32768).minPrecip(8192).maxPrecip(8192).encode();
        new Material(this.getFeature("tree_banana", null), 8.0E-5f).minTemp(32768).minPrecip(12288).encode();
        new Material(this.getFeature("tree_coconut", null), 8.0E-5f).minTemp(32768).minPrecip(12288).maxPlates(8).encode();
        new Material(this.getFeature("tree_fig", null), 1.0E-5f).minTemp(49152).maxPrecip(4096).maxLift(1024).encode();
        new Material(this.getFeature("tree_olive", null), 1.0E-5f).minTemp(32768).maxPrecip(0).encode();
        new Material(this.getFeature("tree_lemon", null), 2.0E-5f).minTemp(49152).minPrecip(8192).encode();
        this.options = options != null ? options : "";
        this.properties = new Properties();
        if (this.options.startsWith("properties")) {
            try {
                this.properties.load(new StringReader(this.options));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private final double surface(int x, int z) {
        return this.noiseGen7.noise(x, z);
    }

    private final double temperature(int x, int z) {
        return this.noiseGen8.noise(x, z);
    }

    private final double precipitation(int x, int z) {
        return this.noiseGen9.noise(x, z);
    }

    private final double uplift(int x, int z) {
        return this.noiseGen3.noise(x, z);
    }

    private final double erosion(int x, int z) {
        return this.noiseGen6.noise(x, z);
    }

    private final double geothermal(int x, int z) {
        return this.noiseGen4.noise(x, z);
    }

    private final double age(int x, int z) {
        return this.noiseGen5.noise(x, z);
    }

    private final double plates(int x, int z) {
        return this.noiseGen1.noise(x, z);
    }

    private final double rock(int x, int z) {
        return this.noiseGen2.noise(x, z);
    }

    @Override
    public void getSpawn(int[] position) {
        int surfaceElev = 0;
        double tempMin = -1024.0;
        double tempMax = 1024.0;
        double precipMin = -1024.0;
        double precipMax = 1024.0;
        double liftMin = -1024.0;
        double liftMax = 1024.0;
        double erosionMin = -1024.0;
        double erosionMax = 1024.0;
        double thermalMin = -1024.0;
        double thermalMax = 1024.0;
        double ageMin = -1024.0;
        double ageMax = 1024.0;
        double plateMin = -1024.0;
        double plateMax = 1024.0;
        double rockMin = -1024.0;
        double rockMax = 1024.0;
        double elevMin = -1024.0;
        double elevMax = 1024.0;
        try {
            tempMin = Double.parseDouble(this.properties.getProperty("tempMin", String.valueOf(-1024.0)));
            tempMax = Double.parseDouble(this.properties.getProperty("tempMax", String.valueOf(1024.0)));
            precipMin = Double.parseDouble(this.properties.getProperty("precipMin", String.valueOf(-1024.0)));
            precipMax = Double.parseDouble(this.properties.getProperty("precipMax", String.valueOf(1024.0)));
            liftMin = Double.parseDouble(this.properties.getProperty("liftMin", String.valueOf(-1024.0)));
            liftMax = Double.parseDouble(this.properties.getProperty("liftMax", String.valueOf(1024.0)));
            erosionMin = Double.parseDouble(this.properties.getProperty("erosionMin", String.valueOf(-1024.0)));
            erosionMax = Double.parseDouble(this.properties.getProperty("erosionMax", String.valueOf(1024.0)));
            thermalMin = Double.parseDouble(this.properties.getProperty("thermalMin", String.valueOf(-1024.0)));
            thermalMax = Double.parseDouble(this.properties.getProperty("thermalMax", String.valueOf(1024.0)));
            ageMin = Double.parseDouble(this.properties.getProperty("ageMin", String.valueOf(-1024.0)));
            ageMax = Double.parseDouble(this.properties.getProperty("ageMax", String.valueOf(1024.0)));
            plateMin = Double.parseDouble(this.properties.getProperty("plateMin", String.valueOf(plateMin)));
            plateMax = Double.parseDouble(this.properties.getProperty("plateMax", String.valueOf(plateMax)));
            rockMin = Double.parseDouble(this.properties.getProperty("rockMin", String.valueOf(-1024.0)));
            rockMax = Double.parseDouble(this.properties.getProperty("rockMax", String.valueOf(1024.0)));
            elevMin = Double.parseDouble(this.properties.getProperty("elevMin", String.valueOf(-1024.0)));
            elevMax = Double.parseDouble(this.properties.getProperty("elevMax", String.valueOf(1024.0)));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (plateMin == -1024.0 && plateMax == 1024.0) {
            plateMin = -0.1;
            plateMax = 0.4;
        }
        for (int i = 0; i < 80192; ++i) {
            long xSpawn = Long.MAX_VALUE;
            long ySpawn = Long.MAX_VALUE;
            if (this.options.equals("shire")) {
                xSpawn = 824L;
                ySpawn = 732L;
            } else if (this.options.equals("mordor")) {
                xSpawn = 1470L;
                ySpawn = 1132L;
            } else if (this.options.equals("misty mountains")) {
                xSpawn = 1149L;
                ySpawn = 917L;
            } else if (this.options.equals("north")) {
                xSpawn = 741L;
                ySpawn = 329L;
            } else if (this.options.equals("rauros")) {
                xSpawn = 1354L;
                ySpawn = 1134L;
            } else if (this.options.equals("moria west gate")) {
                xSpawn = 1134L;
                ySpawn = 872L;
            } else if (this.options.equals("isengard")) {
                xSpawn = 1103L;
                ySpawn = 1053L;
            } else if (this.options.equals("gondor")) {
                xSpawn = 1420L;
                ySpawn = 1247L;
            } else if (this.options.equals("lonely mountain")) {
                xSpawn = 1465L;
                ySpawn = 610L;
            }
            if (xSpawn != Long.MAX_VALUE) {
                position[0] = (int)((xSpawn - 824L) * 100L & 0xFFFFFFFFL);
                position[2] = (int)((ySpawn - 732L) * 100L & 0xFFFFFFFFL);
            } else {
                position[0] = this.rand.nextInt(65536) - 32768;
                position[2] = this.rand.nextInt(65536) - 32768;
            }
            double plate = this.plates(position[0], position[2]);
            double rock = this.rock(position[0], position[2]);
            double lift = this.uplift(position[0], position[2]);
            double thermal = this.geothermal(position[0], position[2]);
            double age = this.age(position[0], position[2]);
            double erosion = this.erosion(position[0], position[2]);
            double temperature = this.temperature(position[0], position[2]);
            double percipitation = this.precipitation(position[0], position[2]);
            double surface = this.surface(position[0], position[2]);
            surfaceElev = this.getSurfaceElevation(plate, rock, lift, age, erosion, surface);
            if (temperature >= tempMin && temperature <= tempMax && percipitation >= precipMin && percipitation <= precipMax && lift >= liftMin && lift <= liftMax && erosion >= erosionMin && erosion <= erosionMax && thermal >= thermalMin && thermal <= thermalMax && age >= ageMin && age <= ageMax && plate >= plateMin && plate <= plateMax && rock >= rockMin && rock <= rockMax && (double)surfaceElev >= elevMin && (double)surfaceElev <= elevMax) break;
        }
        position[1] = surfaceElev >= 0 ? surfaceElev + 32 : 32;
    }

    private int getSurfaceElevation(double plate, double rock, double lift, double age, double erosion, double surface) {
        double erosionFactor;
        int surfaceDepth = (int)((surface + 1.0) * (lift > -0.5 ? lift + 0.5 : 0.0) * 25.0 + (age + 0.5) * 50.0);
        if (surfaceDepth < 1) {
            surfaceDepth = 1;
        }
        if ((erosionFactor = surface * 2.0) > 0.0) {
            erosionFactor = -erosionFactor;
        }
        if (erosionFactor > -0.1) {
            erosionFactor = -0.1;
        }
        erosionFactor = 1.0 + erosionFactor;
        int erosionDepth = rock < -0.5 ? (erosion > 0.0 ? (int)(erosion * 200.0) : 0) : (rock < 0.0 ? (erosion > 0.0 ? (int)(erosion * 160.0) : 0) : (rock < 0.5 ? (erosion > 0.0 ? (int)(erosion * 130.0) : 0) : (erosion > 0.0 ? (int)(erosion * 110.0) : 0)));
        double elevation = plate * 500.0 + (lift > 0.0 ? lift * 500.0 : 0.0);
        int surfaceElev = (int)(elevation + (double)surfaceDepth);
        if (erosionFactor > 0.0) {
            surfaceElev = (int)((double)surfaceElev - erosionFactor * (double)erosionDepth);
        }
        return surfaceElev;
    }

    @Override
    public void generateChunk(World world, int blockX, int blockY, int blockZ) {
        if (world == null) {
            return;
        }
        for (int x = 0; x < this.chunkSizeX; ++x) {
            int xOffset = blockX + x;
            for (int z = 0; z < this.chunkSizeZ; ++z) {
                int mantle;
                int surfaceElev;
                double erosionFactor;
                int zOffset = blockZ + z;
                int id = 0;
                double r = this.rand.nextDouble() * 0.2 - 0.1;
                double plate = this.plates(xOffset, zOffset);
                id = plate + r < -0.5 ? (id |= 0) : (plate + r < 0.0 ? (id |= 4) : (plate + r < 0.5 ? (id |= 8) : (id |= 0xC)));
                double rock = this.rock(xOffset, zOffset);
                id = rock + r < -0.5 ? (id |= 0) : (rock + r < 0.0 ? (id |= 1) : (rock + r < 0.5 ? (id |= 2) : (id |= 3)));
                double lift = this.uplift(xOffset, zOffset);
                id = lift + r < -0.5 ? (id |= 0) : (lift + r < 0.0 ? (id |= 0x400) : (lift + r < 0.5 ? (id |= 0x800) : (id |= 0xC00)));
                double thermal = this.geothermal(xOffset, zOffset);
                id = thermal + r < -0.5 ? (id |= 0) : (thermal + r < 0.0 ? (id |= 0x40) : (thermal + r < 0.5 ? (id |= 0x80) : (id |= 0xC0)));
                double age = this.age(xOffset, zOffset);
                id = age + r < -0.5 ? (id |= 0) : (age + r < 0.0 ? (id |= 0x10) : (age + r < 0.5 ? (id |= 0x20) : (id |= 0x30)));
                double erosion = this.erosion(xOffset, zOffset);
                id = erosion + r < -0.5 ? (id |= 0) : (erosion + r < 0.0 ? (id |= 0x100) : (erosion + r < 0.5 ? (id |= 0x200) : (id |= 0x300)));
                double temperature = this.temperature(xOffset, zOffset);
                id = temperature + r < -0.5 ? (id |= 0) : (temperature + r < 0.0 ? (id |= 0x4000) : (temperature + r < 0.5 ? (id |= 0x8000) : (id |= 0xC000)));
                double precipitation = this.precipitation(xOffset, zOffset);
                id = precipitation + r < -0.5 ? (id |= 0) : (precipitation + r < 0.0 ? (id |= 0x1000) : (precipitation + r < 0.5 ? (id |= 0x2000) : (id |= 0x3000)));
                double surface = this.surface(xOffset, zOffset);
                int surfaceDepth = (int)((surface + 1.0) * (lift > -0.5 ? lift + 0.5 : 0.0) * 25.0 + (age + 0.5) * 50.0);
                if (surfaceDepth < 1) {
                    surfaceDepth = 1;
                }
                if ((erosionFactor = surface * 2.0) > 0.0) {
                    erosionFactor = -erosionFactor;
                }
                if (erosionFactor > -0.1) {
                    erosionFactor = -0.1;
                }
                erosionFactor = 1.0 + erosionFactor;
                int erosionDepth = rock < -0.5 ? (erosion > 0.0 ? (int)(erosion * 200.0) : 0) : (rock < 0.0 ? (erosion > 0.0 ? (int)(erosion * 160.0) : 0) : (rock < 0.5 ? (erosion > 0.0 ? (int)(erosion * 130.0) : 0) : (erosion > 0.0 ? (int)(erosion * 110.0) : 0)));
                int elevation = (int)(plate * 500.0 + (lift > 0.0 ? lift * 500.0 : 0.0));
                int surfaceElevMod = surfaceElev = elevation + surfaceDepth;
                if (erosionFactor > 0.0) {
                    surfaceElevMod = (int)((double)surfaceElevMod - erosionFactor * (double)erosionDepth);
                }
                if (lift < -0.5) {
                    surfaceElevMod = (int)((double)surfaceElevMod - (-lift - 0.5) * 200.0);
                }
                if ((mantle = elevation - (int)(800.0 - (thermal > 0.0 ? thermal * 1080.0 : 0.0))) > elevation) {
                    mantle = elevation;
                }
                if (mantle >= surfaceElevMod) {
                    mantle = surfaceElevMod - 1;
                }
                if (elevation >= surfaceElevMod || lift >= 0.5) {
                    elevation = surfaceElevMod - 1;
                }
                for (int y = 0; y < this.chunkSizeY; ++y) {
                    int yOffset = blockY + y;
                    Block type = this.blockDict.getBlock("air");
                    if (yOffset <= mantle) {
                        world.setBlock(xOffset, yOffset, zOffset, this.blockDict.getBlock("lava").getId(), false);
                        continue;
                    }
                    if (yOffset <= elevation) {
                        if (rock < -0.5) {
                            double oilMod2;
                            double clayMod1 = lift < 0.0 ? -lift : 0.0;
                            double clayMod2 = age < 0.0 ? -age : 0.0;
                            double saltMod1 = lift < 0.0 ? -lift : 0.0;
                            double saltMod2 = temperature > 0.0 ? temperature : 0.0;
                            double oilMod1 = plate * 500.0 - 128.0 - plate * 96.0;
                            double d = oilMod2 = plate < 0.0 ? -plate : 0.0;
                            type = yOffset == elevation && precipitation < 0.1 ? ((double)this.rand.nextFloat() < 0.2 + saltMod1 * 0.2 + saltMod2 * 0.2 ? this.blockDict.getBlock("salt_block") : this.blockDict.getBlock("clay_hardened")) : (yOffset == elevation - 1 && precipitation < 0.1 ? ((double)this.rand.nextFloat() < 0.1 + saltMod1 * 0.1 + saltMod2 * 0.1 ? this.blockDict.getBlock("salt_block") : this.blockDict.getBlock("clay_hardened")) : (yOffset == (int)oilMod1 ? (yOffset < -1 && surface < 0.0 && age > 0.5 - 0.2 * oilMod2 && precipitation < -0.3 + 0.2 * oilMod2 ? this.blockDict.getBlock("oil") : this.blockDict.getBlock("clay_hardened")) : (yOffset + 1 == (int)oilMod1 ? (yOffset < -1 && surface < 0.0 && age > 0.7 - 0.2 * oilMod2 && precipitation < -0.5 + 0.2 * oilMod2 ? this.blockDict.getBlock("oil") : this.blockDict.getBlock("clay_hardened")) : (yOffset % 17 == 0 ? this.blockDict.getBlock("clay_hardened_stained_orange") : (yOffset % 15 == 0 ? this.blockDict.getBlock("clay_hardened_stained_red") : (yOffset % 13 == 0 ? this.blockDict.getBlock("clay_hardened_stained_gray") : (yOffset % 11 == 0 ? this.blockDict.getBlock("clay_hardened_stained_silver") : (yOffset % 9 == 0 ? this.blockDict.getBlock("clay_hardened_stained_brown") : (yOffset % 19 == 0 ? this.blockDict.getBlock("clay_hardened_stained_yellow") : (yOffset % 7 == 0 && yOffset > elevation - 16 ? (precipitation > -0.1 && (double)this.rand.nextFloat() < 0.2 + clayMod1 * 0.2 + clayMod2 * 0.2 ? this.blockDict.getBlock("clay") : this.blockDict.getBlock("clay_hardened_stained_white")) : this.blockDict.getBlock("sandstone")))))))))));
                        } else if (rock < 0.0) {
                            double ironMod2;
                            double coalMod1 = precipitation > 0.0 ? precipitation : 0.0;
                            double coalMod2 = lift < 0.0 ? -lift : 0.0;
                            double ironMod1 = erosion < 0.0 ? -erosion : 0.0;
                            double d = ironMod2 = thermal > 0.0 ? thermal : 0.0;
                            type = yOffset % 12 == 0 ? this.blockDict.getBlock("cobblestone") : (yOffset % 55 == 0 ? (age > 0.0 && (double)this.rand.nextFloat() < 0.06 + coalMod1 * 0.06 + coalMod2 * 0.06 ? this.blockDict.getBlock("coal_ore") : this.blockDict.getBlock("stone")) : ((yOffset + 1) % 55 == 0 ? (age > 0.3 && (double)this.rand.nextFloat() < 0.12 + coalMod1 * 0.12 + coalMod2 * 0.12 ? this.blockDict.getBlock("coal_ore") : this.blockDict.getBlock("stone")) : ((yOffset + 2) % 55 == 0 ? (age > 0.7 && (double)this.rand.nextFloat() < 0.24 + coalMod1 * 0.24 + coalMod2 * 0.24 ? this.blockDict.getBlock("coal_ore") : this.blockDict.getBlock("stone")) : (yOffset % 16 == 0 ? this.blockDict.getBlock("gravel") : (yOffset % 75 == 0 ? (lift > 0.0 && (double)this.rand.nextFloat() < 0.012 + ironMod1 * 0.012 + ironMod2 * 0.012 ? this.blockDict.getBlock("iron_ore") : this.blockDict.getBlock("stone")) : ((yOffset + 1) % 75 == 0 ? (lift > 0.3 && (double)this.rand.nextFloat() < 0.06 + ironMod1 * 0.06 + ironMod2 * 0.06 ? this.blockDict.getBlock("iron_ore") : this.blockDict.getBlock("stone")) : ((yOffset + 2) % 75 == 0 ? (lift > 0.7 && (double)this.rand.nextFloat() < 0.12 + ironMod1 * 0.12 + ironMod2 * 0.12 ? this.blockDict.getBlock("iron_ore") : this.blockDict.getBlock("stone")) : this.blockDict.getBlock("stone"))))))));
                        } else if (rock < 0.5) {
                            float mineral;
                            double redstoneMod2;
                            double goldMod1 = lift > 0.0 ? lift : 0.0;
                            double goldMod2 = temperature < 0.0 ? -temperature : 0.0;
                            double redstoneMod1 = age < 0.0 ? -age : 0.0;
                            double d = redstoneMod2 = precipitation < 0.0 ? -precipitation : 0.0;
                            type = yOffset % 7 == 0 ? ((mineral = this.rand.nextFloat()) < 0.001f ? this.blockDict.getBlock("emerald_ore") : (mineral < 0.06f ? this.blockDict.getBlock("lapis_ore") : this.blockDict.getBlock("stone_andesite"))) : (yOffset % 19 == 0 ? (erosion > 0.3 && (double)this.rand.nextFloat() < (double)0.06f + goldMod1 * 0.06 + goldMod2 * 0.06 ? this.blockDict.getBlock("gold_ore") : this.blockDict.getBlock("stone")) : ((yOffset + 1) % 19 == 0 ? (erosion > 0.7 && (double)this.rand.nextFloat() < (double)0.096f + goldMod1 * 0.096 + goldMod2 * 0.096 ? this.blockDict.getBlock("gold_ore") : this.blockDict.getBlock("stone")) : (yOffset % 33 == 0 ? (lift > -0.1 && (double)this.rand.nextFloat() < (double)0.12f + redstoneMod1 * 0.12 + redstoneMod2 * 0.12 ? this.blockDict.getBlock("copper_ore") : this.blockDict.getBlock("stone_granite")) : this.blockDict.getBlock("stone_granite"))));
                        } else {
                            double quartzMod2;
                            double quartzMod1 = thermal < 0.0 ? -thermal : 0.0;
                            double d = quartzMod2 = age < 0.0 ? -age : 0.0;
                            type = yOffset % 17 == 0 ? this.blockDict.getBlock("obsidian") : (yOffset % 15 == 0 ? (this.rand.nextFloat() < 0.02f ? this.blockDict.getBlock("emerald_ore") : this.blockDict.getBlock("stone_andesite")) : (yOffset % 9 == 0 ? (erosion < -0.3 && (double)this.rand.nextFloat() < (double)0.12f + quartzMod1 * 0.12 + quartzMod2 * 0.12 ? this.blockDict.getBlock("quartz_ore") : this.blockDict.getBlock("stone_granite")) : (thermal > 0.3 && this.rand.nextFloat() < 0.012f ? this.blockDict.getBlock("diamond_ore") : this.blockDict.getBlock("stone_diorite"))));
                        }
                        world.setBlock(xOffset, yOffset, zOffset, type.getId(), false);
                        continue;
                    }
                    if (yOffset <= surfaceElevMod) {
                        if (yOffset == surfaceElevMod) {
                            if (!(lift < 0.5) && !(surface < 0.0) || world.getBlock(xOffset, yOffset - 1, zOffset) <= 0) continue;
                            List<Material> blockList = blocks.get(id);
                            Block materialType = world.getBlock(xOffset, yOffset - 1, zOffset) == this.blockDict.getBlock("lava").getId() ? this.blockDict.getBlock("obsidian") : (yOffset < 0 ? (surface < -0.5 ? this.blockDict.getBlock("gravel") : this.blockDict.getBlock("sand")) : (blockList != null ? this.blockDict.getBlock(blockList.get((int)this.rand.nextInt((int)blockList.size())).blockType) : (precipitation < -0.5 ? this.blockDict.getBlock("sand") : this.blockDict.getBlock("dirt"))));
                            world.setBlock(xOffset, yOffset, zOffset, materialType.getId(), false);
                            continue;
                        }
                        if (yOffset <= surfaceElevMod - surfaceDepth / 2) {
                            if (surfaceElevMod - mantle < 20 && surface < 0.0) continue;
                            if (lift > 0.5) {
                                world.setBlock(xOffset, yOffset, zOffset, this.blockDict.getBlock("stone").getId(), false);
                                continue;
                            }
                            world.setBlock(xOffset, yOffset, zOffset, this.blockDict.getBlock("dirt_coarse").getId(), false);
                            continue;
                        }
                        if (surfaceElevMod - mantle < 20 && surface < 0.0) continue;
                        if (precipitation < -0.5) {
                            world.setBlock(xOffset, yOffset, zOffset, this.blockDict.getBlock("sand").getId(), false);
                            continue;
                        }
                        world.setBlock(xOffset, yOffset, zOffset, this.blockDict.getBlock("dirt").getId(), false);
                        continue;
                    }
                    if ((double)yOffset < (double)surfaceElev + (Math.min(precipitation, 0.7) - 0.7) * 60.0 - Math.max(lift, 0.0) * 100.0) {
                        if (temperature < -0.5) {
                            world.setBlock(xOffset, yOffset, zOffset, this.blockDict.getBlock("ice_packed").getId(), false);
                            continue;
                        }
                        world.setBlock(xOffset, yOffset, zOffset, this.blockDict.getBlock("water").getId(), false);
                        continue;
                    }
                    if (yOffset >= 0) continue;
                    world.setBlock(xOffset, yOffset, zOffset, this.blockDict.getBlock("water_salt").getId(), false);
                }
            }
        }
    }

    @Override
    public void populateChunk(World world, int blockX, int blockY, int blockZ) {
        for (int x = 0; x < this.chunkSizeX; ++x) {
            int xOffset = blockX + x;
            for (int z = 0; z < this.chunkSizeZ; ++z) {
                Block block;
                int topSurface;
                double erosionFactor;
                int zOffset = blockZ + z;
                int id = 0;
                double r = this.rand.nextDouble() * 0.1 - 0.05;
                double plate = this.plates(xOffset, zOffset);
                id = plate + r < -0.5 ? (id |= 0) : (plate + r < 0.0 ? (id |= 4) : (plate + r < 0.5 ? (id |= 8) : (id |= 0xC)));
                double rock = this.rock(xOffset, zOffset);
                id = rock + r < -0.5 ? (id |= 0) : (rock + r < 0.0 ? (id |= 1) : (rock + r < 0.5 ? (id |= 2) : (id |= 3)));
                double lift = this.uplift(xOffset, zOffset);
                id = lift + r < -0.5 ? (id |= 0) : (lift + r < 0.0 ? (id |= 0x400) : (lift + r < 0.5 ? (id |= 0x800) : (id |= 0xC00)));
                double thermal = this.geothermal(xOffset, zOffset);
                id = thermal + r < -0.5 ? (id |= 0) : (thermal + r < 0.0 ? (id |= 0x40) : (thermal + r < 0.5 ? (id |= 0x80) : (id |= 0xC0)));
                double age = this.age(xOffset, zOffset);
                id = age + r < -0.5 ? (id |= 0) : (age + r < 0.0 ? (id |= 0x10) : (age + r < 0.5 ? (id |= 0x20) : (id |= 0x30)));
                double erosion = this.erosion(xOffset, zOffset);
                id = erosion + r < -0.5 ? (id |= 0) : (erosion + r < 0.0 ? (id |= 0x100) : (erosion + r < 0.5 ? (id |= 0x200) : (id |= 0x300)));
                double temperature = this.temperature(xOffset, zOffset);
                id = temperature + r < -0.5 ? (id |= 0) : (temperature + r < 0.0 ? (id |= 0x4000) : (temperature + r < 0.5 ? (id |= 0x8000) : (id |= 0xC000)));
                double precipitation = this.precipitation(xOffset, zOffset);
                id = precipitation + r < -0.5 ? (id |= 0) : (precipitation + r < 0.0 ? (id |= 0x1000) : (precipitation + r < 0.5 ? (id |= 0x2000) : (id |= 0x3000)));
                double surface = this.surface(xOffset, zOffset);
                int surfaceDepth = (int)((surface + 1.0) * (lift > -0.5 ? lift + 0.5 : 0.0) * 25.0 + (age + 0.5) * 50.0);
                if (surfaceDepth < 1) {
                    surfaceDepth = 1;
                }
                if ((erosionFactor = surface * 2.0) > 0.0) {
                    erosionFactor = -erosionFactor;
                }
                if (erosionFactor > -0.1) {
                    erosionFactor = -0.1;
                }
                erosionFactor = 1.0 + erosionFactor;
                int erosionDepth = rock < -0.5 ? (erosion > 0.0 ? (int)(erosion * 200.0) : 0) : (rock < 0.0 ? (erosion > 0.0 ? (int)(erosion * 160.0) : 0) : (rock < 0.5 ? (erosion > 0.0 ? (int)(erosion * 130.0) : 0) : (erosion > 0.0 ? (int)(erosion * 110.0) : 0)));
                double elevation = plate * 500.0 + (lift > 0.0 ? lift * 500.0 : 0.0);
                int surfaceElev = (int)(elevation + (double)surfaceDepth);
                if (erosionFactor > 0.0) {
                    surfaceElev = (int)((double)surfaceElev - erosionFactor * (double)erosionDepth);
                }
                if (lift < -0.5) {
                    surfaceElev = (int)((double)surfaceElev - (-lift - 0.5) * 200.0);
                }
                double occuranceMod = (age + 1.0) / 4.0 + 0.5;
                block2: for (int y = 0; y < this.chunkSizeY; ++y) {
                    List<Material> featureList;
                    int yOffset = blockY + y;
                    if (yOffset != surfaceElev && (surfaceElev >= 0 || yOffset != 0)) continue;
                    if (!(lift < 0.5) && !(surface < 0.0) || (featureList = features.get(id)) == null) break;
                    for (int i = 0; i < featureList.size(); ++i) {
                        Material feature = featureList.get(this.rand.nextInt(featureList.size()));
                        if (!((double)this.rand.nextFloat() < (double)feature.occurance * occuranceMod)) continue;
                        feature.feature.generate(world, this.rand, xOffset, yOffset + 1, zOffset, false);
                        break block2;
                    }
                    break;
                }
                if (surfaceElev <= 0 || surfaceElev < blockY || surfaceElev >= blockY + this.chunkSizeY) continue;
                for (topSurface = surfaceElev + this.chunkSizeY; world.getBlock(xOffset, topSurface, zOffset) == 0 && topSurface >= 0; --topSurface) {
                }
                if ((id & 0xC000) != 0 || (block = this.blockDict.getBlock(world.getBlock(xOffset, topSurface, zOffset))) == null || block.getSolidity() != 49152) continue;
                world.setBlock(xOffset, topSurface + 1, zOffset, this.blockDict.getBlock("snow_layer").getId(), false);
            }
        }
    }

    public static class Material {
        int blockType = -1;
        TerrainFeature feature;
        float occurance;
        int minTemp = 0;
        int maxTemp = 3;
        int minPrecip = 0;
        int maxPrecip = 3;
        int minLift = 0;
        int maxLift = 3;
        int minErosion = 0;
        int maxErosion = 3;
        int minThermal = 0;
        int maxThermal = 3;
        int minAge = 0;
        int maxAge = 3;
        int minPlates = 0;
        int maxPlates = 3;
        int minRock = 0;
        int maxRock = 3;

        public Material(int blockType) {
            this.blockType = blockType;
        }

        public Material(TerrainFeature feature, float occurance) {
            if (feature == null) {
                Thread.dumpStack();
            }
            this.feature = feature;
            this.occurance = occurance;
        }

        public void encode() {
            for (int t = this.minTemp; t <= this.maxTemp; ++t) {
                for (int w = this.minPrecip; w <= this.maxPrecip; ++w) {
                    for (int u = this.minLift; u <= this.maxLift; ++u) {
                        for (int e = this.minErosion; e <= this.maxErosion; ++e) {
                            for (int g = this.minThermal; g <= this.maxThermal; ++g) {
                                for (int a = this.minAge; a <= this.maxAge; ++a) {
                                    for (int p = this.minPlates; p <= this.maxPlates; ++p) {
                                        for (int r = this.minRock; r <= this.maxRock; ++r) {
                                            ArrayList<Material> list;
                                            int id = t << 14 | w << 12 | u << 10 | e << 8 | g << 6 | a << 4 | p << 2 | r << 0;
                                            List<Material> list2 = list = this.blockType != -1 ? (ArrayList<Material>)blocks.get(id) : (List)features.get(id);
                                            if (list == null) {
                                                list = new ArrayList<Material>();
                                                if (this.blockType != -1) {
                                                    blocks.put(id, list);
                                                } else {
                                                    features.put(id, list);
                                                }
                                            }
                                            list.add(this);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public Material minTemp(int temp) {
            this.minTemp = temp >> 14;
            return this;
        }

        public Material maxTemp(int temp) {
            this.maxTemp = temp >> 14;
            return this;
        }

        public Material minPrecip(int percip) {
            this.minPrecip = percip >> 12;
            return this;
        }

        public Material maxPrecip(int percip) {
            this.maxPrecip = percip >> 12;
            return this;
        }

        public Material minLift(int lift) {
            this.minLift = lift >> 10;
            return this;
        }

        public Material maxLift(int lift) {
            this.maxLift = lift >> 10;
            return this;
        }

        public Material minErosion(int erosion) {
            this.minErosion = erosion >> 8;
            return this;
        }

        public Material maxErosion(int erosion) {
            this.maxErosion = erosion >> 8;
            return this;
        }

        public Material minThermal(int thermal) {
            this.minThermal = thermal >> 6;
            return this;
        }

        public Material maxThermal(int thermal) {
            this.maxThermal = thermal >> 6;
            return this;
        }

        public Material minAge(int age) {
            this.minAge = age >> 4;
            return this;
        }

        public Material maxAge(int age) {
            this.maxAge = age >> 4;
            return this;
        }

        public Material minPlates(int plates) {
            this.minPlates = plates >> 2;
            return this;
        }

        public Material maxPlates(int plates) {
            this.maxPlates = plates >> 2;
            return this;
        }

        public Material minRock(int rock) {
            this.minRock = rock >> 0;
            return this;
        }

        public Material maxRock(int rock) {
            this.maxRock = rock >> 0;
            return this;
        }
    }
}

