/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.voxel.noise;

import com.dooglamoo.voxel.noise.NoiseGeneratorImproved;
import java.util.Random;

public class NoiseGeneratorOctaves {
    private NoiseGeneratorImproved[] generatorCollection;
    private int octaves;

    public NoiseGeneratorOctaves(Random rand, int octaves) {
        this.octaves = octaves;
        this.generatorCollection = new NoiseGeneratorImproved[octaves];
        for (int i = 0; i < octaves; ++i) {
            this.generatorCollection[i] = new NoiseGeneratorImproved(rand);
        }
    }

    public double[] generateNoiseOctaves(double[] noiseArray, int noiseOffsetX, int noiseOffsetY, int noiseOffsetZ, int xSize, int ySize, int zSize, double noiseScaleX, double noiseScaleY, double noiseScaleZ) {
        if (noiseArray == null) {
            noiseArray = new double[xSize * ySize * zSize];
        } else {
            for (int k = 0; k < noiseArray.length; ++k) {
                noiseArray[k] = 0.0;
            }
        }
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            double xOffset = (double)noiseOffsetX * frequency * noiseScaleX;
            double yOffset = (double)noiseOffsetY * frequency * noiseScaleY;
            double zOffset = (double)noiseOffsetZ * frequency * noiseScaleZ;
            long i2 = NoiseGeneratorOctaves.floor_double_long(xOffset);
            long j2 = NoiseGeneratorOctaves.floor_double_long(zOffset);
            xOffset -= (double)i2;
            zOffset -= (double)j2;
            this.generatorCollection[i].populateNoiseArray(noiseArray, xOffset += (double)(i2 %= 0x1000000L), yOffset, zOffset += (double)(j2 %= 0x1000000L), xSize, ySize, zSize, noiseScaleX * frequency, noiseScaleY * frequency, noiseScaleZ * frequency, frequency);
            frequency /= 2.0;
        }
        return noiseArray;
    }

    public double[] generateNoiseOctaves(double[] noiseArray, int noiseOffsetX, int noiseOffsetZ, int xSize, int zSize, double noiseScaleX, double noiseScaleZ, double p_76305_10_) {
        return this.generateNoiseOctaves(noiseArray, noiseOffsetX, 10, noiseOffsetZ, xSize, 1, zSize, noiseScaleX, 1.0, noiseScaleZ);
    }

    private static long floor_double_long(double a) {
        long i = (long)a;
        return a < (double)i ? i - 1L : i;
    }
}

