/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds;

import com.dooglamoo.worlds.common.CommonProxy;
import com.dooglamoo.worlds.common.ConfigHandler;
import com.dooglamoo.worlds.dict.DictionaryFactory;
import com.dooglamoo.worlds.dict.GeoFeature;
import com.dooglamoo.worlds.event.EventHandlerDooglamoo;
import com.dooglamoo.worlds.world.WorldTypeDooglamoo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

@Mod(modid="dooglamooworlds", name="Dooglamoo Worlds", version="1.1.7", guiFactory="com.dooglamoo.worlds.client.gui.WorldsGuiFactory", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class DooglamooWorlds {
    public static final String MODID = "dooglamooworlds";
    public static final String NAME = "Dooglamoo Worlds";
    public static final String VERSION = "1.1.7";
    public static final String GUI_FACTORY = "com.dooglamoo.worlds.client.gui.WorldsGuiFactory";
    @Mod.Instance(value="dooglamooworlds")
    public static DooglamooWorlds instance;
    @SidedProxy(clientSide="com.dooglamoo.worlds.client.ClientProxy", serverSide="com.dooglamoo.worlds.common.CommonProxy")
    public static CommonProxy proxy;
    private static Gson GSON;
    public static Logger logger;
    @GameRegistry.ObjectHolder(value="biomesoplenty:dirt")
    public static final Block BOP_DIRT;
    @GameRegistry.ObjectHolder(value="biomesoplenty:grass")
    public static final Block BOP_GRASS;
    @GameRegistry.ObjectHolder(value="biomesoplenty:ash_block")
    public static final Block BOP_ASH_BLOCK;
    @GameRegistry.ObjectHolder(value="biomesoplenty:mud")
    public static final Block BOP_MUD;
    @GameRegistry.ObjectHolder(value="biomesoplenty:white_sand")
    public static final Block BOP_WHITE_SAND;
    @GameRegistry.ObjectHolder(value="biomesoplenty:bamboo")
    public static final Block BOP_BAMBOO;
    @GameRegistry.ObjectHolder(value="biomesoplenty:coral")
    public static final Block BOP_CORAL;
    public static Map<Integer, DimensionType> dimMap;
    public static final WorldType DOOGLAMOO;
    private static File configDir;

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        configDir = new File(event.getModConfigurationDirectory() + "/" + MODID);
        configDir.mkdirs();
        ConfigHandler.init(configDir.getPath(), "dooglamooworlds.cfg");
        DictionaryFactory.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerDooglamoo());
    }

    @Mod.EventHandler
    public void init(FMLPostInitializationEvent event) {
        DictionaryFactory.postInit();
        DooglamooWorlds.loadGeoFeatures(Loader.instance().activeModContainer());
        DooglamooWorlds.loadGeoFeaturesPost(Loader.instance().activeModContainer());
        DictionaryFactory.postLoad();
    }

    private static boolean loadGeoFeatures(ModContainer mod) {
        JsonContext ctx = new JsonContext(mod.getModId());
        DictionaryFactory.totalCount = 0;
        DictionaryFactory.biomeCount = 0;
        DictionaryFactory.blockCount = 0;
        DictionaryFactory.featureCount = 0;
        boolean result = CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/geofeatures"), root -> true, (root, file) -> {
            Loader.instance().setActiveModContainer(mod);
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                GeoFeature geo = DictionaryFactory.getGeoFeature(name, json, ctx);
                DictionaryFactory.register(geo);
            }
            catch (JsonParseException e) {
                logger.error("Parsing error loading geofeature {}", (Object)key, (Object)e);
                Boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                logger.error("Couldn't read geofeature {} from {}", (Object)key, file, (Object)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        });
        logger.info("Loaded {} base geofeatures", (Object)DictionaryFactory.totalCount);
        logger.info("{} biomes cover {}% of geofactors", (Object)DictionaryFactory.biomeCount, (Object)((int)((double)DictionaryFactory.biomes.size() / 65536.0 * 100.0)));
        logger.info("{} blocks cover {}% of geofactors", (Object)DictionaryFactory.blockCount, (Object)((int)((double)DictionaryFactory.blocks.size() / 65536.0 * 100.0)));
        logger.info("{} features cover {}% of geofactors", (Object)DictionaryFactory.featureCount, (Object)((int)((double)DictionaryFactory.features.size() / 65536.0 * 100.0)));
        return result;
    }

    private static boolean loadGeoFeaturesPost(ModContainer mod) {
        DictionaryFactory.totalCount = 0;
        DictionaryFactory.biomeCount = 0;
        DictionaryFactory.blockCount = 0;
        DictionaryFactory.featureCount = 0;
        Iterator itr = null;
        Path root = new File(configDir + "/geofeatures/").toPath();
        try {
            itr = Files.walk(root, new FileVisitOption[0]).iterator();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            logger.warn("Error iterating filesystem for: {}", (Object)mod.getModId(), (Object)e.getMessage());
            return false;
        }
        JsonContext ctx = new JsonContext(mod.getModId());
        Loader.instance().setActiveModContainer(mod);
        while (itr != null && itr.hasNext()) {
            Boolean cont = DooglamooWorlds.apply(ctx, root, (Path)itr.next());
            if (cont != null && cont.booleanValue()) continue;
            return false;
        }
        logger.info("Loaded {} extra geofeatures", (Object)DictionaryFactory.totalCount);
        logger.info("{} biomes cover {}% of geofactors", (Object)DictionaryFactory.biomeCount, (Object)((int)((double)DictionaryFactory.biomes.size() / 65536.0 * 100.0)));
        logger.info("{} blocks cover {}% of geofactors", (Object)DictionaryFactory.blockCount, (Object)((int)((double)DictionaryFactory.blocks.size() / 65536.0 * 100.0)));
        logger.info("{} features cover {}% of geofactors", (Object)DictionaryFactory.featureCount, (Object)((int)((double)DictionaryFactory.features.size() / 65536.0 * 100.0)));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean apply(JsonContext ctx, Path root, Path file) {
        String relative = root.relativize(file).toString();
        if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
            return true;
        }
        String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
        ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(file);
            JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            GeoFeature geo = DictionaryFactory.getGeoFeature(name, json, ctx);
            DictionaryFactory.register(geo);
        }
        catch (JsonParseException e) {
            logger.error("Parsing error loading geofeature {}", (Object)key, (Object)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error("Couldn't read geofeature {} from {}", (Object)key, (Object)file, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return true;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        BOP_DIRT = null;
        BOP_GRASS = null;
        BOP_ASH_BLOCK = null;
        BOP_MUD = null;
        BOP_WHITE_SAND = null;
        BOP_BAMBOO = null;
        BOP_CORAL = null;
        dimMap = new HashMap<Integer, DimensionType>();
        DOOGLAMOO = new WorldTypeDooglamoo("dooglamoo");
    }

    @Mod.EventBusSubscriber(modid="dooglamooworlds")
    public static class Registration {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
        }

        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
        }
    }
}

