/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.common;

import com.dooglamoo.worlds.dict.DictionaryFactory;
import com.dooglamoo.worlds.world.biome.BiomeProviderDooglamoo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.io.IOUtils;

public class ConfigHandler {
    public static final String CUSTOM_GEN_ORES = "custom_generate_ores";
    public static final String STANDARD_GEN_ORES = "standard_generate_ores";
    public static final String CUSTOM_GEN_MODDED_ORES = "custom_generate_modded_ores";
    public static final String CUSTOM_GEN_SLIME_ORE = "custom_generate_slime_ore";
    public static final String CUSTOM_GEN_GLOWSTONE_ORE = "custom_generate_glowstone_ore";
    public static final String CUSTOM_GEN_QUARTZ_ORE = "custom_generate_quartz_ore";
    public static final String CUSTOM_GEN_CLAY_ORE = "custom_generate_clay_ore";
    public static final String CUSTOM_GEN_HELL_BIOME = "custom_generate_hell_biome";
    public static final String ELEVATION_AMPLIFIER = "elevation_amplifier";
    public static final String DENSITY_AMPLIFIER = "density_amplifier";
    public static final String ERA_AMPLIFIER = "era_amplifier";
    public static final String VOLCANISM_AMPLIFIER = "volcanism_amplifier";
    public static final String EROSION_AMPLIFIER = "erosion_amplifier";
    public static final String UPLIFT_AMPLIFIER = "uplift_amplifier";
    public static final String PRECIPITATION_AMPLIFIER = "precipitation_amplifier";
    public static final String TEMPERATURE_AMPLIFIER = "temperature_amplifier";
    public static final String SHARP_BIOME_EDGES = "sharp_biome_edges";
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static String configDir = "";
    public static Configuration config;

    public static void init(String path, String filename) {
        configDir = path;
        config = new Configuration(new File(path, filename));
        ConfigHandler.syncConfig();
    }

    public static boolean geomapsExist(String name) {
        return new File(configDir + "/geomaps/" + name).exists();
    }

    public static boolean geomapExist(String name, GeomapType type) {
        switch (type) {
            case ELEVATION: {
                return new File(configDir + "/geomaps/" + name + "/elevation.png").exists();
            }
            case DENSITY: {
                return new File(configDir + "/geomaps/" + name + "/density.png").exists();
            }
            case ERA: {
                return new File(configDir + "/geomaps/" + name + "/era.png").exists();
            }
            case VOLCANISM: {
                return new File(configDir + "/geomaps/" + name + "/volcanism.png").exists();
            }
            case EROSION: {
                return new File(configDir + "/geomaps/" + name + "/erosion.png").exists();
            }
            case UPLIFT: {
                return new File(configDir + "/geomaps/" + name + "/uplift.png").exists();
            }
            case PRECIPITATION: {
                return new File(configDir + "/geomaps/" + name + "/precipitation.png").exists();
            }
            case TEMPERATURE: {
                return new File(configDir + "/geomaps/" + name + "/temperature.png").exists();
            }
        }
        return false;
    }

    public static Path getGeomap(String name, GeomapType type) {
        switch (type) {
            case ELEVATION: {
                return new File(configDir + "/geomaps/" + name + "/elevation.png").toPath();
            }
            case DENSITY: {
                return new File(configDir + "/geomaps/" + name + "/density.png").toPath();
            }
            case ERA: {
                return new File(configDir + "/geomaps/" + name + "/era.png").toPath();
            }
            case VOLCANISM: {
                return new File(configDir + "/geomaps/" + name + "/volcanism.png").toPath();
            }
            case EROSION: {
                return new File(configDir + "/geomaps/" + name + "/erosion.png").toPath();
            }
            case UPLIFT: {
                return new File(configDir + "/geomaps/" + name + "/uplift.png").toPath();
            }
            case PRECIPITATION: {
                return new File(configDir + "/geomaps/" + name + "/precipitation.png").toPath();
            }
            case TEMPERATURE: {
                return new File(configDir + "/geomaps/" + name + "/temperature.png").toPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject getGeomapConfig(String name) {
        BufferedReader reader = null;
        File file = new File(configDir + "/geomaps/" + name + "/geomap.json");
        if (file.exists()) {
            try {
                reader = Files.newBufferedReader(file.toPath());
                JsonObject jsonObject = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                return jsonObject;
            }
            catch (JsonParseException e) {
                FMLLog.log.error("Parsing error loading geomap {}", (Object)name, (Object)e);
                JsonObject jsonObject = null;
                return jsonObject;
            }
            catch (IOException e) {
                FMLLog.log.error("Couldn't read geomap {} from {}", (Object)name, (Object)(configDir + "/geomaps/"), (Object)e);
                JsonObject jsonObject = null;
                return jsonObject;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        return null;
    }

    public static void syncConfig() {
        DictionaryFactory.disableOres = !config.getBoolean(CUSTOM_GEN_ORES, "general", true, "If true, custom generates localized small to large ore clusters.", "config.property.custom_generate_ores");
        DictionaryFactory.vanillaOres = config.getBoolean(STANDARD_GEN_ORES, "general", false, "If true, generates standard vanilla Minecraft ore distribution.", "config.property.standard_generate_ores");
        DictionaryFactory.disableExtraOres = !config.getBoolean(CUSTOM_GEN_MODDED_ORES, "general", false, "Detect and generate modded ores. If true, this mod detects and custom generates modded ores. If this is set to true, then ore generation in the mod's configs should be set to false.", "config.property.custom_generate_modded_ores");
        DictionaryFactory.disableSlimeOre = !config.getBoolean(CUSTOM_GEN_SLIME_ORE, "general", true, "If false, no vanilla slime blocks will be generated.", "config.property.custom_generate_slime_ore");
        DictionaryFactory.disableGlowstoneOre = !config.getBoolean(CUSTOM_GEN_GLOWSTONE_ORE, "general", true, "If false, no vanilla glowstone blocks will be generated in overworld.", "config.property.custom_generate_glowstone_ore");
        DictionaryFactory.disableQuartzOre = !config.getBoolean(CUSTOM_GEN_QUARTZ_ORE, "general", true, "If false, no vanilla nether quartz blocks will be generated in overworld.", "config.property.custom_generate_quartz_ore");
        DictionaryFactory.disableClayOre = !config.getBoolean(CUSTOM_GEN_CLAY_ORE, "general", true, "If false, no vanilla clay blocks will be generated underground. Clay will still generate on surface.", "config.property.custom_generate_clay_ore");
        DictionaryFactory.replaceHellBiome = !config.getBoolean(CUSTOM_GEN_HELL_BIOME, "general", false, "If true, Nether mobs will generate around volcanic areas in the overworld.", "config.property.custom_generate_hell_biome");
        BiomeProviderDooglamoo.plateFactor = config.getFloat(ELEVATION_AMPLIFIER, "general", 1.0f, 0.0f, 3.0f, "Less than 1 will bring all elevation more toward medium. Greater than 1 will make elevation change more extreme (low/high).", "config.property.elevation_amplifier");
        BiomeProviderDooglamoo.rockFactor = config.getFloat(DENSITY_AMPLIFIER, "general", 1.0f, 0.0f, 3.0f, "Less than 1 will make all rock types closer to medium density. Greater than 1 will make all rock types more extreme density (softer/harder).", "config.property.density_amplifier");
        BiomeProviderDooglamoo.ageFactor = config.getFloat(ERA_AMPLIFIER, "general", 1.0f, 0.0f, 3.0f, "Less than 1 will make ther era closer to medium age. Greater than 1 will make era change more extreme (younger/older).", "config.property.era_amplifier");
        BiomeProviderDooglamoo.thermalFactor = config.getFloat(VOLCANISM_AMPLIFIER, "general", 1.0f, 0.0f, 3.0f, "Less than 1 will bring volcanism closer toward medium. Greater than 1 will make volcanism change more extreme (peaceful/volcanic).", "config.property.volcanism_amplifier");
        BiomeProviderDooglamoo.erosionFactor = config.getFloat(EROSION_AMPLIFIER, "general", 1.0f, 0.0f, 3.0f, "Less than 1 will make erosion closer to medium. Greater than 1 will make erosion change more extreme (flat/canyons).", "config.property.erosion_amplifier");
        BiomeProviderDooglamoo.liftFactor = config.getFloat(UPLIFT_AMPLIFIER, "general", 1.0f, 0.0f, 3.0f, "Less than 1 will make uplift closer to medium. Greater than 1 will make uplift change more extreme (depressions/mountains).", "config.property.uplift_amplifier");
        BiomeProviderDooglamoo.precipFactor = config.getFloat(PRECIPITATION_AMPLIFIER, "general", 1.0f, 0.0f, 3.0f, "Less than 1 will make precipitation closer to medium. Greater than 1 will make precipitation change more extreme (dry/wet).", "config.property.precipitation_amplifier");
        BiomeProviderDooglamoo.tempFactor = config.getFloat(TEMPERATURE_AMPLIFIER, "general", 1.0f, 0.0f, 3.0f, "Less than 1 will make temperature closer to medium. Greater than 1 will make temperature change more extreme (cold/hot).", "config.property.temperature_amplifier");
        BiomeProviderDooglamoo.sharpEdges = config.getBoolean(SHARP_BIOME_EDGES, "general", false, "If false, biome transitions will be blended.", "config.property.sharp_biome_edges");
        config.save();
    }

    public static enum GeomapType {
        ELEVATION,
        DENSITY,
        ERA,
        VOLCANISM,
        EROSION,
        UPLIFT,
        PRECIPITATION,
        TEMPERATURE;

    }
}

