/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.dict;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.config.ColumnGenerator;
import biomesoplenty.api.config.FloraGenerator;
import biomesoplenty.api.config.LakesGenerator;
import biomesoplenty.api.config.TreeGenerator;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import com.dooglamoo.api.DooglamooWorldsApi;
import com.dooglamoo.worlds.DooglamooWorlds;
import com.dooglamoo.worlds.dict.BlockDictionary;
import com.dooglamoo.worlds.dict.FeatureDictionary;
import com.dooglamoo.worlds.dict.GeoFeature;
import com.dooglamoo.worlds.dict.MinMaxBounds;
import com.dooglamoo.worlds.world.gen.feature.FallenTreeFeature;
import com.dooglamoo.worlds.world.gen.feature.WorldGenCoral;
import com.dooglamoo.worlds.world.gen.feature.WorldGenLiquids;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenCactus;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenClay;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenIcePath;
import net.minecraft.world.gen.feature.WorldGenIceSpike;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenMelon;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenSand;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class DictionaryFactory {
    public static HashMap<String, IBlockState> blockDictionary;
    public static HashMap<String, WorldGenerator> featureDictionary;
    public static List<Integer> addedBiomes;
    public static Map<Integer, List<GeoFeature>> blocks;
    public static Map<Integer, List<GeoFeature>> features;
    public static Map<Integer, List<GeoFeature>> caveFeatures;
    public static Map<Integer, List<GeoFeature>> oceanFeatures;
    public static Map<Integer, List<GeoFeature>> biomes;
    public static Map<Integer, List<GeoFeature>> oceanBiomes;
    public static Map<Integer, List<GeoFeature>> ores;
    private static Gson GSON;
    public static int biomeCount;
    public static int blockCount;
    public static int featureCount;
    public static int totalCount;
    public static DooglamooWorldsApi api;
    public static boolean disableOres;
    public static boolean vanillaOres;
    public static boolean disableExtraOres;
    public static boolean disableSlimeOre;
    public static boolean disableGlowstoneOre;
    public static boolean disableQuartzOre;
    public static boolean disableClayOre;
    public static boolean replaceHellBiome;

    public static void init() {
        blockDictionary = new BlockDictionary();
        featureDictionary = new FeatureDictionary();
        addedBiomes = new ArrayList<Integer>();
        try {
            Class<DooglamooWorldsApi> c = Class.forName("com.dooglamoo.worlds.common.Api").asSubclass(DooglamooWorldsApi.class);
            api = c.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        blockDictionary.put("air", Blocks.field_150350_a.func_176223_P());
        blockDictionary.put("lava", Blocks.field_150353_l.func_176223_P());
        blockDictionary.put("water", Blocks.field_150355_j.func_176223_P());
        blockDictionary.put("water_salt", Blocks.field_150355_j.func_176223_P());
        blockDictionary.put("magma", Blocks.field_189877_df.func_176223_P());
        blockDictionary.put("stone", Blocks.field_150348_b.func_176223_P());
        blockDictionary.put("stone_andesite", Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE));
        blockDictionary.put("stone_granite", Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE));
        blockDictionary.put("stone_diorite", Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE));
        blockDictionary.put("dirt", Blocks.field_150346_d.func_176223_P());
        blockDictionary.put("coarsedirt", Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
        blockDictionary.put("loam", Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
        blockDictionary.put("podzol", Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL));
        blockDictionary.put("mycelium", Blocks.field_150391_bh.func_176223_P());
        blockDictionary.put("grass", Blocks.field_150349_c.func_176223_P());
        blockDictionary.put("heath", Blocks.field_150349_c.func_176223_P());
        blockDictionary.put("terracotta", Blocks.field_150405_ch.func_176223_P());
        blockDictionary.put("sandstone", Blocks.field_150322_A.func_176223_P());
        blockDictionary.put("terracotta_white", Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE));
        blockDictionary.put("terracotta_orange", Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE));
        blockDictionary.put("terracotta_yellow", Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW));
        blockDictionary.put("terracotta_gray", Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.GRAY));
        blockDictionary.put("terracotta_silver", Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.SILVER));
        blockDictionary.put("terracotta_brown", Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BROWN));
        blockDictionary.put("terracotta_red", Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED));
        blockDictionary.put("cobblestone", Blocks.field_150347_e.func_176223_P());
        blockDictionary.put("obsidian", Blocks.field_150343_Z.func_176223_P());
        blockDictionary.put("gravel", Blocks.field_150351_n.func_176223_P());
        blockDictionary.put("sand", Blocks.field_150354_m.func_176223_P());
        blockDictionary.put("sand_red", Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND));
        blockDictionary.put("ice", Blocks.field_150432_aD.func_176223_P());
        blockDictionary.put("snow", Blocks.field_150433_aE.func_176223_P());
        blockDictionary.put("snowpack", Blocks.field_150433_aE.func_176223_P());
        blockDictionary.put("icepack", Blocks.field_150403_cj.func_176223_P());
        blockDictionary.put("silverfish", Blocks.field_150418_aU.func_176223_P());
        blockDictionary.put("clay", Blocks.field_150435_aG.func_176223_P());
        blockDictionary.put("oil", Blocks.field_180399_cE.func_176223_P());
        blockDictionary.put("glowstone", Blocks.field_150426_aN.func_176223_P());
        blockDictionary.put("coal_ore", Blocks.field_150365_q.func_176223_P());
        blockDictionary.put("iron_ore", Blocks.field_150366_p.func_176223_P());
        blockDictionary.put("gold_ore", Blocks.field_150352_o.func_176223_P());
        blockDictionary.put("emerald_ore", Blocks.field_150412_bA.func_176223_P());
        blockDictionary.put("lapis_ore", Blocks.field_150369_x.func_176223_P());
        blockDictionary.put("redstone_ore", Blocks.field_150450_ax.func_176223_P());
        blockDictionary.put("diamond_ore", Blocks.field_150482_ag.func_176223_P());
        blockDictionary.put("quartz_ore", Blocks.field_150449_bY.func_176223_P());
        blockDictionary.put("salt_block", Blocks.field_180395_cM.func_176223_P());
        blockDictionary.put("sponge_wet", Blocks.field_150360_v.func_176223_P().func_177226_a((IProperty)BlockSponge.field_176313_a, (Comparable)Boolean.valueOf(true)));
        if (!Loader.isModLoaded((String)"dynamictrees")) {
            featureDictionary.put("tree_spruce_mega", (WorldGenerator)new WorldGenMegaPineTree(false, false));
            featureDictionary.put("tree_spruce_redwood", (WorldGenerator)new WorldGenMegaPineTree(false, true));
            featureDictionary.put("tree_spruce", (WorldGenerator)new WorldGenTaiga2(false));
            featureDictionary.put("tree_spruce_tall", (WorldGenerator)new WorldGenTaiga1());
            featureDictionary.put("tree_spruce_fallen", (WorldGenerator)new FallenTreeFeature(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE)));
            featureDictionary.put("tree_birch", (WorldGenerator)new WorldGenBirchTree(false, false));
            featureDictionary.put("tree_birch_tall", (WorldGenerator)new WorldGenBirchTree(false, true));
            featureDictionary.put("tree_birch_fallen", (WorldGenerator)new FallenTreeFeature(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH)));
            featureDictionary.put("tree_jungle_mega", (WorldGenerator)new WorldGenMegaJungle(false, 10, 20, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false))));
            featureDictionary.put("tree_jungle", (WorldGenerator)new WorldGenTrees(false, 4, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), false));
            featureDictionary.put("tree_jungle_tall", (WorldGenerator)new WorldGenTrees(false, 8, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), false));
            featureDictionary.put("tree_jungle_vines", (WorldGenerator)new WorldGenTrees(false, 6, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), true));
            featureDictionary.put("tree_acacia", (WorldGenerator)new WorldGenSavannaTree(false));
            featureDictionary.put("tree_oak_dark", (WorldGenerator)new WorldGenCanopyTree(false));
            featureDictionary.put("tree_oak_big", (WorldGenerator)new WorldGenBigTree(false));
            featureDictionary.put("tree_oak", (WorldGenerator)new WorldGenTrees(false));
            featureDictionary.put("tree_oak_fallen", (WorldGenerator)new FallenTreeFeature(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK)));
            featureDictionary.put("tree_oak_swamp", (WorldGenerator)new WorldGenSwamp());
            featureDictionary.put("shrub_jungle", (WorldGenerator)new WorldGenShrub(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false))));
        }
        featureDictionary.put("clay", (WorldGenerator)new WorldGenClay(4));
        featureDictionary.put("sand", (WorldGenerator)new WorldGenSand((Block)Blocks.field_150354_m, 7));
        featureDictionary.put("gravel", (WorldGenerator)new WorldGenSand(Blocks.field_150351_n, 6));
        featureDictionary.put("mushroom_brown", (WorldGenerator)new WorldGenBush(Blocks.field_150338_P));
        featureDictionary.put("mushroom_red", (WorldGenerator)new WorldGenBush(Blocks.field_150337_Q));
        featureDictionary.put("reed", (WorldGenerator)new WorldGenReed());
        featureDictionary.put("cactus", (WorldGenerator)new WorldGenCactus());
        featureDictionary.put("waterlily", (WorldGenerator)new WorldGenWaterlily());
        featureDictionary.put("ice_spike", (WorldGenerator)new WorldGenIceSpike());
        featureDictionary.put("ice_path", (WorldGenerator)new WorldGenIcePath(4));
        featureDictionary.put("fern", (WorldGenerator)new WorldGenTallGrass(BlockTallGrass.EnumType.FERN));
        featureDictionary.put("grass", (WorldGenerator)new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS));
        featureDictionary.put("grass_tussock", (WorldGenerator)new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS));
        featureDictionary.put("blob", (WorldGenerator)new WorldGenBlockBlob(Blocks.field_150341_Y, 0));
        featureDictionary.put("rock_river", (WorldGenerator)new WorldGenBlockBlob(Blocks.field_150347_e, 0));
        featureDictionary.put("rock_river_mossy", (WorldGenerator)new WorldGenBlockBlob(Blocks.field_150341_Y, 0));
        featureDictionary.put("bush_dead", (WorldGenerator)new WorldGenDeadBush());
        featureDictionary.put("flower_dandelion", (WorldGenerator)new WorldGenFlowers(Blocks.field_150327_N, BlockFlower.EnumFlowerType.DANDELION));
        featureDictionary.put("flower_poppy", (WorldGenerator)new WorldGenFlowers(Blocks.field_150328_O, BlockFlower.EnumFlowerType.POPPY));
        featureDictionary.put("flower_orchid_blue", (WorldGenerator)new WorldGenFlowers(Blocks.field_150328_O, BlockFlower.EnumFlowerType.BLUE_ORCHID));
        featureDictionary.put("flower_allium", (WorldGenerator)new WorldGenFlowers(Blocks.field_150328_O, BlockFlower.EnumFlowerType.ALLIUM));
        featureDictionary.put("flower_houstonia", (WorldGenerator)new WorldGenFlowers(Blocks.field_150328_O, BlockFlower.EnumFlowerType.HOUSTONIA));
        featureDictionary.put("flower_tulip_red", (WorldGenerator)new WorldGenFlowers(Blocks.field_150328_O, BlockFlower.EnumFlowerType.RED_TULIP));
        featureDictionary.put("flower_tulip_orange", (WorldGenerator)new WorldGenFlowers(Blocks.field_150328_O, BlockFlower.EnumFlowerType.ORANGE_TULIP));
        featureDictionary.put("flower_tulip_white", (WorldGenerator)new WorldGenFlowers(Blocks.field_150328_O, BlockFlower.EnumFlowerType.WHITE_TULIP));
        featureDictionary.put("flower_tulip_pink", (WorldGenerator)new WorldGenFlowers(Blocks.field_150328_O, BlockFlower.EnumFlowerType.PINK_TULIP));
        featureDictionary.put("flower_oxeyedaisy", (WorldGenerator)new WorldGenFlowers(Blocks.field_150328_O, BlockFlower.EnumFlowerType.OXEYE_DAISY));
        featureDictionary.put("pumpkin", (WorldGenerator)new WorldGenPumpkin());
        featureDictionary.put("melon", (WorldGenerator)new WorldGenMelon());
        featureDictionary.put("flower_rose_tall", (WorldGenerator)DictionaryFactory.getDoublePlantGenerator(BlockDoublePlant.EnumPlantType.ROSE));
        featureDictionary.put("flower_syringa_tall", (WorldGenerator)DictionaryFactory.getDoublePlantGenerator(BlockDoublePlant.EnumPlantType.SYRINGA));
        featureDictionary.put("flower_paeonia_tall", (WorldGenerator)DictionaryFactory.getDoublePlantGenerator(BlockDoublePlant.EnumPlantType.PAEONIA));
        featureDictionary.put("flower_sunflower_tall", (WorldGenerator)DictionaryFactory.getDoublePlantGenerator(BlockDoublePlant.EnumPlantType.SUNFLOWER));
        featureDictionary.put("grass_tall", (WorldGenerator)DictionaryFactory.getDoublePlantGenerator(BlockDoublePlant.EnumPlantType.GRASS));
        featureDictionary.put("fern_tall", (WorldGenerator)DictionaryFactory.getDoublePlantGenerator(BlockDoublePlant.EnumPlantType.FERN));
        featureDictionary.put("water_flowing", new WorldGenLiquids((Block)Blocks.field_150358_i));
        featureDictionary.put("lava_flowing", new WorldGenLiquids((Block)Blocks.field_150356_k));
        featureDictionary.put("mushroom_brown_tall", (WorldGenerator)new WorldGenBigMushroom(Blocks.field_150420_aW));
        featureDictionary.put("mushroom_red_tall", (WorldGenerator)new WorldGenBigMushroom(Blocks.field_150419_aX));
        featureDictionary.put("coral", new WorldGenCoral());
    }

    public static void postInit() {
        try {
            if (DooglamooWorlds.BOP_BAMBOO != null) {
                api.registerBlock("ash_block", DictionaryFactory.getBlockState(DooglamooWorlds.BOP_ASH_BLOCK, "{}"));
                api.registerBlock("mud_mud", DictionaryFactory.getBlockState(DooglamooWorlds.BOP_MUD, "{\"variant\":\"mud\"}"));
                api.registerBlock("sand_white", DictionaryFactory.getBlockState(DooglamooWorlds.BOP_WHITE_SAND, "{}"));
                api.registerBlock("grass_loamy", DictionaryFactory.getBlockState(DooglamooWorlds.BOP_GRASS, "{\"variant\":\"loamy\",\"snowy\":\"false\"}"));
                api.registerBlock("grass_sandy", DictionaryFactory.getBlockState(DooglamooWorlds.BOP_GRASS, "{\"variant\":\"sandy\",\"snowy\":\"false\"}"));
                api.registerBlock("grass_silty", DictionaryFactory.getBlockState(DooglamooWorlds.BOP_GRASS, "{\"variant\":\"silty\",\"snowy\":\"false\"}"));
                if (!Loader.isModLoaded((String)"dynamictrees")) {
                    api.registerGenerator("tree_cherry_pink", new TreeGenerator("GeneratorBasicTree").log(BOPWoods.CHERRY).leaves(BOPTrees.PINK_CHERRY).create());
                    api.registerGenerator("tree_cherry_pink_large", new TreeGenerator("GeneratorBigTree").log(BOPWoods.CHERRY).leaves(BOPTrees.PINK_CHERRY).create());
                    api.registerGenerator("tree_cherry_white", new TreeGenerator("GeneratorBasicTree").log(BOPWoods.CHERRY).leaves(BOPTrees.WHITE_CHERRY).create());
                    api.registerGenerator("tree_cherry_white_large", new TreeGenerator("GeneratorBigTree").log(BOPWoods.CHERRY).leaves(BOPTrees.WHITE_CHERRY).create());
                    api.registerGenerator("tree_fir", new TreeGenerator("GeneratorTaigaTree").log(BOPWoods.FIR).leaves(BOPTrees.FIR).minHeight(10).maxHeight(19).create());
                    api.registerGenerator("tree_fir_mega", new TreeGenerator("GeneratorTaigaTree").log(BOPWoods.FIR).leaves(BOPTrees.FIR).minHeight(20).maxHeight(40).trunkWidth(2).create());
                    api.registerGenerator("tree_bamboo", new TreeGenerator("GeneratorBulbTree").minHeight(10).maxHeight(20).log(DooglamooWorlds.BOP_BAMBOO.func_176223_P()).leaves(BOPTrees.BAMBOO).create());
                    api.registerGenerator("tree_bamboo_thin", new TreeGenerator("GeneratorTwigletTree").minHeight(5).maxHeight(10).log(DooglamooWorlds.BOP_BAMBOO.func_176223_P()).leaves(BOPTrees.BAMBOO).create());
                    api.registerGenerator("tree_willow", new TreeGenerator("GeneratorBayouTree").log(BOPWoods.WILLOW).leaves(BOPTrees.WILLOW).minHeight(6).maxHeight(12).create());
                    api.registerGenerator("tree_willow_large", new TreeGenerator("GeneratorBayouTree").log(BOPWoods.WILLOW).leaves(BOPTrees.WILLOW).minHeight(10).maxHeight(18).create());
                    api.registerGenerator("tree_oak_dark_twiglet", new TreeGenerator("GeneratorTwigletTree").log(BlockPlanks.EnumType.DARK_OAK).leaves(BlockPlanks.EnumType.DARK_OAK).minHeight(5).maxHeight(10).create());
                    api.registerGenerator("tree_birch_twiglet", new TreeGenerator("GeneratorTwigletTree").log(BlockPlanks.EnumType.BIRCH).leaves(BlockPlanks.EnumType.BIRCH).minHeight(5).maxHeight(10).create());
                    api.registerGenerator("bush_oak", new TreeGenerator("GeneratorBush").maxHeight(2).create());
                    api.registerGenerator("tree_oak_twiglet", new TreeGenerator("GeneratorTwigletTree").minHeight(2).maxHeight(2).log(BlockPlanks.EnumType.OAK).leaves(BlockPlanks.EnumType.OAK).create());
                    api.registerGenerator("tree_autumn_yellow", new TreeGenerator("GeneratorBasicTree").log(BlockPlanks.EnumType.BIRCH).leaves(BOPTrees.YELLOW_AUTUMN).minHeight(5).maxHeight(8).create());
                    api.registerGenerator("tree_autumn_orange", new TreeGenerator("GeneratorBasicTree").log(BlockPlanks.EnumType.DARK_OAK).leaves(BOPTrees.ORANGE_AUTUMN).minHeight(5).maxHeight(8).create());
                    api.registerGenerator("tree_acacia_brush", new TreeGenerator("GeneratorBasicTree").log(BlockPlanks.EnumType.ACACIA).leaves(BlockPlanks.EnumType.ACACIA).minHeight(3).maxHeight(5).create());
                    api.registerGenerator("tree_ebony_twiglet", new TreeGenerator("GeneratorTwigletTree").minHeight(1).maxHeight(2).log(BOPWoods.EBONY).leaves(BOPTrees.EBONY).create());
                    api.registerGenerator("tree_jungle_twiglet", new TreeGenerator("GeneratorTwigletTree").minHeight(2).maxHeight(2).log(BlockPlanks.EnumType.JUNGLE).leaves(BlockPlanks.EnumType.JUNGLE).create());
                    api.registerGenerator("tree_ebony_decaying", new TreeGenerator("GeneratorBigTree").log(BOPWoods.EBONY).leaves(BOPTrees.EBONY).minHeight(4).maxHeight(10).foliageHeight(1).create());
                    api.registerGenerator("tree_dying", new TreeGenerator("GeneratorBigTree").minHeight(5).maxHeight(12).foliageHeight(2).log(BOPWoods.DEAD).leaves(BOPTrees.DEAD).create());
                    api.registerGenerator("tree_dead", new TreeGenerator("GeneratorBigTree").minHeight(5).maxHeight(12).foliageHeight(0).log(BOPWoods.DEAD).leaves(Blocks.field_150350_a.func_176223_P()).create());
                    api.registerGenerator("tree_eucalyptus_tall", new TreeGenerator("GeneratorBulbTree").minHeight(1).maxHeight(30).log(BOPWoods.EUCALYPTUS).leaves(BOPTrees.EUCALYPTUS).create());
                    api.registerGenerator("tree_oak_dark_taiga", new TreeGenerator("GeneratorTaigaTree").log(BlockPlanks.EnumType.DARK_OAK).maxHeight(14).leaves(BlockPlanks.EnumType.DARK_OAK).create());
                    api.registerGenerator("tree_oak_dark_dying", new TreeGenerator("GeneratorTaigaTree").log(BlockPlanks.EnumType.DARK_OAK).maxHeight(14).leaves(BOPTrees.DEAD).create());
                    api.registerGenerator("tree_poplar_dark", new TreeGenerator("GeneratorProfileTree").minHeight(6).maxHeight(14).log(BlockPlanks.EnumType.DARK_OAK).leaves(BlockPlanks.EnumType.DARK_OAK).create());
                    api.registerGenerator("tree_poplar", new TreeGenerator("GeneratorProfileTree").minHeight(8).maxHeight(18).log(BlockPlanks.EnumType.BIRCH).leaves(BlockPlanks.EnumType.BIRCH).create());
                    api.registerGenerator("tree_jacaranda", new TreeGenerator("GeneratorBasicTree").minHeight(4).maxHeight(7).log(BOPWoods.JACARANDA).leaves(BOPTrees.JACARANDA).create());
                    api.registerGenerator("tree_acacia_decaying", new TreeGenerator("GeneratorBigTree").minHeight(5).maxHeight(12).log(BlockPlanks.EnumType.ACACIA).leaves(BlockPlanks.EnumType.ACACIA).foliageHeight(3).create());
                    api.registerGenerator("tree_mangrove", new TreeGenerator("GeneratorMangroveTree").log(BOPWoods.MANGROVE).leaves(BOPTrees.MANGROVE).create());
                    api.registerGenerator("tree_maple", new TreeGenerator("GeneratorBasicTree").log(BlockPlanks.EnumType.OAK).leaves(BOPTrees.MAPLE).create());
                    api.registerGenerator("bush_spruce", new TreeGenerator("GeneratorBush").maxHeight(2).log(BlockPlanks.EnumType.SPRUCE).leaves(BlockPlanks.EnumType.SPRUCE).create());
                    api.registerGenerator("tree_pine", new TreeGenerator("GeneratorPineTree").minHeight(6).maxHeight(18).log(BOPWoods.PINE).leaves(BOPTrees.PINE).create());
                    api.registerGenerator("tree_magic", new TreeGenerator("GeneratorBasicTree").log(BOPWoods.MAGIC).leaves(BOPTrees.MAGIC).create());
                    api.registerGenerator("tree_palm", new TreeGenerator("GeneratorPalmTree").log(BOPWoods.PALM).leaves(BOPTrees.PALM).create());
                    api.registerGenerator("tree_umbran_moss", new TreeGenerator("GeneratorBasicTree").log(BOPWoods.UMBRAN).leaves(BOPTrees.UMBRAN).minHeight(8).maxHeight(12).create());
                    api.registerGenerator("tree_umbran_spruce", new TreeGenerator("GeneratorTaigaTree").log(BOPWoods.UMBRAN).leaves(BOPTrees.UMBRAN).maxHeight(20).create());
                    api.registerGenerator("tree_umbran_mega", new TreeGenerator("GeneratorTaigaTree").log(BOPWoods.UMBRAN).leaves(BOPTrees.UMBRAN).minHeight(20).maxHeight(30).trunkWidth(2).create());
                    api.registerGenerator("bush_acacia", new TreeGenerator("GeneratorBush").log(BlockPlanks.EnumType.ACACIA).leaves(BlockPlanks.EnumType.ACACIA).maxHeight(2).create());
                    api.registerGenerator("tree_acacia_twiglet", new TreeGenerator("GeneratorTwigletTree").minHeight(2).maxHeight(2).log(BlockPlanks.EnumType.ACACIA).leaves(BlockPlanks.EnumType.ACACIA).create());
                    api.registerGenerator("tree_mahogany", new TreeGenerator("GeneratorMahoganyTree").minHeight(5).maxHeight(10).create());
                    api.registerGenerator("tree_redwood", new TreeGenerator("GeneratorRedwoodTree").log(BOPWoods.REDWOOD).leaves(BOPTrees.REDWOOD).create());
                    api.registerGenerator("tree_redwood_thin", new TreeGenerator("GeneratorRedwoodTreeThin").log(BOPWoods.REDWOOD).leaves(BOPTrees.REDWOOD).create());
                    api.registerGenerator("tree_oak_sacred", new TreeGenerator("GeneratorBigTree").log(BOPWoods.SACRED_OAK).leaves(BOPTrees.SACRED_OAK).minHeight(35).maxHeight(40).trunkWidth(2).create());
                    api.registerGenerator("tree_cedar_small", new TreeGenerator("GeneratorTaigaTree").log(BlockPlanks.EnumType.OAK).leaves(BlockPlanks.EnumType.OAK).minHeight(5).maxHeight(15).create());
                    api.registerGenerator("tree_cedar", new TreeGenerator("GeneratorTaigaTree").log(BlockPlanks.EnumType.OAK).leaves(BlockPlanks.EnumType.OAK).minHeight(20).maxHeight(40).create());
                }
                api.registerGenerator("flower_lavender", new FloraGenerator("GeneratorFlora").with(BOPFlowers.LAVENDER).create());
                api.registerGenerator("coral_pink", new FloraGenerator("GeneratorFlora").replace((Block)Blocks.field_150355_j).with(DictionaryFactory.getBlockState(DooglamooWorlds.BOP_CORAL, "{\"variant\":\"pink\"}")).create());
                api.registerGenerator("coral_orange", new FloraGenerator("GeneratorFlora").replace((Block)Blocks.field_150355_j).with(DictionaryFactory.getBlockState(DooglamooWorlds.BOP_CORAL, "{\"variant\":\"orange\"}")).create());
                api.registerGenerator("coral_blue", new FloraGenerator("GeneratorFlora").replace((Block)Blocks.field_150355_j).with(DictionaryFactory.getBlockState(DooglamooWorlds.BOP_CORAL, "{\"variant\":\"blue\"}")).create());
                api.registerGenerator("coral_glowing", new FloraGenerator("GeneratorFlora").replace((Block)Blocks.field_150355_j).with(DictionaryFactory.getBlockState(DooglamooWorlds.BOP_CORAL, "{\"variant\":\"glowing\"}")).create());
                api.registerGenerator("lake_poison", new LakesGenerator("GeneratorLakes").liquid(BOPBlocks.poison).frozenLiquid(null).create());
                api.registerGenerator("lake_quicksand", new LakesGenerator("GeneratorLakes").liquid(BOPBlocks.sand).frozenLiquid(null).create());
                api.registerGenerator("lake_hotspring", new LakesGenerator("GeneratorLakes").liquid(BOPBlocks.hot_spring_water).frozenLiquid(null).create());
                api.registerGenerator("kelp", new ColumnGenerator("GeneratorColumns").replace(BlockQueries.waterCovered).with(BOPBlocks.seaweed.func_176223_P()).create());
                api.registerGenerator("kelp_tall", new ColumnGenerator("GeneratorColumns").replace(BlockQueries.waterCovered).with(BOPBlocks.seaweed.func_176223_P()).minHeight(6).maxHeight(12).create());
                api.registerGenerator("koru", new FloraGenerator("GeneratorFlora").with(BOPPlants.KORU).create());
                api.registerGenerator("algae", new FloraGenerator("GeneratorFlora").replace((Block)Blocks.field_150355_j).with(DictionaryFactory.getBlockState(DooglamooWorlds.BOP_CORAL, "{\"variant\":\"algae\"}")).create());
                api.registerGenerator("leafpile", new FloraGenerator("GeneratorFlora").with(BOPPlants.LEAFPILE).create());
                api.registerGenerator("bush_berry", new FloraGenerator("GeneratorFlora").with(BOPPlants.BERRYBUSH).create());
            }
            if (!disableExtraOres) {
                DictionaryFactory.findModdedOre("Copper", null);
                DictionaryFactory.findModdedOre("Tin", "Cassiterite");
                DictionaryFactory.findModdedOre("Aluminum", "Bauxite");
                DictionaryFactory.findModdedOre("Lead", "Galena");
                DictionaryFactory.findModdedOre("Silver", null);
                DictionaryFactory.findModdedOre("Nickel", "Garnierite");
                DictionaryFactory.findModdedOre("Uranium", null);
                DictionaryFactory.findModdedOre("Iridium", null);
                DictionaryFactory.findModdedOre("Mercury", "Cinnabar");
                DictionaryFactory.findModdedOre("Zinc", "Sphalerite");
                DictionaryFactory.findModdedOre("Tungsten", null);
                DictionaryFactory.findModdedOre("Platinum", null);
                DictionaryFactory.findModdedOre("Mithril", null);
                DictionaryFactory.findModdedOre("Sulfur", null);
                DictionaryFactory.findModdedOre("ClathrateOilSand", null);
                DictionaryFactory.findModdedOre("ClathrateOilShale", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void findModdedOre(String name, String backup) {
        ItemStack stack;
        Block block;
        if (OreDictionary.doesOreNameExist((String)("ore" + name))) {
            ItemStack stack2 = (ItemStack)OreDictionary.getOres((String)("ore" + name)).get(0);
            Block block2 = Block.func_149634_a((Item)stack2.func_77973_b());
            if (block2 != Blocks.field_150350_a) {
                blockDictionary.put(name.toLowerCase() + "_ore", block2.func_176203_a(stack2.func_77960_j()));
            }
        } else if (backup != null && OreDictionary.doesOreNameExist((String)("ore" + backup)) && (block = Block.func_149634_a((Item)(stack = (ItemStack)OreDictionary.getOres((String)("ore" + backup)).get(0)).func_77973_b())) != Blocks.field_150350_a) {
            blockDictionary.put(name.toLowerCase() + "_ore", block.func_176203_a(stack.func_77960_j()));
        }
    }

    public static void postLoad() {
        if (disableOres) {
            ores.clear();
        }
        if (disableSlimeOre) {
            DictionaryFactory.removeOre("oil");
        }
        if (disableGlowstoneOre) {
            DictionaryFactory.removeOre("glowstone");
        }
        if (disableQuartzOre) {
            DictionaryFactory.removeOre("quartz_ore");
        }
        if (disableClayOre) {
            DictionaryFactory.removeOre("clay");
        }
        if (replaceHellBiome) {
            block0: for (List<GeoFeature> biomes : DictionaryFactory.biomes.values()) {
                for (GeoFeature biome : biomes) {
                    if (biome.index != 8) continue;
                    biome.index = 25;
                    break block0;
                }
            }
        }
    }

    private static boolean removeOre(String key) {
        boolean removed = false;
        for (List<GeoFeature> list : ores.values()) {
            int found = -1;
            for (int i = 0; i < list.size(); ++i) {
                GeoFeature ore = list.get(i);
                if (!ore.block.equals(blockDictionary.get(key))) continue;
                found = i;
                break;
            }
            if (found < 0) continue;
            list.remove(found);
            removed = true;
        }
        return removed;
    }

    private static IBlockState getBlockState(Block block, String properties) {
        JsonObject propertiesJson = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)new StringReader(properties), JsonObject.class);
        Set set = propertiesJson.entrySet();
        if (block != null) {
            ImmutableList states = block.func_176194_O().func_177619_a();
            block0: for (IBlockState state : states) {
                for (Map.Entry entry : set) {
                    Object value = DictionaryFactory.getStatePropertyValue(state, (String)entry.getKey());
                    if (((JsonElement)entry.getValue()).getAsString().equals(String.valueOf(value))) continue;
                    continue block0;
                }
                return state;
            }
        }
        throw new IllegalArgumentException(block.getRegistryName() + ":" + properties);
    }

    private static Object getStatePropertyValue(IBlockState state, String key) {
        for (IProperty prop : state.func_177227_a()) {
            if (!key.equals(prop.func_177701_a())) continue;
            return state.func_177229_b(prop);
        }
        return null;
    }

    public static GeoFeature getGeoFeature(String key, JsonObject json, JsonContext context) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("getMaterial Context cannot be null");
        }
        String type = context.appendModId(JsonUtils.func_151200_h((JsonObject)json, (String)"type"));
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Material type can not be an empty string");
        }
        key = key.substring(key.lastIndexOf("/") + 1);
        int level = key.split("_").length;
        GeoFeature geo = null;
        switch (type) {
            case "dooglamooworlds:block": {
                IBlockState state = blockDictionary.get(key);
                if (state != null) {
                    geo = new GeoFeature(state, level);
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorlds.logger.info("No registered block found: " + key);
                break;
            }
            case "dooglamooworlds:block_ore": {
                IBlockState state = blockDictionary.get(key);
                if (state != null) {
                    geo = new GeoFeature(state, JsonUtils.func_151208_a((JsonObject)json, (String)"spacing", (int)23), JsonUtils.func_151208_a((JsonObject)json, (String)"depth", (int)255));
                    JsonArray rar = JsonUtils.func_151214_t((JsonObject)json, (String)"rarity");
                    if (rar.size() > 0) {
                        geo.rarity[0] = rar.get(0).getAsFloat();
                    }
                    if (rar.size() > 1) {
                        geo.rarity[1] = rar.get(1).getAsFloat();
                    }
                    if (rar.size() > 2) {
                        geo.rarity[2] = rar.get(2).getAsFloat();
                    }
                    JsonArray req = JsonUtils.func_151213_a((JsonObject)json, (String)"requirements", (JsonArray)new JsonArray());
                    int requirement = 1;
                    if (req.size() > 0) {
                        for (Map.Entry entry : req.get(0).getAsJsonObject().entrySet()) {
                            switch ((String)entry.getKey()) {
                                case "elevation": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 2 : 10;
                                    break;
                                }
                                case "density": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 3 : 11;
                                    break;
                                }
                                case "uplift": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 4 : 12;
                                    break;
                                }
                                case "volcanism": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 5 : 13;
                                    break;
                                }
                                case "era": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 6 : 14;
                                    break;
                                }
                                case "erosion": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 7 : 15;
                                    break;
                                }
                                case "temperature": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 8 : 16;
                                    break;
                                }
                                case "precipitation": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 9 : 17;
                                }
                            }
                        }
                    }
                    geo.requirement = requirement;
                    JsonArray mod = JsonUtils.func_151213_a((JsonObject)json, (String)"modifiers", (JsonArray)new JsonArray());
                    int modifier1 = 0;
                    int modifier2 = 0;
                    if (mod.size() > 0) {
                        for (Map.Entry entry : mod.get(0).getAsJsonObject().entrySet()) {
                            switch ((String)entry.getKey()) {
                                case "elevation": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 2 : 10;
                                    break;
                                }
                                case "density": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 3 : 11;
                                    break;
                                }
                                case "uplift": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 4 : 12;
                                    break;
                                }
                                case "volcanism": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 5 : 13;
                                    break;
                                }
                                case "era": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 6 : 14;
                                    break;
                                }
                                case "erosion": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 7 : 15;
                                    break;
                                }
                                case "temperature": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 8 : 16;
                                    break;
                                }
                                case "precipitation": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 9 : 17;
                                }
                            }
                        }
                    }
                    if (mod.size() > 1) {
                        for (Map.Entry entry : mod.get(1).getAsJsonObject().entrySet()) {
                            switch ((String)entry.getKey()) {
                                case "elevation": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 2 : 10;
                                    break;
                                }
                                case "density": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 3 : 11;
                                    break;
                                }
                                case "uplift": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 4 : 12;
                                    break;
                                }
                                case "volcanism": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 5 : 13;
                                    break;
                                }
                                case "era": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 6 : 14;
                                    break;
                                }
                                case "erosion": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 7 : 15;
                                    break;
                                }
                                case "temperature": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 8 : 16;
                                    break;
                                }
                                case "precipitation": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 9 : 17;
                                }
                            }
                        }
                    }
                    geo.modifier[0] = modifier1;
                    geo.modifier[1] = modifier2;
                    MinMaxBounds density = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinDensity(density.getMin());
                    geo.setMaxDensity(density.getMax());
                    break;
                }
                DooglamooWorlds.logger.info("No registered block found: " + key);
                break;
            }
            case "dooglamooworlds:feature": {
                WorldGenerator gen = featureDictionary.get(key);
                if (gen != null) {
                    geo = new GeoFeature(gen, JsonUtils.func_151217_k((JsonObject)json, (String)"rarity"), null);
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorlds.logger.info("No registered feature found: " + key);
                break;
            }
            case "dooglamooworlds:feature_cave": {
                WorldGenerator gen = featureDictionary.get(key);
                if (gen != null) {
                    geo = new GeoFeature(gen, JsonUtils.func_151217_k((JsonObject)json, (String)"rarity"), "cave");
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorlds.logger.info("No registered feature found: " + key);
                break;
            }
            case "dooglamooworlds:feature_ocean": {
                WorldGenerator gen = featureDictionary.get(key);
                if (gen != null) {
                    geo = new GeoFeature(gen, JsonUtils.func_151217_k((JsonObject)json, (String)"rarity"), "ocean");
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorlds.logger.info("No registered feature found: " + key);
                break;
            }
            case "dooglamooworlds:biome": {
                String domain = JsonUtils.func_151219_a((JsonObject)json, (String)"domain", (String)"minecraft");
                Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(domain, key));
                if (biome != null) {
                    geo = new GeoFeature(Biome.func_185362_a((Biome)biome), "minecraft".equals(domain) ? 0 : 1, null);
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorlds.logger.info("No registered biome found: " + key);
                break;
            }
            case "dooglamooworlds:biome_ocean": {
                String domain = JsonUtils.func_151219_a((JsonObject)json, (String)"domain", (String)"minecraft");
                Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(domain, key));
                if (biome != null) {
                    geo = new GeoFeature(Biome.func_185362_a((Biome)biome), "minecraft".equals(domain) ? 0 : 1, "ocean");
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorlds.logger.info("No registered biome found: " + key);
                break;
            }
            default: {
                DooglamooWorlds.logger.info("Unknown geofeature type: " + type);
            }
        }
        return geo;
    }

    public static void register(GeoFeature geo) {
        if (geo == null) {
            return;
        }
        ++totalCount;
        if (geo.getType() == GeoFeature.Type.Biome || geo.getType() == GeoFeature.Type.OceanBiome) {
            if (geo.level > 0) {
                addedBiomes.add(geo.getBiome());
            }
            ++biomeCount;
        } else if (geo.getType() == GeoFeature.Type.Block) {
            ++blockCount;
        } else if (geo.getType() == GeoFeature.Type.Feature) {
            ++featureCount;
        } else if (geo.getType() == GeoFeature.Type.OreBlock) {
            for (int i = geo.getMinDensity(); i <= geo.getMaxDensity(); ++i) {
                List<GeoFeature> list = ores.get(i);
                if (list == null) {
                    list = new ArrayList<GeoFeature>();
                    ores.put(i, list);
                }
                int origIndex = -1;
                for (int j = 0; j < list.size(); ++j) {
                    GeoFeature orig = list.get(j);
                    if (!orig.block.equals(geo.block)) continue;
                    origIndex = j;
                    break;
                }
                if (origIndex >= 0) {
                    list.set(origIndex, geo);
                    continue;
                }
                list.add(geo);
            }
            return;
        }
        for (int t = geo.getMinTemperature(); t <= geo.getMaxTemperature(); ++t) {
            for (int w = geo.getMinPrecipitation(); w <= geo.getMaxPrecipitation(); ++w) {
                for (int u = geo.getMinUplift(); u <= geo.getMaxUplift(); ++u) {
                    for (int e = geo.getMinErosion(); e <= geo.getMaxErosion(); ++e) {
                        for (int g = geo.getMinVolcanism(); g <= geo.getMaxVolcanism(); ++g) {
                            for (int a = geo.getMinEra(); a <= geo.getMaxEra(); ++a) {
                                for (int p = geo.getMinElevation(); p <= geo.getMaxElevation(); ++p) {
                                    for (int r = geo.getMinDensity(); r <= geo.getMaxDensity(); ++r) {
                                        int id = t << 14 | w << 12 | u << 10 | e << 8 | g << 6 | a << 4 | p << 2 | r << 0;
                                        List<GeoFeature> list = null;
                                        switch (geo.getType()) {
                                            case Block: {
                                                list = blocks.get(id);
                                                break;
                                            }
                                            case OreBlock: {
                                                break;
                                            }
                                            case Feature: {
                                                list = features.get(id);
                                                break;
                                            }
                                            case CaveFeature: {
                                                list = caveFeatures.get(id);
                                                break;
                                            }
                                            case OceanFeature: {
                                                list = oceanFeatures.get(id);
                                                break;
                                            }
                                            case Biome: {
                                                list = biomes.get(id);
                                                break;
                                            }
                                            case OceanBiome: {
                                                list = oceanBiomes.get(id);
                                            }
                                        }
                                        if (list == null) {
                                            list = new ArrayList<GeoFeature>();
                                            switch (geo.getType()) {
                                                case Block: {
                                                    blocks.put(id, list);
                                                    break;
                                                }
                                                case OreBlock: {
                                                    break;
                                                }
                                                case Feature: {
                                                    features.put(id, list);
                                                    break;
                                                }
                                                case CaveFeature: {
                                                    caveFeatures.put(id, list);
                                                    break;
                                                }
                                                case OceanFeature: {
                                                    oceanFeatures.put(id, list);
                                                    break;
                                                }
                                                case Biome: {
                                                    biomes.put(id, list);
                                                    break;
                                                }
                                                case OceanBiome: {
                                                    oceanBiomes.put(id, list);
                                                }
                                            }
                                        }
                                        if (geo.getType() == GeoFeature.Type.Biome || geo.getType() == GeoFeature.Type.OceanBiome) {
                                            if (list.size() > 0 && geo.getLevel() <= list.get(0).getLevel()) {
                                                DooglamooWorlds.logger.info("registering biome mapping failed: " + geo.getBiome() + " overlaps " + list.get(0).getBiome());
                                                continue;
                                            }
                                            list.clear();
                                            list.add(geo);
                                            continue;
                                        }
                                        if (geo.getType() == GeoFeature.Type.Block) {
                                            boolean skip = false;
                                            Iterator<GeoFeature> it = list.iterator();
                                            while (it.hasNext()) {
                                                GeoFeature feature = it.next();
                                                if (feature.getLevel() < geo.getLevel()) {
                                                    it.remove();
                                                    continue;
                                                }
                                                if (feature.getLevel() <= geo.getLevel()) continue;
                                                skip = true;
                                            }
                                            if (skip) continue;
                                            list.add(geo);
                                            continue;
                                        }
                                        list.add(geo);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static WorldGenDoublePlant getDoublePlantGenerator(BlockDoublePlant.EnumPlantType plantTypeIn) {
        WorldGenDoublePlant plantGen = new WorldGenDoublePlant();
        plantGen.func_180710_a(plantTypeIn);
        return plantGen;
    }

    static {
        blocks = new HashMap<Integer, List<GeoFeature>>();
        features = new HashMap<Integer, List<GeoFeature>>();
        caveFeatures = new HashMap<Integer, List<GeoFeature>>();
        oceanFeatures = new HashMap<Integer, List<GeoFeature>>();
        biomes = new HashMap<Integer, List<GeoFeature>>();
        oceanBiomes = new HashMap<Integer, List<GeoFeature>>();
        ores = new HashMap<Integer, List<GeoFeature>>();
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }
}

