/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.viewer;

import com.dooglamoo.worlds.viewer.TerrainView;
import java.awt.Color;

public class ClimateTerrainView
implements TerrainView {
    private static final Color JUNGLE = new Color(31, 167, 99);
    private static final Color DARK_FOREST = new Color(0, 128, 0);
    private static final Color SAVANNA = new Color(157, 157, 0);
    private static final Color DESERT = new Color(233, 203, 112);
    private static final Color SWAMP = new Color(66, 104, 68);
    private static final Color FOREST = new Color(0, 213, 0);
    private static final Color PLAINS = new Color(181, 230, 29);
    private static final Color BADLANDS = new Color(217, 173, 43);
    private static final Color GIANT_TAIGA = new Color(128, 174, 130);
    private static final Color TAIGA = new Color(106, 255, 106);
    private static final Color BIRCH_FOREST = new Color(208, 239, 114);
    private static final Color STONE_SHORE = new Color(167, 141, 92);
    private static final Color FROZEN_RIVER = new Color(195, 195, 195);
    private static final Color SNOWY_TAIGA = new Color(228, 228, 228);
    private static final Color TUNDRA = new Color(255, 255, 255);
    private static final Color VOLCANO = new Color(50, 43, 51);
    private static final Color FROZEN_OCEAN = new Color(154, 79, 255);
    private static final Color DEEP_FROZEN_OCEAN = new Color(121, 21, 255);
    private static final Color COLD_OCEAN = new Color(114, 79, 255);
    private static final Color DEEP_COLD_OCEAN = new Color(68, 21, 255);
    private static final Color OCEAN = new Color(79, 79, 255);
    private static final Color DEEP_OCEAN = new Color(21, 21, 255);
    private static final Color LUKEWARM_OCEAN = new Color(79, 118, 255);
    private static final Color DEEP_LUKEWARM_OCEAN = new Color(21, 74, 255);
    private static final Color WARM_OCEAN = new Color(79, 167, 255);
    private static final Color DEEP_WARM_OCEAN = new Color(21, 138, 255);
    private static final Color RIVER = new Color(0, 53, 132);
    private static final Color BEACH = new Color(105, 78, 14);
    private static final Color SNOWY_BEACH = new Color(251, 247, 230);

    @Override
    public Color getColor(int x, int z, double[] geofactors, int[] levels, int code) {
        Color color = Color.MAGENTA;
        if (geofactors[1] > 0.0) {
            block0 : switch (code & 0xC000) {
                case 49152: {
                    switch (code & 0x3000) {
                        case 12288: {
                            color = JUNGLE;
                            break block0;
                        }
                        case 8192: {
                            color = DARK_FOREST;
                            break block0;
                        }
                        case 4096: {
                            color = SAVANNA;
                            break block0;
                        }
                        case 0: {
                            color = DESERT;
                        }
                    }
                    break;
                }
                case 32768: {
                    switch (code & 0x3000) {
                        case 12288: {
                            color = SWAMP;
                            break block0;
                        }
                        case 8192: {
                            color = FOREST;
                            break block0;
                        }
                        case 4096: {
                            color = PLAINS;
                            break block0;
                        }
                        case 0: {
                            color = BADLANDS;
                        }
                    }
                    break;
                }
                case 16384: {
                    switch (code & 0x3000) {
                        case 12288: {
                            color = GIANT_TAIGA;
                            break block0;
                        }
                        case 8192: {
                            color = TAIGA;
                            break block0;
                        }
                        case 4096: {
                            color = BIRCH_FOREST;
                            break block0;
                        }
                        case 0: {
                            color = STONE_SHORE;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (code & 0x3000) {
                        case 12288: {
                            color = FROZEN_RIVER;
                            break block0;
                        }
                        case 8192: {
                            color = SNOWY_TAIGA;
                            break block0;
                        }
                        case 4096: {
                            color = TUNDRA;
                            break block0;
                        }
                        case 0: {
                            color = TUNDRA;
                        }
                    }
                }
            }
        } else if (geofactors[1] > -0.5) {
            switch (code & 0xC000) {
                case 49152: {
                    color = WARM_OCEAN;
                    break;
                }
                case 32768: {
                    color = LUKEWARM_OCEAN;
                    break;
                }
                case 16384: {
                    color = COLD_OCEAN;
                    break;
                }
                case 0: {
                    color = FROZEN_OCEAN;
                }
            }
            if ((code & 0x3000) == 0 || (code & 0x3000) == 4096) {
                switch (code & 0xC000) {
                    case 16384: 
                    case 32768: {
                        color = OCEAN;
                    }
                }
            }
        } else {
            switch (code & 0xC000) {
                case 49152: {
                    color = DEEP_WARM_OCEAN;
                    break;
                }
                case 32768: {
                    color = DEEP_LUKEWARM_OCEAN;
                    break;
                }
                case 16384: {
                    color = DEEP_COLD_OCEAN;
                    break;
                }
                case 0: {
                    color = DEEP_FROZEN_OCEAN;
                }
            }
            if ((code & 0x3000) == 0 || (code & 0x3000) == 4096) {
                switch (code & 0xC000) {
                    case 16384: 
                    case 32768: {
                        color = DEEP_OCEAN;
                    }
                }
            }
        }
        if ((code & 0xC0) == 192 && ((code & 0x30) == 0 || (code & 0x30) == 16)) {
            color = VOLCANO;
        }
        if (geofactors[1] > 0.0 && (levels[3] < 63 || levels[3] < levels[1] - 1)) {
            color = RIVER;
        } else if (geofactors[1] <= 0.0 && levels[3] >= 62) {
            color = (code & 0xC000) == 0 ? SNOWY_BEACH : BEACH;
        }
        return color;
    }
}

