/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.viewer;

import com.dooglamoo.worlds.dict.MinMaxBounds;
import com.dooglamoo.worlds.viewer.TerrainView;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.io.Reader;
import java.io.StringReader;
import net.minecraft.util.JsonUtils;

public class JsonTerrainView
implements TerrainView {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final MinMaxBounds temperature;
    private final MinMaxBounds precipitation;
    private final MinMaxBounds uplift;
    private final MinMaxBounds erosion;
    private final MinMaxBounds volcanism;
    private final MinMaxBounds era;
    private final MinMaxBounds elevation;
    private final MinMaxBounds density;

    public JsonTerrainView(String jsonStr) {
        StringReader reader = new StringReader(jsonStr);
        JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
        this.temperature = MinMaxBounds.deserialize(json.get("temperature"));
        this.precipitation = MinMaxBounds.deserialize(json.get("precipitation"));
        this.uplift = MinMaxBounds.deserialize(json.get("uplift"));
        this.erosion = MinMaxBounds.deserialize(json.get("erosion"));
        this.volcanism = MinMaxBounds.deserialize(json.get("volcanism"));
        this.era = MinMaxBounds.deserialize(json.get("era"));
        this.elevation = MinMaxBounds.deserialize(json.get("elevation"));
        this.density = MinMaxBounds.deserialize(json.get("density"));
    }

    @Override
    public Color getColor(int x, int z, double[] geofactors, int[] levels, int code) {
        Color color = Color.WHITE;
        block0: for (int t = this.temperature.getMin(); t <= this.temperature.getMax(); ++t) {
            for (int w = this.precipitation.getMin(); w <= this.precipitation.getMax(); ++w) {
                for (int u = this.uplift.getMin(); u <= this.uplift.getMax(); ++u) {
                    for (int e = this.erosion.getMin(); e <= this.erosion.getMax(); ++e) {
                        for (int g = this.volcanism.getMin(); g <= this.volcanism.getMax(); ++g) {
                            for (int a = this.era.getMin(); a <= this.era.getMax(); ++a) {
                                for (int p = this.elevation.getMin(); p <= this.elevation.getMax(); ++p) {
                                    for (int r = this.density.getMin(); r <= this.density.getMax(); ++r) {
                                        int code1 = t << 14 | w << 12 | u << 10 | e << 8 | g << 6 | a << 4 | p << 2 | r << 0;
                                        if (code1 != code) continue;
                                        color = Color.BLACK;
                                        break block0;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return color;
    }
}

