/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.viewer;

import com.dooglamoo.worlds.viewer.TerrainView;
import java.awt.Color;

public class OreTerrainView
implements TerrainView {
    public static final double[] IRON = new double[]{1.0, 12.0, 7.0, 13.0};
    public static final double[] COAL = new double[]{1.0, 14.0, 17.0, 4.0};
    public static final double[] GOLD = new double[]{2.0, 15.0, 12.0, 8.0};
    public static final double[] REDSTONE = new double[]{2.0, 12.0, 6.0, 9.0};
    public static final double[] DIAMOND = new double[]{3.0, 13.0};
    public static final double[] EMERALD = new double[]{3.0};
    public static final double[] QUARTZ = new double[]{3.0, 7.0, 5.0, 6.0};
    public static final double[] CLAY = new double[]{0.0, 17.0, 6.0, 4.0};
    public static final double[] ALUMINUM = new double[]{0.0, 16.0, 7.0, 14.0};
    public static final double[] COPPER = new double[]{2.0, 12.0, 5.0, 9.0};
    public static final double[] LEAD = new double[]{3.0, 13.0, 15.0, 6.0};
    public static final double[] NICKEL = new double[]{0.0, 4.0, 5.0, 17.0};
    public static final double[] SILVER = new double[]{1.0, 8.0, 12.0, 15.0};
    public static final double[] TIN = new double[]{2.0, 17.0, 13.0, 15.0};
    public static final double[] URANIUM = new double[]{1.0, 6.0};
    private int density;
    private int requirement = -1;
    private int modifier1 = -1;
    private int modifier2 = -1;
    private double[] factors = new double[18];

    public OreTerrainView(double[] params) {
        if (params != null) {
            if (params.length > 0) {
                this.density = (int)params[0];
            }
            if (params.length > 1) {
                this.requirement = (int)params[1];
            }
            if (params.length > 2) {
                this.modifier1 = (int)params[2];
            }
            if (params.length > 3) {
                this.modifier2 = (int)params[3];
            }
        }
    }

    @Override
    public Color getColor(int x, int z, double[] geofactors, int[] levels, int code) {
        this.factors[2] = geofactors[1] < 0.0 ? -geofactors[1] : 0.0;
        this.factors[3] = geofactors[2] < 0.0 ? -geofactors[2] : 0.0;
        this.factors[4] = geofactors[3] < 0.0 ? -geofactors[3] : 0.0;
        this.factors[5] = geofactors[4] < 0.0 ? -geofactors[4] : 0.0;
        this.factors[6] = geofactors[5] < 0.0 ? -geofactors[5] : 0.0;
        this.factors[7] = geofactors[6] < 0.0 ? -geofactors[6] : 0.0;
        this.factors[8] = geofactors[7] < 0.0 ? -geofactors[7] : 0.0;
        this.factors[9] = geofactors[8] < 0.0 ? -geofactors[8] : 0.0;
        this.factors[10] = geofactors[1] > 0.0 ? geofactors[1] : 0.0;
        this.factors[11] = geofactors[2] > 0.0 ? geofactors[2] : 0.0;
        this.factors[12] = geofactors[3] > 0.0 ? geofactors[3] : 0.0;
        this.factors[13] = geofactors[4] > 0.0 ? geofactors[4] : 0.0;
        this.factors[14] = geofactors[5] > 0.0 ? geofactors[5] : 0.0;
        this.factors[15] = geofactors[6] > 0.0 ? geofactors[6] : 0.0;
        this.factors[16] = geofactors[7] > 0.0 ? geofactors[7] : 0.0;
        double d = this.factors[17] = geofactors[8] > 0.0 ? geofactors[8] : 0.0;
        if (levels[3] < levels[5] - 1 || levels[3] < levels[1] - 1) {
            return Color.CYAN;
        }
        Color color = Color.green;
        if (geofactors[2] < -0.5 && this.density == 0 || geofactors[2] >= -0.5 && geofactors[2] < 0.0 && this.density == 1 || geofactors[2] >= 0.0 && geofactors[2] < 0.5 && this.density == 2 || geofactors[2] >= 0.5 && this.density == 3) {
            color = color.darker();
            if (this.requirement == -1 || this.factors[this.requirement] > 0.0) {
                double amount = ((this.modifier1 != -1 ? this.factors[this.modifier1] : 0.4) + (this.modifier2 != -1 ? this.factors[this.modifier2] : 0.4)) / 1.6;
                if (amount > 1.0) {
                    amount = 1.0;
                }
                color = new Color((int)(amount * 255.0), 0, 127);
            }
        }
        return color;
    }
}

