/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.biome;

import com.dooglamoo.voxel.noise.NoiseGenerator;
import com.dooglamoo.voxel.noise.NoiseGeneratorHeightMap;
import com.dooglamoo.voxel.noise.NoiseGeneratorPerlin;
import com.dooglamoo.worlds.common.ConfigHandler;
import com.dooglamoo.worlds.world.biome.GeoFactorCache;
import com.dooglamoo.worlds.world.gen.layer.GenLayerDooglamoo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Biomes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.IntCache;

public class BiomeProviderDooglamoo
extends BiomeProvider {
    private GenLayerDooglamoo genBiomes;
    private final List<Biome> biomesToSpawnIn;
    private final BiomeCache biomeCache;
    private final GeoFactorCache geoFactorCache;
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public final Random rand;
    public NoiseGenerator noiseGen7;
    public NoiseGenerator noiseGen1;
    public NoiseGenerator noiseGen2;
    public NoiseGenerator noiseGen3;
    public NoiseGenerator noiseGen4;
    public NoiseGenerator noiseGen5;
    public NoiseGenerator noiseGen6;
    public NoiseGenerator noiseGen8;
    public NoiseGenerator noiseGen9;
    public double plateWeight;
    public double rockWeight;
    public double liftWeight;
    public double thermalWeight;
    public double ageWeight;
    public double erosionWeight;
    public double tempWeight;
    public double precipWeight;
    public static double plateFactor = 1.0;
    public static double rockFactor = 1.0;
    public static double liftFactor = 1.0;
    public static double thermalFactor = 1.0;
    public static double ageFactor = 1.0;
    public static double erosionFactor = 1.0;
    public static double tempFactor = 1.0;
    public static double precipFactor = 1.0;
    public static boolean sharpEdges;

    public BiomeProviderDooglamoo(World worldIn, long seed, boolean weighted, double scale, String generatorOptions) {
        this.rand = new Random(seed);
        this.noiseGen7 = new NoiseGeneratorPerlin(this.rand, 5).setScale(0.2);
        if (ConfigHandler.geomapsExist(worldIn.func_72912_H().func_76065_j())) {
            double scaleConfig = 1.0;
            Vec3d centerConfig = null;
            JsonObject geomapConfigJson = ConfigHandler.getGeomapConfig(worldIn.func_72912_H().func_76065_j());
            if (geomapConfigJson != null) {
                scaleConfig = JsonUtils.func_151221_a((JsonObject)geomapConfigJson, (String)"scale", (float)1.0f);
                JsonObject centerConfigJson = JsonUtils.func_152754_s((JsonObject)geomapConfigJson, (String)"spawn");
                if (JsonUtils.func_151204_g((JsonObject)centerConfigJson, (String)"x") && JsonUtils.func_151204_g((JsonObject)centerConfigJson, (String)"z")) {
                    centerConfig = new Vec3d((double)JsonUtils.func_151221_a((JsonObject)centerConfigJson, (String)"x", (float)0.0f), 0.0, (double)JsonUtils.func_151221_a((JsonObject)centerConfigJson, (String)"z", (float)0.0f));
                }
            }
            this.noiseGen1 = ConfigHandler.geomapExist(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.ELEVATION) ? new NoiseGeneratorHeightMap(ConfigHandler.getGeomap(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.ELEVATION), null, 0.0).setScale(scaleConfig).setCenter(centerConfig) : new NoiseGeneratorPerlin(this.rand, 5).setScale(1.6E-4 * (-4.0 * scale + 13.0));
            this.noiseGen2 = ConfigHandler.geomapExist(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.DENSITY) ? new NoiseGeneratorHeightMap(ConfigHandler.getGeomap(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.DENSITY), null, 0.0).setScale(scaleConfig).setCenter(centerConfig) : new NoiseGeneratorPerlin(this.rand, 2).setScale(6.0E-4 * (-4.0 * scale + 13.0));
            this.noiseGen3 = ConfigHandler.geomapExist(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.UPLIFT) ? new NoiseGeneratorHeightMap(ConfigHandler.getGeomap(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.UPLIFT), this.noiseGen7, 0.1).setScale(scaleConfig).setCenter(centerConfig) : new NoiseGeneratorPerlin(this.rand, 6).setScale(0.004 * (-4.0 * scale + 13.0));
            this.noiseGen4 = ConfigHandler.geomapExist(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.VOLCANISM) ? new NoiseGeneratorHeightMap(ConfigHandler.getGeomap(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.VOLCANISM), null, 0.0).setScale(scaleConfig).setCenter(centerConfig) : new NoiseGeneratorPerlin(this.rand, 3).setScale(1.0E-4 * (-4.0 * scale + 13.0));
            this.noiseGen5 = ConfigHandler.geomapExist(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.ERA) ? new NoiseGeneratorHeightMap(ConfigHandler.getGeomap(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.ERA), null, 0.0).setScale(scaleConfig).setCenter(centerConfig) : new NoiseGeneratorPerlin(this.rand, 4).setScale(5.0E-4 * (-4.0 * scale + 13.0));
            this.noiseGen6 = ConfigHandler.geomapExist(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.EROSION) ? new NoiseGeneratorHeightMap(ConfigHandler.getGeomap(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.EROSION), null, 0.0).setScale(scaleConfig).setCenter(centerConfig) : new NoiseGeneratorPerlin(this.rand, 5).setScale(0.006 * (-4.0 * scale + 13.0));
            this.noiseGen8 = ConfigHandler.geomapExist(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.TEMPERATURE) ? new NoiseGeneratorHeightMap(ConfigHandler.getGeomap(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.TEMPERATURE), null, 0.0).setScale(scaleConfig).setCenter(centerConfig) : new NoiseGeneratorPerlin(this.rand, 2).setScale(1.6E-4 * (-4.0 * scale + 13.0));
            this.noiseGen9 = ConfigHandler.geomapExist(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.PRECIPITATION) ? new NoiseGeneratorHeightMap(ConfigHandler.getGeomap(worldIn.func_72912_H().func_76065_j(), ConfigHandler.GeomapType.PRECIPITATION), null, 0.0).setScale(scaleConfig).setCenter(centerConfig) : new NoiseGeneratorPerlin(this.rand, 2).setScale(1.6E-4 * (-4.0 * scale + 13.0));
        } else {
            this.noiseGen1 = new NoiseGeneratorPerlin(this.rand, 5).setScale(1.6E-4 * (-4.0 * scale + 13.0));
            this.noiseGen2 = new NoiseGeneratorPerlin(this.rand, 2).setScale(6.0E-4 * (-4.0 * scale + 13.0));
            this.noiseGen3 = new NoiseGeneratorPerlin(this.rand, 6).setScale(0.004 * (-4.0 * scale + 13.0));
            this.noiseGen4 = new NoiseGeneratorPerlin(this.rand, 3).setScale(1.0E-4 * (-4.0 * scale + 13.0));
            this.noiseGen5 = new NoiseGeneratorPerlin(this.rand, 4).setScale(5.0E-4 * (-4.0 * scale + 13.0));
            this.noiseGen6 = new NoiseGeneratorPerlin(this.rand, 5).setScale(0.006 * (-4.0 * scale + 13.0));
            this.noiseGen8 = new NoiseGeneratorPerlin(this.rand, 2).setScale(1.6E-4 * (-4.0 * scale + 13.0));
            this.noiseGen9 = new NoiseGeneratorPerlin(this.rand, 2).setScale(1.6E-4 * (-4.0 * scale + 13.0));
        }
        JsonObject weightConfigJson = null;
        if (generatorOptions != null && !generatorOptions.isEmpty()) {
            weightConfigJson = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)new StringReader(generatorOptions), JsonObject.class);
        }
        if (weighted) {
            if (weightConfigJson != null) {
                this.plateWeight = JsonUtils.func_151221_a(weightConfigJson, (String)"elevation", (float)0.0f);
                this.rockWeight = JsonUtils.func_151221_a((JsonObject)weightConfigJson, (String)"density", (float)0.0f);
                this.liftWeight = JsonUtils.func_151221_a((JsonObject)weightConfigJson, (String)"uplift", (float)0.0f);
                this.thermalWeight = JsonUtils.func_151221_a((JsonObject)weightConfigJson, (String)"volcanism", (float)0.0f);
                this.ageWeight = JsonUtils.func_151221_a((JsonObject)weightConfigJson, (String)"era", (float)0.0f);
                this.erosionWeight = JsonUtils.func_151221_a((JsonObject)weightConfigJson, (String)"erosion", (float)0.0f);
                this.tempWeight = JsonUtils.func_151221_a((JsonObject)weightConfigJson, (String)"temperature", (float)0.0f);
                this.precipWeight = JsonUtils.func_151221_a((JsonObject)weightConfigJson, (String)"precipitation", (float)0.0f);
            } else {
                this.plateWeight = this.rand.nextDouble() * 1.2 - 0.6;
                this.rockWeight = this.rand.nextDouble() * 1.2 - 0.6;
                this.liftWeight = this.rand.nextDouble() * 1.2 - 0.6;
                this.thermalWeight = this.rand.nextDouble() * 1.2 - 0.6;
                this.ageWeight = this.rand.nextDouble() * 1.2 - 0.6;
                this.erosionWeight = this.rand.nextDouble() * 1.2 - 0.6;
                this.tempWeight = this.rand.nextDouble() * 1.2 - 0.6;
                this.precipWeight = this.rand.nextDouble() * 1.2 - 0.6;
            }
        }
        this.biomeCache = new BiomeCache((BiomeProvider)this);
        this.geoFactorCache = new GeoFactorCache(this);
        this.biomesToSpawnIn = Lists.newArrayList((Iterable)allowedBiomes);
        this.genBiomes = new GenLayerDooglamoo(this, seed, weighted, scale, generatorOptions);
    }

    public List<Biome> func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        int[] aint = this.genBiomes.func_75904_a(x, z, width, height);
        try {
            for (int i = 0; i < width * height; ++i) {
                biomes[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
            }
            return biomes;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("w", (Object)width);
            crashreportcategory.func_71507_a("h", (Object)height);
            throw new ReportedException(crashreport);
        }
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] abiome = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(abiome, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        int[] aint = this.genBiomes.func_75904_a(x, z, width, length);
        for (int i = 0; i < width * length; ++i) {
            listToReuse[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_185440_P);
        }
        return listToReuse;
    }

    public double[][] getGeoFactors(@Nullable double[][] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new double[width * length][9];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            double[][] ageofactor = this.geoFactorCache.getCachedGeoFactors(x, z);
            System.arraycopy(ageofactor, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        double[][] aint = this.genBiomes.getGeoFactors(x, z, width, length);
        for (int i = 0; i < width * length; ++i) {
            listToReuse[i] = aint[i];
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        IntCache.func_76446_a();
        int i = x - radius;
        int j = z - radius;
        int k = x + radius;
        int l = z + radius;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
        try {
            for (int k1 = 0; k1 < i1 * j1; ++k1) {
                Biome biome = Biome.func_150568_d((int)aint[k1]);
                if (allowed.contains(biome)) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)((Object)((Object)this.genBiomes)).toString());
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)radius);
            crashreportcategory.func_71507_a("allowed", allowed);
            throw new ReportedException(crashreport);
        }
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        IntCache.func_76446_a();
        int i = x - range;
        int j = z - range;
        int k = x + range;
        int l = z + range;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            Biome biome = Biome.func_150568_d((int)aint[l1]);
            if (!biomes.contains(biome) || blockpos != null && random.nextInt(k1 + 1) != 0) continue;
            blockpos = new BlockPos(i2, 0, j2);
            ++k1;
        }
        return blockpos;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
        this.geoFactorCache.cleanupCache();
    }

    public boolean func_190944_c() {
        return false;
    }

    public Biome func_190943_d() {
        return null;
    }
}

