/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.biome;

import com.dooglamoo.worlds.world.biome.BiomeProviderDooglamoo;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.server.MinecraftServer;

public class GeoFactorCache {
    private final BiomeProviderDooglamoo provider;
    private long lastCleanupTime;
    private final Long2ObjectMap<Block> cacheMap = new Long2ObjectOpenHashMap(4096);
    private final List<Block> cache = Lists.newArrayList();

    public GeoFactorCache(BiomeProviderDooglamoo provider) {
        this.provider = provider;
    }

    public Block getGeoFactorCacheBlock(int x, int z) {
        long i = (long)(x >>= 4) & 0xFFFFFFFFL | ((long)(z >>= 4) & 0xFFFFFFFFL) << 32;
        Block geofactorcache$block = (Block)this.cacheMap.get(i);
        if (geofactorcache$block == null) {
            geofactorcache$block = new Block(x, z);
            this.cacheMap.put(i, (Object)geofactorcache$block);
            this.cache.add(geofactorcache$block);
        }
        geofactorcache$block.lastAccessTime = MinecraftServer.func_130071_aq();
        return geofactorcache$block;
    }

    public void cleanupCache() {
        long i = MinecraftServer.func_130071_aq();
        long j = i - this.lastCleanupTime;
        if (j > 7500L || j < 0L) {
            this.lastCleanupTime = i;
            for (int k = 0; k < this.cache.size(); ++k) {
                Block geofactorcache$block = this.cache.get(k);
                long l = i - geofactorcache$block.lastAccessTime;
                if (l <= 30000L && l >= 0L) continue;
                this.cache.remove(k--);
                long i1 = (long)geofactorcache$block.x & 0xFFFFFFFFL | ((long)geofactorcache$block.z & 0xFFFFFFFFL) << 32;
                this.cacheMap.remove(i1);
            }
        }
    }

    public double[][] getCachedGeoFactors(int x, int z) {
        return this.getGeoFactorCacheBlock((int)x, (int)z).geofactors;
    }

    public class Block {
        public double[][] geofactors = new double[256][9];
        public int x;
        public int z;
        public long lastAccessTime;

        public Block(int x, int z) {
            this.x = x;
            this.z = z;
            GeoFactorCache.this.provider.getGeoFactors(this.geofactors, x << 4, z << 4, 16, 16, false);
        }
    }
}

