/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.gen;

import com.dooglamoo.voxel.noise.NoiseGenerator;
import com.dooglamoo.worlds.dict.DictionaryFactory;
import com.dooglamoo.worlds.dict.GeoFeature;
import com.dooglamoo.worlds.world.biome.BiomeProviderDooglamoo;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeHills;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.WoodlandMansion;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorDooglamoo
implements IChunkGenerator {
    public static final int TEMP_COLD = 0;
    public static final int TEMP_COOL = 16384;
    public static final int TEMP_WARM = 32768;
    public static final int TEMP_HOT = 49152;
    public static final int TEMP_MASK = 49152;
    public static final int PRECIP_DRY = 0;
    public static final int PRECIP_MOIST = 4096;
    public static final int PRECIP_HUMID = 8192;
    public static final int PRECIP_WET = 12288;
    public static final int PRECIP_MASK = 12288;
    public static final int LIFT_SUNK = 0;
    public static final int LIFT_LEVEL = 1024;
    public static final int LIFT_HILLS = 2048;
    public static final int LIFT_MOUNTAINS = 3072;
    public static final int LIFT_MASK = 3072;
    public static final int EROSION_NONE = 0;
    public static final int EROSION_SOME = 256;
    public static final int EROSION_MOST = 512;
    public static final int EROSION_FULL = 768;
    public static final int EROSION_MASK = 768;
    public static final int THERMAL_NONE = 0;
    public static final int THERMAL_SOME = 64;
    public static final int THERMAL_MOST = 128;
    public static final int THERMAL_FULL = 192;
    public static final int THERMAL_MASK = 192;
    public static final int AGE_YOUNGEST = 0;
    public static final int AGE_YOUNG = 16;
    public static final int AGE_OLD = 32;
    public static final int AGE_OLDEST = 48;
    public static final int AGE_MASK = 48;
    public static final int PLATES_OCEAN = 0;
    public static final int PLATES_SHALLOWS = 4;
    public static final int PLATES_PLAINS = 8;
    public static final int PLATES_PLATEAU = 12;
    public static final int PLATES_MASK = 12;
    public static final int ROCK_SEDIMENTARY = 0;
    public static final int ROCK_SOFT = 1;
    public static final int ROCK_HARD = 2;
    public static final int ROCK_IGNEOUS = 3;
    public static final int ROCK_MASK = 3;
    public static final int SEA_LEVEL = 63;
    private static double[] factors = new double[18];
    public static final int ROCK_LEVEL = 0;
    private static int[] levels = new int[9];
    private final boolean mapFeaturesEnabled;
    private final IBlockState AIR;
    private final IBlockState LAVA;
    private final IBlockState MAGMA;
    private final IBlockState WATER;
    private final IBlockState WATER_SALT;
    private final IBlockState ICEPACK;
    private final IBlockState TERRACOTTA;
    private final IBlockState TERRACOTTA_ORANGE;
    private final IBlockState TERRACOTTA_RED;
    private final IBlockState TERRACOTTA_SILVER;
    private final IBlockState TERRACOTTA_BROWN;
    private final IBlockState TERRACOTTA_YELLOW;
    private final IBlockState TERRACOTTA_WHITE;
    private final IBlockState OBSIDIAN;
    private final IBlockState STONE;
    private final IBlockState STONE_ANDESITE;
    private final IBlockState STONE_GRANITE;
    private final IBlockState STONE_DIORITE;
    private final IBlockState SANDSTONE;
    private final IBlockState GRAVEL;
    private final IBlockState SAND;
    private final IBlockState DIRT;
    private final IBlockState DIRT_COARSE;
    private final Random rand;
    public NoiseGenerator surfaceGen;
    public NoiseGenerator elevationGen;
    public NoiseGenerator densityGen;
    public NoiseGenerator upliftGen;
    public NoiseGenerator volcanismGen;
    public NoiseGenerator eraGen;
    public NoiseGenerator erosionGen;
    public NoiseGenerator temperatureGen;
    public NoiseGenerator precipitationGen;
    private final World world;
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    private StructureOceanMonument oceanMonumentGenerator = new StructureOceanMonument();
    private final WoodlandMansion woodlandMansionGenerator;
    private Biome[] biomesForGeneration;
    private double[][] geoFactorsForGeneration;
    private double[][] geoFactorsForPopulation;
    private List<GeoFeature> density0;
    private List<GeoFeature> density1;
    private List<GeoFeature> density2;
    private List<GeoFeature> density3;

    public ChunkGeneratorDooglamoo(World worldIn, long seed, boolean mapFeaturesEnabledIn, boolean useStrongholds, boolean weighted, double scale, String generatorOptions) {
        this.world = worldIn;
        this.mapFeaturesEnabled = mapFeaturesEnabledIn;
        ChunkGeneratorDooglamoo.factors[0] = 0.0;
        ChunkGeneratorDooglamoo.factors[1] = 1.0;
        BiomeProviderDooglamoo provider = (BiomeProviderDooglamoo)worldIn.func_72959_q();
        this.rand = provider.rand;
        this.surfaceGen = provider.noiseGen7;
        this.elevationGen = provider.noiseGen1;
        this.densityGen = provider.noiseGen2;
        this.upliftGen = provider.noiseGen3;
        this.volcanismGen = provider.noiseGen4;
        this.eraGen = provider.noiseGen5;
        this.erosionGen = provider.noiseGen6;
        this.temperatureGen = provider.noiseGen8;
        this.precipitationGen = provider.noiseGen9;
        this.AIR = DictionaryFactory.blockDictionary.get("air");
        this.LAVA = DictionaryFactory.blockDictionary.get("lava");
        this.MAGMA = DictionaryFactory.blockDictionary.get("magma");
        this.WATER = DictionaryFactory.blockDictionary.get("water");
        this.WATER_SALT = DictionaryFactory.blockDictionary.get("water_salt");
        this.ICEPACK = DictionaryFactory.blockDictionary.get("icepack");
        this.TERRACOTTA = DictionaryFactory.blockDictionary.get("terracotta");
        this.TERRACOTTA_ORANGE = DictionaryFactory.blockDictionary.get("terracotta_orange");
        this.TERRACOTTA_RED = DictionaryFactory.blockDictionary.get("terracotta_red");
        this.TERRACOTTA_SILVER = DictionaryFactory.blockDictionary.get("terracotta_silver");
        this.TERRACOTTA_BROWN = DictionaryFactory.blockDictionary.get("terracotta_brown");
        this.TERRACOTTA_YELLOW = DictionaryFactory.blockDictionary.get("terracotta_yellow");
        this.TERRACOTTA_WHITE = DictionaryFactory.blockDictionary.get("terracotta_white");
        this.OBSIDIAN = DictionaryFactory.blockDictionary.get("obsidian");
        this.STONE = DictionaryFactory.blockDictionary.get("stone");
        this.STONE_ANDESITE = DictionaryFactory.blockDictionary.get("stone_andesite");
        this.STONE_GRANITE = DictionaryFactory.blockDictionary.get("stone_granite");
        this.STONE_DIORITE = DictionaryFactory.blockDictionary.get("stone_diorite");
        this.SANDSTONE = DictionaryFactory.blockDictionary.get("sandstone");
        this.GRAVEL = DictionaryFactory.blockDictionary.get("gravel");
        this.SAND = DictionaryFactory.blockDictionary.get("sand");
        this.DIRT = DictionaryFactory.blockDictionary.get("dirt");
        this.DIRT_COARSE = DictionaryFactory.blockDictionary.get("coarsedirt");
        this.density0 = DictionaryFactory.ores.get(0);
        if (this.density0 == null) {
            this.density0 = new ArrayList<GeoFeature>();
        }
        this.density1 = DictionaryFactory.ores.get(1);
        if (this.density1 == null) {
            this.density1 = new ArrayList<GeoFeature>();
        }
        this.density2 = DictionaryFactory.ores.get(2);
        if (this.density2 == null) {
            this.density2 = new ArrayList<GeoFeature>();
        }
        this.density3 = DictionaryFactory.ores.get(3);
        if (this.density3 == null) {
            this.density3 = new ArrayList<GeoFeature>();
        }
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.oceanMonumentGenerator = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)this.oceanMonumentGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
        this.woodlandMansionGenerator = new WoodlandMansion(new ChunkGeneratorOverworld(worldIn, seed, false, null){

            public void func_185976_a(int x, int z, ChunkPrimer primer) {
                ChunkGeneratorDooglamoo.this.setBlocksInChunkDooglamoo(x, z, primer);
            }
        });
    }

    private void setBlocksInChunkDooglamoo(int chunkX, int chunkZ, ChunkPrimer primer) {
        int x = chunkX << 4;
        int z = chunkZ << 4;
        this.geoFactorsForGeneration = ((BiomeProviderDooglamoo)this.world.func_72959_q()).getGeoFactors(this.geoFactorsForGeneration, x, z, 16, 16, true);
        for (int n = 0; n < 16; ++n) {
            for (int m = 0; m < 16; ++m) {
                int mantleLevel;
                int surfaceVirtualLevel;
                double erosionFactor;
                int id = 0;
                int index = m * 16 + n;
                double surface = this.geoFactorsForGeneration[index][0];
                double elevation = this.geoFactorsForGeneration[index][1];
                double density = this.geoFactorsForGeneration[index][2];
                double uplift = this.geoFactorsForGeneration[index][3];
                double volcanism = this.geoFactorsForGeneration[index][4];
                double era = this.geoFactorsForGeneration[index][5];
                double erosion = this.geoFactorsForGeneration[index][6];
                double temperature = this.geoFactorsForGeneration[index][7];
                double precipitation = this.geoFactorsForGeneration[index][8];
                double d = this.rand.nextDouble();
                double r = surface * 0.1 + (BiomeProviderDooglamoo.sharpEdges ? 0.0 : d * 0.1 - 0.05);
                id = elevation + surface * 0.008 < -0.5 ? (id |= 0) : (elevation + surface * 0.008 < 0.0 ? (id |= 4) : (elevation + surface * 0.008 < 0.5 ? (id |= 8) : (id |= 0xC)));
                id = density + r < -0.5 ? (id |= 0) : (density + r < 0.0 ? (id |= 1) : (density + r < 0.5 ? (id |= 2) : (id |= 3)));
                id = uplift + r < -0.5 ? (id |= 0) : (uplift + r < 0.0 ? (id |= 0x400) : (uplift + r < 0.5 ? (id |= 0x800) : (id |= 0xC00)));
                id = volcanism + r < -0.5 ? (id |= 0) : (volcanism + r < 0.0 ? (id |= 0x40) : (volcanism + r < 0.5 ? (id |= 0x80) : (id |= 0xC0)));
                id = era + r < -0.5 ? (id |= 0) : (era + r < 0.0 ? (id |= 0x10) : (era + r < 0.5 ? (id |= 0x20) : (id |= 0x30)));
                id = erosion + r < -0.5 ? (id |= 0) : (erosion + r < 0.0 ? (id |= 0x100) : (erosion + r < 0.5 ? (id |= 0x200) : (id |= 0x300)));
                id = temperature + r < -0.5 ? (id |= 0) : (temperature + r < 0.0 ? (id |= 0x4000) : (temperature + r < 0.5 ? (id |= 0x8000) : (id |= 0xC000)));
                id = precipitation + r < -0.5 ? (id |= 0) : (precipitation + r < 0.0 ? (id |= 0x1000) : (precipitation + r < 0.5 ? (id |= 0x2000) : (id |= 0x3000)));
                double surfaceDepthPlateFactor = Math.max(Math.min((elevation + 0.02) * 25.0, 1.0), 0.08);
                int surfaceDepth = (int)(((surface + 1.0) * (uplift > -0.5 ? uplift + 0.5 : 0.0) * 6.0 + (era + 0.5) * 12.0) * surfaceDepthPlateFactor);
                if (surfaceDepth < 1) {
                    surfaceDepth = 1;
                }
                if ((erosionFactor = surface * 2.0) > 0.0) {
                    erosionFactor = -erosionFactor;
                }
                if (erosionFactor > -0.1) {
                    erosionFactor = -0.1;
                }
                erosionFactor = 1.0 + erosionFactor;
                int erosionDepth = density < -0.5 ? (erosion > 0.0 ? (int)(erosion * 50.0) : 0) : (density < 0.0 ? (erosion > 0.0 ? (int)(erosion * 40.0) : 0) : (density < 0.5 ? (erosion > 0.0 ? (int)(erosion * 32.0) : 0) : (erosion > 0.0 ? (int)(erosion * 26.0) : 0)));
                ChunkGeneratorDooglamoo.levels[0] = (int)((elevation + 1.0) / 2.0 * 128.0 + surface * 0.3);
                double upliftFactor = (erosion < 0.0 && uplift > 0.1 && uplift <= 0.6 ? Math.min(Math.max((uplift - 0.1) * (-erosion * 6.0), uplift), 0.6) : uplift) * 128.0;
                int upliftLevel = levels[0] + (int)(uplift > 0.0 ? upliftFactor * Math.min(surfaceDepthPlateFactor + (volcanism > 0.45 ? (volcanism - 0.45) * 4.5 : 0.0), 1.0) : 0.0);
                int surfaceActualLevel = surfaceVirtualLevel = upliftLevel + surfaceDepth;
                if (erosionFactor > 0.0) {
                    surfaceActualLevel = (int)((double)surfaceActualLevel - erosionFactor * (double)erosionDepth);
                }
                if (uplift < -0.5) {
                    surfaceActualLevel = (int)((double)surfaceActualLevel - (-uplift - 0.5) * 50.0);
                }
                if ((mantleLevel = upliftLevel - (int)(200.0 - (volcanism > 0.0 ? volcanism * 256.0 : 0.0))) > upliftLevel) {
                    mantleLevel = upliftLevel;
                }
                if (upliftLevel >= surfaceActualLevel || uplift >= 0.5) {
                    upliftLevel = surfaceActualLevel - 1;
                }
                for (int y = 0; y < 256; ++y) {
                    IBlockState type = this.AIR;
                    if (y < 1) {
                        primer.func_177855_a(n, y, m, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    if (y < 2 && surface > 0.0) {
                        primer.func_177855_a(n, y, m, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    if (y <= mantleLevel) {
                        if (y < 63) {
                            primer.func_177855_a(n, y, m, this.LAVA);
                            continue;
                        }
                        primer.func_177855_a(n, y, m, this.MAGMA);
                        continue;
                    }
                    if (y <= upliftLevel) {
                        type = density < -0.5 ? (y % 67 == 0 ? this.STONE : (y % 17 == 0 ? this.TERRACOTTA_ORANGE : (y % 15 == 0 ? this.TERRACOTTA_RED : (y % 11 == 0 ? this.TERRACOTTA_SILVER : (y % 9 == 0 ? this.TERRACOTTA_BROWN : (y % 19 == 0 ? this.TERRACOTTA_YELLOW : (y % 7 == 0 ? this.TERRACOTTA_WHITE : this.SANDSTONE))))))) : (density < 0.0 ? (y % 12 == 0 ? this.DIRT_COARSE : (y % 16 == 0 ? this.GRAVEL : (y % 71 == 0 ? this.STONE_ANDESITE : this.STONE))) : (density < 0.5 ? (y % 7 == 0 ? this.STONE_ANDESITE : (y % 35 == 0 ? this.STONE : this.STONE_GRANITE)) : (y % 17 == 0 ? this.OBSIDIAN : (y % 15 == 0 ? this.STONE_ANDESITE : (y % 9 == 0 ? this.STONE_GRANITE : this.STONE_DIORITE)))));
                        if ((y >= surfaceActualLevel - 1 && surfaceActualLevel - 1 <= 63 || y >= levels[0] && levels[0] <= 63) && y == mantleLevel + 1) {
                            type = this.OBSIDIAN;
                        }
                        primer.func_177855_a(n, y, m, type);
                        continue;
                    }
                    if (y <= surfaceActualLevel) {
                        if (y == surfaceActualLevel) {
                            if ((uplift < 0.5 || surface < 0.0) && y > 0 && primer.func_177856_a(n, y - 1, m).func_185904_a() != Material.field_151579_a) {
                                List<GeoFeature> blockList = DictionaryFactory.blocks.get(id);
                                IBlockState materialType = y > 0 && (primer.func_177856_a(n, y - 1, m).func_177230_c() == Blocks.field_150353_l || primer.func_177856_a(n, y - 1, m).func_177230_c() == Blocks.field_189877_df) ? this.OBSIDIAN : (y < 63 ? (surface < -0.5 ? this.GRAVEL : this.SAND) : (blockList != null ? blockList.get(this.rand.nextInt(blockList.size())).getBlockType() : (precipitation + r < -0.5 ? this.SAND : this.DIRT)));
                                primer.func_177855_a(n, y, m, materialType);
                                continue;
                            }
                            if (y >= 63) continue;
                            primer.func_177855_a(n, y, m, this.WATER);
                            continue;
                        }
                        if (y <= surfaceActualLevel - (surfaceVirtualLevel - upliftLevel) / 2) {
                            if (surfaceActualLevel - mantleLevel < 5 && surface < 0.0) continue;
                            if (uplift > 0.5) {
                                primer.func_177855_a(n, y, m, this.STONE);
                                continue;
                            }
                            primer.func_177855_a(n, y, m, this.DIRT_COARSE);
                            continue;
                        }
                        if (surfaceActualLevel - mantleLevel < 5 && surface < 0.0) continue;
                        if (precipitation < -0.5) {
                            if (temperature > 0.5) {
                                primer.func_177855_a(n, y, m, this.SAND);
                                continue;
                            }
                            if (temperature < -0.5) {
                                primer.func_177855_a(n, y, m, this.ICEPACK);
                                continue;
                            }
                            if (y % 13 == 0) {
                                primer.func_177855_a(n, y, m, this.TERRACOTTA_RED);
                                continue;
                            }
                            if (y % 15 == 0) {
                                primer.func_177855_a(n, y, m, this.TERRACOTTA_BROWN);
                                continue;
                            }
                            if (y % 17 == 0) {
                                primer.func_177855_a(n, y, m, this.TERRACOTTA_YELLOW);
                                continue;
                            }
                            if (y % 19 == 0) {
                                primer.func_177855_a(n, y, m, this.TERRACOTTA_ORANGE);
                                continue;
                            }
                            primer.func_177855_a(n, y, m, this.TERRACOTTA);
                            continue;
                        }
                        primer.func_177855_a(n, y, m, this.DIRT);
                        continue;
                    }
                    if ((double)y < (double)surfaceVirtualLevel + (Math.min(precipitation, 0.7) - 0.7) * 15.0 - Math.max(uplift, 0.0) * 25.0) {
                        if (temperature < -0.5) {
                            primer.func_177855_a(n, y, m, this.ICEPACK);
                            continue;
                        }
                        if (y >= 63 && y >= levels[0] - 1) continue;
                        primer.func_177855_a(n, y, m, this.WATER);
                        continue;
                    }
                    if (y >= 63 && y >= levels[0] - 1) continue;
                    primer.func_177855_a(n, y, m, this.WATER_SALT);
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunkDooglamoo(x, z, chunkprimer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x << 4, z << 4, 16, 16);
        this.caveGenerator.func_186125_a(this.world, x, z, chunkprimer);
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.villageGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.strongholdGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.scatteredFeatureGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.oceanMonumentGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.woodlandMansionGenerator.func_186125_a(this.world, x, z, chunkprimer);
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int i = chunkX << 4;
        int j = chunkZ << 4;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
        boolean flag = false;
        this.geoFactorsForPopulation = ((BiomeProviderDooglamoo)this.world.func_72959_q()).getGeoFactors(this.geoFactorsForPopulation, i, j, 16, 16, true);
        double precipitationCorner = this.geoFactorsForPopulation[136][8];
        double volcanismCorner = this.geoFactorsForPopulation[136][4];
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag);
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        if (this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_175794_a(this.world, this.rand, chunkpos);
            if (biome != Biomes.field_76778_j) {
                this.mineshaftGenerator.func_175794_a(this.world, this.rand, chunkpos);
                flag = this.villageGenerator.func_175794_a(this.world, this.rand, chunkpos);
                this.scatteredFeatureGenerator.func_175794_a(this.world, this.rand, chunkpos);
                this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, chunkpos);
                this.woodlandMansionGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
        }
        if (precipitationCorner > 0.0 && biome != Biomes.field_76778_j && this.rand.nextDouble() < precipitationCorner / 4.0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int i1 = this.rand.nextInt(16) + 8;
            int j1 = this.rand.nextInt(256);
            int k1 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i1, j1, k1));
        }
        if (volcanismCorner > 0.0 && this.rand.nextDouble() < volcanismCorner / 5.0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
            int i2 = this.rand.nextInt(16) + 8;
            int l2 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            int k3 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i2, l2, k3));
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int j2 = 0; j2 < 5; ++j2) {
                int i3 = this.rand.nextInt(16) + 8;
                int l3 = this.rand.nextInt(256);
                int l1 = this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.world, this.rand, blockpos.func_177982_a(i3, l3, l1));
            }
        }
        this.genOre(i, j);
        if (DictionaryFactory.addedBiomes.contains(Biome.func_185362_a((Biome)biome))) {
            biome.func_180624_a(this.world, this.rand, blockpos);
        } else {
            ChunkPos forgeChunkPos = new ChunkPos(blockpos);
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.rand, forgeChunkPos));
            if (DictionaryFactory.vanillaOres) {
                ChunkGeneratorSettings chunkProviderSettings = ChunkGeneratorSettings.Factory.func_177865_a((String)this.world.func_72912_H().func_82571_y()).func_177864_b();
                WorldGenMinable coalGen = new WorldGenMinable(Blocks.field_150365_q.func_176223_P(), chunkProviderSettings.field_177844_ac);
                WorldGenMinable ironGen = new WorldGenMinable(Blocks.field_150366_p.func_176223_P(), chunkProviderSettings.field_177848_ag);
                WorldGenMinable goldGen = new WorldGenMinable(Blocks.field_150352_o.func_176223_P(), chunkProviderSettings.field_177828_ak);
                WorldGenMinable redstoneGen = new WorldGenMinable(Blocks.field_150450_ax.func_176223_P(), chunkProviderSettings.field_177836_ao);
                WorldGenMinable diamondGen = new WorldGenMinable(Blocks.field_150482_ag.func_176223_P(), chunkProviderSettings.field_177814_as);
                WorldGenMinable lapisGen = new WorldGenMinable(Blocks.field_150369_x.func_176223_P(), chunkProviderSettings.field_177822_aw);
                EmeraldGenerator emeralds = new EmeraldGenerator();
                MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(this.world, this.rand, blockpos));
                if (biome instanceof BiomeHills && TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)emeralds, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.EMERALD)) {
                    emeralds.func_180709_b(this.world, this.rand, blockpos);
                }
                if (TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)coalGen, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.COAL)) {
                    this.genStandardOre1(this.world, this.rand, chunkProviderSettings.field_177845_ad, (WorldGenerator)coalGen, chunkProviderSettings.field_177851_ae, chunkProviderSettings.field_177853_af, blockpos);
                }
                if (TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)ironGen, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.IRON)) {
                    this.genStandardOre1(this.world, this.rand, chunkProviderSettings.field_177849_ah, (WorldGenerator)ironGen, chunkProviderSettings.field_177832_ai, chunkProviderSettings.field_177834_aj, blockpos);
                }
                if (TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)goldGen, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GOLD)) {
                    this.genStandardOre1(this.world, this.rand, chunkProviderSettings.field_177830_al, (WorldGenerator)goldGen, chunkProviderSettings.field_177840_am, chunkProviderSettings.field_177842_an, blockpos);
                }
                if (TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)redstoneGen, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.REDSTONE)) {
                    this.genStandardOre1(this.world, this.rand, chunkProviderSettings.field_177838_ap, (WorldGenerator)redstoneGen, chunkProviderSettings.field_177818_aq, chunkProviderSettings.field_177816_ar, blockpos);
                }
                if (TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)diamondGen, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND)) {
                    this.genStandardOre1(this.world, this.rand, chunkProviderSettings.field_177812_at, (WorldGenerator)diamondGen, chunkProviderSettings.field_177826_au, chunkProviderSettings.field_177824_av, blockpos);
                }
                if (TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)lapisGen, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.LAPIS)) {
                    this.genStandardOre2(this.world, this.rand, chunkProviderSettings.field_177820_ax, (WorldGenerator)lapisGen, chunkProviderSettings.field_177807_ay, chunkProviderSettings.field_177805_az, blockpos);
                }
                MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(this.world, this.rand, blockpos));
            }
            for (int n = 0; n < 16; ++n) {
                int xOffset = i + n + 8;
                block2: for (int m = 0; m < 16; ++m) {
                    double erosionFactor;
                    int zOffset = j + m + 8;
                    int id = 0;
                    int index = m * 16 + n;
                    double surface = this.geoFactorsForPopulation[index][0];
                    double elevation = this.geoFactorsForPopulation[index][1];
                    double density = this.geoFactorsForPopulation[index][2];
                    double uplift = this.geoFactorsForPopulation[index][3];
                    double volcanism = this.geoFactorsForPopulation[index][4];
                    double era = this.geoFactorsForPopulation[index][5];
                    double erosion = this.geoFactorsForPopulation[index][6];
                    double temperature = this.geoFactorsForPopulation[index][7];
                    double precipitation = this.geoFactorsForPopulation[index][8];
                    double r = surface * 0.1 + (BiomeProviderDooglamoo.sharpEdges ? 0.0 : this.rand.nextDouble() * 0.1 - 0.05);
                    id = elevation + surface * 0.008 < -0.5 ? (id |= 0) : (elevation + surface * 0.008 < 0.0 ? (id |= 4) : (elevation + surface * 0.008 < 0.5 ? (id |= 8) : (id |= 0xC)));
                    id = density + r < -0.5 ? (id |= 0) : (density + r < 0.0 ? (id |= 1) : (density + r < 0.5 ? (id |= 2) : (id |= 3)));
                    id = uplift + r < -0.5 ? (id |= 0) : (uplift + r < 0.0 ? (id |= 0x400) : (uplift + r < 0.5 ? (id |= 0x800) : (id |= 0xC00)));
                    id = volcanism + r < -0.5 ? (id |= 0) : (volcanism + r < 0.0 ? (id |= 0x40) : (volcanism + r < 0.5 ? (id |= 0x80) : (id |= 0xC0)));
                    id = era + r < -0.5 ? (id |= 0) : (era + r < 0.0 ? (id |= 0x10) : (era + r < 0.5 ? (id |= 0x20) : (id |= 0x30)));
                    id = erosion + r < -0.5 ? (id |= 0) : (erosion + r < 0.0 ? (id |= 0x100) : (erosion + r < 0.5 ? (id |= 0x200) : (id |= 0x300)));
                    id = temperature + r < -0.5 ? (id |= 0) : (temperature + r < 0.0 ? (id |= 0x4000) : (temperature + r < 0.5 ? (id |= 0x8000) : (id |= 0xC000)));
                    id = precipitation + r < -0.5 ? (id |= 0) : (precipitation + r < 0.0 ? (id |= 0x1000) : (precipitation + r < 0.5 ? (id |= 0x2000) : (id |= 0x3000)));
                    double surfaceDepthPlateFactor = Math.max(Math.min((elevation + 0.02) * 25.0, 1.0), 0.08);
                    int surfaceDepth = (int)(((surface + 1.0) * (uplift > -0.5 ? uplift + 0.5 : 0.0) * 6.0 + (era + 0.5) * 12.0) * surfaceDepthPlateFactor);
                    if (surfaceDepth < 1) {
                        surfaceDepth = 1;
                    }
                    if ((erosionFactor = surface * 2.0) > 0.0) {
                        erosionFactor = -erosionFactor;
                    }
                    if (erosionFactor > -0.1) {
                        erosionFactor = -0.1;
                    }
                    erosionFactor = 1.0 + erosionFactor;
                    int erosionDepth = density < -0.5 ? (erosion > 0.0 ? (int)(erosion * 50.0) : 0) : (density < 0.0 ? (erosion > 0.0 ? (int)(erosion * 40.0) : 0) : (density < 0.5 ? (erosion > 0.0 ? (int)(erosion * 32.0) : 0) : (erosion > 0.0 ? (int)(erosion * 26.0) : 0)));
                    int rockLevel = (int)((elevation + 1.0) / 2.0 * 128.0 + surface * 0.3);
                    double upliftFactor = (erosion < 0.0 && uplift > 0.1 && uplift <= 0.6 ? Math.min(Math.max((uplift - 0.1) * (-erosion * 6.0), uplift), 0.6) : uplift) * 128.0;
                    int upliftLevel = rockLevel + (int)(uplift > 0.0 ? upliftFactor * Math.min(surfaceDepthPlateFactor + (volcanism > 0.45 ? (volcanism - 0.45) * 4.5 : 0.0), 1.0) : 0.0);
                    int surfaceActualLevel = upliftLevel + surfaceDepth;
                    if (erosionFactor > 0.0) {
                        surfaceActualLevel = (int)((double)surfaceActualLevel - erosionFactor * (double)erosionDepth);
                    }
                    if (uplift < -0.5) {
                        surfaceActualLevel = (int)((double)surfaceActualLevel - (-uplift - 0.5) * 50.0);
                    }
                    double occuranceMod = (era + 1.0) / 4.0 + 0.5;
                    for (int y = 0; y < 256; ++y) {
                        GeoFeature geo;
                        int f;
                        List<GeoFeature> featureList;
                        if (y != surfaceActualLevel) continue;
                        if (y > 63) {
                            if (!(uplift < 0.1 || uplift < 0.5 && erosion > 0.0) && !(surface < 0.0) || (featureList = DictionaryFactory.features.get(id)) == null) continue block2;
                            for (f = 0; f < featureList.size(); ++f) {
                                geo = featureList.get(this.rand.nextInt(featureList.size()));
                                if (!((double)this.rand.nextFloat() < (double)geo.getRarity() * occuranceMod)) continue;
                                geo.getFeature().func_180709_b(this.world, this.rand, new BlockPos(xOffset, y + 1, zOffset));
                                continue block2;
                            }
                            continue block2;
                        }
                        featureList = DictionaryFactory.oceanFeatures.get(id);
                        if (featureList == null) continue block2;
                        for (f = 0; f < featureList.size(); ++f) {
                            geo = featureList.get(this.rand.nextInt(featureList.size()));
                            if (!((double)this.rand.nextFloat() < (double)geo.getRarity() * occuranceMod)) continue;
                            geo.getFeature().func_180709_b(this.world, this.rand, new BlockPos(xOffset, y + 1, zOffset));
                            continue block2;
                        }
                        continue block2;
                    }
                }
            }
            TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM);
            TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS);
            TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS);
            TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH);
            TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LILYPAD);
            TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM);
            TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.REED);
            TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.PUMPKIN);
            TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS);
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.rand, forgeChunkPos));
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            blockpos = blockpos.func_177982_a(8, 0, 8);
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.world.func_175708_f(blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        boolean flag = false;
        if (this.mapFeaturesEnabled && chunkIn.func_177416_w() < 3600L) {
            flag |= this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
        }
        return flag;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        if (this.mapFeaturesEnabled) {
            if (creatureType == EnumCreatureType.MONSTER && this.scatteredFeatureGenerator.func_175798_a(pos)) {
                return this.scatteredFeatureGenerator.func_82667_a();
            }
            if (creatureType == EnumCreatureType.MONSTER && this.oceanMonumentGenerator.func_175796_a(this.world, pos)) {
                return this.oceanMonumentGenerator.func_175799_b();
            }
        }
        return biome.func_76747_a(creatureType);
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        if (!this.mapFeaturesEnabled) {
            return false;
        }
        if ("Stronghold".equals(structureName)) {
            return this.strongholdGenerator.func_175795_b(pos);
        }
        if ("Mansion".equals(structureName) && this.woodlandMansionGenerator != null) {
            return this.woodlandMansionGenerator.func_175795_b(pos);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_175795_b(pos);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_175795_b(pos);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(pos);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_175795_b(pos) : false;
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        if (!this.mapFeaturesEnabled) {
            return null;
        }
        if ("Stronghold".equals(structureName)) {
            return this.strongholdGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Mansion".equals(structureName) && this.woodlandMansionGenerator != null) {
            return this.woodlandMansionGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_180706_b(worldIn, position, findUnexplored) : null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            this.villageGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            this.strongholdGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            this.scatteredFeatureGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            this.oceanMonumentGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            this.woodlandMansionGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
        }
    }

    protected void genStandardOre1(World worldIn, Random random, int blockCount, WorldGenerator generator, int minHeight, int maxHeight, BlockPos pos) {
        if (maxHeight < minHeight) {
            int i = minHeight;
            minHeight = maxHeight;
            maxHeight = i;
        } else if (maxHeight == minHeight) {
            if (minHeight < 255) {
                ++maxHeight;
            } else {
                --minHeight;
            }
        }
        for (int j = 0; j < blockCount; ++j) {
            BlockPos blockpos = pos.func_177982_a(random.nextInt(16), random.nextInt(maxHeight - minHeight) + minHeight, random.nextInt(16));
            generator.func_180709_b(worldIn, random, blockpos);
        }
    }

    protected void genStandardOre2(World worldIn, Random random, int blockCount, WorldGenerator generator, int centerHeight, int spread, BlockPos pos) {
        for (int i = 0; i < blockCount; ++i) {
            BlockPos blockpos = pos.func_177982_a(random.nextInt(16), random.nextInt(spread) + random.nextInt(spread) + centerHeight - spread, random.nextInt(16));
            generator.func_180709_b(worldIn, random, blockpos);
        }
    }

    private void genOre(int x, int z) {
        int density0Size = this.density0.size();
        int density1Size = this.density1.size();
        int density2Size = this.density2.size();
        int density3Size = this.density3.size();
        for (int n = 0; n < 16; ++n) {
            int xOffset = x + n + 1;
            for (int m = 0; m < 16; ++m) {
                int mantleLevel;
                int surfaceVirtualLevel;
                double erosionFactor;
                double surfaceDepthPlateFactor;
                int zOffset = z + m + 1;
                int index = m * 16 + n;
                double surface = this.geoFactorsForPopulation[index][0];
                double elevation = this.geoFactorsForPopulation[index][1];
                double density = this.geoFactorsForPopulation[index][2];
                double uplift = this.geoFactorsForPopulation[index][3];
                double volcanism = this.geoFactorsForPopulation[index][4];
                double era = this.geoFactorsForPopulation[index][5];
                double erosion = this.geoFactorsForPopulation[index][6];
                double temperature = this.geoFactorsForPopulation[index][7];
                double precipitation = this.geoFactorsForPopulation[index][8];
                ChunkGeneratorDooglamoo.factors[2] = elevation < 0.0 ? -elevation : 0.0;
                ChunkGeneratorDooglamoo.factors[3] = density < 0.0 ? -density : 0.0;
                ChunkGeneratorDooglamoo.factors[4] = uplift < 0.0 ? -uplift : 0.0;
                ChunkGeneratorDooglamoo.factors[5] = volcanism < 0.0 ? -volcanism : 0.0;
                ChunkGeneratorDooglamoo.factors[6] = era < 0.0 ? -era : 0.0;
                ChunkGeneratorDooglamoo.factors[7] = erosion < 0.0 ? -erosion : 0.0;
                ChunkGeneratorDooglamoo.factors[8] = temperature < 0.0 ? -temperature : 0.0;
                ChunkGeneratorDooglamoo.factors[9] = precipitation < 0.0 ? -precipitation : 0.0;
                ChunkGeneratorDooglamoo.factors[10] = elevation > 0.0 ? elevation : 0.0;
                ChunkGeneratorDooglamoo.factors[11] = density > 0.0 ? density : 0.0;
                ChunkGeneratorDooglamoo.factors[12] = uplift > 0.0 ? uplift : 0.0;
                ChunkGeneratorDooglamoo.factors[13] = volcanism > 0.0 ? volcanism : 0.0;
                ChunkGeneratorDooglamoo.factors[14] = era > 0.0 ? era : 0.0;
                ChunkGeneratorDooglamoo.factors[15] = erosion > 0.0 ? erosion : 0.0;
                ChunkGeneratorDooglamoo.factors[16] = temperature > 0.0 ? temperature : 0.0;
                ChunkGeneratorDooglamoo.factors[17] = precipitation > 0.0 ? precipitation : 0.0;
                int surfaceDepth = (int)(((surface + 1.0) * (uplift > -0.5 ? uplift + 0.5 : 0.0) * 6.0 + (era + 0.5) * 12.0) * (surfaceDepthPlateFactor = Math.max(Math.min((elevation + 0.02) * 25.0, 1.0), 0.08)));
                if (surfaceDepth < 1) {
                    surfaceDepth = 1;
                }
                if ((erosionFactor = surface * 2.0) > 0.0) {
                    erosionFactor = -erosionFactor;
                }
                if (erosionFactor > -0.1) {
                    erosionFactor = -0.1;
                }
                erosionFactor = 1.0 + erosionFactor;
                int erosionDepth = density < -0.5 ? (erosion > 0.0 ? (int)(erosion * 50.0) : 0) : (density < 0.0 ? (erosion > 0.0 ? (int)(erosion * 40.0) : 0) : (density < 0.5 ? (erosion > 0.0 ? (int)(erosion * 32.0) : 0) : (erosion > 0.0 ? (int)(erosion * 26.0) : 0)));
                ChunkGeneratorDooglamoo.levels[0] = (int)((elevation + 1.0) / 2.0 * 128.0 + surface * 0.3);
                double upliftFactor = (erosion < 0.0 && uplift > 0.1 && uplift <= 0.6 ? Math.min(Math.max((uplift - 0.1) * (-erosion * 6.0), uplift), 0.6) : uplift) * 128.0;
                int upliftLevel = levels[0] + (int)(uplift > 0.0 ? upliftFactor * Math.min(surfaceDepthPlateFactor + (volcanism > 0.45 ? (volcanism - 0.45) * 4.5 : 0.0), 1.0) : 0.0);
                int surfaceActualLevel = surfaceVirtualLevel = upliftLevel + surfaceDepth;
                if (erosionFactor > 0.0) {
                    surfaceActualLevel = (int)((double)surfaceActualLevel - erosionFactor * (double)erosionDepth);
                }
                if (uplift < -0.5) {
                    surfaceActualLevel = (int)((double)surfaceActualLevel - (-uplift - 0.5) * 50.0);
                }
                if ((mantleLevel = upliftLevel - (int)(200.0 - (volcanism > 0.0 ? volcanism * 256.0 : 0.0))) > upliftLevel) {
                    mantleLevel = upliftLevel;
                }
                if (upliftLevel >= surfaceActualLevel || uplift >= 0.5) {
                    upliftLevel = surfaceActualLevel - 1;
                }
                for (int y = 0; y < 256; ++y) {
                    GeoFeature ore;
                    int i;
                    IBlockState currentstate;
                    if (y > upliftLevel || y <= mantleLevel || (currentstate = this.world.func_180495_p(new BlockPos(xOffset, y, zOffset))).func_185904_a() != Material.field_151576_e || currentstate.func_177230_c() == Blocks.field_150357_h || currentstate.func_177230_c() == Blocks.field_189877_df) continue;
                    IBlockState blockstate = Blocks.field_150350_a.func_176223_P();
                    if (density < -0.5) {
                        for (i = 0; i < density0Size; ++i) {
                            ore = this.density0.get(i);
                            if (y % ore.index == 0) {
                                if ((double)ore.rarity[0] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.0) || !((double)this.rand.nextFloat() < (double)ore.rarity[0] + factors[ore.modifier[0]] * (double)ore.rarity[0] + factors[ore.modifier[1]] * (double)ore.rarity[0])) continue;
                                blockstate = ore.block;
                            } else if ((y + 1) % ore.index == 0) {
                                if ((double)ore.rarity[1] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.3) || !((double)this.rand.nextFloat() < (double)ore.rarity[1] + factors[ore.modifier[0]] * (double)ore.rarity[1] + factors[ore.modifier[1]] * (double)ore.rarity[1])) continue;
                                blockstate = ore.block;
                            } else {
                                if ((y + 2) % ore.index != 0 || (double)ore.rarity[2] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.7) || !((double)this.rand.nextFloat() < (double)ore.rarity[2] + factors[ore.modifier[0]] * (double)ore.rarity[2] + factors[ore.modifier[1]] * (double)ore.rarity[2])) continue;
                                blockstate = ore.block;
                            }
                            break;
                        }
                    } else if (density < 0.0) {
                        for (i = 0; i < density1Size; ++i) {
                            ore = this.density1.get(i);
                            if (y % ore.index == 0) {
                                if ((double)ore.rarity[0] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.0) || !((double)this.rand.nextFloat() < (double)ore.rarity[0] + factors[ore.modifier[0]] * (double)ore.rarity[0] + factors[ore.modifier[1]] * (double)ore.rarity[0])) continue;
                                blockstate = ore.block;
                            } else if ((y + 1) % ore.index == 0) {
                                if ((double)ore.rarity[1] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.3) || !((double)this.rand.nextFloat() < (double)ore.rarity[1] + factors[ore.modifier[0]] * (double)ore.rarity[1] + factors[ore.modifier[1]] * (double)ore.rarity[1])) continue;
                                blockstate = ore.block;
                            } else {
                                if ((y + 2) % ore.index != 0 || (double)ore.rarity[2] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.7) || !((double)this.rand.nextFloat() < (double)ore.rarity[2] + factors[ore.modifier[0]] * (double)ore.rarity[2] + factors[ore.modifier[1]] * (double)ore.rarity[2])) continue;
                                blockstate = ore.block;
                            }
                            break;
                        }
                    } else if (density < 0.5) {
                        for (i = 0; i < density2Size; ++i) {
                            ore = this.density2.get(i);
                            if (y % ore.index == 0) {
                                if ((double)ore.rarity[0] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.0) || !((double)this.rand.nextFloat() < (double)ore.rarity[0] + factors[ore.modifier[0]] * (double)ore.rarity[0] + factors[ore.modifier[1]] * (double)ore.rarity[0])) continue;
                                blockstate = ore.block;
                            } else if ((y + 1) % ore.index == 0) {
                                if ((double)ore.rarity[1] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.3) || !((double)this.rand.nextFloat() < (double)ore.rarity[1] + factors[ore.modifier[0]] * (double)ore.rarity[1] + factors[ore.modifier[1]] * (double)ore.rarity[1])) continue;
                                blockstate = ore.block;
                            } else {
                                if ((y + 2) % ore.index != 0 || (double)ore.rarity[2] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.7) || !((double)this.rand.nextFloat() < (double)ore.rarity[2] + factors[ore.modifier[0]] * (double)ore.rarity[2] + factors[ore.modifier[1]] * (double)ore.rarity[2])) continue;
                                blockstate = ore.block;
                            }
                            break;
                        }
                    } else {
                        for (i = 0; i < density3Size; ++i) {
                            ore = this.density3.get(i);
                            if (y % ore.index == 0) {
                                if ((double)ore.rarity[0] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.0) || !((double)this.rand.nextFloat() < (double)ore.rarity[0] + factors[ore.modifier[0]] * (double)ore.rarity[0] + factors[ore.modifier[1]] * (double)ore.rarity[0])) continue;
                                blockstate = ore.block;
                            } else if ((y + 1) % ore.index == 0) {
                                if ((double)ore.rarity[1] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.3) || !((double)this.rand.nextFloat() < (double)ore.rarity[1] + factors[ore.modifier[0]] * (double)ore.rarity[1] + factors[ore.modifier[1]] * (double)ore.rarity[1])) continue;
                                blockstate = ore.block;
                            } else {
                                if ((y + 2) % ore.index != 0 || (double)ore.rarity[2] == 0.0 || y > (ore.level < 9 ? levels[ore.level] : ore.level) || !(factors[ore.requirement] > 0.7) || !((double)this.rand.nextFloat() < (double)ore.rarity[2] + factors[ore.modifier[0]] * (double)ore.rarity[2] + factors[ore.modifier[1]] * (double)ore.rarity[2])) continue;
                                blockstate = ore.block;
                            }
                            break;
                        }
                    }
                    if (blockstate.func_185904_a() == Material.field_151579_a) continue;
                    this.world.func_180501_a(new BlockPos(xOffset, y, zOffset), blockstate, 2);
                }
            }
        }
    }

    private static class EmeraldGenerator
    extends WorldGenerator {
        private EmeraldGenerator() {
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
            int count = 3 + rand.nextInt(6);
            for (int i = 0; i < count; ++i) {
                int offset = ForgeModContainer.fixVanillaCascading ? 8 : 0;
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(16) + offset, rand.nextInt(28) + 4, rand.nextInt(16) + offset);
                IBlockState state = worldIn.func_180495_p(blockpos);
                if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b))) continue;
                worldIn.func_180501_a(blockpos, Blocks.field_150412_bA.func_176223_P(), 18);
            }
            return true;
        }
    }
}

