/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.gen;

import com.dooglamoo.voxel.noise.NoiseGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.Vec3d;

public class RiverRegion {
    private Random rand = new Random();
    public List<River> rivers = new ArrayList<River>();
    private static final HeightComparator HIGHT_COMPARE = new HeightComparator();
    private static final double MIN_LENGTH_SQUARED = Math.pow(256.0, 2.0);

    public RiverRegion(long seed, int regionStartX, int regionStartZ, int regionWidth, int regionHeight, int samples, NoiseGenerator elevationGen, NoiseGenerator precipitationGen) {
        int n;
        this.rand.setSeed(seed);
        samples = samples / 2 * 2;
        ArrayList<Vec3d> points = new ArrayList<Vec3d>();
        for (int i = 0; i < samples; ++i) {
            int x1 = regionStartX + this.rand.nextInt(regionWidth);
            int z1 = regionStartZ + this.rand.nextInt(regionHeight);
            double y = elevationGen.noise(x1, z1);
            Vec3d v = new Vec3d((double)x1, y, (double)z1);
            points.add(v);
        }
        Collections.sort(points, HIGHT_COMPARE);
        for (n = 0; n < points.size() / 2; ++n) {
            Vec3d v1 = (Vec3d)points.get(points.size() - 1 - n);
            Vec3d v2 = (Vec3d)points.get(n);
            if (!(v1.field_72448_b > 0.15)) continue;
            this.rivers.add(new River(v1, v2, precipitationGen.noise(v1.field_72450_a, v1.field_72449_c) < -0.5));
        }
        for (n = 1; n < this.rivers.size(); ++n) {
            River r = this.rivers.get(n);
            for (int m = 0; m < n; ++m) {
                River c = this.rivers.get(m);
                Vec3d p = RiverRegion.getLineIntersection(r.vHi.field_72450_a, r.vHi.field_72449_c, r.vLo.field_72450_a, r.vLo.field_72449_c, c.vHi.field_72450_a, c.vHi.field_72449_c, c.vLo.field_72450_a, c.vLo.field_72449_c);
                if (p == null) continue;
                r.vLo = elevationGen.noise(p.field_72450_a, p.field_72449_c) >= r.vHi.field_72448_b ? new Vec3d(p.field_72450_a, 1.0, p.field_72448_b) : p;
                r.lengthSquared = RiverRegion.dist2(r.vHi.field_72450_a, r.vHi.field_72449_c, r.vLo.field_72450_a, r.vLo.field_72449_c);
                r.dry = c.dry;
            }
        }
        Iterator<River> it = this.rivers.iterator();
        while (it.hasNext()) {
            River river = it.next();
            if (river.vLo.field_72448_b > 0.0 || river.vHi.field_72448_b - river.vLo.field_72448_b < 0.15 || river.lengthSquared < MIN_LENGTH_SQUARED) {
                it.remove();
                continue;
            }
            if (!(Math.abs(river.vHi.field_72449_c - (double)regionStartZ) < 512.0 && Math.abs(river.vLo.field_72449_c - (double)regionStartZ) < 512.0 || Math.abs(river.vHi.field_72449_c - (double)(regionStartZ + regionHeight)) < 512.0 && Math.abs(river.vLo.field_72449_c - (double)(regionStartZ + regionHeight)) < 512.0 || Math.abs(river.vHi.field_72450_a - (double)regionStartX) < 512.0 && Math.abs(river.vLo.field_72450_a - (double)regionStartX) < 512.0) && (!(Math.abs(river.vHi.field_72450_a - (double)(regionStartX + regionWidth)) < 512.0) || !(Math.abs(river.vLo.field_72450_a - (double)(regionStartX + regionWidth)) < 512.0))) continue;
            it.remove();
        }
    }

    private static final Vec3d getLineIntersection(double p0_x, double p0_y, double p1_x, double p1_y, double p2_x, double p2_y, double p3_x, double p3_y) {
        double s1_x = p1_x - p0_x;
        double s1_y = p1_y - p0_y;
        double s2_x = p3_x - p2_x;
        double s2_y = p3_y - p2_y;
        double s = (-s1_y * (p0_x - p2_x) + s1_x * (p0_y - p2_y)) / (-s2_x * s1_y + s1_x * s2_y);
        double t = (s2_x * (p0_y - p2_y) - s2_y * (p0_x - p2_x)) / (-s2_x * s1_y + s1_x * s2_y);
        if (s >= 0.0 && s <= 1.0 && t >= 0.0 && t <= 1.0) {
            return new Vec3d(p0_x + t * s1_x, 0.0, p0_y + t * s1_y);
        }
        return null;
    }

    private static final double sqr(double x) {
        return x * x;
    }

    private static final double dist2(double vx, double vz, double wx, double wz) {
        return RiverRegion.sqr(vx - wx) + RiverRegion.sqr(vz - wz);
    }

    public static final double distToSegmentSquared(double px, double pz, double vx, double vz, double wx, double wz) {
        double l2 = RiverRegion.dist2(vx, vz, wx, wz);
        if (l2 == 0.0) {
            return RiverRegion.dist2(px, pz, vx, vz);
        }
        double t = ((px - vx) * (wx - vx) + (pz - vz) * (wz - vz)) / l2;
        t = Math.max(0.0, Math.min(1.0, t));
        return RiverRegion.dist2(px, pz, vx + t * (wx - vx), vz + t * (wz - vz));
    }

    private static class HeightComparator
    implements Comparator<Vec3d> {
        private HeightComparator() {
        }

        @Override
        public int compare(Vec3d o1, Vec3d o2) {
            if (o1.field_72448_b < o2.field_72448_b) {
                return -1;
            }
            if (o1.field_72448_b > o2.field_72448_b) {
                return 1;
            }
            return 0;
        }
    }

    public static class River {
        public Vec3d vHi;
        public Vec3d vLo;
        public double lengthSquared;
        public boolean dry;

        public River(Vec3d vHi, Vec3d vLo, boolean dry) {
            this.vHi = vHi;
            this.vLo = vLo;
            this.dry = dry;
            this.lengthSquared = RiverRegion.dist2(vHi.field_72450_a, vHi.field_72449_c, vLo.field_72450_a, vLo.field_72449_c);
        }

        public String toString() {
            return "pHi:" + this.vHi + " pLo:" + this.vLo + " length squared:" + this.lengthSquared;
        }
    }
}

