/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class FallenTreeFeature
extends WorldGenAbstractTree {
    private final IBlockState state;

    public FallenTreeFeature(IBlockState state) {
        super(false);
        this.state = state;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        if (!this.canPlace(worldIn, pos)) {
            return false;
        }
        IBlockState blockstate = this.state;
        int dir = rand.nextInt(4);
        if (dir == 0) {
            int length = 2 + rand.nextInt(4);
            for (int x = 0; x < length && this.canPlace(worldIn, pos.func_177982_a(x, 0, 0)); ++x) {
                this.func_175903_a(worldIn, pos.func_177982_a(x, 0, 0), blockstate.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X));
            }
            return true;
        }
        if (dir == 1) {
            int length = 2 + rand.nextInt(4);
            for (int z = 0; z < length && this.canPlace(worldIn, pos.func_177982_a(0, 0, z)); ++z) {
                this.func_175903_a(worldIn, pos.func_177982_a(0, 0, z), blockstate.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z));
            }
            return true;
        }
        this.func_175903_a(worldIn, pos, blockstate);
        return true;
    }

    private boolean canPlace(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g)) && this.isReplaceable(worldIn, pos);
    }
}

