/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.gen.layer;

import com.dooglamoo.voxel.noise.NoiseGenerator;
import com.dooglamoo.worlds.dict.DictionaryFactory;
import com.dooglamoo.worlds.dict.GeoFeature;
import com.dooglamoo.worlds.world.biome.BiomeProviderDooglamoo;
import com.dooglamoo.worlds.world.gen.RiverRegion;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.layer.GenLayer;

public class GenLayerDooglamoo
extends GenLayer {
    private NoiseGenerator elevationGen;
    private NoiseGenerator densityGen;
    private NoiseGenerator upliftGen;
    private NoiseGenerator volcanismGen;
    private NoiseGenerator eraGen;
    private NoiseGenerator erosionGen;
    private NoiseGenerator surfaceGen;
    private NoiseGenerator temperatureGen;
    private NoiseGenerator precipitationGen;
    private double plateWeight;
    private double rockWeight;
    private double liftWeight;
    private double thermalWeight;
    private double ageWeight;
    private double erosionWeight;
    private double tempWeight;
    public double precipWeight;
    private double plateFactor;
    private double rockFactor;
    private double liftFactor;
    private double thermalFactor;
    private double ageFactor;
    private double erosionFactor;
    private double tempFactor;
    private double precipFactor;
    private final Random rand;
    private BiomeProviderDooglamoo provider;
    private double[][] geoFactorsForBiomes;
    private final long seed;
    private final int riverRegionHalfWidth;
    private final int riverRegionWidth;
    private final double riverWiggleHi;
    private final double riverWiggleLo;
    private final double riverWidthSquared;
    private final double riverBank;
    private final double riverShore;
    private final double riverChannel;
    private final double riverShallow;
    protected final Map<Long, RiverRegion> riverRegionCache = new ConcurrentHashMap<Long, RiverRegion>();

    public GenLayerDooglamoo(BiomeProviderDooglamoo provider, long seed, boolean weighted, double scale, String generatorOptions) {
        super(200L);
        this.seed = seed;
        this.provider = provider;
        this.rand = provider.rand;
        this.surfaceGen = provider.noiseGen7;
        this.elevationGen = provider.noiseGen1;
        this.densityGen = provider.noiseGen2;
        this.upliftGen = provider.noiseGen3;
        this.volcanismGen = provider.noiseGen4;
        this.eraGen = provider.noiseGen5;
        this.erosionGen = provider.noiseGen6;
        this.temperatureGen = provider.noiseGen8;
        this.precipitationGen = provider.noiseGen9;
        this.plateWeight = provider.plateWeight;
        this.rockWeight = provider.rockWeight;
        this.liftWeight = provider.liftWeight;
        this.thermalWeight = provider.thermalWeight;
        this.ageWeight = provider.ageWeight;
        this.erosionWeight = provider.erosionWeight;
        this.tempWeight = provider.tempWeight;
        this.precipWeight = provider.precipWeight;
        this.plateFactor = BiomeProviderDooglamoo.plateFactor;
        this.rockFactor = BiomeProviderDooglamoo.rockFactor;
        this.liftFactor = BiomeProviderDooglamoo.liftFactor;
        this.thermalFactor = BiomeProviderDooglamoo.thermalFactor;
        this.ageFactor = BiomeProviderDooglamoo.ageFactor;
        this.erosionFactor = BiomeProviderDooglamoo.erosionFactor;
        this.tempFactor = BiomeProviderDooglamoo.tempFactor;
        this.precipFactor = BiomeProviderDooglamoo.precipFactor;
        this.riverRegionHalfWidth = (int)(8192.0 * scale) / 2;
        this.riverRegionWidth = this.riverRegionHalfWidth * 2;
        this.riverWiggleHi = 400.0 * scale;
        this.riverWiggleLo = this.riverWiggleHi * 1.3;
        this.riverWidthSquared = Math.pow(256.0, 2.0) * scale;
        this.riverBank = this.riverWidthSquared * 0.2;
        this.riverShore = this.riverWidthSquared - this.riverBank;
        this.riverChannel = this.riverBank * 0.2;
        this.riverShallow = this.riverBank - this.riverChannel;
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] biomes = new int[areaWidth * areaHeight];
        this.geoFactorsForBiomes = this.provider.getGeoFactors(this.geoFactorsForBiomes, areaX, areaY, areaWidth, areaHeight, true);
        for (int n = 0; n < areaWidth; ++n) {
            for (int m = 0; m < areaHeight; ++m) {
                List<GeoFeature> biomeList;
                int plates;
                int surfaceVirtualLevel;
                double erosionFactor;
                int id = 0;
                int index = m * areaWidth + n;
                double surface = this.geoFactorsForBiomes[index][0];
                double elevation = this.geoFactorsForBiomes[index][1];
                double density = this.geoFactorsForBiomes[index][2];
                double uplift = this.geoFactorsForBiomes[index][3];
                double volcanism = this.geoFactorsForBiomes[index][4];
                double era = this.geoFactorsForBiomes[index][5];
                double erosion = this.geoFactorsForBiomes[index][6];
                double temperature = this.geoFactorsForBiomes[index][7];
                double precipitation = this.geoFactorsForBiomes[index][8];
                double r = surface * 0.1 + (BiomeProviderDooglamoo.sharpEdges ? 0.0 : this.rand.nextDouble() * 0.1 - 0.05);
                id = elevation + surface * 0.008 < -0.5 ? (id |= 0) : (elevation + surface * 0.008 < 0.0 ? (id |= 4) : (elevation + surface * 0.008 < 0.5 ? (id |= 8) : (id |= 0xC)));
                id = density + r < -0.5 ? (id |= 0) : (density + r < 0.0 ? (id |= 1) : (density + r < 0.5 ? (id |= 2) : (id |= 3)));
                id = uplift + r < -0.5 ? (id |= 0) : (uplift + r < 0.0 ? (id |= 0x400) : (uplift + r < 0.5 ? (id |= 0x800) : (id |= 0xC00)));
                id = volcanism + r < -0.5 ? (id |= 0) : (volcanism + r < 0.0 ? (id |= 0x40) : (volcanism + r < 0.5 ? (id |= 0x80) : (id |= 0xC0)));
                id = era + r < -0.5 ? (id |= 0) : (era + r < 0.0 ? (id |= 0x10) : (era + r < 0.5 ? (id |= 0x20) : (id |= 0x30)));
                id = erosion + r < -0.5 ? (id |= 0) : (erosion + r < 0.0 ? (id |= 0x100) : (erosion + r < 0.5 ? (id |= 0x200) : (id |= 0x300)));
                id = temperature + r < -0.5 ? (id |= 0) : (temperature + r < 0.0 ? (id |= 0x4000) : (temperature + r < 0.5 ? (id |= 0x8000) : (id |= 0xC000)));
                id = precipitation + r < -0.5 ? (id |= 0) : (precipitation + r < 0.0 ? (id |= 0x1000) : (precipitation + r < 0.5 ? (id |= 0x2000) : (id |= 0x3000)));
                double surfaceDepthPlateFactor = Math.max(Math.min((elevation + 0.02) * 25.0, 1.0), 0.08);
                int surfaceDepth = (int)(((surface + 1.0) * (uplift > -0.5 ? uplift + 0.5 : 0.0) * 6.0 + (era + 0.5) * 12.0) * surfaceDepthPlateFactor);
                if (surfaceDepth < 1) {
                    surfaceDepth = 1;
                }
                if ((erosionFactor = surface * 2.0) > 0.0) {
                    erosionFactor = -erosionFactor;
                }
                if (erosionFactor > -0.1) {
                    erosionFactor = -0.1;
                }
                erosionFactor = 1.0 + erosionFactor;
                int erosionDepth = density < -0.5 ? (erosion > 0.0 ? (int)(erosion * 50.0) : 0) : (density < 0.0 ? (erosion > 0.0 ? (int)(erosion * 40.0) : 0) : (density < 0.5 ? (erosion > 0.0 ? (int)(erosion * 32.0) : 0) : (erosion > 0.0 ? (int)(erosion * 26.0) : 0)));
                int rockLevel = (int)((elevation + 1.0) / 2.0 * 128.0 + surface * 0.3);
                double upliftFactor = (erosion < 0.0 && uplift > 0.1 && uplift <= 0.6 ? Math.min(Math.max((uplift - 0.1) * (-erosion * 6.0), uplift), 0.6) : uplift) * 128.0;
                int upliftLevel = rockLevel + (int)(uplift > 0.0 ? upliftFactor * Math.min(surfaceDepthPlateFactor + (volcanism > 0.45 ? (volcanism - 0.45) * 4.5 : 0.0), 1.0) : 0.0);
                int surfaceActualLevel = surfaceVirtualLevel = upliftLevel + surfaceDepth;
                if (erosionFactor > 0.0) {
                    surfaceActualLevel = (int)((double)surfaceActualLevel - erosionFactor * (double)erosionDepth);
                }
                if (uplift < -0.5) {
                    surfaceActualLevel = (int)((double)surfaceActualLevel - (-uplift - 0.5) * 50.0);
                }
                if (!((plates = id & 0xC) != 8 && plates != 12 || surfaceActualLevel >= 63 && surfaceActualLevel >= rockLevel - 1)) {
                    biomes[index] = 7;
                    continue;
                }
                if (plates == 0 || plates == 4) {
                    if (surfaceActualLevel >= 62) {
                        if ((id & 0xC000) != 0) {
                            biomes[index] = 16;
                            continue;
                        }
                        biomes[index] = 26;
                        continue;
                    }
                    biomeList = DictionaryFactory.oceanBiomes.get(id);
                    if (biomeList == null || biomeList.isEmpty()) {
                        biomes[m * areaWidth + n] = plates == 4 ? 0 : 24;
                        continue;
                    }
                    biomes[m * areaWidth + n] = biomeList.get(0).getBiome();
                    continue;
                }
                biomeList = DictionaryFactory.biomes.get(id);
                biomes[index] = biomeList == null || biomeList.isEmpty() ? 127 : biomeList.get(0).getBiome();
            }
        }
        return biomes;
    }

    public double[][] getGeoFactors(int areaX, int areaY, int areaWidth, int areaHeight) {
        long riverKey = (long)Math.floorDiv(areaX + this.riverRegionHalfWidth, this.riverRegionWidth) & 0xFFFFFFFFL | ((long)Math.floorDiv(areaY + this.riverRegionHalfWidth, this.riverRegionWidth) & 0xFFFFFFFFL) << 32;
        RiverRegion riverRegion = this.riverRegionCache.get(riverKey);
        if (riverRegion == null) {
            int startX = Math.floorDiv(areaX + this.riverRegionHalfWidth, this.riverRegionWidth) * this.riverRegionWidth - this.riverRegionHalfWidth;
            int startZ = Math.floorDiv(areaY + this.riverRegionHalfWidth, this.riverRegionWidth) * this.riverRegionWidth - this.riverRegionHalfWidth;
            riverRegion = new RiverRegion(this.seed & riverKey, startX, startZ, this.riverRegionWidth, this.riverRegionWidth, 40, this.elevationGen, this.precipitationGen);
            if (this.riverRegionCache.size() > 4096) {
                this.riverRegionCache.clear();
            }
            this.riverRegionCache.put(riverKey, riverRegion);
        }
        double[][] geofactors = new double[areaWidth * areaHeight][9];
        for (int n = 0; n < areaWidth; ++n) {
            int xOffset = areaX + n;
            for (int m = 0; m < areaHeight; ++m) {
                int zOffset = areaY + m;
                int index = m * areaWidth + n;
                double surface = this.surfaceGen.noise(xOffset, zOffset);
                double elevation = this.elevationGen.noise(xOffset, zOffset) * this.plateFactor + this.plateWeight;
                double density = this.densityGen.noise(xOffset, zOffset) * this.rockFactor + this.rockWeight;
                double uplift = this.upliftGen.noise(xOffset, zOffset) * this.liftFactor + this.liftWeight;
                double volcanism = this.volcanismGen.noise(xOffset, zOffset) * this.thermalFactor + this.thermalWeight;
                double era = this.eraGen.noise(xOffset, zOffset) * this.ageFactor + this.ageWeight;
                double erosion = this.erosionGen.noise(xOffset, zOffset) * this.erosionFactor + this.erosionWeight;
                double temperature = this.temperatureGen.noise(xOffset, zOffset) * this.tempFactor + MathHelper.func_151237_a((double)(this.tempWeight + (double)zOffset * 1.875E-5), (double)-0.6, (double)0.6);
                double precipitation = this.precipitationGen.noise(xOffset, zOffset) * this.precipFactor + MathHelper.func_151237_a((double)(this.precipWeight + (double)xOffset * 1.875E-5), (double)-0.6, (double)0.6);
                if (elevation > -0.2) {
                    double riverUplift = uplift;
                    for (int t = 0; t < riverRegion.rivers.size(); ++t) {
                        RiverRegion.River river = riverRegion.rivers.get(t);
                        double d = RiverRegion.distToSegmentSquared(xOffset, zOffset, river.vHi.field_72450_a + this.riverWiggleHi * precipitation, river.vHi.field_72449_c + this.riverWiggleHi * uplift, river.vLo.field_72450_a + this.riverWiggleLo * precipitation, river.vLo.field_72449_c + this.riverWiggleLo * uplift) + surface * 6400.0;
                        if (d < this.riverChannel) {
                            riverUplift = -0.8;
                            continue;
                        }
                        if (d < this.riverBank) {
                            riverUplift = Math.min((d - this.riverChannel) / this.riverShallow * 0.8 - 0.8, riverUplift);
                            continue;
                        }
                        if (!(d < this.riverWidthSquared)) continue;
                        riverUplift = Math.min((d - this.riverBank) / this.riverShore, riverUplift);
                    }
                    if (elevation < 0.0) {
                        riverUplift += -elevation * 5.0 * (uplift - riverUplift);
                    }
                    uplift = riverUplift;
                }
                geofactors[index][0] = surface;
                geofactors[index][1] = elevation;
                geofactors[index][2] = density;
                geofactors[index][3] = uplift;
                geofactors[index][4] = volcanism;
                geofactors[index][5] = era;
                geofactors[index][6] = erosion;
                geofactors[index][7] = temperature;
                geofactors[index][8] = precipitation;
            }
        }
        return geofactors;
    }
}

