/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds;

import com.dooglamoo.worlds.DooglamooConfig;
import com.dooglamoo.worlds.command.DooglamooCommands;
import com.dooglamoo.worlds.dict.DictionaryFactory;
import com.dooglamoo.worlds.dict.GeofeatureManager;
import com.dooglamoo.worlds.world.DooglamooWorldType;
import com.dooglamoo.worlds.world.gen.feature.DooglamooFeatures;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dooglamooworlds")
public class DooglamooWorldsMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final WorldType DOOGLAMOO = new DooglamooWorldType("dooglamoo");

    public DooglamooWorldsMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::dedicatedServerSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, DooglamooConfig.spec);
    }

    private void setup(FMLCommonSetupEvent event) {
        DictionaryFactory.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        DictionaryFactory.loadComplete();
    }

    private void dedicatedServerSetup(FMLDedicatedServerSetupEvent event) {
    }

    @SubscribeEvent
    public void tagsUpdated(TagsUpdatedEvent event) {
        DictionaryFactory.tagsUpdated(event);
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new GeofeatureManager());
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        event.getCommandDispatcher().register(DooglamooCommands.GEOFACTORS);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onFeatureRegistry(RegistryEvent.Register<Feature<?>> featureRegistryEvent) {
            DooglamooFeatures.register(featureRegistryEvent.getRegistry());
        }
    }
}

