/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.client.gui.screen;

import com.dooglamoo.worlds.world.gen.DooglamooGenSettings;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.OptionsRowList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreateDooglamooWorldScreen
extends Screen {
    private final CreateWorldScreen parent;
    private DooglamooGenSettings generatorInfo = DooglamooGenSettings.getDefaultDooglamooGenerator();
    private OptionsRowList optionsRowList;

    public CreateDooglamooWorldScreen(CreateWorldScreen parent, CompoundNBT generatorOptions) {
        super((ITextComponent)new TranslationTextComponent("createWorld.customize.dooglamoo.title", new Object[0]));
        this.parent = parent;
        this.setGeneratorOptions(generatorOptions);
    }

    public CompoundNBT getGeneratorOptions() {
        return (CompoundNBT)this.generatorInfo.buildSettings(NBTDynamicOps.field_210820_a).getValue();
    }

    public void setGeneratorOptions(CompoundNBT nbt) {
        this.generatorInfo = DooglamooGenSettings.createDooglamooGenerator(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt));
    }

    protected void init() {
        SliderPercentageOption elevationScaleOption = new SliderPercentageOption("config.property.elevation_scale", 1.0, 3.0, 0.01f, gamesettings -> this.generatorInfo.elevationScale, (gamesettings, value) -> {
            this.generatorInfo.elevationScale = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption densityScaleOption = new SliderPercentageOption("config.property.density_scale", 1.0, 3.0, 0.01f, gamesettings -> this.generatorInfo.densityScale, (gamesettings, value) -> {
            this.generatorInfo.densityScale = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption upliftScaleOption = new SliderPercentageOption("config.property.uplift_scale", 1.0, 3.0, 0.01f, gamesettings -> this.generatorInfo.upliftScale, (gamesettings, value) -> {
            this.generatorInfo.upliftScale = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption volcanismScaleOption = new SliderPercentageOption("config.property.volcanism_scale", 1.0, 3.0, 0.01f, gamesettings -> this.generatorInfo.volcanismScale, (gamesettings, value) -> {
            this.generatorInfo.volcanismScale = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption eraScaleOption = new SliderPercentageOption("config.property.era_scale", 1.0, 3.0, 0.01f, gamesettings -> this.generatorInfo.eraScale, (gamesettings, value) -> {
            this.generatorInfo.eraScale = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption erosionScaleOption = new SliderPercentageOption("config.property.erosion_scale", 1.0, 3.0, 0.01f, gamesettings -> this.generatorInfo.erosionScale, (gamesettings, value) -> {
            this.generatorInfo.erosionScale = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption temperatureScaleOption = new SliderPercentageOption("config.property.temperature_scale", 1.0, 3.0, 0.01f, gamesettings -> this.generatorInfo.temperatureScale, (gamesettings, value) -> {
            this.generatorInfo.temperatureScale = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption precipitationScaleOption = new SliderPercentageOption("config.property.precipitation_scale", 1.0, 3.0, 0.01f, gamesettings -> this.generatorInfo.precipitationScale, (gamesettings, value) -> {
            this.generatorInfo.precipitationScale = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption elevationAmplitudeOption = new SliderPercentageOption("config.property.elevation_amplitude", 0.0, 2.0, 0.01f, gamesettings -> this.generatorInfo.elevationAmplitude, (gamesettings, value) -> {
            this.generatorInfo.elevationAmplitude = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption densityAmplitudeOption = new SliderPercentageOption("config.property.density_amplitude", 0.0, 2.0, 0.01f, gamesettings -> this.generatorInfo.densityAmplitude, (gamesettings, value) -> {
            this.generatorInfo.densityAmplitude = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption upliftAmplitudeOption = new SliderPercentageOption("config.property.uplift_amplitude", 0.0, 2.0, 0.01f, gamesettings -> this.generatorInfo.upliftAmplitude, (gamesettings, value) -> {
            this.generatorInfo.upliftAmplitude = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption volcanismAmplitudeOption = new SliderPercentageOption("config.property.volcanism_amplitude", 0.0, 2.0, 0.01f, gamesettings -> this.generatorInfo.volcanismAmplitude, (gamesettings, value) -> {
            this.generatorInfo.volcanismAmplitude = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption eraAmplitudeOption = new SliderPercentageOption("config.property.era_amplitude", 0.0, 2.0, 0.01f, gamesettings -> this.generatorInfo.eraAmplitude, (gamesettings, value) -> {
            this.generatorInfo.eraAmplitude = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption erosionAmplitudeOption = new SliderPercentageOption("config.property.erosion_amplitude", 0.0, 2.0, 0.01f, gamesettings -> this.generatorInfo.erosionAmplitude, (gamesettings, value) -> {
            this.generatorInfo.erosionAmplitude = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption temperatureAmplitudeOption = new SliderPercentageOption("config.property.temperature_amplitude", 0.0, 2.0, 0.01f, gamesettings -> this.generatorInfo.temperatureAmplitude, (gamesettings, value) -> {
            this.generatorInfo.temperatureAmplitude = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption precipitationAmplitudeOption = new SliderPercentageOption("config.property.precipitation_amplitude", 0.0, 2.0, 0.01f, gamesettings -> this.generatorInfo.precipitationAmplitude, (gamesettings, value) -> {
            this.generatorInfo.precipitationAmplitude = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption elevationWeightOption = new SliderPercentageOption("config.property.elevation_weight", -0.6, 0.6, 0.01f, gamesettings -> this.generatorInfo.elevationWeight, (gamesettings, value) -> {
            this.generatorInfo.elevationWeight = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption densityWeightOption = new SliderPercentageOption("config.property.density_weight", -0.6, 0.6, 0.01f, gamesettings -> this.generatorInfo.densityWeight, (gamesettings, value) -> {
            this.generatorInfo.densityWeight = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption upliftWeightOption = new SliderPercentageOption("config.property.uplift_weight", -0.6, 0.6, 0.01f, gamesettings -> this.generatorInfo.upliftWeight, (gamesettings, value) -> {
            this.generatorInfo.upliftWeight = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption volcanismWeightOption = new SliderPercentageOption("config.property.volcanism_weight", -0.6, 0.6, 0.01f, gamesettings -> this.generatorInfo.volcanismWeight, (gamesettings, value) -> {
            this.generatorInfo.volcanismWeight = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption eraWeightOption = new SliderPercentageOption("config.property.era_weight", -0.6, 0.6, 0.01f, gamesettings -> this.generatorInfo.eraWeight, (gamesettings, value) -> {
            this.generatorInfo.eraWeight = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption erosionWeightOption = new SliderPercentageOption("config.property.erosion_weight", -0.6, 0.6, 0.01f, gamesettings -> this.generatorInfo.erosionWeight, (gamesettings, value) -> {
            this.generatorInfo.erosionWeight = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption temperatureWeightOption = new SliderPercentageOption("config.property.temperature_weight", -0.6, 0.6, 0.01f, gamesettings -> this.generatorInfo.temperatureWeight, (gamesettings, value) -> {
            this.generatorInfo.temperatureWeight = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        SliderPercentageOption precipitationWeightOption = new SliderPercentageOption("config.property.precipitation_weight", -0.6, 0.6, 0.01f, gamesettings -> this.generatorInfo.precipitationWeight, (gamesettings, value) -> {
            this.generatorInfo.precipitationWeight = value;
        }, (gamesettings, option) -> option.func_216617_a() + (double)((int)(option.func_216729_a(gamesettings) * 100.0)) / 100.0);
        AbstractOption[] options = new AbstractOption[]{elevationScaleOption, densityScaleOption, upliftScaleOption, volcanismScaleOption, eraScaleOption, erosionScaleOption, temperatureScaleOption, precipitationScaleOption, elevationAmplitudeOption, densityAmplitudeOption, upliftAmplitudeOption, volcanismAmplitudeOption, eraAmplitudeOption, erosionAmplitudeOption, temperatureAmplitudeOption, precipitationAmplitudeOption, elevationWeightOption, densityWeightOption, upliftWeightOption, volcanismWeightOption, eraWeightOption, erosionWeightOption, temperatureWeightOption, precipitationWeightOption};
        this.optionsRowList = new OptionsRowList(this.minecraft, this.width, this.height, 32, this.height - 32, 25);
        this.optionsRowList.func_214335_a(options);
        this.children.add(this.optionsRowList);
        this.addButton((Widget)new Button(this.width / 2 - 155, this.height - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), p_213010_1_ -> {
            this.parent.field_146334_a = this.getGeneratorOptions();
            this.minecraft.func_147108_a((Screen)this.parent);
        }));
        this.addButton((Widget)new Button(this.width / 2 + 5, this.height - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), p_213009_1_ -> this.minecraft.func_147108_a((Screen)this.parent)));
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        this.optionsRowList.render(p_render_1_, p_render_2_, p_render_3_);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 8, 0xFFFFFF);
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }
}

