/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.dict;

import com.dooglamoo.worlds.DooglamooConfig;
import com.dooglamoo.worlds.DooglamooWorldsMod;
import com.dooglamoo.worlds.dict.GeoFeature;
import com.dooglamoo.worlds.dict.MinMaxBounds;
import com.dooglamoo.worlds.world.gen.feature.DooglamooFeatures;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.BushConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DoublePlantConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureRadiusConfig;
import net.minecraft.world.gen.feature.GrassFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SeaGrassConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

public class DictionaryFactory {
    @ObjectHolder(value="lostcities:lostcityfeature")
    public static final Feature<NoFeatureConfig> LOSTCITY_FEATURE = null;
    public static HashMap<String, BlockState> blockDictionary;
    public static HashMap<String, ConfiguredFeature<?>> featureDictionary;
    public static List<Biome> baseBiomes;
    public static List<Biome> addedBiomes;
    public static Map<Integer, List<GeoFeature>> blocks;
    public static Map<Integer, List<GeoFeature>> features;
    public static Map<Integer, List<GeoFeature>> biomes;
    public static Map<Integer, List<GeoFeature>> ores;
    public static int biomeCount;
    public static int blockCount;
    public static int featureCount;

    public static void clear() {
        baseBiomes.clear();
        addedBiomes.clear();
        blocks.clear();
        features.clear();
        biomes.clear();
        ores.clear();
        biomeCount = 0;
        blockCount = 0;
        featureCount = 0;
    }

    public static void init() {
        blockDictionary = new HashMap();
        featureDictionary = new HashMap();
        baseBiomes = new ArrayList<Biome>();
        addedBiomes = new ArrayList<Biome>();
        blockDictionary.put("air", Blocks.field_150350_a.func_176223_P());
        blockDictionary.put("lava", Blocks.field_150353_l.func_176223_P());
        blockDictionary.put("water", Blocks.field_150355_j.func_176223_P());
        blockDictionary.put("water_salt", Blocks.field_150355_j.func_176223_P());
        blockDictionary.put("magma", Blocks.field_196814_hQ.func_176223_P());
        blockDictionary.put("stone", Blocks.field_150348_b.func_176223_P());
        blockDictionary.put("stone_andesite", Blocks.field_196656_g.func_176223_P());
        blockDictionary.put("stone_granite", Blocks.field_196650_c.func_176223_P());
        blockDictionary.put("stone_diorite", Blocks.field_196654_e.func_176223_P());
        blockDictionary.put("dirt", Blocks.field_150346_d.func_176223_P());
        blockDictionary.put("coarsedirt", Blocks.field_196660_k.func_176223_P());
        blockDictionary.put("loam", Blocks.field_196660_k.func_176223_P());
        blockDictionary.put("podzol", Blocks.field_196661_l.func_176223_P());
        blockDictionary.put("mycelium", Blocks.field_150391_bh.func_176223_P());
        blockDictionary.put("grass", Blocks.field_196658_i.func_176223_P());
        blockDictionary.put("heath", Blocks.field_196658_i.func_176223_P());
        blockDictionary.put("terracotta", Blocks.field_150405_ch.func_176223_P());
        blockDictionary.put("sandstone", Blocks.field_150322_A.func_176223_P());
        blockDictionary.put("terracotta_white", Blocks.field_196777_fo.func_176223_P());
        blockDictionary.put("terracotta_orange", Blocks.field_196778_fp.func_176223_P());
        blockDictionary.put("terracotta_yellow", Blocks.field_196783_fs.func_176223_P());
        blockDictionary.put("terracotta_gray", Blocks.field_196789_fv.func_176223_P());
        blockDictionary.put("terracotta_silver", Blocks.field_196791_fw.func_176223_P());
        blockDictionary.put("terracotta_brown", Blocks.field_196719_fA.func_176223_P());
        blockDictionary.put("terracotta_red", Blocks.field_196721_fC.func_176223_P());
        blockDictionary.put("cobblestone", Blocks.field_150347_e.func_176223_P());
        blockDictionary.put("obsidian", Blocks.field_150343_Z.func_176223_P());
        blockDictionary.put("gravel", Blocks.field_150351_n.func_176223_P());
        blockDictionary.put("sand", Blocks.field_150354_m.func_176223_P());
        blockDictionary.put("sand_red", Blocks.field_196611_F.func_176223_P());
        blockDictionary.put("ice", Blocks.field_150432_aD.func_176223_P());
        blockDictionary.put("snow", Blocks.field_196604_cC.func_176223_P());
        blockDictionary.put("snowpack", Blocks.field_196604_cC.func_176223_P());
        blockDictionary.put("icepack", Blocks.field_150403_cj.func_176223_P());
        blockDictionary.put("silverfish", Blocks.field_196686_dc.func_176223_P());
        blockDictionary.put("clay", Blocks.field_150435_aG.func_176223_P());
        if (((Boolean)DooglamooConfig.GENERAL.customGenSlimeOre.get()).booleanValue()) {
            blockDictionary.put("oil", Blocks.field_180399_cE.func_176223_P());
        }
        if (((Boolean)DooglamooConfig.GENERAL.customGenGlowstoneOre.get()).booleanValue()) {
            blockDictionary.put("glowstone", Blocks.field_150426_aN.func_176223_P());
        }
        blockDictionary.put("coal_ore", Blocks.field_150365_q.func_176223_P());
        blockDictionary.put("iron_ore", Blocks.field_150366_p.func_176223_P());
        blockDictionary.put("gold_ore", Blocks.field_150352_o.func_176223_P());
        blockDictionary.put("emerald_ore", Blocks.field_150412_bA.func_176223_P());
        blockDictionary.put("lapis_ore", Blocks.field_150369_x.func_176223_P());
        blockDictionary.put("redstone_ore", Blocks.field_150450_ax.func_176223_P());
        blockDictionary.put("diamond_ore", Blocks.field_150482_ag.func_176223_P());
        if (((Boolean)DooglamooConfig.GENERAL.customGenQuartzOre.get()).booleanValue()) {
            blockDictionary.put("quartz_ore", Blocks.field_196766_fg.func_176223_P());
        }
        featureDictionary.put("tree_spruce_mega", Biome.func_222280_a((Feature)Feature.field_202303_C, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
        featureDictionary.put("tree_spruce_redwood", Biome.func_222280_a((Feature)Feature.field_202304_D, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
        featureDictionary.put("tree_spruce", Biome.func_222280_a((Feature)Feature.field_202344_v, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(6, 0.1f, 1)));
        featureDictionary.put("tree_spruce_tall", Biome.func_222280_a((Feature)Feature.field_202347_y, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(8, 0.1f, 1)));
        featureDictionary.put("tree_birch", Biome.func_222280_a((Feature)Feature.field_202340_r, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(6, 0.1f, 1)));
        featureDictionary.put("tree_birch_tall", Biome.func_222280_a((Feature)Feature.field_202341_s, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(8, 0.1f, 1)));
        featureDictionary.put("tree_jungle_mega", Biome.func_222280_a((Feature)Feature.field_202302_B, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(50, 0.1f, 1)));
        featureDictionary.put("tree_jungle", Biome.func_222280_a((Feature)Feature.field_202343_u, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
        featureDictionary.put("tree_jungle_tall", Biome.func_222280_a((Feature)Feature.field_202343_u, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
        featureDictionary.put("tree_jungle_vines", Biome.func_222280_a((Feature)Feature.field_202343_u, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
        featureDictionary.put("tree_acacia", Biome.func_222280_a((Feature)Feature.field_202346_x, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(8, 0.1f, 1)));
        featureDictionary.put("tree_oak_dark", Biome.func_222280_a((Feature)Feature.field_214551_w, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215008_G, (IPlacementConfig)IPlacementConfig.field_202468_e));
        featureDictionary.put("tree_oak_big", Biome.func_222280_a((Feature)Feature.field_202339_q, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
        featureDictionary.put("tree_oak", Biome.func_222280_a((Feature)Feature.field_202301_A, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(6, 0.1f, 1)));
        featureDictionary.put("tree_oak_swamp", Biome.func_222280_a((Feature)Feature.field_202348_z, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
        featureDictionary.put("clay", Biome.func_222280_a((Feature)Feature.field_202285_ae, (IFeatureConfig)new SphereReplaceConfig(Blocks.field_150435_aG.func_176223_P(), 4, 1, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_150435_aG.func_176223_P()})), (Placement)Placement.field_215016_b, (IPlacementConfig)new FrequencyConfig(1)));
        featureDictionary.put("sand", Biome.func_222280_a((Feature)Feature.field_202285_ae, (IFeatureConfig)new SphereReplaceConfig(Blocks.field_150354_m.func_176223_P(), 7, 2, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P()})), (Placement)Placement.field_215016_b, (IPlacementConfig)new FrequencyConfig(3)));
        featureDictionary.put("gravel", Biome.func_222280_a((Feature)Feature.field_202285_ae, (IFeatureConfig)new SphereReplaceConfig(Blocks.field_150351_n.func_176223_P(), 6, 2, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P()})), (Placement)Placement.field_215016_b, (IPlacementConfig)new FrequencyConfig(1)));
        featureDictionary.put("mushroom_brown", Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Blocks.field_150338_P.func_176223_P()), (Placement)Placement.field_215034_t, (IPlacementConfig)new HeightWithChanceConfig(8, 0.25f)));
        featureDictionary.put("mushroom_red", Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Blocks.field_150337_Q.func_176223_P()), (Placement)Placement.field_215034_t, (IPlacementConfig)new HeightWithChanceConfig(8, 0.25f)));
        featureDictionary.put("reed", Biome.func_222280_a((Feature)Feature.field_202324_X, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(10)));
        featureDictionary.put("cactus", Biome.func_222280_a((Feature)Feature.field_202313_M, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(5)));
        featureDictionary.put("waterlily", Biome.func_222280_a((Feature)Feature.field_202281_aa, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(4)));
        featureDictionary.put("ice_spike", Biome.func_222280_a((Feature)Feature.field_202320_T, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(3)));
        featureDictionary.put("ice_path", Biome.func_222280_a((Feature)Feature.field_202288_ah, (IFeatureConfig)new FeatureRadiusConfig(2), (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("shrub_jungle", Biome.func_222280_a((Feature)Feature.field_202342_t, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
        featureDictionary.put("fern", Biome.func_222280_a((Feature)Feature.field_202310_J, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(7)));
        featureDictionary.put("grass", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("grass_tussock", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("blob", Biome.func_222280_a((Feature)Feature.field_202283_ac, (IFeatureConfig)new BlockBlobConfig(Blocks.field_150341_Y.func_176223_P(), 0), (Placement)Placement.field_215040_z, (IPlacementConfig)new FrequencyConfig(3)));
        featureDictionary.put("bush_dead", Biome.func_222280_a((Feature)Feature.field_202314_N, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("flower_dandelion", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_196605_bc.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("flower_poppy", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_196606_bd.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("flower_orchid_blue", Biome.func_222280_a((Feature)Feature.field_202308_H, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
        featureDictionary.put("flower_allium", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_196609_bf.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("flower_houstonia", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_196610_bg.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("flower_tulip_red", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_196612_bh.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("flower_tulip_orange", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_196613_bi.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("flower_tulip_white", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_196614_bj.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("flower_tulip_pink", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_196615_bk.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("flower_oxeyedaisy", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_196616_bl.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("flower_cornflower", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_222387_by.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("flower_lilyofthevalley", Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_222383_bA.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
        featureDictionary.put("pumpkin", Biome.func_222280_a((Feature)Feature.field_202323_W, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(1)));
        featureDictionary.put("melon", Biome.func_222280_a((Feature)Feature.field_202322_V, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(1)));
        featureDictionary.put("flower_rose_tall", Biome.func_222280_a((Feature)Feature.field_202286_af, (IFeatureConfig)new DoublePlantConfig(Blocks.field_196802_gf.func_176223_P()), (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(10)));
        featureDictionary.put("flower_syringa_tall", Biome.func_222280_a((Feature)Feature.field_202286_af, (IFeatureConfig)new DoublePlantConfig(Blocks.field_196801_ge.func_176223_P()), (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(10)));
        featureDictionary.put("flower_paeonia_tall", Biome.func_222280_a((Feature)Feature.field_202286_af, (IFeatureConfig)new DoublePlantConfig(Blocks.field_196803_gg.func_176223_P()), (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(10)));
        featureDictionary.put("flower_sunflower_tall", Biome.func_222280_a((Feature)Feature.field_202286_af, (IFeatureConfig)new DoublePlantConfig(Blocks.field_196800_gd.func_176223_P()), (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(10)));
        featureDictionary.put("grass_tall", Biome.func_222280_a((Feature)Feature.field_202286_af, (IFeatureConfig)new DoublePlantConfig(Blocks.field_196804_gh.func_176223_P()), (Placement)Placement.field_215020_f, (IPlacementConfig)new NoiseDependant(-0.8, 0, 7)));
        featureDictionary.put("fern_tall", Biome.func_222280_a((Feature)Feature.field_202286_af, (IFeatureConfig)new DoublePlantConfig(Blocks.field_196805_gi.func_176223_P()), (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(7)));
        featureDictionary.put("water_flowing", Biome.func_222280_a((Feature)Feature.field_202295_ao, (IFeatureConfig)new LiquidsConfig(Fluids.field_204546_a.func_207188_f()), (Placement)Placement.field_215029_o, (IPlacementConfig)new CountRangeConfig(50, 8, 8, 256)));
        featureDictionary.put("lava_flowing", Biome.func_222280_a((Feature)Feature.field_202295_ao, (IFeatureConfig)new LiquidsConfig(Fluids.field_204547_b.func_207188_f()), (Placement)Placement.field_215030_p, (IPlacementConfig)new CountRangeConfig(20, 8, 16, 256)));
        featureDictionary.put("mushroom_brown_tall", Biome.func_222280_a((Feature)Feature.field_202319_S, (IFeatureConfig)new BigMushroomFeatureConfig(false), (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(1)));
        featureDictionary.put("mushroom_red_tall", Biome.func_222280_a((Feature)Feature.field_202318_R, (IFeatureConfig)new BigMushroomFeatureConfig(false), (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(1)));
        featureDictionary.put("coral", Biome.func_222280_a((Feature)Feature.field_204620_ao, (IFeatureConfig)new SingleRandomFeature(new Feature[]{Feature.field_204621_ay, Feature.field_204619_aA, Feature.field_204622_az}, new IFeatureConfig[]{IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e}), (Placement)Placement.field_215038_x, (IPlacementConfig)new TopSolidWithNoiseConfig(20, 400.0, 0.0, Heightmap.Type.OCEAN_FLOOR_WG)));
        featureDictionary.put("kelp", Biome.func_222280_a((Feature)Feature.field_203235_au, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215038_x, (IPlacementConfig)new TopSolidWithNoiseConfig(80, 80.0, 0.0, Heightmap.Type.OCEAN_FLOOR_WG)));
        featureDictionary.put("seagrass", Biome.func_222280_a((Feature)Feature.field_203234_at, (IFeatureConfig)new SeaGrassConfig(80, 0.3), (Placement)Placement.field_215036_v, (IPlacementConfig)IPlacementConfig.field_202468_e));
        featureDictionary.put("bush_berry_sweet", Biome.func_222280_a((Feature)Feature.field_214485_aM, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(1)));
        featureDictionary.put("sea_pickle", Biome.func_222280_a((Feature)Feature.field_204914_aC, (IFeatureConfig)new CountConfig(20), (Placement)Placement.field_215026_l, (IPlacementConfig)new ChanceConfig(16)));
        featureDictionary.put("bamboo", Biome.func_222280_a((Feature)Feature.field_214482_aJ, (IFeatureConfig)new ProbabilityConfig(0.2f), (Placement)Placement.field_215038_x, (IPlacementConfig)new TopSolidWithNoiseConfig(160, 80.0, 0.3, Heightmap.Type.WORLD_SURFACE_WG)));
        featureDictionary.put("tree_birch_fallen", Biome.func_222280_a(DooglamooFeatures.FALLEN_TREE, (IFeatureConfig)new BushConfig(Blocks.field_196619_M.func_176223_P()), (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.2f, 1)));
        featureDictionary.put("tree_oak_fallen", Biome.func_222280_a(DooglamooFeatures.FALLEN_TREE, (IFeatureConfig)new BushConfig(Blocks.field_196617_K.func_176223_P()), (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.2f, 1)));
        featureDictionary.put("tree_spruce_fallen", Biome.func_222280_a(DooglamooFeatures.FALLEN_TREE, (IFeatureConfig)new BushConfig(Blocks.field_196618_L.func_176223_P()), (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.2f, 1)));
        featureDictionary.put("rock_river_mossy", Biome.func_222280_a((Feature)Feature.field_202283_ac, (IFeatureConfig)new BlockBlobConfig(Blocks.field_150341_Y.func_176223_P(), 0), (Placement)Placement.field_215040_z, (IPlacementConfig)new FrequencyConfig(6)));
        featureDictionary.put("rock_river", Biome.func_222280_a((Feature)Feature.field_202283_ac, (IFeatureConfig)new BlockBlobConfig(Blocks.field_150347_e.func_176223_P(), 0), (Placement)Placement.field_215040_z, (IPlacementConfig)new FrequencyConfig(6)));
        try {
            Class<?> bopFeatures = Class.forName("biomesoplenty.common.world.gen.feature.BOPBiomeFeatures");
            Feature feature = DictionaryFactory.getExternalFeature(bopFeatures, "PINK_CHERRY_TREE");
            if (feature != null) {
                featureDictionary.put("tree_cherry_pink", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "BIG_PINK_CHERRY_TREE")) != null) {
                featureDictionary.put("tree_cherry_pink_large", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "WHITE_CHERRY_TREE")) != null) {
                featureDictionary.put("tree_cherry_white", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "BIG_WHITE_CHERRY_TREE")) != null) {
                featureDictionary.put("tree_cherry_white_large", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "FIR_TREE")) != null) {
                featureDictionary.put("tree_fir", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "FIR_TREE_LARGE")) != null) {
                featureDictionary.put("tree_fir_mega", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "WILLOW_TREE")) != null) {
                featureDictionary.put("tree_willow", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "YELLOW_AUTUMN_TREE")) != null) {
                featureDictionary.put("tree_autumn_yellow", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "ORANGE_AUTUMN_TREE")) != null) {
                featureDictionary.put("tree_autumn_orange", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "JUNGLE_TWIGLET_TREE")) != null) {
                featureDictionary.put("tree_jungle_twiglet", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "DYING_TREE")) != null) {
                featureDictionary.put("tree_dying", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "DEAD_TREE")) != null) {
                featureDictionary.put("tree_dead", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "DARK_OAK_POPLAR")) != null) {
                featureDictionary.put("tree_poplar_dark", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "BIRCH_POPLAR")) != null) {
                featureDictionary.put("tree_poplar", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "JACARANDA_TREE")) != null) {
                featureDictionary.put("tree_jacaranda", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "MAPLE_TREE")) != null) {
                featureDictionary.put("tree_maple", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "MAGIC_TREE")) != null) {
                featureDictionary.put("tree_magic", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "PALM_TREE")) != null) {
                featureDictionary.put("tree_palm", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "TALL_UMBRAN_TREE")) != null) {
                featureDictionary.put("tree_umbran_mega", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "ACACIA_BUSH")) != null) {
                featureDictionary.put("bush_acacia", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "ACACIA_TWIGLET_TREE")) != null) {
                featureDictionary.put("tree_acacia_twiglet", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "MAHOGANY_TREE")) != null) {
                featureDictionary.put("tree_mahogany", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "REDWOOD_TREE")) != null) {
                featureDictionary.put("tree_redwood", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "REDWOOD_TREE_MEDIUM")) != null) {
                featureDictionary.put("tree_redwood_thin", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(5)));
            }
            if ((feature = DictionaryFactory.getExternalFeature(bopFeatures, "LAVENDER_FLOWERS")) != null) {
                featureDictionary.put("flower_lavender", Biome.func_222280_a((Feature)feature, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
            }
        }
        catch (Exception e) {
            DooglamooWorldsMod.LOGGER.info("Error getting BoP features: " + e);
        }
        if (LOSTCITY_FEATURE != null) {
            featureDictionary.put("lostcity", Biome.func_222280_a(LOSTCITY_FEATURE, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 0, 0, 1)));
        }
    }

    private static Feature getExternalFeature(Class<?> c, String name) {
        try {
            Field field = c.getField(name);
            if (Feature.class.isAssignableFrom(field.getType())) {
                return (Feature)field.get(null);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void tagsUpdated(TagsUpdatedEvent event) {
        if (EffectiveSide.get() == LogicalSide.SERVER) {
            DictionaryFactory.findModdedOre("copper", event);
            DictionaryFactory.findModdedOre("tin", event);
            DictionaryFactory.findModdedOre("aluminum", event);
            DictionaryFactory.findModdedOre("lead", event);
            DictionaryFactory.findModdedOre("silver", event);
            DictionaryFactory.findModdedOre("nickel", event);
            DictionaryFactory.findModdedOre("uranium", event);
        }
    }

    public static void loadComplete() {
        DictionaryFactory.registerBlock("biomesoplenty", "ash_block", "ash_block");
        DictionaryFactory.registerBlock("biomesoplenty", "mud", "mud_mud");
        DictionaryFactory.registerBlock("biomesoplenty", "white_sand", "sand_white");
    }

    private static void findModdedOre(String name, TagsUpdatedEvent event) {
        Optional block;
        if (event.getTagManager().func_199717_a().func_199910_a(new ResourceLocation("forge", "ores/" + name)) != null && (block = event.getTagManager().func_199717_a().func_199910_a(new ResourceLocation("forge", "ores/" + name)).func_199885_a().stream().findFirst()).isPresent()) {
            blockDictionary.put(name + "_ore", ((Block)block.get()).func_176223_P());
        }
    }

    private static void registerBlock(String domain, String id, String name) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(domain, id));
        if (block != null && block != Blocks.field_150350_a) {
            blockDictionary.put(name, block.func_176223_P());
        }
    }

    public static GeoFeature getGeoFeature(String key, JsonObject json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        String type = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Material type can not be an empty string");
        }
        if (!type.contains(":")) {
            type = "dooglamooworlds:" + type;
        }
        key = key.substring(key.lastIndexOf("/") + 1);
        int level = key.split("_").length;
        GeoFeature geo = null;
        switch (type) {
            case "dooglamooworlds:block": {
                BlockState state = blockDictionary.get(key);
                if (state != null) {
                    geo = new GeoFeature(state, level);
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorldsMod.LOGGER.info("No registered block found: " + key);
                break;
            }
            case "dooglamooworlds:block_ore": {
                BlockState state = blockDictionary.get(key);
                if (state != null) {
                    geo = new GeoFeature(state, JSONUtils.func_151208_a((JsonObject)json, (String)"spacing", (int)23), JSONUtils.func_151208_a((JsonObject)json, (String)"depth", (int)255));
                    JsonArray rar = JSONUtils.func_151214_t((JsonObject)json, (String)"rarity");
                    if (rar.size() > 0) {
                        geo.rarity[0] = rar.get(0).getAsFloat();
                    }
                    if (rar.size() > 1) {
                        geo.rarity[1] = rar.get(1).getAsFloat();
                    }
                    if (rar.size() > 2) {
                        geo.rarity[2] = rar.get(2).getAsFloat();
                    }
                    JsonArray req = JSONUtils.func_151213_a((JsonObject)json, (String)"requirements", (JsonArray)new JsonArray());
                    int requirement = 1;
                    if (req.size() > 0) {
                        for (Map.Entry entry : req.get(0).getAsJsonObject().entrySet()) {
                            switch ((String)entry.getKey()) {
                                case "elevation": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 2 : 10;
                                    break;
                                }
                                case "density": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 3 : 11;
                                    break;
                                }
                                case "uplift": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 4 : 12;
                                    break;
                                }
                                case "volcanism": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 5 : 13;
                                    break;
                                }
                                case "era": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 6 : 14;
                                    break;
                                }
                                case "erosion": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 7 : 15;
                                    break;
                                }
                                case "temperature": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 8 : 16;
                                    break;
                                }
                                case "precipitation": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 9 : 17;
                                }
                            }
                        }
                    }
                    geo.requirement = requirement;
                    JsonArray mod = JSONUtils.func_151213_a((JsonObject)json, (String)"modifiers", (JsonArray)new JsonArray());
                    int modifier1 = 0;
                    int modifier2 = 0;
                    if (mod.size() > 0) {
                        for (Map.Entry entry : mod.get(0).getAsJsonObject().entrySet()) {
                            switch ((String)entry.getKey()) {
                                case "elevation": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 2 : 10;
                                    break;
                                }
                                case "density": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 3 : 11;
                                    break;
                                }
                                case "uplift": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 4 : 12;
                                    break;
                                }
                                case "volcanism": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 5 : 13;
                                    break;
                                }
                                case "era": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 6 : 14;
                                    break;
                                }
                                case "erosion": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 7 : 15;
                                    break;
                                }
                                case "temperature": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 8 : 16;
                                    break;
                                }
                                case "precipitation": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 9 : 17;
                                }
                            }
                        }
                    }
                    if (mod.size() > 1) {
                        for (Map.Entry entry : mod.get(1).getAsJsonObject().entrySet()) {
                            switch ((String)entry.getKey()) {
                                case "elevation": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 2 : 10;
                                    break;
                                }
                                case "density": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 3 : 11;
                                    break;
                                }
                                case "uplift": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 4 : 12;
                                    break;
                                }
                                case "volcanism": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 5 : 13;
                                    break;
                                }
                                case "era": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 6 : 14;
                                    break;
                                }
                                case "erosion": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 7 : 15;
                                    break;
                                }
                                case "temperature": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 8 : 16;
                                    break;
                                }
                                case "precipitation": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 9 : 17;
                                }
                            }
                        }
                    }
                    geo.modifier[0] = modifier1;
                    geo.modifier[1] = modifier2;
                    MinMaxBounds density = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinDensity(density.getMin());
                    geo.setMaxDensity(density.getMax());
                    break;
                }
                DooglamooWorldsMod.LOGGER.info("No registered block found: " + key);
                break;
            }
            case "dooglamooworlds:feature": 
            case "dooglamooworlds:feature_ocean": {
                ConfiguredFeature<?> gen = featureDictionary.get(key);
                if (gen != null) {
                    geo = new GeoFeature(gen, JSONUtils.func_151217_k((JsonObject)json, (String)"rarity"));
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorldsMod.LOGGER.info("No registered feature found: " + key);
                break;
            }
            case "dooglamooworlds:biome": 
            case "dooglamooworlds:biome_ocean": {
                String domain = JSONUtils.func_151219_a((JsonObject)json, (String)"domain", (String)"minecraft");
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(domain, key));
                if (biome != null) {
                    geo = new GeoFeature(biome, "minecraft".equals(domain) ? 0 : 1);
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorldsMod.LOGGER.info("No registered biome found: " + key);
                break;
            }
            default: {
                DooglamooWorldsMod.LOGGER.info("Unknown geofeature type: " + type);
            }
        }
        return geo;
    }

    public static void register(GeoFeature geo) {
        if (geo == null) {
            return;
        }
        if (geo.getType() == GeoFeature.Type.Biome) {
            if (geo.level == 0) {
                baseBiomes.add(geo.getBiome());
            } else {
                addedBiomes.add(geo.getBiome());
            }
            ++biomeCount;
        } else if (geo.getType() == GeoFeature.Type.Block) {
            ++blockCount;
        } else if (geo.getType() == GeoFeature.Type.Feature) {
            ++featureCount;
        } else if (geo.getType() == GeoFeature.Type.OreBlock) {
            for (int i = geo.getMinDensity(); i <= geo.getMaxDensity(); ++i) {
                List<GeoFeature> list = ores.get(i);
                if (list == null) {
                    list = new ArrayList<GeoFeature>();
                    ores.put(i, list);
                }
                int origIndex = -1;
                for (int j = 0; j < list.size(); ++j) {
                    GeoFeature orig = list.get(j);
                    if (!orig.blockstate.equals((Object)geo.blockstate)) continue;
                    origIndex = j;
                    break;
                }
                if (origIndex >= 0) {
                    list.set(origIndex, geo);
                    continue;
                }
                list.add(geo);
            }
            return;
        }
        for (int t = geo.getMinTemperature(); t <= geo.getMaxTemperature(); ++t) {
            for (int w = geo.getMinPrecipitation(); w <= geo.getMaxPrecipitation(); ++w) {
                for (int u = geo.getMinUplift(); u <= geo.getMaxUplift(); ++u) {
                    for (int e = geo.getMinErosion(); e <= geo.getMaxErosion(); ++e) {
                        for (int g = geo.getMinVolcanism(); g <= geo.getMaxVolcanism(); ++g) {
                            for (int a = geo.getMinEra(); a <= geo.getMaxEra(); ++a) {
                                for (int p = geo.getMinElevation(); p <= geo.getMaxElevation(); ++p) {
                                    for (int r = geo.getMinDensity(); r <= geo.getMaxDensity(); ++r) {
                                        int id = t << 14 | w << 12 | u << 10 | e << 8 | g << 6 | a << 4 | p << 2 | r << 0;
                                        List<GeoFeature> list = null;
                                        switch (geo.getType()) {
                                            case Block: {
                                                list = blocks.get(id);
                                                break;
                                            }
                                            case OreBlock: {
                                                break;
                                            }
                                            case Feature: {
                                                list = features.get(id);
                                                break;
                                            }
                                            case Biome: {
                                                list = biomes.get(id);
                                            }
                                        }
                                        if (list == null) {
                                            list = new ArrayList<GeoFeature>();
                                            switch (geo.getType()) {
                                                case Block: {
                                                    blocks.put(id, list);
                                                    break;
                                                }
                                                case OreBlock: {
                                                    break;
                                                }
                                                case Feature: {
                                                    features.put(id, list);
                                                    break;
                                                }
                                                case Biome: {
                                                    biomes.put(id, list);
                                                }
                                            }
                                        }
                                        if (geo.getType() == GeoFeature.Type.Biome) {
                                            if (list.size() > 0 && geo.getLevel() <= list.get(0).getLevel()) {
                                                if (geo.getLevel() != list.get(0).getLevel()) continue;
                                                DooglamooWorldsMod.LOGGER.info("registering biome mapping failed: " + geo.getBiome() + " overlaps " + list.get(0).getBiome());
                                                continue;
                                            }
                                            list.clear();
                                            list.add(geo);
                                            continue;
                                        }
                                        if (geo.getType() == GeoFeature.Type.Block) {
                                            boolean skip = false;
                                            Iterator<GeoFeature> it = list.iterator();
                                            while (it.hasNext()) {
                                                GeoFeature feature = it.next();
                                                if (feature.getLevel() < geo.getLevel()) {
                                                    it.remove();
                                                    continue;
                                                }
                                                if (feature.getLevel() <= geo.getLevel()) continue;
                                                skip = true;
                                            }
                                            if (skip) continue;
                                            list.add(geo);
                                            continue;
                                        }
                                        list.add(geo);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    static {
        blocks = new HashMap<Integer, List<GeoFeature>>();
        features = new HashMap<Integer, List<GeoFeature>>();
        biomes = new HashMap<Integer, List<GeoFeature>>();
        ores = new HashMap<Integer, List<GeoFeature>>();
    }
}

