/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.dict;

import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public class GeoFeature {
    public static final int INDEX_ZERO = 0;
    public static final int INDEX_ONE = 1;
    public static final int INDEX_ELEVATION_LOW = 2;
    public static final int INDEX_DENSITY_LOW = 3;
    public static final int INDEX_UPLIFT_LOW = 4;
    public static final int INDEX_VOLCANISM_LOW = 5;
    public static final int INDEX_ERA_LOW = 6;
    public static final int INDEX_EROSION_LOW = 7;
    public static final int INDEX_TEMPERATURE_LOW = 8;
    public static final int INDEX_PRECIPITATION_LOW = 9;
    public static final int INDEX_ELEVATION_HIGH = 10;
    public static final int INDEX_DENSITY_HIGH = 11;
    public static final int INDEX_UPLIFT_HIGH = 12;
    public static final int INDEX_VOLCANISM_HIGH = 13;
    public static final int INDEX_ERA_HIGH = 14;
    public static final int INDEX_EROSION_HIGH = 15;
    public static final int INDEX_TEMPERATURE_HIGH = 16;
    public static final int INDEX_PRECIPITATION_HIGH = 17;
    public static final int INDEX_CRUST = 0;
    private Type type;
    public BlockState blockstate = null;
    private ConfiguredFeature<?> feature;
    public int spacing = 127;
    public Biome biome = Biomes.field_185440_P;
    public float[] rarity = new float[3];
    public int level;
    public int requirement;
    public int[] modifier = new int[2];
    private int minTemp = 0;
    private int maxTemp = 3;
    private int minPrecip = 0;
    private int maxPrecip = 3;
    private int minLift = 0;
    private int maxLift = 3;
    private int minErosion = 0;
    private int maxErosion = 3;
    private int minThermal = 0;
    private int maxThermal = 3;
    private int minAge = 0;
    private int maxAge = 3;
    private int minPlates = 0;
    private int maxPlates = 3;
    private int minRock = 0;
    private int maxRock = 3;

    public GeoFeature(BlockState blockType, int level) {
        this.blockstate = blockType;
        this.type = Type.Block;
        this.level = level;
    }

    public GeoFeature(BlockState blockType, int spacing, int depth) {
        this.blockstate = blockType;
        this.type = Type.OreBlock;
        this.spacing = spacing;
        this.level = depth == -1 ? 0 : Math.max(depth, 9);
    }

    public GeoFeature(ConfiguredFeature<?> feature, float occurance) {
        if (feature == null) {
            Thread.dumpStack();
        }
        this.feature = feature;
        this.rarity[0] = occurance;
        if (this.rarity[0] < 0.0f) {
            this.rarity[0] = 0.0f;
        } else if (this.rarity[0] > 1.0f) {
            this.rarity[0] = 1.0f;
        }
        this.type = Type.Feature;
    }

    public GeoFeature(Biome biome, int level) {
        this.biome = biome;
        this.level = level;
        this.type = Type.Biome;
    }

    public String toString() {
        switch (this.type) {
            case Block: {
                return "Block " + this.blockstate;
            }
            case OreBlock: {
                return "OreBlock " + this.blockstate + "," + this.spacing + "," + this.level + "," + this.requirement + "," + this.rarity[0] + "," + this.rarity[1] + "," + this.rarity[2] + "," + this.modifier[0] + "," + this.modifier[1] + "," + this.minRock + "," + this.maxRock;
            }
            case Feature: {
                return "Feature " + this.feature.getClass();
            }
            case Biome: {
                return "Biome " + this.biome.getRegistryName();
            }
        }
        return "Unknown material";
    }

    public Type getType() {
        return this.type;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public BlockState getBlockType() {
        return this.blockstate;
    }

    public float getRarity() {
        return this.rarity[0];
    }

    public ConfiguredFeature<?> getFeature() {
        return this.feature;
    }

    public int getLevel() {
        return this.level;
    }

    public void setMinTemperature(int temp) {
        this.minTemp = temp;
    }

    public void setMaxTemperature(int temp) {
        this.maxTemp = temp;
    }

    public void setMinPrecipitation(int percip) {
        this.minPrecip = percip;
    }

    public void setMaxPrecipitation(int percip) {
        this.maxPrecip = percip;
    }

    public void setMinUplift(int lift) {
        this.minLift = lift;
    }

    public void setMaxUplift(int lift) {
        this.maxLift = lift;
    }

    public void setMinErosion(int erosion) {
        this.minErosion = erosion;
    }

    public void setMaxErosion(int erosion) {
        this.maxErosion = erosion;
    }

    public void setMinVolcanism(int thermal) {
        this.minThermal = thermal;
    }

    public void setMaxVolcanism(int thermal) {
        this.maxThermal = thermal;
    }

    public void setMinEra(int age) {
        this.minAge = age;
    }

    public void setMaxEra(int age) {
        this.maxAge = age;
    }

    public void setMinElevation(int plates) {
        this.minPlates = plates;
    }

    public void setMaxElevation(int plates) {
        this.maxPlates = plates;
    }

    public void setMinDensity(int rock) {
        this.minRock = rock;
    }

    public void setMaxDensity(int rock) {
        this.maxRock = rock;
    }

    public int getMinTemperature() {
        return this.minTemp;
    }

    public int getMaxTemperature() {
        return this.maxTemp;
    }

    public int getMinPrecipitation() {
        return this.minPrecip;
    }

    public int getMaxPrecipitation() {
        return this.maxPrecip;
    }

    public int getMinUplift() {
        return this.minLift;
    }

    public int getMaxUplift() {
        return this.maxLift;
    }

    public int getMinErosion() {
        return this.minErosion;
    }

    public int getMaxErosion() {
        return this.maxErosion;
    }

    public int getMinVolcanism() {
        return this.minThermal;
    }

    public int getMaxVolcanism() {
        return this.maxThermal;
    }

    public int getMinEra() {
        return this.minAge;
    }

    public int getMaxEra() {
        return this.maxAge;
    }

    public int getMinElevation() {
        return this.minPlates;
    }

    public int getMaxElevation() {
        return this.maxPlates;
    }

    public int getMinDensity() {
        return this.minRock;
    }

    public int getMaxDensity() {
        return this.maxRock;
    }

    public static enum Type {
        Block,
        OreBlock,
        Feature,
        Biome;

    }
}

