/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.dict;

import com.dooglamoo.worlds.DooglamooWorldsMod;
import com.dooglamoo.worlds.dict.DictionaryFactory;
import com.dooglamoo.worlds.dict.GeoFeature;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class GeofeatureManager
extends JsonReloadListener {
    public static final Gson GSON = new GsonBuilder().create();

    public GeofeatureManager() {
        super(GSON, "geofeatures");
    }

    protected void apply(Map<ResourceLocation, JsonObject> splashList, IResourceManager resourceManager, IProfiler profiler) {
        DictionaryFactory.clear();
        int count = 0;
        for (Map.Entry<ResourceLocation, JsonObject> entry : splashList.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.func_110623_a().startsWith("_")) continue;
            try {
                String name = FilenameUtils.removeExtension((String)resourcelocation.func_110623_a()).replaceAll("\\\\", "/");
                GeoFeature geo = DictionaryFactory.getGeoFeature(name, entry.getValue());
                DictionaryFactory.register(geo);
                ++count;
            }
            catch (JsonParseException jsonparseexception) {
                DooglamooWorldsMod.LOGGER.error("Parsing error loading geofeature {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        DooglamooWorldsMod.LOGGER.info("Loaded {} geofeatures", (Object)count);
        DooglamooWorldsMod.LOGGER.info("{} biomes cover {}% of geofactors", (Object)DictionaryFactory.biomeCount, (Object)((int)((double)DictionaryFactory.biomes.size() / 65536.0 * 100.0)));
        DooglamooWorldsMod.LOGGER.info("{} blocks cover {}% of geofactors", (Object)DictionaryFactory.blockCount, (Object)((int)((double)DictionaryFactory.blocks.size() / 65536.0 * 100.0)));
        DooglamooWorldsMod.LOGGER.info("{} features cover {}% of geofactors", (Object)DictionaryFactory.featureCount, (Object)((int)((double)DictionaryFactory.features.size() / 65536.0 * 100.0)));
    }
}

