/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.biome.provider;

import com.dooglamoo.worlds.DooglamooConfig;
import com.dooglamoo.worlds.dict.DictionaryFactory;
import com.dooglamoo.worlds.dict.GeoFeature;
import com.dooglamoo.worlds.world.biome.provider.DooglamooBiomeProviderSettings;
import com.dooglamoo.worlds.world.gen.GeoData;
import com.dooglamoo.worlds.world.gen.NoiseGenerator;
import com.dooglamoo.worlds.world.gen.NoiseGeneratorPerlin;
import com.dooglamoo.worlds.world.gen.RiverRegion;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.feature.structure.Structure;

public class DooglamooBiomeProvider
extends BiomeProvider {
    public static final int TEMP_COLD = 0;
    public static final int TEMP_COOL = 16384;
    public static final int TEMP_WARM = 32768;
    public static final int TEMP_HOT = 49152;
    public static final int TEMP_MASK = 49152;
    public static final int PRECIP_DRY = 0;
    public static final int PRECIP_MOIST = 4096;
    public static final int PRECIP_HUMID = 8192;
    public static final int PRECIP_WET = 12288;
    public static final int PRECIP_MASK = 12288;
    public static final int LIFT_SUNK = 0;
    public static final int LIFT_LEVEL = 1024;
    public static final int LIFT_HILLS = 2048;
    public static final int LIFT_MOUNTAINS = 3072;
    public static final int LIFT_MASK = 3072;
    public static final int EROSION_NONE = 0;
    public static final int EROSION_SOME = 256;
    public static final int EROSION_MOST = 512;
    public static final int EROSION_FULL = 768;
    public static final int EROSION_MASK = 768;
    public static final int THERMAL_NONE = 0;
    public static final int THERMAL_SOME = 64;
    public static final int THERMAL_MOST = 128;
    public static final int THERMAL_FULL = 192;
    public static final int THERMAL_MASK = 192;
    public static final int AGE_YOUNGEST = 0;
    public static final int AGE_YOUNG = 16;
    public static final int AGE_OLD = 32;
    public static final int AGE_OLDEST = 48;
    public static final int AGE_MASK = 48;
    public static final int PLATES_OCEAN = 0;
    public static final int PLATES_SHALLOWS = 4;
    public static final int PLATES_PLAINS = 8;
    public static final int PLATES_PLATEAU = 12;
    public static final int PLATES_MASK = 12;
    public static final int ROCK_SEDIMENTARY = 0;
    public static final int ROCK_SOFT = 1;
    public static final int ROCK_HARD = 2;
    public static final int ROCK_IGNEOUS = 3;
    public static final int ROCK_MASK = 3;
    public final NoiseGenerator surfaceGen;
    public final NoiseGenerator elevationGen;
    public final NoiseGenerator densityGen;
    public final NoiseGenerator upliftGen;
    public final NoiseGenerator volcanismGen;
    public final NoiseGenerator eraGen;
    public final NoiseGenerator erosionGen;
    public final NoiseGenerator temperatureGen;
    public final NoiseGenerator precipitationGen;
    public final double elevationScale;
    public final double densityScale;
    public final double upliftScale;
    public final double volcanismScale;
    public final double eraScale;
    public final double erosionScale;
    public final double temperatureScale;
    public final double precipitationScale;
    public final double elevationAmplitude;
    public final double densityAmplitude;
    public final double upliftAmplitude;
    public final double volcanismAmplitude;
    public final double eraAmplitude;
    public final double erosionAmplitude;
    public final double temperatureAmplitude;
    public final double precipitationAmplitude;
    public final double elevationWeight;
    public final double densityWeight;
    public final double upliftWeight;
    public final double volcanismWeight;
    public final double eraWeight;
    public final double erosionWeight;
    public final double temperatureWeight;
    public final double precipitationWeight;
    private final double riverWiggleHi;
    private final double riverWiggleLo;
    private final double riverWidthSquared;
    private final double riverBank;
    private final double riverShore;
    private final double riverChannel;
    private final double riverShallow;
    public final int riverRegionHalfWidth;
    public final int riverRegionWidth;
    public final double xClimateFactor;
    public final double zClimateFactor;
    private final Random rand;
    private final DooglamooBiomeProviderSettings settings;
    protected final Map<Long, GeoData> geoDataCache = new ConcurrentHashMap<Long, GeoData>();
    protected final Map<Long, RiverRegion> riverRegionCache = new ConcurrentHashMap<Long, RiverRegion>();

    public DooglamooBiomeProvider(DooglamooBiomeProviderSettings settings) {
        this.settings = settings;
        this.elevationScale = MathHelper.func_151237_a((double)settings.getGeneratorSettings().elevationScale, (double)1.0, (double)3.0);
        this.densityScale = MathHelper.func_151237_a((double)settings.getGeneratorSettings().densityScale, (double)1.0, (double)3.0);
        this.upliftScale = MathHelper.func_151237_a((double)settings.getGeneratorSettings().upliftScale, (double)1.0, (double)3.0);
        this.volcanismScale = MathHelper.func_151237_a((double)settings.getGeneratorSettings().volcanismScale, (double)1.0, (double)3.0);
        this.eraScale = MathHelper.func_151237_a((double)settings.getGeneratorSettings().eraScale, (double)1.0, (double)3.0);
        this.erosionScale = MathHelper.func_151237_a((double)settings.getGeneratorSettings().erosionScale, (double)1.0, (double)3.0);
        this.temperatureScale = MathHelper.func_151237_a((double)settings.getGeneratorSettings().temperatureScale, (double)1.0, (double)3.0);
        this.precipitationScale = MathHelper.func_151237_a((double)settings.getGeneratorSettings().precipitationScale, (double)1.0, (double)3.0);
        this.rand = new Random(settings.getWorldInfo().func_76063_b());
        this.surfaceGen = new NoiseGeneratorPerlin(this.rand, 5).setScale(0.2);
        this.elevationGen = new NoiseGeneratorPerlin(this.rand, 5).setScale(1.6E-4 * (-4.0 * this.elevationScale + 13.0));
        this.densityGen = new NoiseGeneratorPerlin(this.rand, 2).setScale(6.0E-4 * (-4.0 * this.densityScale + 13.0));
        this.upliftGen = new NoiseGeneratorPerlin(this.rand, 6).setScale(0.004 * (-4.0 * this.upliftScale + 13.0));
        this.volcanismGen = new NoiseGeneratorPerlin(this.rand, 3).setScale(1.0E-4 * (-4.0 * this.volcanismScale + 13.0));
        this.eraGen = new NoiseGeneratorPerlin(this.rand, 4).setScale(5.0E-4 * (-4.0 * this.eraScale + 13.0));
        this.erosionGen = new NoiseGeneratorPerlin(this.rand, 5).setScale(0.006 * (-4.0 * this.erosionScale + 13.0));
        this.temperatureGen = new NoiseGeneratorPerlin(this.rand, 2).setScale(1.6E-4 * (-4.0 * this.temperatureScale + 13.0));
        this.precipitationGen = new NoiseGeneratorPerlin(this.rand, 2).setScale(1.6E-4 * (-4.0 * this.precipitationScale + 13.0));
        this.elevationWeight = MathHelper.func_151237_a((double)settings.getGeneratorSettings().elevationWeight, (double)-0.6, (double)0.6);
        this.densityWeight = MathHelper.func_151237_a((double)settings.getGeneratorSettings().densityWeight, (double)-0.6, (double)0.6);
        this.upliftWeight = MathHelper.func_151237_a((double)settings.getGeneratorSettings().upliftWeight, (double)-0.6, (double)0.6);
        this.volcanismWeight = MathHelper.func_151237_a((double)settings.getGeneratorSettings().volcanismWeight, (double)-0.6, (double)0.6);
        this.eraWeight = MathHelper.func_151237_a((double)settings.getGeneratorSettings().eraWeight, (double)-0.6, (double)0.6);
        this.erosionWeight = MathHelper.func_151237_a((double)settings.getGeneratorSettings().erosionWeight, (double)-0.6, (double)0.6);
        this.temperatureWeight = MathHelper.func_151237_a((double)settings.getGeneratorSettings().temperatureWeight, (double)-0.6, (double)0.6);
        this.precipitationWeight = MathHelper.func_151237_a((double)settings.getGeneratorSettings().precipitationWeight, (double)-0.6, (double)0.6);
        this.elevationAmplitude = MathHelper.func_151237_a((double)settings.getGeneratorSettings().elevationAmplitude, (double)0.0, (double)2.0);
        this.densityAmplitude = MathHelper.func_151237_a((double)settings.getGeneratorSettings().densityAmplitude, (double)0.0, (double)2.0);
        this.upliftAmplitude = MathHelper.func_151237_a((double)settings.getGeneratorSettings().upliftAmplitude, (double)0.0, (double)2.0);
        this.volcanismAmplitude = MathHelper.func_151237_a((double)settings.getGeneratorSettings().volcanismAmplitude, (double)0.0, (double)2.0);
        this.eraAmplitude = MathHelper.func_151237_a((double)settings.getGeneratorSettings().eraAmplitude, (double)0.0, (double)2.0);
        this.erosionAmplitude = MathHelper.func_151237_a((double)settings.getGeneratorSettings().erosionAmplitude, (double)0.0, (double)2.0);
        this.temperatureAmplitude = MathHelper.func_151237_a((double)settings.getGeneratorSettings().temperatureAmplitude, (double)0.0, (double)2.0);
        this.precipitationAmplitude = MathHelper.func_151237_a((double)settings.getGeneratorSettings().precipitationAmplitude, (double)0.0, (double)2.0);
        this.riverRegionHalfWidth = (int)(8192.0 * this.elevationScale) / 2;
        this.riverRegionWidth = this.riverRegionHalfWidth * 2;
        this.riverWiggleHi = 400.0 * this.elevationScale;
        this.riverWiggleLo = this.riverWiggleHi * 1.3;
        this.riverWidthSquared = Math.pow(256.0, 2.0) * this.elevationScale;
        this.riverBank = this.riverWidthSquared * 0.2;
        this.riverShore = this.riverWidthSquared - this.riverBank;
        this.riverChannel = this.riverBank * 0.2;
        this.riverShallow = this.riverBank - this.riverChannel;
        this.xClimateFactor = (Boolean)DooglamooConfig.GENERAL.swapEastWestPrecipitation.get() != false ? -1.875E-5 : 1.875E-5;
        this.zClimateFactor = (Boolean)DooglamooConfig.GENERAL.swapNorthSouthTemperature.get() != false ? -1.875E-5 : 1.875E-5;
    }

    public Biome func_201545_a(int x, int z) {
        return this.func_201537_a(x, z, 1, 1, false)[0];
    }

    public Biome[] func_201537_a(int x, int z, int width, int length, boolean cacheFlag) {
        Biome[] biomes = new Biome[width * length];
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            GeoData geoData = this.getGeoData(x, z);
            for (int n = 0; n < width; ++n) {
                for (int m = 0; m < length; ++m) {
                    int code = geoData.code[n][m];
                    int rockLevel = geoData.rockLevel[n][m];
                    int surfaceActualLevel = geoData.surfaceActualLevel[n][m];
                    int plate = code & 0xC;
                    int index = m * width + n;
                    if (!(!((Boolean)DooglamooConfig.GENERAL.customGenHellBiome.get()).booleanValue() || plate != 8 && plate != 12 || (code & 0xC0) != 192 || (code & 0x30) != 0 && (code & 0x30) != 16)) {
                        biomes[index] = Biomes.field_76778_j;
                        continue;
                    }
                    if (!(plate != 8 && plate != 12 || surfaceActualLevel >= 63 && surfaceActualLevel >= rockLevel - 1)) {
                        biomes[index] = Biomes.field_76781_i;
                        continue;
                    }
                    if ((plate == 0 || plate == 4) && surfaceActualLevel >= 62) {
                        if ((code & 0xC000) != 0) {
                            biomes[index] = Biomes.field_76787_r;
                            continue;
                        }
                        biomes[index] = Biomes.field_150577_O;
                        continue;
                    }
                    List<GeoFeature> biomeList = DictionaryFactory.biomes.get(code);
                    biomes[index] = biomeList == null || biomeList.isEmpty() ? Biomes.field_185440_P : biomeList.get(0).getBiome();
                }
            }
        } else {
            long riverKey = (long)Math.floorDiv(x + this.riverRegionHalfWidth, this.riverRegionWidth) & 0xFFFFFFFFL | ((long)Math.floorDiv(z + this.riverRegionHalfWidth, this.riverRegionWidth) & 0xFFFFFFFFL) << 32;
            RiverRegion riverRegion = this.riverRegionCache.get(riverKey);
            if (riverRegion == null) {
                int startX = Math.floorDiv(x + this.riverRegionHalfWidth, this.riverRegionWidth) * this.riverRegionWidth - this.riverRegionHalfWidth;
                int startZ = Math.floorDiv(z + this.riverRegionHalfWidth, this.riverRegionWidth) * this.riverRegionWidth - this.riverRegionHalfWidth;
                riverRegion = new RiverRegion(this.settings.getWorldInfo().func_76063_b() & riverKey, startX, startZ, this.riverRegionWidth, this.riverRegionWidth, 40, this.elevationGen, this.precipitationGen);
                if (this.riverRegionCache.size() > 4096) {
                    this.riverRegionCache.clear();
                }
                this.riverRegionCache.put(riverKey, riverRegion);
            }
            for (int n = 0; n < width; ++n) {
                int x1 = x + n;
                for (int m = 0; m < length; ++m) {
                    int mantle;
                    int surfaceElev;
                    double erosionFactor;
                    int z1 = z + m;
                    double surface = this.surfaceGen.noise(x1, z1);
                    double elevation = this.elevationGen.noise(x1, z1) * this.elevationAmplitude + this.elevationWeight;
                    double density = this.densityGen.noise(x1, z1) * this.densityAmplitude + this.densityWeight;
                    double uplift = this.upliftGen.noise(x1, z1) * this.upliftAmplitude + this.upliftWeight;
                    double volcanism = this.volcanismGen.noise(x1, z1) * this.volcanismAmplitude + this.volcanismWeight;
                    double era = this.eraGen.noise(x1, z1) * this.eraAmplitude + this.eraWeight;
                    double erosion = this.erosionGen.noise(x1, z1) * this.erosionAmplitude + this.erosionWeight;
                    double temperature = this.temperatureGen.noise(x1, z1) * this.temperatureAmplitude + MathHelper.func_151237_a((double)(this.temperatureWeight + (double)z1 * this.zClimateFactor), (double)-0.6, (double)0.6);
                    double precipitation = this.precipitationGen.noise(x1, z1) * this.precipitationAmplitude + MathHelper.func_151237_a((double)(this.precipitationWeight + (double)x1 * this.xClimateFactor), (double)-0.6, (double)0.6);
                    if (elevation > -0.2) {
                        double riverUplift = uplift;
                        for (int t = 0; t < riverRegion.rivers.size(); ++t) {
                            RiverRegion.River river = riverRegion.rivers.get(t);
                            double d = RiverRegion.distToSegmentSquared(x1, z1, river.vHi.field_72450_a + this.riverWiggleHi * precipitation, river.vHi.field_72449_c + this.riverWiggleHi * uplift, river.vLo.field_72450_a + this.riverWiggleLo * precipitation, river.vLo.field_72449_c + this.riverWiggleLo * uplift) + surface * 6400.0;
                            if (d < this.riverChannel) {
                                riverUplift = -0.8;
                                continue;
                            }
                            if (d < this.riverBank) {
                                riverUplift = Math.min((d - this.riverChannel) / this.riverShallow * 0.8 - 0.8, riverUplift);
                                continue;
                            }
                            if (!(d < this.riverWidthSquared)) continue;
                            riverUplift = Math.min((d - this.riverBank) / this.riverShore, riverUplift);
                        }
                        if (elevation < 0.0) {
                            riverUplift = MathHelper.func_219803_d((double)(-elevation * 5.0), (double)riverUplift, (double)uplift);
                        }
                        uplift = riverUplift;
                    }
                    double r = surface * 0.1 + (this.rand.nextDouble() * 0.1 - 0.05);
                    int code = 0;
                    code = elevation + surface * 0.008 < -0.5 ? (code |= 0) : (elevation + surface * 0.008 < 0.0 ? (code |= 4) : (elevation + surface * 0.008 < 0.5 ? (code |= 8) : (code |= 0xC)));
                    code = density + r < -0.5 ? (code |= 0) : (density + r < 0.0 ? (code |= 1) : (density + r < 0.5 ? (code |= 2) : (code |= 3)));
                    code = uplift + r < -0.5 ? (code |= 0) : (uplift + r < 0.0 ? (code |= 0x400) : (uplift + r < 0.5 ? (code |= 0x800) : (code |= 0xC00)));
                    code = volcanism + r < -0.5 ? (code |= 0) : (volcanism + r < 0.0 ? (code |= 0x40) : (volcanism + r < 0.5 ? (code |= 0x80) : (code |= 0xC0)));
                    code = era + r < -0.5 ? (code |= 0) : (era + r < 0.0 ? (code |= 0x10) : (era + r < 0.5 ? (code |= 0x20) : (code |= 0x30)));
                    code = erosion + r < -0.5 ? (code |= 0) : (erosion + r < 0.0 ? (code |= 0x100) : (erosion + r < 0.5 ? (code |= 0x200) : (code |= 0x300)));
                    code = temperature + r < -0.5 ? (code |= 0) : (temperature + r < 0.0 ? (code |= 0x4000) : (temperature + r < 0.5 ? (code |= 0x8000) : (code |= 0xC000)));
                    code = precipitation + r < -0.5 ? (code |= 0) : (precipitation + r < 0.0 ? (code |= 0x1000) : (precipitation + r < 0.5 ? (code |= 0x2000) : (code |= 0x3000)));
                    double surfaceDepthPlateFactor = Math.max(Math.min((elevation + 0.02) * 25.0, 1.0), 0.08);
                    int surfaceDepth = (int)(((surface + 1.0) * (uplift > -0.5 ? uplift + 0.5 : 0.0) * 6.0 + (era + 0.5) * 12.0) * surfaceDepthPlateFactor);
                    if (surfaceDepth < 1) {
                        surfaceDepth = 1;
                    }
                    if ((erosionFactor = surface * 2.0) > 0.0) {
                        erosionFactor = -erosionFactor;
                    }
                    if (erosionFactor > -0.1) {
                        erosionFactor = -0.1;
                    }
                    erosionFactor = 1.0 + erosionFactor;
                    int erosionDepth = density < -0.5 ? (erosion > 0.0 ? (int)(erosion * 50.0) : 0) : (density < 0.0 ? (erosion > 0.0 ? (int)(erosion * 40.0) : 0) : (density < 0.5 ? (erosion > 0.0 ? (int)(erosion * 32.0) : 0) : (erosion > 0.0 ? (int)(erosion * 26.0) : 0)));
                    int elevationInt = (int)((elevation + 1.0) / 2.0 * 128.0 + surface * 0.3);
                    double upliftFactor = (erosion < 0.0 && uplift > 0.1 && uplift <= 0.6 ? Math.min(Math.max((uplift - 0.1) * (-erosion * 6.0), uplift), 0.6) : uplift) * 128.0;
                    int elevationLevel = elevationInt + (int)(uplift > 0.0 ? upliftFactor * Math.min(surfaceDepthPlateFactor + (volcanism > 0.45 ? (volcanism - 0.45) * 4.5 : 0.0), 1.0) : 0.0);
                    int surfaceElevMod = surfaceElev = elevationLevel + surfaceDepth;
                    if (erosionFactor > 0.0) {
                        surfaceElevMod = (int)((double)surfaceElevMod - erosionFactor * (double)erosionDepth);
                    }
                    if (uplift < -0.5) {
                        surfaceElevMod = (int)((double)surfaceElevMod - (-uplift - 0.5) * 50.0);
                    }
                    if ((mantle = elevationLevel - (int)(200.0 - (volcanism > 0.0 ? volcanism * 256.0 : 0.0))) > elevationLevel) {
                        mantle = elevationLevel;
                    }
                    if (elevationLevel >= surfaceElevMod || uplift >= 0.5) {
                        elevationLevel = surfaceElevMod - 1;
                    }
                    int plate = code & 0xC;
                    int index = m * width + n;
                    if (!(!((Boolean)DooglamooConfig.GENERAL.customGenHellBiome.get()).booleanValue() || plate != 8 && plate != 12 || (code & 0xC0) != 192 || (code & 0x30) != 0 && (code & 0x30) != 16)) {
                        biomes[index] = Biomes.field_76778_j;
                        continue;
                    }
                    if (!(plate != 8 && plate != 12 || surfaceElevMod >= 63 && surfaceElevMod >= elevationInt - 1)) {
                        biomes[index] = Biomes.field_76781_i;
                        continue;
                    }
                    if ((plate == 0 || plate == 4) && surfaceElevMod >= 62) {
                        if ((code & 0xC000) != 0) {
                            biomes[index] = Biomes.field_76787_r;
                            continue;
                        }
                        biomes[index] = Biomes.field_150577_O;
                        continue;
                    }
                    List<GeoFeature> biomeList = DictionaryFactory.biomes.get(code);
                    biomes[index] = biomeList == null || biomeList.isEmpty() ? Biomes.field_185440_P : biomeList.get(0).getBiome();
                }
            }
        }
        return biomes;
    }

    public Set<Biome> func_201538_a(int centerX, int centerZ, int sideLength) {
        int i = centerX - sideLength >> 2;
        int j = centerZ - sideLength >> 2;
        int k = centerX + sideLength >> 2;
        int l = centerZ + sideLength >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        HashSet set = Sets.newHashSet();
        Collections.addAll(set, this.func_201537_a(i, j, i1, j1, false));
        return set;
    }

    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        Biome[] abiome = this.func_201537_a(i, j, i1, j1, false);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            if (!biomes.contains(abiome[l1])) continue;
            if (blockpos == null || random.nextInt(k1 + 1) == 0) {
                blockpos = new BlockPos(i2, 0, j2);
            }
            ++k1;
        }
        return blockpos;
    }

    public boolean func_205004_a(Structure<?> structureKey) {
        return this.field_205005_a.computeIfAbsent(structureKey, structure -> {
            for (Biome biome : DictionaryFactory.baseBiomes) {
                if (!biome.func_201858_a(structure)) continue;
                return true;
            }
            for (Biome biome : DictionaryFactory.addedBiomes) {
                if (!biome.func_201858_a(structure)) continue;
                return true;
            }
            return false;
        });
    }

    public Set<BlockState> func_205706_b() {
        if (this.field_205707_b.isEmpty()) {
            this.field_205707_b.add(Blocks.field_196658_i.func_176223_P());
            this.field_205707_b.add(Blocks.field_150346_d.func_176223_P());
            this.field_205707_b.add(Blocks.field_196660_k.func_176223_P());
            this.field_205707_b.add(Blocks.field_196661_l.func_176223_P());
            this.field_205707_b.add(Blocks.field_150354_m.func_176223_P());
        }
        return this.field_205707_b;
    }

    public GeoData getGeoData(int x, int z) {
        long key;
        GeoData cachegeofactors;
        long riverKey = (long)Math.floorDiv(x + this.riverRegionHalfWidth, this.riverRegionWidth) & 0xFFFFFFFFL | ((long)Math.floorDiv(z + this.riverRegionHalfWidth, this.riverRegionWidth) & 0xFFFFFFFFL) << 32;
        RiverRegion riverRegion = this.riverRegionCache.get(riverKey);
        if (riverRegion == null) {
            int startX = Math.floorDiv(x + this.riverRegionHalfWidth, this.riverRegionWidth) * this.riverRegionWidth - this.riverRegionHalfWidth;
            int startZ = Math.floorDiv(z + this.riverRegionHalfWidth, this.riverRegionWidth) * this.riverRegionWidth - this.riverRegionHalfWidth;
            riverRegion = new RiverRegion(this.settings.getWorldInfo().func_76063_b() & riverKey, startX, startZ, this.riverRegionWidth, this.riverRegionWidth, 40, this.elevationGen, this.precipitationGen);
            if (this.riverRegionCache.size() > 4096) {
                this.riverRegionCache.clear();
            }
            this.riverRegionCache.put(riverKey, riverRegion);
        }
        if ((cachegeofactors = this.geoDataCache.get(key = (long)(x >> 4) & 0xFFFFFFFFL | ((long)(z >> 4) & 0xFFFFFFFFL) << 32)) == null) {
            cachegeofactors = new GeoData();
            for (int n = 0; n < 16; ++n) {
                int x1 = x + n;
                for (int m = 0; m < 16; ++m) {
                    double erosionFactor;
                    int z1 = z + m;
                    double surface = this.surfaceGen.noise(x1, z1);
                    double elevation = this.elevationGen.noise(x1, z1) * this.elevationAmplitude + this.elevationWeight;
                    double density = this.densityGen.noise(x1, z1) * this.densityAmplitude + this.densityWeight;
                    double uplift = this.upliftGen.noise(x1, z1) * this.upliftAmplitude + this.upliftWeight;
                    double volcanism = this.volcanismGen.noise(x1, z1) * this.volcanismAmplitude + this.volcanismWeight;
                    double era = this.eraGen.noise(x1, z1) * this.eraAmplitude + this.eraWeight;
                    double erosion = this.erosionGen.noise(x1, z1) * this.erosionAmplitude + this.erosionWeight;
                    double temperature = this.temperatureGen.noise(x1, z1) * this.temperatureAmplitude + MathHelper.func_151237_a((double)(this.temperatureWeight + (double)z1 * this.zClimateFactor), (double)-0.6, (double)0.6);
                    double precipitation = this.precipitationGen.noise(x1, z1) * this.precipitationAmplitude + MathHelper.func_151237_a((double)(this.precipitationWeight + (double)x1 * this.xClimateFactor), (double)-0.6, (double)0.6);
                    if (elevation > -0.2) {
                        double riverUplift = uplift;
                        for (int t = 0; t < riverRegion.rivers.size(); ++t) {
                            RiverRegion.River river = riverRegion.rivers.get(t);
                            double d = RiverRegion.distToSegmentSquared(x1, z1, river.vHi.field_72450_a + this.riverWiggleHi * precipitation, river.vHi.field_72449_c + this.riverWiggleHi * uplift, river.vLo.field_72450_a + this.riverWiggleLo * precipitation, river.vLo.field_72449_c + this.riverWiggleLo * uplift) + surface * 6400.0;
                            if (d < this.riverChannel) {
                                riverUplift = -0.8;
                                continue;
                            }
                            if (d < this.riverBank) {
                                riverUplift = Math.min((d - this.riverChannel) / this.riverShallow * 0.8 - 0.8, riverUplift);
                                continue;
                            }
                            if (!(d < this.riverWidthSquared)) continue;
                            riverUplift = Math.min((d - this.riverBank) / this.riverShore, riverUplift);
                        }
                        if (elevation < 0.0) {
                            riverUplift = MathHelper.func_219803_d((double)(-elevation * 5.0), (double)riverUplift, (double)uplift);
                        }
                        uplift = riverUplift;
                    }
                    cachegeofactors.surface[n][m] = surface;
                    cachegeofactors.elevation[n][m] = elevation;
                    cachegeofactors.density[n][m] = density;
                    cachegeofactors.uplift[n][m] = uplift;
                    cachegeofactors.volcanism[n][m] = volcanism;
                    cachegeofactors.era[n][m] = era;
                    cachegeofactors.erosion[n][m] = erosion;
                    cachegeofactors.temperature[n][m] = temperature;
                    cachegeofactors.precipitation[n][m] = precipitation;
                    double r = surface * 0.1 + (this.rand.nextDouble() * 0.1 - 0.05);
                    int code = 0;
                    code = elevation + surface * 0.008 < -0.5 ? (code |= 0) : (elevation + surface * 0.008 < 0.0 ? (code |= 4) : (elevation + surface * 0.008 < 0.5 ? (code |= 8) : (code |= 0xC)));
                    code = density + r < -0.5 ? (code |= 0) : (density + r < 0.0 ? (code |= 1) : (density + r < 0.5 ? (code |= 2) : (code |= 3)));
                    code = uplift + r < -0.5 ? (code |= 0) : (uplift + r < 0.0 ? (code |= 0x400) : (uplift + r < 0.5 ? (code |= 0x800) : (code |= 0xC00)));
                    code = volcanism + r < -0.5 ? (code |= 0) : (volcanism + r < 0.0 ? (code |= 0x40) : (volcanism + r < 0.5 ? (code |= 0x80) : (code |= 0xC0)));
                    code = era + r < -0.5 ? (code |= 0) : (era + r < 0.0 ? (code |= 0x10) : (era + r < 0.5 ? (code |= 0x20) : (code |= 0x30)));
                    code = erosion + r < -0.5 ? (code |= 0) : (erosion + r < 0.0 ? (code |= 0x100) : (erosion + r < 0.5 ? (code |= 0x200) : (code |= 0x300)));
                    code = temperature + r < -0.5 ? (code |= 0) : (temperature + r < 0.0 ? (code |= 0x4000) : (temperature + r < 0.5 ? (code |= 0x8000) : (code |= 0xC000)));
                    code = precipitation + r < -0.5 ? (code |= 0) : (precipitation + r < 0.0 ? (code |= 0x1000) : (precipitation + r < 0.5 ? (code |= 0x2000) : (code |= 0x3000)));
                    cachegeofactors.code[n][m] = code;
                    double surfaceDepthPlateFactor = Math.max(Math.min((elevation + 0.02) * 25.0, 1.0), 0.08);
                    int surfaceDepth = (int)(((surface + 1.0) * (uplift > -0.5 ? uplift + 0.5 : 0.0) * 6.0 + (era + 0.5) * 12.0) * surfaceDepthPlateFactor);
                    if (surfaceDepth < 1) {
                        surfaceDepth = 1;
                    }
                    if ((erosionFactor = surface * 2.0) > 0.0) {
                        erosionFactor = -erosionFactor;
                    }
                    if (erosionFactor > -0.1) {
                        erosionFactor = -0.1;
                    }
                    erosionFactor = 1.0 + erosionFactor;
                    int erosionDepth = density < -0.5 ? (erosion > 0.0 ? (int)(erosion * 50.0) : 0) : (density < 0.0 ? (erosion > 0.0 ? (int)(erosion * 40.0) : 0) : (density < 0.5 ? (erosion > 0.0 ? (int)(erosion * 32.0) : 0) : (erosion > 0.0 ? (int)(erosion * 26.0) : 0)));
                    cachegeofactors.rockLevel[n][m] = (int)((elevation + 1.0) / 2.0 * 128.0 + surface * 0.3);
                    double upliftFactor = (erosion < 0.0 && uplift > 0.1 && uplift <= 0.6 ? Math.min(Math.max((uplift - 0.1) * (-erosion * 6.0), uplift), 0.6) : uplift) * 128.0;
                    cachegeofactors.upliftLevel[n][m] = cachegeofactors.rockLevel[n][m] + (int)(uplift > 0.0 ? upliftFactor * Math.min(surfaceDepthPlateFactor + (volcanism > 0.45 ? (volcanism - 0.45) * 4.5 : 0.0), 1.0) : 0.0);
                    cachegeofactors.surfaceVirtualLevel[n][m] = cachegeofactors.upliftLevel[n][m] + surfaceDepth;
                    cachegeofactors.surfaceActualLevel[n][m] = cachegeofactors.surfaceVirtualLevel[n][m];
                    if (erosionFactor > 0.0) {
                        int[] nArray = cachegeofactors.surfaceActualLevel[n];
                        int n2 = m;
                        nArray[n2] = (int)((double)nArray[n2] - erosionFactor * (double)erosionDepth);
                    }
                    if (uplift < -0.5) {
                        int[] nArray = cachegeofactors.surfaceActualLevel[n];
                        int n3 = m;
                        nArray[n3] = (int)((double)nArray[n3] - (-uplift - 0.5) * 50.0);
                    }
                    cachegeofactors.mantleLevel[n][m] = cachegeofactors.upliftLevel[n][m] - (int)(200.0 - (volcanism > 0.0 ? volcanism * 256.0 : 0.0));
                    if (cachegeofactors.mantleLevel[n][m] > cachegeofactors.upliftLevel[n][m]) {
                        cachegeofactors.mantleLevel[n][m] = cachegeofactors.upliftLevel[n][m];
                    }
                    if (cachegeofactors.upliftLevel[n][m] < cachegeofactors.surfaceActualLevel[n][m] && !(uplift >= 0.5)) continue;
                    cachegeofactors.upliftLevel[n][m] = cachegeofactors.surfaceActualLevel[n][m] - 1;
                }
            }
            if (this.geoDataCache.size() > 4096) {
                this.geoDataCache.clear();
            }
            this.geoDataCache.put(key, cachegeofactors);
        }
        return cachegeofactors;
    }
}

