/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.gen;

import com.dooglamoo.worlds.DooglamooConfig;
import com.dooglamoo.worlds.dict.DictionaryFactory;
import com.dooglamoo.worlds.dict.GeoFeature;
import com.dooglamoo.worlds.world.biome.provider.DooglamooBiomeProvider;
import com.dooglamoo.worlds.world.gen.DooglamooGenSettings;
import com.dooglamoo.worlds.world.gen.GeoData;
import com.dooglamoo.worlds.world.gen.feature.DooglamooFeatures;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.IcebergConfig;
import net.minecraft.world.gen.feature.LakesConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.BuriedTreasureConfig;
import net.minecraft.world.gen.feature.structure.BuriedTreasureStructure;
import net.minecraft.world.gen.feature.structure.DesertPyramidStructure;
import net.minecraft.world.gen.feature.structure.IglooStructure;
import net.minecraft.world.gen.feature.structure.JunglePyramidStructure;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.OceanMonumentStructure;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraft.world.gen.feature.structure.PillagerOutpostConfig;
import net.minecraft.world.gen.feature.structure.PillagerOutpostStructure;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.ShipwreckStructure;
import net.minecraft.world.gen.feature.structure.StrongholdStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.SwampHutStructure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.structure.VillageStructure;
import net.minecraft.world.gen.feature.structure.WoodlandMansionStructure;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.LakeChanceConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class DooglamooChunkGenerator
extends ChunkGenerator<DooglamooGenSettings> {
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    private static final BlockState MAGMA_BLOCK = Blocks.field_196814_hQ.func_176223_P();
    private static final BlockState OBSIDIAN = Blocks.field_150343_Z.func_176223_P();
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    private static final BlockState SAND = Blocks.field_150354_m.func_176223_P();
    private static final BlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    private static final BlockState COARSE_DIRT = Blocks.field_196660_k.func_176223_P();
    private static final BlockState DIRT = Blocks.field_150346_d.func_176223_P();
    private static final BlockState ANDESITE = Blocks.field_196656_g.func_176223_P();
    private static final BlockState GRANITE = Blocks.field_196650_c.func_176223_P();
    private static final BlockState DIORITE = Blocks.field_196654_e.func_176223_P();
    private static final BlockState PACKED_ICE = Blocks.field_150403_cj.func_176223_P();
    private static final BlockState ORANGE_TERRACOTTA = Blocks.field_196778_fp.func_176223_P();
    private static final BlockState RED_TERRACOTTA = Blocks.field_196721_fC.func_176223_P();
    private static final BlockState LIGHT_GRAY_TERRACOTTA = Blocks.field_196791_fw.func_176223_P();
    private static final BlockState BROWN_TERRACOTTA = Blocks.field_196719_fA.func_176223_P();
    private static final BlockState YELLOW_TERRACOTTA = Blocks.field_196783_fs.func_176223_P();
    private static final BlockState WHITE_TERRACOTTA = Blocks.field_196777_fo.func_176223_P();
    private static final BlockState TERRACOTTA = Blocks.field_150405_ch.func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    public final DooglamooBiomeProvider field_222542_c;
    private final ConfiguredFeature<?> oreFeature;
    private final ConfiguredFeature<?> packedicebergFeature;
    private final ConfiguredFeature<?> blueicebergFeature;
    private final ConfiguredFeature<?> lavaLakeFeature;
    private final PhantomSpawner phantomSpawner = new PhantomSpawner();
    private final PatrolSpawner patrolSpawner = new PatrolSpawner();
    private final CatSpawner catSpawner = new CatSpawner();
    private final VillageSiege villageSiege = new VillageSiege();

    public DooglamooChunkGenerator(IWorld world, DooglamooBiomeProvider biomeProvider, DooglamooGenSettings generationSettings) {
        super(world, (BiomeProvider)biomeProvider, (GenerationSettings)generationSettings);
        this.field_222542_c = biomeProvider;
        this.oreFeature = Biome.func_222280_a(DooglamooFeatures.ORE, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e);
        this.packedicebergFeature = Biome.func_222280_a((Feature)Feature.field_205172_ag, (IFeatureConfig)new IcebergConfig(Blocks.field_150403_cj.func_176223_P()), (Placement)Placement.field_215009_H, (IPlacementConfig)new ChanceConfig(16));
        this.blueicebergFeature = Biome.func_222280_a((Feature)Feature.field_205172_ag, (IFeatureConfig)new IcebergConfig(Blocks.field_205164_gk.func_176223_P()), (Placement)Placement.field_215009_H, (IPlacementConfig)new ChanceConfig(200));
        this.lavaLakeFeature = Biome.func_222280_a((Feature)Feature.field_202289_ai, (IFeatureConfig)new LakesConfig(Blocks.field_150353_l.func_176223_P()), (Placement)Placement.field_215005_D, (IPlacementConfig)new LakeChanceConfig(80));
    }

    public void func_222535_c(IChunk chunk) {
    }

    public int func_205470_d() {
        IChunk ichunk = this.field_222540_a.func_212866_a_(0, 0);
        return ichunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 8, 8);
    }

    public int func_222530_f() {
        return 63;
    }

    public void func_222537_b(IWorld world, IChunk chunk) {
        ChunkPos chunkpos = chunk.func_76632_l();
        int l = chunkpos.field_77276_a << 4;
        int i = chunkpos.field_77275_b << 4;
        ObjectArrayList objectlist = new ObjectArrayList(10);
        ObjectArrayList objectlist1 = new ObjectArrayList(32);
        for (Structure structure : Feature.field_214488_aQ) {
            String s = structure.func_143025_a();
            LongIterator longiterator = chunk.func_201578_b(s).iterator();
            while (longiterator.hasNext()) {
                long j1 = longiterator.nextLong();
                ChunkPos chunkpos1 = new ChunkPos(j1);
                IChunk ichunk = world.func_212866_a_(chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                StructureStart structurestart = ichunk.func_201585_a(s);
                if (structurestart == null || !structurestart.func_75069_d()) continue;
                for (StructurePiece structurepiece : structurestart.func_186161_c()) {
                    if (!structurepiece.func_214810_a(chunkpos, 12) || !(structurepiece instanceof AbstractVillagePiece)) continue;
                    AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece;
                    JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                    if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                        objectlist.add((Object)abstractvillagepiece);
                    }
                    for (JigsawJunction jigsawjunction : abstractvillagepiece.func_214829_e()) {
                        int k1 = jigsawjunction.func_214895_a();
                        int l1 = jigsawjunction.func_214893_c();
                        if (k1 <= l - 12 || l1 <= i - 12 || k1 >= l + 15 + 12 || l1 >= i + 15 + 12) continue;
                        objectlist1.add((Object)jigsawjunction);
                    }
                }
            }
        }
        ObjectListIterator objectlistiterator = objectlist.iterator();
        ObjectListIterator objectlistiterator1 = objectlist1.iterator();
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        ChunkPrimer chunkprimer = (ChunkPrimer)chunk;
        Heightmap heightmap = chunkprimer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkprimer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        GeoData geoData = this.field_222542_c.getGeoData(l, i);
        for (int n = 0; n < 16; ++n) {
            int x1 = l + n;
            for (int m = 0; m < 16; ++m) {
                int z1 = i + m;
                double surface = geoData.surface[n][m];
                double density = geoData.density[n][m];
                double uplift = geoData.uplift[n][m];
                double temperature = geoData.temperature[n][m];
                double precipitation = geoData.precipitation[n][m];
                int code = geoData.code[n][m];
                int mantle = geoData.mantleLevel[n][m];
                int rockLevel = geoData.rockLevel[n][m];
                int upliftLevel = geoData.upliftLevel[n][m];
                int surfaceActualLevel = geoData.surfaceActualLevel[n][m];
                int surfaceVirtualLevel = geoData.surfaceVirtualLevel[n][m];
                while (objectlistiterator.hasNext()) {
                    AbstractVillagePiece abstractvillagepiece1 = (AbstractVillagePiece)objectlistiterator.next();
                    MutableBoundingBox mutableboundingbox = abstractvillagepiece1.func_74874_b();
                    if (!mutableboundingbox.func_78885_a(x1, z1, x1, z1)) continue;
                    surfaceActualLevel = mutableboundingbox.field_78895_b + abstractvillagepiece1.func_214830_d() - 1;
                }
                objectlistiterator.back(objectlist.size());
                while (objectlistiterator1.hasNext()) {
                    JigsawJunction jigsawjunction1 = (JigsawJunction)objectlistiterator1.next();
                    if (jigsawjunction1.func_214895_a() != x1 || jigsawjunction1.func_214893_c() != z1) continue;
                    surfaceActualLevel = jigsawjunction1.func_214896_b() - 1;
                }
                objectlistiterator1.back(objectlist1.size());
                for (int y = 0; y < 256; ++y) {
                    BlockState blockstate = AIR;
                    if (y < 1) {
                        blockstate = BEDROCK;
                    } else if (y < 2 && surface > 0.0) {
                        blockstate = BEDROCK;
                    } else if (y <= mantle) {
                        if (y == mantle && y >= surfaceActualLevel && (y < this.func_222530_f() || y < rockLevel - 1)) {
                            if (sharedseedrandom.nextInt(6) == 0) {
                                chunkprimer.func_177436_a((BlockPos)blockpos.func_181079_c(n, y, m), MAGMA_BLOCK, false);
                                chunkprimer.func_205218_i_().func_205360_a((BlockPos)blockpos.func_181079_c(n, y, m), (Object)Blocks.field_196814_hQ, 0);
                                heightmap.func_202270_a(n, y, m, blockstate);
                                heightmap1.func_202270_a(n, y, m, blockstate);
                                continue;
                            }
                            blockstate = OBSIDIAN;
                        } else {
                            blockstate = MAGMA_BLOCK;
                        }
                    } else if (y <= upliftLevel) {
                        blockstate = density < -0.5 ? (y % 67 == 0 ? STONE : (y % 17 == 0 ? ORANGE_TERRACOTTA : (y % 15 == 0 ? RED_TERRACOTTA : (y % 11 == 0 ? LIGHT_GRAY_TERRACOTTA : (y % 9 == 0 ? BROWN_TERRACOTTA : (y % 19 == 0 ? YELLOW_TERRACOTTA : (y % 7 == 0 ? WHITE_TERRACOTTA : SANDSTONE))))))) : (density < 0.0 ? (y % 12 == 0 ? COARSE_DIRT : (y % 16 == 0 ? GRAVEL : (y % 71 == 0 ? ANDESITE : STONE))) : (density < 0.5 ? (y % 7 == 0 ? ANDESITE : (y % 35 == 0 ? STONE : GRANITE)) : (y % 17 == 0 ? OBSIDIAN : (y % 15 == 0 ? ANDESITE : (y % 9 == 0 ? GRANITE : DIORITE)))));
                        if ((y >= surfaceActualLevel - 1 && surfaceActualLevel - 1 <= this.func_222530_f() || y >= rockLevel && rockLevel <= this.func_222530_f()) && y == mantle + 1) {
                            blockstate = OBSIDIAN;
                        }
                    } else if (y <= surfaceActualLevel) {
                        if (y == surfaceActualLevel) {
                            BlockState below = chunkprimer.func_180495_p((BlockPos)blockpos.func_181079_c(x1, y - 1, z1));
                            if ((uplift < 0.5 || surface < 0.0) && y > 0 && below.func_185904_a() != Material.field_151579_a) {
                                List<GeoFeature> blockList = DictionaryFactory.blocks.get(code);
                                blockstate = y > 0 && (below.func_177230_c() == Blocks.field_150353_l || below.func_177230_c() == Blocks.field_196814_hQ) ? OBSIDIAN : (y < this.func_222530_f() ? (surface < -0.5 ? GRAVEL : SAND) : (blockList != null && !blockList.isEmpty() ? blockList.get(sharedseedrandom.nextInt(blockList.size())).getBlockType() : ((code & 0x3000) == 0 ? SAND : DIRT)));
                            } else if (y < this.func_222530_f()) {
                                blockstate = WATER;
                            }
                        } else if (y <= surfaceActualLevel - (surfaceVirtualLevel - upliftLevel) / 2) {
                            if (surfaceActualLevel - mantle >= 5 || !(surface < 0.0)) {
                                blockstate = uplift > 0.5 ? STONE : COARSE_DIRT;
                            }
                        } else if (surfaceActualLevel - mantle >= 5 || !(surface < 0.0)) {
                            blockstate = precipitation < -0.5 ? (temperature > 0.5 ? SAND : (temperature < -0.5 ? PACKED_ICE : (y % 13 == 0 ? RED_TERRACOTTA : (y % 15 == 0 ? BROWN_TERRACOTTA : (y % 17 == 0 ? YELLOW_TERRACOTTA : (y % 19 == 0 ? ORANGE_TERRACOTTA : TERRACOTTA)))))) : DIRT;
                        }
                    } else if ((double)y < (double)surfaceVirtualLevel + (Math.min(precipitation, 0.7) - 0.7) * 15.0 - Math.max(uplift, 0.0) * 25.0) {
                        if (temperature < -0.5) {
                            blockstate = PACKED_ICE;
                        } else if (y < this.func_222530_f() || y < rockLevel - 1) {
                            blockstate = WATER;
                        }
                    } else if (y < this.func_222530_f() || y < rockLevel - 1) {
                        blockstate = WATER;
                    }
                    if (blockstate.func_185904_a() == Material.field_151579_a) continue;
                    chunkprimer.func_177436_a((BlockPos)blockpos.func_181079_c(n, y, m), blockstate, false);
                    heightmap.func_202270_a(n, y, m, blockstate);
                    heightmap1.func_202270_a(n, y, m, blockstate);
                }
            }
        }
    }

    public int func_222529_a(int x, int z, Heightmap.Type type) {
        if (type == Heightmap.Type.WORLD_SURFACE_WG) {
            int n = Math.floorMod(x, 16);
            int m = Math.floorMod(z, 16);
            GeoData geoData = this.field_222542_c.getGeoData(x >> 4 << 4, z >> 4 << 4);
            int rockLevel = geoData.rockLevel[n][m];
            int surfaceActualLevel = geoData.surfaceActualLevel[n][m];
            if (surfaceActualLevel < this.func_222530_f()) {
                return this.func_222530_f();
            }
            if (surfaceActualLevel < rockLevel - 1) {
                return rockLevel - 1;
            }
            return surfaceActualLevel + 1;
        }
        return 0;
    }

    public <C extends IFeatureConfig> C func_202087_b(Biome biomeIn, Structure<C> structureIn) {
        IFeatureConfig c = super.func_202087_b(biomeIn, structureIn);
        if (c == null) {
            if (structureIn instanceof BuriedTreasureStructure) {
                return (C)new BuriedTreasureConfig(0.01f);
            }
            if (structureIn instanceof DesertPyramidStructure) {
                return (C)IFeatureConfig.field_202429_e;
            }
            if (structureIn instanceof IglooStructure) {
                return (C)IFeatureConfig.field_202429_e;
            }
            if (structureIn instanceof JunglePyramidStructure) {
                return (C)IFeatureConfig.field_202429_e;
            }
            if (structureIn instanceof MineshaftStructure) {
                return (C)new MineshaftConfig(0.004, MineshaftStructure.Type.NORMAL);
            }
            if (structureIn instanceof OceanMonumentStructure) {
                return (C)IFeatureConfig.field_202429_e;
            }
            if (structureIn instanceof OceanRuinStructure) {
                if (biomeIn.func_185353_n() < 0.2f) {
                    return (C)new OceanRuinConfig(OceanRuinStructure.Type.COLD, 0.3f, 0.9f);
                }
                return (C)new OceanRuinConfig(OceanRuinStructure.Type.WARM, 0.3f, 0.9f);
            }
            if (structureIn instanceof PillagerOutpostStructure) {
                return (C)new PillagerOutpostConfig(0.004);
            }
            if (structureIn instanceof ShipwreckStructure) {
                if (biomeIn.func_201856_r() == Biome.Category.OCEAN) {
                    return (C)new ShipwreckConfig(false);
                }
                return (C)new ShipwreckConfig(true);
            }
            if (structureIn instanceof StrongholdStructure) {
                return (C)IFeatureConfig.field_202429_e;
            }
            if (structureIn instanceof SwampHutStructure) {
                return (C)IFeatureConfig.field_202429_e;
            }
            if (structureIn instanceof VillageStructure) {
                return (C)new VillageConfig("village/plains/town_centers", 6);
            }
            if (structureIn instanceof WoodlandMansionStructure) {
                return (C)IFeatureConfig.field_202429_e;
            }
        }
        return (C)c;
    }

    public void func_202092_b(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        int k = i * 16;
        int l = j * 16;
        BlockPos blockpos = new BlockPos(k, 0, l);
        Biome biome = this.func_222527_a(region, blockpos.func_177982_a(8, 8, 8));
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        long i1 = sharedseedrandom.func_202424_a(region.func_72905_C(), k, l);
        if (DictionaryFactory.addedBiomes.contains(biome)) {
            GenerationStage.Decoration stage = null;
            try {
                stage = GenerationStage.Decoration.RAW_GENERATION;
                biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
                stage = GenerationStage.Decoration.LOCAL_MODIFICATIONS;
                biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
                stage = GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
                biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
                stage = GenerationStage.Decoration.SURFACE_STRUCTURES;
                biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
                stage = GenerationStage.Decoration.UNDERGROUND_ORES;
                if (((Boolean)DooglamooConfig.GENERAL.standardGenOres.get()).booleanValue()) {
                    biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
                }
                if (((Boolean)DooglamooConfig.GENERAL.customGenOres.get()).booleanValue()) {
                    this.oreFeature.func_222734_a((IWorld)region, (ChunkGenerator)this, (Random)sharedseedrandom, blockpos);
                }
                stage = GenerationStage.Decoration.UNDERGROUND_DECORATION;
                biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
                stage = GenerationStage.Decoration.VEGETAL_DECORATION;
                biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
                stage = GenerationStage.Decoration.TOP_LAYER_MODIFICATION;
                biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Biome decoration");
                crashreport.func_85058_a("Generation").func_71507_a("CenterX", (Object)i).func_71507_a("CenterZ", (Object)j).func_71507_a("Step", (Object)stage).func_71507_a("Seed", (Object)i1).func_71507_a("Biome", (Object)Registry.field_212624_m.func_177774_c((Object)biome));
                throw new ReportedException(crashreport);
            }
        }
        GeoData geoData = this.field_222542_c.getGeoData(k, l);
        double elevation = geoData.elevation[8][8];
        double volcanism = geoData.volcanism[8][8];
        double era = geoData.era[8][8];
        double temperature = geoData.temperature[8][8];
        int code = geoData.code[8][8];
        GenerationStage.Decoration stage = null;
        try {
            stage = GenerationStage.Decoration.LOCAL_MODIFICATIONS;
            if (elevation < -0.1 && temperature < -0.55) {
                this.packedicebergFeature.func_222734_a((IWorld)region, (ChunkGenerator)this, (Random)sharedseedrandom, blockpos);
                this.blueicebergFeature.func_222734_a((IWorld)region, (ChunkGenerator)this, (Random)sharedseedrandom, blockpos);
            }
            if (volcanism > 0.0) {
                this.lavaLakeFeature.func_222734_a((IWorld)region, (ChunkGenerator)this, (Random)sharedseedrandom, blockpos);
            }
            stage = GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
            biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
            stage = GenerationStage.Decoration.SURFACE_STRUCTURES;
            biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
            stage = GenerationStage.Decoration.UNDERGROUND_ORES;
            if (((Boolean)DooglamooConfig.GENERAL.standardGenOres.get()).booleanValue()) {
                biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
            }
            if (((Boolean)DooglamooConfig.GENERAL.customGenOres.get()).booleanValue()) {
                this.oreFeature.func_222734_a((IWorld)region, (ChunkGenerator)this, (Random)sharedseedrandom, blockpos);
            }
            stage = GenerationStage.Decoration.UNDERGROUND_DECORATION;
            biome.func_203608_a(stage, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Biome decoration");
            crashreport.func_85058_a("Generation").func_71507_a("CenterX", (Object)i).func_71507_a("CenterZ", (Object)j).func_71507_a("Step", (Object)stage).func_71507_a("Seed", (Object)i1).func_71507_a("Biome", (Object)Registry.field_212624_m.func_177774_c((Object)biome));
            throw new ReportedException(crashreport);
        }
        float occuranceMod = (((float)era + 1.0f) / 4.0f + 0.5f) * 64.0f;
        int t = 0;
        List<GeoFeature> featureList = DictionaryFactory.features.get(code);
        if (featureList != null && !featureList.isEmpty()) {
            if (featureList.size() > 1) {
                Collections.shuffle(featureList, (Random)sharedseedrandom);
            }
            for (GeoFeature geo : featureList) {
                if (!(sharedseedrandom.nextFloat() < geo.getRarity() * occuranceMod)) continue;
                sharedseedrandom.func_202426_b(i1, t, GenerationStage.Decoration.VEGETAL_DECORATION.ordinal());
                geo.getFeature().func_222734_a((IWorld)region, (ChunkGenerator)this, (Random)sharedseedrandom, blockpos);
                ++t;
            }
        }
        try {
            biome.func_203608_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, (ChunkGenerator)this, (IWorld)region, i1, sharedseedrandom, blockpos);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Biome decoration");
            crashreport.func_85058_a("Generation").func_71507_a("CenterX", (Object)i).func_71507_a("CenterZ", (Object)j).func_71507_a("Step", (Object)GenerationStage.Decoration.TOP_LAYER_MODIFICATION).func_71507_a("Seed", (Object)i1).func_71507_a("Biome", (Object)Registry.field_212624_m.func_177774_c((Object)biome));
            throw new ReportedException(crashreport);
        }
    }

    public void func_202093_c(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        Biome biome = region.func_212866_a_(i, j).func_201590_e()[0];
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202424_a(region.func_72905_C(), i << 4, j << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)i, (int)j, (Random)sharedseedrandom);
    }

    public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        this.phantomSpawner.func_203232_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.patrolSpawner.func_222696_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.catSpawner.func_221124_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.villageSiege.func_225477_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        if (Feature.field_202334_l.func_202383_b(this.field_222540_a, pos)) {
            if (creatureType == EntityClassification.MONSTER) {
                return Feature.field_202334_l.func_202279_e();
            }
            if (creatureType == EntityClassification.CREATURE) {
                return Feature.field_202334_l.func_214469_f();
            }
        } else if (creatureType == EntityClassification.MONSTER) {
            if (Feature.field_214536_b.func_175796_a(this.field_222540_a, pos)) {
                return Feature.field_214536_b.func_202279_e();
            }
            if (Feature.field_202336_n.func_175796_a(this.field_222540_a, pos)) {
                return Feature.field_202336_n.func_202279_e();
            }
        }
        return super.func_177458_a(creatureType, pos);
    }
}

