/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.gen;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DooglamooGenSettings
extends GenerationSettings {
    public double elevationScale = 2.0;
    public double densityScale = 2.0;
    public double upliftScale = 2.0;
    public double volcanismScale = 2.0;
    public double eraScale = 2.0;
    public double erosionScale = 2.0;
    public double temperatureScale = 2.0;
    public double precipitationScale = 2.0;
    public double elevationAmplitude = 1.0;
    public double densityAmplitude = 1.0;
    public double upliftAmplitude = 1.0;
    public double volcanismAmplitude = 1.0;
    public double eraAmplitude = 1.0;
    public double erosionAmplitude = 1.0;
    public double temperatureAmplitude = 1.0;
    public double precipitationAmplitude = 1.0;
    public double elevationWeight = 0.0;
    public double densityWeight = 0.0;
    public double upliftWeight = 0.0;
    public double volcanismWeight = 0.0;
    public double eraWeight = 0.0;
    public double erosionWeight = 0.0;
    public double temperatureWeight = 0.0;
    public double precipitationWeight = 0.0;

    @OnlyIn(value=Dist.CLIENT)
    public <T> Dynamic<T> buildSettings(DynamicOps<T> dyn) {
        ImmutableMap.Builder map = new ImmutableMap.Builder();
        map.put(dyn.createString("elevationScale"), dyn.createDouble(this.elevationScale));
        map.put(dyn.createString("densityScale"), dyn.createDouble(this.densityScale));
        map.put(dyn.createString("upliftScale"), dyn.createDouble(this.upliftScale));
        map.put(dyn.createString("volcanismScale"), dyn.createDouble(this.volcanismScale));
        map.put(dyn.createString("eraScale"), dyn.createDouble(this.eraScale));
        map.put(dyn.createString("erosionScale"), dyn.createDouble(this.erosionScale));
        map.put(dyn.createString("temperatureScale"), dyn.createDouble(this.temperatureScale));
        map.put(dyn.createString("precipitationScale"), dyn.createDouble(this.precipitationScale));
        map.put(dyn.createString("elevationAmplitude"), dyn.createDouble(this.elevationAmplitude));
        map.put(dyn.createString("densityAmplitude"), dyn.createDouble(this.densityAmplitude));
        map.put(dyn.createString("upliftAmplitude"), dyn.createDouble(this.upliftAmplitude));
        map.put(dyn.createString("volcanismAmplitude"), dyn.createDouble(this.volcanismAmplitude));
        map.put(dyn.createString("eraAmplitude"), dyn.createDouble(this.eraAmplitude));
        map.put(dyn.createString("erosionAmplitude"), dyn.createDouble(this.erosionAmplitude));
        map.put(dyn.createString("temperatureAmplitude"), dyn.createDouble(this.temperatureAmplitude));
        map.put(dyn.createString("precipitationAmplitude"), dyn.createDouble(this.precipitationAmplitude));
        map.put(dyn.createString("elevationWeight"), dyn.createDouble(this.elevationWeight));
        map.put(dyn.createString("densityWeight"), dyn.createDouble(this.densityWeight));
        map.put(dyn.createString("upliftWeight"), dyn.createDouble(this.upliftWeight));
        map.put(dyn.createString("volcanismWeight"), dyn.createDouble(this.volcanismWeight));
        map.put(dyn.createString("eraWeight"), dyn.createDouble(this.eraWeight));
        map.put(dyn.createString("erosionWeight"), dyn.createDouble(this.erosionWeight));
        map.put(dyn.createString("temperatureWeight"), dyn.createDouble(this.temperatureWeight));
        map.put(dyn.createString("precipitationWeight"), dyn.createDouble(this.precipitationWeight));
        return new Dynamic(dyn, dyn.createMap((Map)map.build()));
    }

    public static DooglamooGenSettings createDooglamooGenerator(Dynamic<?> dyn) {
        DooglamooGenSettings settings = new DooglamooGenSettings();
        settings.elevationScale = dyn.get("elevationScale").asDouble(settings.elevationScale);
        settings.densityScale = dyn.get("densityScale").asDouble(settings.densityScale);
        settings.upliftScale = dyn.get("upliftScale").asDouble(settings.upliftScale);
        settings.volcanismScale = dyn.get("volcanismScale").asDouble(settings.volcanismScale);
        settings.eraScale = dyn.get("eraScale").asDouble(settings.eraScale);
        settings.erosionScale = dyn.get("erosionScale").asDouble(settings.erosionScale);
        settings.temperatureScale = dyn.get("temperatureScale").asDouble(settings.temperatureScale);
        settings.precipitationScale = dyn.get("precipitationScale").asDouble(settings.precipitationScale);
        settings.elevationAmplitude = dyn.get("elevationAmplitude").asDouble(settings.elevationAmplitude);
        settings.densityAmplitude = dyn.get("densityAmplitude").asDouble(settings.densityAmplitude);
        settings.upliftAmplitude = dyn.get("upliftAmplitude").asDouble(settings.upliftAmplitude);
        settings.volcanismAmplitude = dyn.get("volcanismAmplitude").asDouble(settings.volcanismAmplitude);
        settings.eraAmplitude = dyn.get("eraAmplitude").asDouble(settings.eraAmplitude);
        settings.erosionAmplitude = dyn.get("erosionAmplitude").asDouble(settings.erosionAmplitude);
        settings.temperatureAmplitude = dyn.get("temperatureAmplitude").asDouble(settings.temperatureAmplitude);
        settings.precipitationAmplitude = dyn.get("precipitationAmplitude").asDouble(settings.precipitationAmplitude);
        settings.elevationWeight = dyn.get("elevationWeight").asDouble(settings.elevationWeight);
        settings.densityWeight = dyn.get("densityWeight").asDouble(settings.densityWeight);
        settings.upliftWeight = dyn.get("upliftWeight").asDouble(settings.upliftWeight);
        settings.volcanismWeight = dyn.get("volcanismWeight").asDouble(settings.volcanismWeight);
        settings.eraWeight = dyn.get("eraWeight").asDouble(settings.eraWeight);
        settings.erosionWeight = dyn.get("erosionWeight").asDouble(settings.erosionWeight);
        settings.temperatureWeight = dyn.get("temperatureWeight").asDouble(settings.temperatureWeight);
        settings.precipitationWeight = dyn.get("precipitationWeight").asDouble(settings.precipitationWeight);
        return settings;
    }

    public static DooglamooGenSettings getDefaultDooglamooGenerator() {
        return new DooglamooGenSettings();
    }
}

