/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.gen;

import com.dooglamoo.worlds.world.gen.NoiseGenerator;
import java.awt.image.BufferedImage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.minecraft.util.math.Vec3d;

public class NoiseGeneratorHeightMap
implements NoiseGenerator {
    private byte[][] imgData;
    private double imgWidth;
    private double imgHeight;
    private double maxX;
    private double maxY;
    private double centerX;
    private double centerY;
    private double scale = 1.0;
    private NoiseGenerator noise;
    private double noiseFactor;
    private double noiseFactorInverse;

    public NoiseGeneratorHeightMap(Path file, NoiseGenerator noise, double noiseFactor) {
        this.noise = noise;
        if (noiseFactor < 0.0) {
            noiseFactor = 0.0;
        } else if (noiseFactor > 1.0) {
            noiseFactor = 1.0;
        }
        this.noiseFactor = noiseFactor;
        this.noiseFactorInverse = 1.0 - noiseFactor;
        if (file != null && Files.exists(file, new LinkOption[0])) {
            try {
                BufferedImage img = ImageIO.read(file.toFile());
                this.imgData = new byte[img.getWidth()][img.getHeight()];
                for (int w = 0; w < img.getWidth(); ++w) {
                    for (int h = 0; h < img.getHeight(); ++h) {
                        this.imgData[w][h] = (byte)img.getRGB(w, h);
                    }
                }
                this.imgWidth = img.getWidth();
                this.imgHeight = img.getHeight();
                this.maxX = this.imgWidth - 1.0;
                this.maxY = this.imgHeight - 1.0;
                this.centerX = (double)img.getWidth() / 2.0;
                this.centerY = (double)img.getHeight() / 2.0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public NoiseGeneratorHeightMap setScale(double scale) {
        this.scale = scale;
        this.imgWidth /= scale;
        this.imgHeight /= scale;
        this.maxX = this.imgWidth - 1.0;
        this.maxY = this.imgHeight - 1.0;
        return this;
    }

    public NoiseGeneratorHeightMap setCenter(Vec3d pos) {
        if (pos != null) {
            this.centerX = pos.field_72450_a;
            this.centerY = pos.field_72449_c;
        }
        return this;
    }

    @Override
    public double noise(double x, double y) {
        x += this.centerX / this.scale;
        y += this.centerY / this.scale;
        if (this.imgData == null || x < 0.0 || x >= this.imgWidth || y < 0.0 || y >= this.imgHeight) {
            return 0.0;
        }
        double n = this.noise != null ? this.noise.noise(x, y) * this.noiseFactor : 0.0;
        double xfyf = this.imgData[(int)Math.floor(x *= this.scale)][(int)Math.floor(y *= this.scale)] & 0xFF;
        double xcyf = this.imgData[(int)Math.min(Math.ceil(x), this.maxX)][(int)Math.floor(y)] & 0xFF;
        double xcyc = this.imgData[(int)Math.min(Math.ceil(x), this.maxX)][(int)Math.min(Math.ceil(y), this.maxY)] & 0xFF;
        double xfyc = this.imgData[(int)Math.floor(x)][(int)Math.min(Math.ceil(y), this.maxY)] & 0xFF;
        double xt = this.lerp(xfyf, xcyf, x - Math.floor(x));
        double xb = this.lerp(xfyc, xcyc, x - Math.floor(x));
        double ym = this.lerp(xt, xb, y - Math.floor(y));
        return this.noise != null ? (ym - 1.0) * this.noiseFactorInverse + n : (ym /= 127.0) - 1.0;
    }

    private final double lerp(double v0, double v1, double t) {
        return (1.0 - t) * v0 + t * v1;
    }
}

