/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.gen;

import java.util.Random;

public class NoiseGeneratorImproved {
    private int[] perm = new int[512];
    public double xCoord;
    public double yCoord;
    public double zCoord;
    private static final double[] field_152381_e = new double[]{1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0};
    private static final double[] field_152382_f = new double[]{1.0, 1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0};
    private static final double[] field_152383_g = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, -1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 0.0, 1.0, 0.0, -1.0};
    private static final double[] field_152384_h = new double[]{1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0};
    private static final double[] field_152385_i = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, -1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 0.0, 1.0, 0.0, -1.0};

    public NoiseGeneratorImproved() {
        this(new Random());
    }

    public NoiseGeneratorImproved(Random rand) {
        this.xCoord = rand.nextDouble() * 256.0;
        this.yCoord = rand.nextDouble() * 256.0;
        this.zCoord = rand.nextDouble() * 256.0;
        int i = 0;
        while (i < 256) {
            this.perm[i] = i++;
        }
        for (i = 0; i < 256; ++i) {
            int j = rand.nextInt(256 - i) + i;
            int k = this.perm[i];
            this.perm[i] = this.perm[j];
            this.perm[j] = k;
            this.perm[i + 256] = this.perm[i];
        }
    }

    public final double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    public final double grad(int hash, double x, double y) {
        int h = hash & 0xF;
        return field_152384_h[h] * x + field_152385_i[h] * y;
    }

    public final double grad(int hash, double x, double y, double z) {
        int h = hash & 0xF;
        return field_152381_e[h] * x + field_152382_f[h] * y + field_152383_g[h] * z;
    }

    public void populateNoiseArray(double[] noiseArray, double xOffset, double yOffset, double zOffset, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double noiseScale) {
        if (ySize == 1) {
            double d21 = 0.0;
            double d22 = 0.0;
            int BA = 0;
            double noiseScaleInverse = 1.0 / noiseScale;
            for (int xi = 0; xi < xSize; ++xi) {
                double d9 = xOffset + (double)xi * xScale + this.xCoord;
                int floorZ = (int)d9;
                if (d9 < (double)floorZ) {
                    --floorZ;
                }
                int k1 = floorZ & 0xFF;
                double d11 = (d9 -= (double)floorZ) * d9 * d9 * (d9 * (d9 * 6.0 - 15.0) + 10.0);
                for (int zi = 0; zi < zSize; ++zi) {
                    int index;
                    double x = zOffset + (double)zi * zScale + this.zCoord;
                    int floorX = (int)x;
                    if (x < (double)floorX) {
                        --floorX;
                    }
                    int X = floorX & 0xFF;
                    double u = (x -= (double)floorX) * x * x * (x * (x * 6.0 - 15.0) + 10.0);
                    int l = this.perm[k1] + 0;
                    int i4 = this.perm[l] + X;
                    int j4 = this.perm[k1 + 1] + 0;
                    int i1 = this.perm[j4] + X;
                    d21 = this.lerp(d11, this.grad(this.perm[i4], d9, x), this.grad(this.perm[i1], d9 - 1.0, 0.0, x));
                    d22 = this.lerp(d11, this.grad(this.perm[i4 + 1], d9, 0.0, x - 1.0), this.grad(this.perm[i1 + 1], d9 - 1.0, 0.0, x - 1.0));
                    double d24 = this.lerp(u, d21, d22);
                    int n = index = BA++;
                    noiseArray[n] = noiseArray[n] + d24 * noiseScaleInverse;
                }
            }
        } else {
            int l = 0;
            double noiseScaleInverse = 1.0 / noiseScale;
            int i1 = -1;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            for (int zi = 0; zi < xSize; ++zi) {
                double x = xOffset + (double)zi * xScale + this.xCoord;
                int floorX = (int)x;
                if (x < (double)floorX) {
                    --floorX;
                }
                int X = floorX & 0xFF;
                double u = (x -= (double)floorX) * x * x * (x * (x * 6.0 - 15.0) + 10.0);
                for (int xi = 0; xi < zSize; ++xi) {
                    double z = zOffset + (double)xi * zScale + this.zCoord;
                    int floorZ = (int)z;
                    if (z < (double)floorZ) {
                        --floorZ;
                    }
                    int Z = floorZ & 0xFF;
                    double w = (z -= (double)floorZ) * z * z * (z * (z * 6.0 - 15.0) + 10.0);
                    for (int yi = 0; yi < ySize; ++yi) {
                        int index;
                        double y = yOffset + (double)yi * yScale + this.yCoord;
                        int floorY = (int)y;
                        if (y < (double)floorY) {
                            --floorY;
                        }
                        int Y = floorY & 0xFF;
                        double v = (y -= (double)floorY) * y * y * (y * (y * 6.0 - 15.0) + 10.0);
                        if (yi == 0 || Y != i1) {
                            i1 = Y;
                            int A = this.perm[X] + Y;
                            int AA = this.perm[A] + Z;
                            int AB = this.perm[A + 1] + Z;
                            int B = this.perm[X + 1] + Y;
                            int BA = this.perm[B] + Z;
                            int BB = this.perm[B + 1] + Z;
                            d8 = this.lerp(u, this.grad(this.perm[AA], x, y, z), this.grad(this.perm[BA], x - 1.0, y, z));
                            d9 = this.lerp(u, this.grad(this.perm[AB], x, y - 1.0, z), this.grad(this.perm[BB], x - 1.0, y - 1.0, z));
                            d10 = this.lerp(u, this.grad(this.perm[AA + 1], x, y, z - 1.0), this.grad(this.perm[BA + 1], x - 1.0, y, z - 1.0));
                            d11 = this.lerp(u, this.grad(this.perm[AB + 1], x, y - 1.0, z - 1.0), this.grad(this.perm[BB + 1], x - 1.0, y - 1.0, z - 1.0));
                        }
                        double d18 = this.lerp(v, d8, d9);
                        double d19 = this.lerp(v, d10, d11);
                        double d20 = this.lerp(w, d18, d19);
                        int n = index = l++;
                        noiseArray[n] = noiseArray[n] + d20 * noiseScaleInverse;
                    }
                }
            }
        }
    }
}

