/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.gen;

import com.dooglamoo.worlds.world.gen.NoiseGenerator;
import java.util.Random;

public class NoiseGeneratorSimplex
implements NoiseGenerator {
    private static int[][] grad3 = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}};
    public static final double SQRT3 = Math.sqrt(3.0);
    private int[] perm = new int[512];
    public double xCoord = 0.0;
    public double yCoord = 0.0;
    public double zCoord = 0.0;
    private static final double F2 = 0.5 * (SQRT3 - 1.0);
    private static final double G2 = (3.0 - SQRT3) / 6.0;

    public NoiseGeneratorSimplex() {
        this(new Random());
    }

    public NoiseGeneratorSimplex(Random rand) {
        int i = 0;
        while (i < 256) {
            this.perm[i] = i++;
        }
        for (i = 0; i < 256; ++i) {
            int j = rand.nextInt(256 - i) + i;
            int k = this.perm[i];
            this.perm[i] = this.perm[j];
            this.perm[j] = k;
            this.perm[i + 256] = this.perm[i];
        }
    }

    private static int fastFloor(double x) {
        return x > 0.0 ? (int)x : (int)x - 1;
    }

    private static double dot(int[] grad, double x, double y) {
        return (double)grad[0] * x + (double)grad[1] * y;
    }

    @Override
    public double noise(double x, double y) {
        double n2;
        double n1;
        double n0;
        int j1;
        int i1;
        double Y0;
        double y0;
        double _G2;
        int j;
        double t;
        double _F2 = 0.5 * (SQRT3 - 1.0);
        double s = (x + y) * _F2;
        int i = NoiseGeneratorSimplex.fastFloor(x + s);
        double X0 = (double)i - (t = (double)(i + (j = NoiseGeneratorSimplex.fastFloor(y + s))) * (_G2 = (3.0 - SQRT3) / 6.0));
        double x0 = x - X0;
        if (x0 > (y0 = y - (Y0 = (double)j - t))) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        double x1 = x0 - (double)i1 + _G2;
        double y1 = y0 - (double)j1 + _G2;
        double x2 = x0 - 1.0 + 2.0 * _G2;
        double y2 = y0 - 1.0 + 2.0 * _G2;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        int gi0 = this.perm[ii + this.perm[jj]] % 12;
        int gi1 = this.perm[ii + i1 + this.perm[jj + j1]] % 12;
        int gi2 = this.perm[ii + 1 + this.perm[jj + 1]] % 12;
        double t0 = 0.5 - x0 * x0 - y0 * y0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * NoiseGeneratorSimplex.dot(grad3[gi0], x0, y0);
        }
        double t1 = 0.5 - x1 * x1 - y1 * y1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * NoiseGeneratorSimplex.dot(grad3[gi1], x1, y1);
        }
        double t2 = 0.5 - x2 * x2 - y2 * y2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * NoiseGeneratorSimplex.dot(grad3[gi2], x2, y2);
        }
        return 70.0 * (n0 + n1 + n2);
    }

    public void noise(double[] noiseArray, double xIn, double yIn, int xSize, int ySize, double xScale, double yScale, double noiseScale) {
        int k = 0;
        for (int iy = 0; iy < ySize; ++iy) {
            double y = (yIn + (double)iy) * yScale + this.yCoord;
            for (int ix = 0; ix < xSize; ++ix) {
                int i3;
                double n2;
                double n1;
                double n0;
                int j1;
                int i1;
                double Y0;
                double y0;
                int j;
                double t;
                double x = (xIn + (double)ix) * xScale + this.xCoord;
                double s = (x + y) * F2;
                int i = NoiseGeneratorSimplex.fastFloor(x + s);
                double X0 = (double)i - (t = (double)(i + (j = NoiseGeneratorSimplex.fastFloor(y + s))) * G2);
                double x0 = x - X0;
                if (x0 > (y0 = y - (Y0 = (double)j - t))) {
                    i1 = 1;
                    j1 = 0;
                } else {
                    i1 = 0;
                    j1 = 1;
                }
                double x1 = x0 - (double)i1 + G2;
                double y1 = y0 - (double)j1 + G2;
                double x2 = x0 - 1.0 + 2.0 * G2;
                double y2 = y0 - 1.0 + 2.0 * G2;
                int ii = i & 0xFF;
                int jj = j & 0xFF;
                int gi0 = this.perm[ii + this.perm[jj]] % 12;
                int gi1 = this.perm[ii + i1 + this.perm[jj + j1]] % 12;
                int gi2 = this.perm[ii + 1 + this.perm[jj + 1]] % 12;
                double t0 = 0.5 - x0 * x0 - y0 * y0;
                if (t0 < 0.0) {
                    n0 = 0.0;
                } else {
                    t0 *= t0;
                    n0 = t0 * t0 * NoiseGeneratorSimplex.dot(grad3[gi0], x0, y0);
                }
                double t1 = 0.5 - x1 * x1 - y1 * y1;
                if (t1 < 0.0) {
                    n1 = 0.0;
                } else {
                    t1 *= t1;
                    n1 = t1 * t1 * NoiseGeneratorSimplex.dot(grad3[gi1], x1, y1);
                }
                double t2 = 0.5 - x2 * x2 - y2 * y2;
                if (t2 < 0.0) {
                    n2 = 0.0;
                } else {
                    t2 *= t2;
                    n2 = t2 * t2 * NoiseGeneratorSimplex.dot(grad3[gi2], x2, y2);
                }
                int n = i3 = k++;
                noiseArray[n] = noiseArray[n] + 70.0 * (n0 + n1 + n2) * noiseScale;
            }
        }
    }
}

