/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.gen.feature;

import com.dooglamoo.worlds.dict.DictionaryFactory;
import com.dooglamoo.worlds.dict.GeoFeature;
import com.dooglamoo.worlds.world.gen.DooglamooChunkGenerator;
import com.dooglamoo.worlds.world.gen.GeoData;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class DooglamooOreFeature
extends Feature<NoFeatureConfig> {
    public double[] factors = new double[18];
    public int[] levels = new int[9];
    public List<GeoFeature> density0;
    public List<GeoFeature> density1;
    public List<GeoFeature> density2;
    public List<GeoFeature> density3;

    public DooglamooOreFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserializer) {
        super(deserializer);
        this.factors[0] = 0.0;
        this.factors[1] = 1.0;
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!(generator instanceof DooglamooChunkGenerator)) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        DooglamooChunkGenerator gen = (DooglamooChunkGenerator)generator;
        GeoData geoData = gen.field_222542_c.getGeoData(pos.func_177958_n(), pos.func_177952_p());
        this.density0 = DictionaryFactory.ores.get(0);
        if (this.density0 == null) {
            this.density0 = new ArrayList<GeoFeature>();
        }
        this.density1 = DictionaryFactory.ores.get(1);
        if (this.density1 == null) {
            this.density1 = new ArrayList<GeoFeature>();
        }
        this.density2 = DictionaryFactory.ores.get(2);
        if (this.density2 == null) {
            this.density2 = new ArrayList<GeoFeature>();
        }
        this.density3 = DictionaryFactory.ores.get(3);
        if (this.density3 == null) {
            this.density3 = new ArrayList<GeoFeature>();
        }
        for (int n = 0; n < 16; ++n) {
            int x1 = pos.func_177958_n() + n;
            for (int m = 0; m < 16; ++m) {
                int z1 = pos.func_177952_p() + m;
                double elevation = geoData.elevation[n][m];
                double density = geoData.density[n][m];
                double uplift = geoData.uplift[n][m];
                double volcanism = geoData.volcanism[n][m];
                double era = geoData.era[n][m];
                double erosion = geoData.erosion[n][m];
                double temperature = geoData.temperature[n][m];
                double precipitation = geoData.precipitation[n][m];
                this.factors[2] = elevation < 0.0 ? -elevation : 0.0;
                this.factors[3] = density < 0.0 ? -density : 0.0;
                this.factors[4] = uplift < 0.0 ? -uplift : 0.0;
                this.factors[5] = volcanism < 0.0 ? -volcanism : 0.0;
                this.factors[6] = era < 0.0 ? -era : 0.0;
                this.factors[7] = erosion < 0.0 ? -erosion : 0.0;
                this.factors[8] = temperature < 0.0 ? -temperature : 0.0;
                this.factors[9] = precipitation < 0.0 ? -precipitation : 0.0;
                this.factors[10] = elevation > 0.0 ? elevation : 0.0;
                this.factors[11] = density > 0.0 ? density : 0.0;
                this.factors[12] = uplift > 0.0 ? uplift : 0.0;
                this.factors[13] = volcanism > 0.0 ? volcanism : 0.0;
                this.factors[14] = era > 0.0 ? era : 0.0;
                this.factors[15] = erosion > 0.0 ? erosion : 0.0;
                this.factors[16] = temperature > 0.0 ? temperature : 0.0;
                this.factors[17] = precipitation > 0.0 ? precipitation : 0.0;
                int upliftLevel = geoData.upliftLevel[n][m];
                for (int y = 0; y < 256; ++y) {
                    BlockState currentstate = world.func_180495_p((BlockPos)blockpos.func_181079_c(x1, y, z1));
                    if (currentstate.func_185904_a() != Material.field_151576_e || currentstate.func_177230_c() == Blocks.field_150357_h || currentstate.func_177230_c() == Blocks.field_196814_hQ) continue;
                    BlockState blockstate = Blocks.field_150350_a.func_176223_P();
                    if (y <= upliftLevel) {
                        GeoFeature ore;
                        int i;
                        if (density < -0.5) {
                            for (i = 0; i < this.density0.size(); ++i) {
                                ore = this.density0.get(i);
                                if (y % ore.spacing == 0) {
                                    if ((double)ore.rarity[0] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.0) || !((double)rand.nextFloat() < (double)ore.rarity[0] + this.factors[ore.modifier[0]] * (double)ore.rarity[0] + this.factors[ore.modifier[1]] * (double)ore.rarity[0])) continue;
                                    blockstate = ore.blockstate;
                                } else if ((y + 1) % ore.spacing == 0) {
                                    if ((double)ore.rarity[1] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.3) || !((double)rand.nextFloat() < (double)ore.rarity[1] + this.factors[ore.modifier[0]] * (double)ore.rarity[1] + this.factors[ore.modifier[1]] * (double)ore.rarity[1])) continue;
                                    blockstate = ore.blockstate;
                                } else {
                                    if ((y + 2) % ore.spacing != 0 || (double)ore.rarity[2] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.7) || !((double)rand.nextFloat() < (double)ore.rarity[2] + this.factors[ore.modifier[0]] * (double)ore.rarity[2] + this.factors[ore.modifier[1]] * (double)ore.rarity[2])) continue;
                                    blockstate = ore.blockstate;
                                }
                                break;
                            }
                        } else if (density < 0.0) {
                            for (i = 0; i < this.density1.size(); ++i) {
                                ore = this.density1.get(i);
                                if (y % ore.spacing == 0) {
                                    if ((double)ore.rarity[0] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.0) || !((double)rand.nextFloat() < (double)ore.rarity[0] + this.factors[ore.modifier[0]] * (double)ore.rarity[0] + this.factors[ore.modifier[1]] * (double)ore.rarity[0])) continue;
                                    blockstate = ore.blockstate;
                                } else if ((y + 1) % ore.spacing == 0) {
                                    if ((double)ore.rarity[1] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.3) || !((double)rand.nextFloat() < (double)ore.rarity[1] + this.factors[ore.modifier[0]] * (double)ore.rarity[1] + this.factors[ore.modifier[1]] * (double)ore.rarity[1])) continue;
                                    blockstate = ore.blockstate;
                                } else {
                                    if ((y + 2) % ore.spacing != 0 || (double)ore.rarity[2] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.7) || !((double)rand.nextFloat() < (double)ore.rarity[2] + this.factors[ore.modifier[0]] * (double)ore.rarity[2] + this.factors[ore.modifier[1]] * (double)ore.rarity[2])) continue;
                                    blockstate = ore.blockstate;
                                }
                                break;
                            }
                        } else if (density < 0.5) {
                            for (i = 0; i < this.density2.size(); ++i) {
                                ore = this.density2.get(i);
                                if (y % ore.spacing == 0) {
                                    if ((double)ore.rarity[0] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.0) || !((double)rand.nextFloat() < (double)ore.rarity[0] + this.factors[ore.modifier[0]] * (double)ore.rarity[0] + this.factors[ore.modifier[1]] * (double)ore.rarity[0])) continue;
                                    blockstate = ore.blockstate;
                                } else if ((y + 1) % ore.spacing == 0) {
                                    if ((double)ore.rarity[1] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.3) || !((double)rand.nextFloat() < (double)ore.rarity[1] + this.factors[ore.modifier[0]] * (double)ore.rarity[1] + this.factors[ore.modifier[1]] * (double)ore.rarity[1])) continue;
                                    blockstate = ore.blockstate;
                                } else {
                                    if ((y + 2) % ore.spacing != 0 || (double)ore.rarity[2] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.7) || !((double)rand.nextFloat() < (double)ore.rarity[2] + this.factors[ore.modifier[0]] * (double)ore.rarity[2] + this.factors[ore.modifier[1]] * (double)ore.rarity[2])) continue;
                                    blockstate = ore.blockstate;
                                }
                                break;
                            }
                        } else {
                            for (i = 0; i < this.density3.size(); ++i) {
                                ore = this.density3.get(i);
                                if (y % ore.spacing == 0) {
                                    if ((double)ore.rarity[0] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.0) || !((double)rand.nextFloat() < (double)ore.rarity[0] + this.factors[ore.modifier[0]] * (double)ore.rarity[0] + this.factors[ore.modifier[1]] * (double)ore.rarity[0])) continue;
                                    blockstate = ore.blockstate;
                                } else if ((y + 1) % ore.spacing == 0) {
                                    if ((double)ore.rarity[1] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.3) || !((double)rand.nextFloat() < (double)ore.rarity[1] + this.factors[ore.modifier[0]] * (double)ore.rarity[1] + this.factors[ore.modifier[1]] * (double)ore.rarity[1])) continue;
                                    blockstate = ore.blockstate;
                                } else {
                                    if ((y + 2) % ore.spacing != 0 || (double)ore.rarity[2] == 0.0 || y > (ore.level < 9 ? this.levels[ore.level] : ore.level) || !(this.factors[ore.requirement] > 0.7) || !((double)rand.nextFloat() < (double)ore.rarity[2] + this.factors[ore.modifier[0]] * (double)ore.rarity[2] + this.factors[ore.modifier[1]] * (double)ore.rarity[2])) continue;
                                    blockstate = ore.blockstate;
                                }
                                break;
                            }
                        }
                    }
                    if (blockstate.func_185904_a() == Material.field_151579_a) continue;
                    world.func_180501_a((BlockPos)blockpos.func_181079_c(x1, y, z1), blockstate, 2);
                }
            }
        }
        return true;
    }
}

