/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.worlds.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BushConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.IPlantable;

public class FallenTreeFeature
extends Feature<BushConfig> {
    public FallenTreeFeature(Function<Dynamic<?>, ? extends BushConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BushConfig config) {
        if (!this.canPlace(worldIn, pos)) {
            return false;
        }
        BlockState blockstate = config.field_214686_a;
        int dir = rand.nextInt(4);
        if (dir == 0) {
            int length = 2 + rand.nextInt(4);
            for (int x = 0; x < length && this.canPlace(worldIn, pos.func_177982_a(x, 0, 0)); ++x) {
                worldIn.func_180501_a(pos.func_177982_a(x, 0, 0), (BlockState)blockstate.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X), 18);
            }
            return true;
        }
        if (dir == 1) {
            int length = 2 + rand.nextInt(4);
            for (int z = 0; z < length && this.canPlace(worldIn, pos.func_177982_a(0, 0, z)); ++z) {
                worldIn.func_180501_a(pos.func_177982_a(0, 0, z), (BlockState)blockstate.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Z), 18);
            }
            return true;
        }
        worldIn.func_180501_a(pos, blockstate, 18);
        return true;
    }

    private boolean canPlace(IWorld worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_177230_c().canSustainPlant(state, (IBlockReader)worldIn, pos.func_177977_b(), Direction.UP, (IPlantable)Blocks.field_196674_t) && worldIn.func_180495_p(pos).func_185904_a().func_76222_j();
    }
}

