/*
 * Decompiled with CFR 0.152.
 */
package dooglamoo.dooglamooworlds.dict;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dooglamoo.dooglamooworlds.DooglamooConfig;
import dooglamoo.dooglamooworlds.DooglamooWorldsMod;
import dooglamoo.dooglamooworlds.dict.GeoFeature;
import dooglamoo.dooglamooworlds.dict.MinMaxBounds;
import dooglamoo.dooglamooworlds.world.gen.feature.DooglamooFeatures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureRadiusConfig;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SeaGrassConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

public class DictionaryFactory {
    private static final BlockState DIRT = Blocks.field_150346_d.func_176223_P();
    private static final BlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    private static final BlockState SAND = Blocks.field_150354_m.func_176223_P();
    private static final BlockState CLAY = Blocks.field_150435_aG.func_176223_P();
    private static final BlockState GRASS_BLOCK = Blocks.field_196658_i.func_176223_P();
    private static final BlockState MOSSY_COBBLESTONE = Blocks.field_150341_Y.func_176223_P();
    private static final BlockState COBBLESTONE = Blocks.field_150347_e.func_176223_P();
    public static final BlockClusterFeatureConfig BIRCH_FALLEN_TREE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196619_M.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig OAK_FALLEN_TREE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig SPRUCE_FALLEN_TREE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196618_L.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig DANDELION_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196605_bc.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig POPPY_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196606_bd.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig ALLIUM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196609_bf.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig AZURE_BLUET_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196610_bg.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig RED_TULIP_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196612_bh.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig ORANGE_TULIP_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196613_bi.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig WHITE_TULIP_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196614_bj.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig PINK_TULIP_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196615_bk.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig OXEYE_DAISY_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196616_bl.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig CORNFLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_222387_by.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    @ObjectHolder(value="lostcities:lostcityfeature")
    public static final Feature<NoFeatureConfig> LOSTCITY_FEATURE = null;
    @ObjectHolder(value="biomesoplenty:pink_cherry_tree")
    public static final Feature<BaseTreeFeatureConfig> PINK_CHERRY_TREE = null;
    @ObjectHolder(value="biomesoplenty:big_pink_cherry_tree")
    public static final Feature<BaseTreeFeatureConfig> BIG_PINK_CHERRY_TREE = null;
    @ObjectHolder(value="biomesoplenty:white_cherry_tree")
    public static final Feature<BaseTreeFeatureConfig> WHITE_CHERRY_TREE = null;
    @ObjectHolder(value="biomesoplenty:big_white_cherry_tree")
    public static final Feature<BaseTreeFeatureConfig> BIG_WHITE_CHERRY_TREE = null;
    @ObjectHolder(value="biomesoplenty:fir_tree")
    public static final Feature<BaseTreeFeatureConfig> FIR_TREE = null;
    @ObjectHolder(value="biomesoplenty:fir_tree_large")
    public static final Feature<BaseTreeFeatureConfig> FIR_TREE_LARGE = null;
    @ObjectHolder(value="biomesoplenty:willow_tree")
    public static final Feature<BaseTreeFeatureConfig> WILLOW_TREE = null;
    @ObjectHolder(value="biomesoplenty:yellow_autumn_tree")
    public static final Feature<BaseTreeFeatureConfig> YELLOW_AUTUMN_TREE = null;
    @ObjectHolder(value="biomesoplenty:orange_autumn_tree")
    public static final Feature<BaseTreeFeatureConfig> ORANGE_AUTUMN_TREE = null;
    @ObjectHolder(value="biomesoplenty:jungle_twiglet_tree")
    public static final Feature<BaseTreeFeatureConfig> JUNGLE_TWIGLET_TREE = null;
    @ObjectHolder(value="biomesoplenty:dying_tree")
    public static final Feature<BaseTreeFeatureConfig> DYING_TREE = null;
    @ObjectHolder(value="biomesoplenty:dead_tree")
    public static final Feature<BaseTreeFeatureConfig> DEAD_TREE = null;
    @ObjectHolder(value="biomesoplenty:dark_oak_poplar")
    public static final Feature<BaseTreeFeatureConfig> DARK_OAK_POPLAR = null;
    @ObjectHolder(value="biomesoplenty:birch_poplar")
    public static final Feature<BaseTreeFeatureConfig> BIRCH_POPLAR = null;
    @ObjectHolder(value="biomesoplenty:jacaranda_tree")
    public static final Feature<BaseTreeFeatureConfig> JACARANDA_TREE = null;
    @ObjectHolder(value="biomesoplenty:maple_tree")
    public static final Feature<BaseTreeFeatureConfig> MAPLE_TREE = null;
    @ObjectHolder(value="biomesoplenty:magic_tree")
    public static final Feature<BaseTreeFeatureConfig> MAGIC_TREE = null;
    @ObjectHolder(value="biomesoplenty:palm_tree")
    public static final Feature<BaseTreeFeatureConfig> PALM_TREE = null;
    @ObjectHolder(value="biomesoplenty:tall_umbran_tree")
    public static final Feature<BaseTreeFeatureConfig> TALL_UMBRAN_TREE = null;
    @ObjectHolder(value="biomesoplenty:acacia_bush")
    public static final Feature<BaseTreeFeatureConfig> ACACIA_BUSH = null;
    @ObjectHolder(value="biomesoplenty:acacia_twiglet_tree")
    public static final Feature<BaseTreeFeatureConfig> ACACIA_TWIGLET_TREE = null;
    @ObjectHolder(value="biomesoplenty:mahogany_tree")
    public static final Feature<BaseTreeFeatureConfig> MAHOGANY_TREE = null;
    @ObjectHolder(value="biomesoplenty:redwood_tree")
    public static final Feature<BaseTreeFeatureConfig> REDWOOD_TREE = null;
    @ObjectHolder(value="biomesoplenty:redwood_tree_medium")
    public static final Feature<BaseTreeFeatureConfig> REDWOOD_TREE_MEDIUM = null;
    @ObjectHolder(value="biomesoplenty:lavender_flowers")
    public static final FlowersFeature<NoFeatureConfig> LAVENDER_FLOWERS = null;
    public static HashMap<String, BlockState> blockDictionary;
    public static HashMap<String, ConfiguredFeature<?, ?>> featureDictionary;
    public static List<Biome> baseBiomes;
    public static List<Biome> addedBiomes;
    public static Map<Integer, List<GeoFeature>> blocks;
    public static Map<Integer, List<GeoFeature>> features;
    public static Map<Integer, List<GeoFeature>> biomes;
    public static Map<Integer, List<GeoFeature>> ores;
    public static int biomeCount;
    public static int blockCount;
    public static int featureCount;

    public static void clear() {
        baseBiomes.clear();
        addedBiomes.clear();
        blocks.clear();
        features.clear();
        biomes.clear();
        ores.clear();
        biomeCount = 0;
        blockCount = 0;
        featureCount = 0;
    }

    public static void init() {
        blockDictionary = new HashMap();
        featureDictionary = new HashMap();
        baseBiomes = new ArrayList<Biome>();
        addedBiomes = new ArrayList<Biome>();
        blockDictionary.put("air", Blocks.field_150350_a.func_176223_P());
        blockDictionary.put("lava", Blocks.field_150353_l.func_176223_P());
        blockDictionary.put("water", Blocks.field_150355_j.func_176223_P());
        blockDictionary.put("water_salt", Blocks.field_150355_j.func_176223_P());
        blockDictionary.put("magma", Blocks.field_196814_hQ.func_176223_P());
        blockDictionary.put("stone", Blocks.field_150348_b.func_176223_P());
        blockDictionary.put("stone_andesite", Blocks.field_196656_g.func_176223_P());
        blockDictionary.put("stone_granite", Blocks.field_196650_c.func_176223_P());
        blockDictionary.put("stone_diorite", Blocks.field_196654_e.func_176223_P());
        blockDictionary.put("dirt", Blocks.field_150346_d.func_176223_P());
        blockDictionary.put("coarsedirt", Blocks.field_196660_k.func_176223_P());
        blockDictionary.put("loam", Blocks.field_196660_k.func_176223_P());
        blockDictionary.put("podzol", Blocks.field_196661_l.func_176223_P());
        blockDictionary.put("mycelium", Blocks.field_150391_bh.func_176223_P());
        blockDictionary.put("grass", Blocks.field_196658_i.func_176223_P());
        blockDictionary.put("heath", Blocks.field_196658_i.func_176223_P());
        blockDictionary.put("terracotta", Blocks.field_150405_ch.func_176223_P());
        blockDictionary.put("sandstone", Blocks.field_150322_A.func_176223_P());
        blockDictionary.put("terracotta_white", Blocks.field_196777_fo.func_176223_P());
        blockDictionary.put("terracotta_orange", Blocks.field_196778_fp.func_176223_P());
        blockDictionary.put("terracotta_yellow", Blocks.field_196783_fs.func_176223_P());
        blockDictionary.put("terracotta_gray", Blocks.field_196789_fv.func_176223_P());
        blockDictionary.put("terracotta_silver", Blocks.field_196791_fw.func_176223_P());
        blockDictionary.put("terracotta_brown", Blocks.field_196719_fA.func_176223_P());
        blockDictionary.put("terracotta_red", Blocks.field_196721_fC.func_176223_P());
        blockDictionary.put("cobblestone", Blocks.field_150347_e.func_176223_P());
        blockDictionary.put("obsidian", Blocks.field_150343_Z.func_176223_P());
        blockDictionary.put("gravel", Blocks.field_150351_n.func_176223_P());
        blockDictionary.put("sand", Blocks.field_150354_m.func_176223_P());
        blockDictionary.put("sand_red", Blocks.field_196611_F.func_176223_P());
        blockDictionary.put("ice", Blocks.field_150432_aD.func_176223_P());
        blockDictionary.put("snow", Blocks.field_196604_cC.func_176223_P());
        blockDictionary.put("snowpack", Blocks.field_196604_cC.func_176223_P());
        blockDictionary.put("icepack", Blocks.field_150403_cj.func_176223_P());
        blockDictionary.put("silverfish", Blocks.field_196686_dc.func_176223_P());
        blockDictionary.put("clay", Blocks.field_150435_aG.func_176223_P());
        if (((Boolean)DooglamooConfig.GENERAL.customGenSlimeOre.get()).booleanValue()) {
            blockDictionary.put("oil", Blocks.field_180399_cE.func_176223_P());
        }
        if (((Boolean)DooglamooConfig.GENERAL.customGenGlowstoneOre.get()).booleanValue()) {
            blockDictionary.put("glowstone", Blocks.field_150426_aN.func_176223_P());
        }
        blockDictionary.put("coal_ore", Blocks.field_150365_q.func_176223_P());
        blockDictionary.put("iron_ore", Blocks.field_150366_p.func_176223_P());
        blockDictionary.put("gold_ore", Blocks.field_150352_o.func_176223_P());
        blockDictionary.put("emerald_ore", Blocks.field_150412_bA.func_176223_P());
        blockDictionary.put("lapis_ore", Blocks.field_150369_x.func_176223_P());
        blockDictionary.put("redstone_ore", Blocks.field_150450_ax.func_176223_P());
        blockDictionary.put("diamond_ore", Blocks.field_150482_ag.func_176223_P());
        if (((Boolean)DooglamooConfig.GENERAL.customGenQuartzOre.get()).booleanValue()) {
            blockDictionary.put("quartz_ore", Blocks.field_196766_fg.func_176223_P());
        }
        DictionaryFactory.addFeature("tree_spruce_mega", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202304_D.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226824_s_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_spruce_redwood", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202304_D.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226823_r_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_spruce", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226809_d_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(6, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_spruce_tall", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226810_e_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(8, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_birch", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230129_h_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(6, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_birch_tall", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230130_i_).func_227227_a_(0.5f)), Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230129_h_))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(8, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_jungle_mega", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202302_B.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226825_t_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(50, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_jungle", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226792_b_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_jungle_tall", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226792_b_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_jungle_vines", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226792_b_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_acacia", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227246_s_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226811_f_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(8, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_oak_dark", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_214551_w.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226822_q_).func_227228_a_(Placement.field_215008_G.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        DictionaryFactory.addFeature("tree_oak_big", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202339_q.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226815_j_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_oak", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(6, 0.1f, 1))));
        DictionaryFactory.addFeature("tree_oak_swamp", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226814_i_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
        DictionaryFactory.addFeature("clay", GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(CLAY, 4, 1, (List)Lists.newArrayList((Object[])new BlockState[]{DIRT, CLAY}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        DictionaryFactory.addFeature("sand", GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(SAND, 7, 2, (List)Lists.newArrayList((Object[])new BlockState[]{DIRT, GRASS_BLOCK}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
        DictionaryFactory.addFeature("gravel", GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(GRAVEL, 6, 2, (List)Lists.newArrayList((Object[])new BlockState[]{DIRT, GRASS_BLOCK}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        DictionaryFactory.addFeature("mushroom_brown", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226722_J_).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(8, 0.25f))));
        DictionaryFactory.addFeature("mushroom_red", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226721_I_).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(8, 0.25f))));
        DictionaryFactory.addFeature("reed", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226730_R_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
        DictionaryFactory.addFeature("cactus", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226729_Q_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        DictionaryFactory.addFeature("waterlily", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226720_H_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(4))));
        DictionaryFactory.addFeature("ice_spike", GenerationStage.Decoration.SURFACE_STRUCTURES, Feature.field_202320_T.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
        DictionaryFactory.addFeature("ice_path", GenerationStage.Decoration.SURFACE_STRUCTURES, Feature.field_202288_ah.func_225566_b_((IFeatureConfig)new FeatureRadiusConfig(2)).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("shrub_jungle", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202342_t.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226821_p_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
        DictionaryFactory.addFeature("fern", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226827_v_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(7))));
        DictionaryFactory.addFeature("grass", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226826_u_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("grass_tussock", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226826_u_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("blob", GenerationStage.Decoration.LOCAL_MODIFICATIONS, Feature.field_202283_ac.func_225566_b_((IFeatureConfig)new BlockBlobConfig(MOSSY_COBBLESTONE, 0)).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
        DictionaryFactory.addFeature("bush_dead", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226715_C_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("flower_dandelion", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)DANDELION_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("flower_poppy", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)POPPY_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("flower_orchid_blue", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226830_y_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        DictionaryFactory.addFeature("flower_allium", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)ALLIUM_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("flower_houstonia", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)AZURE_BLUET_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("flower_tulip_red", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)RED_TULIP_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("flower_tulip_orange", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)ORANGE_TULIP_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("flower_tulip_white", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)WHITE_TULIP_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("flower_tulip_pink", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)PINK_TULIP_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("flower_oxeyedaisy", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)OXEYE_DAISY_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("flower_cornflower", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)CORNFLOWER_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("flower_lilyofthevalley", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226829_x_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        DictionaryFactory.addFeature("pumpkin", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226717_E_).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(32))));
        DictionaryFactory.addFeature("melon", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226716_D_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        DictionaryFactory.addFeature("flower_rose_tall", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226724_L_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
        DictionaryFactory.addFeature("flower_syringa_tall", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226723_K_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
        DictionaryFactory.addFeature("flower_paeonia_tall", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226725_M_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
        DictionaryFactory.addFeature("flower_sunflower_tall", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226726_N_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
        DictionaryFactory.addFeature("grass_tall", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226727_O_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(7))));
        DictionaryFactory.addFeature("fern_tall", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226728_P_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(7))));
        DictionaryFactory.addFeature("water_flowing", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202295_ao.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226736_X_).func_227228_a_(Placement.field_215029_o.func_227446_a_((IPlacementConfig)new CountRangeConfig(50, 8, 8, 256))));
        DictionaryFactory.addFeature("lava_flowing", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202295_ao.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226737_Y_).func_227228_a_(Placement.field_215030_p.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 8, 16, 256))));
        DictionaryFactory.addFeature("mushroom_brown_tall", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202319_S.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226768_ac_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        DictionaryFactory.addFeature("mushroom_red_tall", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202318_R.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226767_ab_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        DictionaryFactory.addFeature("coral", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature((List)ImmutableList.of((Object)Feature.field_204621_ay.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Object)Feature.field_204619_aA.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Object)Feature.field_204622_az.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e)))).func_227228_a_(Placement.field_215038_x.func_227446_a_((IPlacementConfig)new TopSolidWithNoiseConfig(20, 400.0, 0.0, Heightmap.Type.OCEAN_FLOOR_WG))));
        DictionaryFactory.addFeature("kelp", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_203235_au.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215038_x.func_227446_a_((IPlacementConfig)new TopSolidWithNoiseConfig(80, 80.0, 0.0, Heightmap.Type.OCEAN_FLOOR_WG))));
        DictionaryFactory.addFeature("seagrass", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_203234_at.func_225566_b_((IFeatureConfig)new SeaGrassConfig(80, 0.3)).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        DictionaryFactory.addFeature("bush_berry_sweet", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226718_F_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        DictionaryFactory.addFeature("sea_pickle", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_204914_aC.func_225566_b_((IFeatureConfig)new CountConfig(20)).func_227228_a_(Placement.field_215026_l.func_227446_a_((IPlacementConfig)new ChanceConfig(16))));
        DictionaryFactory.addFeature("bamboo", GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_214482_aJ.func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.2f)).func_227228_a_(Placement.field_215038_x.func_227446_a_((IPlacementConfig)new TopSolidWithNoiseConfig(160, 80.0, 0.3, Heightmap.Type.WORLD_SURFACE_WG))));
        DictionaryFactory.addFeature("tree_birch_fallen", GenerationStage.Decoration.VEGETAL_DECORATION, DooglamooFeatures.FALLEN_TREE.func_225566_b_((IFeatureConfig)BIRCH_FALLEN_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.2f, 1))));
        DictionaryFactory.addFeature("tree_oak_fallen", GenerationStage.Decoration.VEGETAL_DECORATION, DooglamooFeatures.FALLEN_TREE.func_225566_b_((IFeatureConfig)OAK_FALLEN_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.2f, 1))));
        DictionaryFactory.addFeature("tree_spruce_fallen", GenerationStage.Decoration.VEGETAL_DECORATION, DooglamooFeatures.FALLEN_TREE.func_225566_b_((IFeatureConfig)SPRUCE_FALLEN_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.2f, 1))));
        DictionaryFactory.addFeature("rock_river_mossy", GenerationStage.Decoration.LOCAL_MODIFICATIONS, Feature.field_202283_ac.func_225566_b_((IFeatureConfig)new BlockBlobConfig(MOSSY_COBBLESTONE, 0)).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(6))));
        DictionaryFactory.addFeature("rock_river", GenerationStage.Decoration.LOCAL_MODIFICATIONS, Feature.field_202283_ac.func_225566_b_((IFeatureConfig)new BlockBlobConfig(COBBLESTONE, 0)).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(6))));
        if (PINK_CHERRY_TREE != null) {
            DictionaryFactory.addFeature("tree_cherry_pink", GenerationStage.Decoration.VEGETAL_DECORATION, PINK_CHERRY_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230133_p_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (BIG_PINK_CHERRY_TREE != null) {
            DictionaryFactory.addFeature("tree_cherry_pink_large", GenerationStage.Decoration.VEGETAL_DECORATION, BIG_PINK_CHERRY_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (WHITE_CHERRY_TREE != null) {
            DictionaryFactory.addFeature("tree_cherry_white", GenerationStage.Decoration.VEGETAL_DECORATION, WHITE_CHERRY_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230133_p_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (BIG_WHITE_CHERRY_TREE != null) {
            DictionaryFactory.addFeature("tree_cherry_white_large", GenerationStage.Decoration.VEGETAL_DECORATION, BIG_WHITE_CHERRY_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (FIR_TREE != null) {
            DictionaryFactory.addFeature("tree_fir", GenerationStage.Decoration.VEGETAL_DECORATION, FIR_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (FIR_TREE_LARGE != null) {
            DictionaryFactory.addFeature("tree_fir_mega", GenerationStage.Decoration.VEGETAL_DECORATION, FIR_TREE_LARGE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (WILLOW_TREE != null) {
            DictionaryFactory.addFeature("tree_willow", GenerationStage.Decoration.VEGETAL_DECORATION, WILLOW_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (YELLOW_AUTUMN_TREE != null) {
            DictionaryFactory.addFeature("tree_autumn_yellow", GenerationStage.Decoration.VEGETAL_DECORATION, YELLOW_AUTUMN_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (ORANGE_AUTUMN_TREE != null) {
            DictionaryFactory.addFeature("tree_autumn_orange", GenerationStage.Decoration.VEGETAL_DECORATION, ORANGE_AUTUMN_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (JUNGLE_TWIGLET_TREE != null) {
            DictionaryFactory.addFeature("tree_jungle_twiglet", GenerationStage.Decoration.VEGETAL_DECORATION, JUNGLE_TWIGLET_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (DYING_TREE != null) {
            DictionaryFactory.addFeature("tree_dying", GenerationStage.Decoration.VEGETAL_DECORATION, DYING_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (DEAD_TREE != null) {
            DictionaryFactory.addFeature("tree_dead", GenerationStage.Decoration.VEGETAL_DECORATION, DEAD_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (DARK_OAK_POPLAR != null) {
            DictionaryFactory.addFeature("tree_poplar_dark", GenerationStage.Decoration.VEGETAL_DECORATION, DARK_OAK_POPLAR.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (BIRCH_POPLAR != null) {
            DictionaryFactory.addFeature("tree_poplar", GenerationStage.Decoration.VEGETAL_DECORATION, BIRCH_POPLAR.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (JACARANDA_TREE != null) {
            DictionaryFactory.addFeature("tree_jacaranda", GenerationStage.Decoration.VEGETAL_DECORATION, JACARANDA_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (MAPLE_TREE != null) {
            DictionaryFactory.addFeature("tree_maple", GenerationStage.Decoration.VEGETAL_DECORATION, MAPLE_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (MAGIC_TREE != null) {
            DictionaryFactory.addFeature("tree_magic", GenerationStage.Decoration.VEGETAL_DECORATION, MAGIC_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (PALM_TREE != null) {
            DictionaryFactory.addFeature("tree_palm", GenerationStage.Decoration.VEGETAL_DECORATION, PALM_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (TALL_UMBRAN_TREE != null) {
            DictionaryFactory.addFeature("tree_umbran_mega", GenerationStage.Decoration.VEGETAL_DECORATION, TALL_UMBRAN_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (ACACIA_BUSH != null) {
            DictionaryFactory.addFeature("bush_acacia", GenerationStage.Decoration.VEGETAL_DECORATION, ACACIA_BUSH.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (ACACIA_TWIGLET_TREE != null) {
            DictionaryFactory.addFeature("tree_acacia_twiglet", GenerationStage.Decoration.VEGETAL_DECORATION, ACACIA_TWIGLET_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (MAHOGANY_TREE != null) {
            DictionaryFactory.addFeature("tree_mahogany", GenerationStage.Decoration.VEGETAL_DECORATION, MAHOGANY_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (REDWOOD_TREE != null) {
            DictionaryFactory.addFeature("tree_redwood", GenerationStage.Decoration.VEGETAL_DECORATION, REDWOOD_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (REDWOOD_TREE_MEDIUM != null) {
            DictionaryFactory.addFeature("tree_redwood_thin", GenerationStage.Decoration.VEGETAL_DECORATION, REDWOOD_TREE_MEDIUM.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_230132_o_).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        }
        if (LAVENDER_FLOWERS != null) {
            DictionaryFactory.addFeature("flower_lavender", GenerationStage.Decoration.VEGETAL_DECORATION, LAVENDER_FLOWERS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        }
        if (LOSTCITY_FEATURE != null) {
            DictionaryFactory.addFeature("lostcity", GenerationStage.Decoration.LOCAL_MODIFICATIONS, LOSTCITY_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 0, 0, 1))));
        }
    }

    private static void addFeature(String name, GenerationStage.Decoration decorationStage, ConfiguredFeature<?, ?> feature) {
        if (!featureDictionary.containsKey(name)) {
            featureDictionary.put(name, feature);
        } else {
            DooglamooWorldsMod.LOGGER.info("Duplicate feature: " + name);
        }
    }

    public static void tagsUpdated(TagsUpdatedEvent event) {
        if (EffectiveSide.get() == LogicalSide.SERVER) {
            DictionaryFactory.findModdedOre("copper", event);
            DictionaryFactory.findModdedOre("tin", event);
            DictionaryFactory.findModdedOre("aluminum", event);
            DictionaryFactory.findModdedOre("lead", event);
            DictionaryFactory.findModdedOre("silver", event);
            DictionaryFactory.findModdedOre("nickel", event);
            DictionaryFactory.findModdedOre("uranium", event);
        }
    }

    public static void loadComplete() {
        DictionaryFactory.registerBlock("biomesoplenty", "ash_block", "ash_block");
        DictionaryFactory.registerBlock("biomesoplenty", "mud", "mud_mud");
        DictionaryFactory.registerBlock("biomesoplenty", "white_sand", "sand_white");
    }

    private static void findModdedOre(String name, TagsUpdatedEvent event) {
        Optional block;
        if (event.getTagManager().func_199717_a().func_199910_a(new ResourceLocation("forge", "ores/" + name)) != null && (block = event.getTagManager().func_199717_a().func_199910_a(new ResourceLocation("forge", "ores/" + name)).func_199885_a().stream().findFirst()).isPresent()) {
            blockDictionary.put(name + "_ore", ((Block)block.get()).func_176223_P());
        }
    }

    private static void registerBlock(String domain, String id, String name) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(domain, id));
        if (block != null && block != Blocks.field_150350_a) {
            blockDictionary.put(name, block.func_176223_P());
        }
    }

    public static GeoFeature getGeoFeature(String key, JsonObject json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        String type = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Material type can not be an empty string");
        }
        if (!type.contains(":")) {
            type = "dooglamooworlds:" + type;
        }
        key = key.substring(key.lastIndexOf("/") + 1);
        int level = key.split("_").length;
        GeoFeature geo = null;
        switch (type) {
            case "dooglamooworlds:block": {
                BlockState state = blockDictionary.get(key);
                if (state != null) {
                    geo = new GeoFeature(state, level);
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorldsMod.LOGGER.info("No registered block found: " + key);
                break;
            }
            case "dooglamooworlds:block_ore": {
                BlockState state = blockDictionary.get(key);
                if (state != null) {
                    geo = new GeoFeature(state, JSONUtils.func_151208_a((JsonObject)json, (String)"spacing", (int)23), JSONUtils.func_151208_a((JsonObject)json, (String)"depth", (int)255));
                    JsonArray rar = JSONUtils.func_151214_t((JsonObject)json, (String)"rarity");
                    if (rar.size() > 0) {
                        geo.rarity[0] = rar.get(0).getAsFloat();
                    }
                    if (rar.size() > 1) {
                        geo.rarity[1] = rar.get(1).getAsFloat();
                    }
                    if (rar.size() > 2) {
                        geo.rarity[2] = rar.get(2).getAsFloat();
                    }
                    JsonArray req = JSONUtils.func_151213_a((JsonObject)json, (String)"requirements", (JsonArray)new JsonArray());
                    int requirement = 1;
                    if (req.size() > 0) {
                        for (Map.Entry entry : req.get(0).getAsJsonObject().entrySet()) {
                            switch ((String)entry.getKey()) {
                                case "elevation": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 2 : 10;
                                    break;
                                }
                                case "density": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 3 : 11;
                                    break;
                                }
                                case "uplift": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 4 : 12;
                                    break;
                                }
                                case "volcanism": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 5 : 13;
                                    break;
                                }
                                case "era": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 6 : 14;
                                    break;
                                }
                                case "erosion": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 7 : 15;
                                    break;
                                }
                                case "temperature": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 8 : 16;
                                    break;
                                }
                                case "precipitation": {
                                    requirement = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 9 : 17;
                                }
                            }
                        }
                    }
                    geo.requirement = requirement;
                    JsonArray mod = JSONUtils.func_151213_a((JsonObject)json, (String)"modifiers", (JsonArray)new JsonArray());
                    int modifier1 = 0;
                    int modifier2 = 0;
                    if (mod.size() > 0) {
                        for (Map.Entry entry : mod.get(0).getAsJsonObject().entrySet()) {
                            switch ((String)entry.getKey()) {
                                case "elevation": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 2 : 10;
                                    break;
                                }
                                case "density": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 3 : 11;
                                    break;
                                }
                                case "uplift": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 4 : 12;
                                    break;
                                }
                                case "volcanism": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 5 : 13;
                                    break;
                                }
                                case "era": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 6 : 14;
                                    break;
                                }
                                case "erosion": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 7 : 15;
                                    break;
                                }
                                case "temperature": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 8 : 16;
                                    break;
                                }
                                case "precipitation": {
                                    modifier1 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 9 : 17;
                                }
                            }
                        }
                    }
                    if (mod.size() > 1) {
                        for (Map.Entry entry : mod.get(1).getAsJsonObject().entrySet()) {
                            switch ((String)entry.getKey()) {
                                case "elevation": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 2 : 10;
                                    break;
                                }
                                case "density": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 3 : 11;
                                    break;
                                }
                                case "uplift": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 4 : 12;
                                    break;
                                }
                                case "volcanism": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 5 : 13;
                                    break;
                                }
                                case "era": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 6 : 14;
                                    break;
                                }
                                case "erosion": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 7 : 15;
                                    break;
                                }
                                case "temperature": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 8 : 16;
                                    break;
                                }
                                case "precipitation": {
                                    modifier2 = "low".equals(((JsonElement)entry.getValue()).getAsString()) ? 9 : 17;
                                }
                            }
                        }
                    }
                    geo.modifier[0] = modifier1;
                    geo.modifier[1] = modifier2;
                    MinMaxBounds density = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinDensity(density.getMin());
                    geo.setMaxDensity(density.getMax());
                    break;
                }
                DooglamooWorldsMod.LOGGER.info("No registered block found: " + key);
                break;
            }
            case "dooglamooworlds:feature": 
            case "dooglamooworlds:feature_ocean": {
                ConfiguredFeature<?, ?> gen = featureDictionary.get(key);
                if (gen != null) {
                    geo = new GeoFeature(gen, JSONUtils.func_151217_k((JsonObject)json, (String)"rarity"));
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorldsMod.LOGGER.info("No registered feature found: " + key);
                break;
            }
            case "dooglamooworlds:biome": 
            case "dooglamooworlds:biome_ocean": {
                String domain = JSONUtils.func_151219_a((JsonObject)json, (String)"domain", (String)"minecraft");
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(domain, key));
                if (biome != null) {
                    geo = new GeoFeature(biome, "minecraft".equals(domain) ? 0 : 1);
                    MinMaxBounds temp = MinMaxBounds.deserialize(json.get("temperature"));
                    MinMaxBounds precip = MinMaxBounds.deserialize(json.get("precipitation"));
                    MinMaxBounds lift = MinMaxBounds.deserialize(json.get("uplift"));
                    MinMaxBounds erosion = MinMaxBounds.deserialize(json.get("erosion"));
                    MinMaxBounds thermal = MinMaxBounds.deserialize(json.get("volcanism"));
                    MinMaxBounds age = MinMaxBounds.deserialize(json.get("era"));
                    MinMaxBounds plates = MinMaxBounds.deserialize(json.get("elevation"));
                    MinMaxBounds rock = MinMaxBounds.deserialize(json.get("density"));
                    geo.setMinTemperature(temp.getMin());
                    geo.setMaxTemperature(temp.getMax());
                    geo.setMinPrecipitation(precip.getMin());
                    geo.setMaxPrecipitation(precip.getMax());
                    geo.setMinUplift(lift.getMin());
                    geo.setMaxUplift(lift.getMax());
                    geo.setMinErosion(erosion.getMin());
                    geo.setMaxErosion(erosion.getMax());
                    geo.setMinVolcanism(thermal.getMin());
                    geo.setMaxVolcanism(thermal.getMax());
                    geo.setMinEra(age.getMin());
                    geo.setMaxEra(age.getMax());
                    geo.setMinElevation(plates.getMin());
                    geo.setMaxElevation(plates.getMax());
                    geo.setMinDensity(rock.getMin());
                    geo.setMaxDensity(rock.getMax());
                    break;
                }
                DooglamooWorldsMod.LOGGER.info("No registered biome found: " + key);
                break;
            }
            default: {
                DooglamooWorldsMod.LOGGER.info("Unknown geofeature type: " + type);
            }
        }
        return geo;
    }

    public static void register(GeoFeature geo) {
        if (geo == null) {
            return;
        }
        if (geo.getType() == GeoFeature.Type.Biome) {
            if (geo.level == 0) {
                baseBiomes.add(geo.getBiome());
            } else {
                addedBiomes.add(geo.getBiome());
            }
            ++biomeCount;
        } else if (geo.getType() == GeoFeature.Type.Block) {
            ++blockCount;
        } else if (geo.getType() == GeoFeature.Type.Feature) {
            ++featureCount;
        } else if (geo.getType() == GeoFeature.Type.OreBlock) {
            for (int i = geo.getMinDensity(); i <= geo.getMaxDensity(); ++i) {
                List<GeoFeature> list = ores.get(i);
                if (list == null) {
                    list = new ArrayList<GeoFeature>();
                    ores.put(i, list);
                }
                int origIndex = -1;
                for (int j = 0; j < list.size(); ++j) {
                    GeoFeature orig = list.get(j);
                    if (!orig.blockstate.equals(geo.blockstate)) continue;
                    origIndex = j;
                    break;
                }
                if (origIndex >= 0) {
                    list.set(origIndex, geo);
                    continue;
                }
                list.add(geo);
            }
            return;
        }
        for (int t = geo.getMinTemperature(); t <= geo.getMaxTemperature(); ++t) {
            for (int w = geo.getMinPrecipitation(); w <= geo.getMaxPrecipitation(); ++w) {
                for (int u = geo.getMinUplift(); u <= geo.getMaxUplift(); ++u) {
                    for (int e = geo.getMinErosion(); e <= geo.getMaxErosion(); ++e) {
                        for (int g = geo.getMinVolcanism(); g <= geo.getMaxVolcanism(); ++g) {
                            for (int a = geo.getMinEra(); a <= geo.getMaxEra(); ++a) {
                                for (int p = geo.getMinElevation(); p <= geo.getMaxElevation(); ++p) {
                                    for (int r = geo.getMinDensity(); r <= geo.getMaxDensity(); ++r) {
                                        int id = t << 14 | w << 12 | u << 10 | e << 8 | g << 6 | a << 4 | p << 2 | r << 0;
                                        List<GeoFeature> list = null;
                                        switch (geo.getType()) {
                                            case Block: {
                                                list = blocks.get(id);
                                                break;
                                            }
                                            case OreBlock: {
                                                break;
                                            }
                                            case Feature: {
                                                list = features.get(id);
                                                break;
                                            }
                                            case Biome: {
                                                list = biomes.get(id);
                                            }
                                        }
                                        if (list == null) {
                                            list = new ArrayList<GeoFeature>();
                                            switch (geo.getType()) {
                                                case Block: {
                                                    blocks.put(id, list);
                                                    break;
                                                }
                                                case OreBlock: {
                                                    break;
                                                }
                                                case Feature: {
                                                    features.put(id, list);
                                                    break;
                                                }
                                                case Biome: {
                                                    biomes.put(id, list);
                                                }
                                            }
                                        }
                                        if (geo.getType() == GeoFeature.Type.Biome) {
                                            if (list.size() > 0 && geo.getLevel() <= list.get(0).getLevel()) {
                                                if (geo.getLevel() != list.get(0).getLevel()) continue;
                                                DooglamooWorldsMod.LOGGER.info("registering biome mapping failed: " + geo.getBiome() + " overlaps " + list.get(0).getBiome());
                                                continue;
                                            }
                                            list.clear();
                                            list.add(geo);
                                            continue;
                                        }
                                        if (geo.getType() == GeoFeature.Type.Block) {
                                            boolean skip = false;
                                            Iterator<GeoFeature> it = list.iterator();
                                            while (it.hasNext()) {
                                                GeoFeature feature = it.next();
                                                if (feature.getLevel() < geo.getLevel()) {
                                                    it.remove();
                                                    continue;
                                                }
                                                if (feature.getLevel() <= geo.getLevel()) continue;
                                                skip = true;
                                            }
                                            if (skip) continue;
                                            list.add(geo);
                                            continue;
                                        }
                                        list.add(geo);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    static {
        blocks = new HashMap<Integer, List<GeoFeature>>();
        features = new HashMap<Integer, List<GeoFeature>>();
        biomes = new HashMap<Integer, List<GeoFeature>>();
        ores = new HashMap<Integer, List<GeoFeature>>();
    }
}

