/*
 * Decompiled with CFR 0.152.
 */
package dooglamoo.dooglamooworlds.viewer;

import dooglamoo.dooglamooworlds.viewer.ElevationTerrainView;
import dooglamoo.dooglamooworlds.world.gen.NoiseGenerator;
import dooglamoo.dooglamooworlds.world.gen.NoiseGeneratorPerlin;
import dooglamoo.dooglamooworlds.world.gen.RiverRegion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.minecraft.util.math.MathHelper;

public class TerrainViewer {
    private static Image img;
    private static int imgWidth;
    private static int imgHeight;
    private static Random rand;
    private static long seed;
    private static final double elevationScale = 2.0;
    private static final double densityScale = 2.0;
    private static final double volcanismScale = 2.0;
    private static final double upliftScale = 2.0;
    private static final double eraScale = 2.0;
    private static final double erosionScale = 2.0;
    private static final double temperatureScale = 2.0;
    private static final double precipitationScale = 2.0;
    public static final double elevationAmplitude = 1.0;
    public static final double densityAmplitude = 1.0;
    public static final double upliftAmplitude = 1.0;
    public static final double volcanismAmplitude = 1.0;
    public static final double eraAmplitude = 1.0;
    public static final double erosionAmplitude = 1.0;
    public static final double temperatureAmplitude = 1.0;
    public static final double precipitationAmplitude = 1.0;
    public static final double elevationWeight = 0.0;
    public static final double densityWeight = 0.0;
    public static final double upliftWeight = 0.0;
    public static final double volcanismWeight = 0.0;
    public static final double eraWeight = 0.0;
    public static final double erosionWeight = 0.0;
    public static final double temperatureWeight = 0.0;
    public static final double precipitationWeight = 0.0;
    private static int imgScale;
    private static int seaLevel;
    private static double riverWiggleHi;
    private static double riverWiggleLo;
    private static final double riverWidthSquared;
    private static final double riverBank;
    private static final double riverShore;
    private static final double riverChannel;
    private static final double riverShallow;
    private static double[] geofactors;
    private static int[] levels;

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Terrain Viewer");
        frame.setDefaultCloseOperation(3);
        JPanel canvas = new JPanel(){

            @Override
            public void paint(Graphics g) {
                g.drawImage(img, 0, 0, null);
            }
        };
        canvas.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent event) {
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                int x1 = (-(imgWidth / 2) + event.getX()) * imgScale;
                int z1 = (-(imgHeight / 2) + event.getY()) * imgScale;
                frame.setTitle("Terrain Viewer seed:" + seed + " (" + x1 + "," + z1 + ")");
            }
        });
        JScrollPane pane = new JScrollPane(canvas);
        canvas.setPreferredSize(new Dimension(imgWidth, imgHeight));
        frame.getContentPane().add(pane);
        frame.pack();
        frame.setVisible(true);
        img = canvas.createImage(imgWidth, imgHeight);
        System.out.println("running ...");
        frame.setTitle("Terrain Viewer calculating ...");
        TerrainViewer.run(canvas);
        System.out.println("finished");
        frame.setTitle("Terrain Viewer seed:" + seed);
        canvas.repaint();
    }

    private static void run(JPanel canvas) {
        if (img == null) {
            System.out.println("null image");
            return;
        }
        Graphics g = img.getGraphics();
        rand.setSeed(seed);
        NoiseGenerator surfaceGen = new NoiseGeneratorPerlin(rand, 5).setScale(0.2);
        NoiseGenerator elevationGen = new NoiseGeneratorPerlin(rand, 5).setScale(8.0E-4);
        NoiseGenerator densityGen = new NoiseGeneratorPerlin(rand, 2).setScale(0.0029999999999999996);
        NoiseGenerator upliftGen = new NoiseGeneratorPerlin(rand, 6).setScale(0.02);
        NoiseGenerator volcanismGen = new NoiseGeneratorPerlin(rand, 3).setScale(5.0E-4);
        NoiseGenerator eraGen = new NoiseGeneratorPerlin(rand, 4).setScale(0.0025);
        NoiseGenerator erosionGen = new NoiseGeneratorPerlin(rand, 5).setScale(0.03);
        NoiseGenerator temperatureGen = new NoiseGeneratorPerlin(rand, 2).setScale(8.0E-4);
        NoiseGenerator precipitationGen = new NoiseGeneratorPerlin(rand, 2).setScale(8.0E-4);
        ElevationTerrainView view = new ElevationTerrainView();
        ConcurrentHashMap<Long, RiverRegion> riverRegionCache = new ConcurrentHashMap<Long, RiverRegion>();
        int riverRegionHalfWidth = 8192;
        int riverRegionWidth = riverRegionHalfWidth * 2;
        TerrainViewer.levels[5] = seaLevel;
        for (int x = 0; x < imgWidth; ++x) {
            int x1 = (-(imgWidth / 2) + x) * imgScale;
            for (int z = 0; z < imgHeight; ++z) {
                double erosionFactor;
                int z1 = (-(imgHeight / 2) + z) * imgScale;
                long riverKey = (long)Math.floorDiv(x1 + riverRegionHalfWidth, riverRegionWidth) & 0xFFFFFFFFL | ((long)Math.floorDiv(z1 + riverRegionHalfWidth, riverRegionWidth) & 0xFFFFFFFFL) << 32;
                RiverRegion riverRegion = (RiverRegion)riverRegionCache.get(riverKey);
                if (riverRegion == null) {
                    int startX = Math.floorDiv(x1 + riverRegionHalfWidth, riverRegionWidth) * riverRegionWidth - riverRegionHalfWidth;
                    int startZ = Math.floorDiv(z1 + riverRegionHalfWidth, riverRegionWidth) * riverRegionWidth - riverRegionHalfWidth;
                    riverRegion = new RiverRegion(seed & riverKey, startX, startZ, riverRegionWidth, riverRegionWidth, 40, elevationGen, precipitationGen);
                    riverRegionCache.put(riverKey, riverRegion);
                }
                double surface = surfaceGen.noise(x1, z1);
                double elevation = elevationGen.noise(x1, z1) * 1.0 + 0.0;
                double density = densityGen.noise(x1, z1) * 1.0 + 0.0;
                double uplift = upliftGen.noise(x1, z1) * 1.0 + 0.0;
                double volcanism = volcanismGen.noise(x1, z1) * 1.0 + 0.0;
                double era = eraGen.noise(x1, z1) * 1.0 + 0.0;
                double erosion = erosionGen.noise(x1, z1) * 1.0 + 0.0;
                double temperature = temperatureGen.noise(x1, z1) * 1.0 + MathHelper.func_151237_a((double)(0.0 + (double)z1 * 1.875E-5), (double)-0.6, (double)0.6);
                double precipitation = precipitationGen.noise(x1, z1) * 1.0 + MathHelper.func_151237_a((double)(0.0 + (double)x1 * 1.875E-5), (double)-0.6, (double)0.6);
                TerrainViewer.geofactors[0] = surface;
                TerrainViewer.geofactors[1] = elevation;
                TerrainViewer.geofactors[2] = density;
                TerrainViewer.geofactors[3] = uplift;
                TerrainViewer.geofactors[4] = volcanism;
                TerrainViewer.geofactors[5] = era;
                TerrainViewer.geofactors[6] = erosion;
                TerrainViewer.geofactors[7] = temperature;
                TerrainViewer.geofactors[8] = precipitation;
                boolean dryRiver = false;
                if (elevation > -0.2) {
                    double riverUplift = uplift;
                    for (int t = 0; t < riverRegion.rivers.size(); ++t) {
                        RiverRegion.River river = riverRegion.rivers.get(t);
                        double d = RiverRegion.distToSegmentSquared(x1, z1, river.vHi.field_72450_a + riverWiggleHi * precipitation, river.vHi.field_72449_c + riverWiggleHi * uplift, river.vLo.field_72450_a + riverWiggleLo * precipitation, river.vLo.field_72449_c + riverWiggleLo * uplift) + surface * 6400.0;
                        if (d < riverChannel) {
                            riverUplift = -0.8;
                            if (!river.dry) continue;
                            dryRiver = true;
                            continue;
                        }
                        if (d < riverBank) {
                            riverUplift = Math.min((d - riverChannel) / riverShallow * 0.8 - 0.8, riverUplift);
                            if (!river.dry) continue;
                            dryRiver = true;
                            continue;
                        }
                        if (!(d < riverWidthSquared)) continue;
                        riverUplift = Math.min((d - riverBank) / riverShore, riverUplift);
                        if (!river.dry) continue;
                        dryRiver = true;
                    }
                    if (elevation < 0.0) {
                        riverUplift = MathHelper.func_219803_d((double)(-elevation * 5.0), (double)riverUplift, (double)uplift);
                    }
                    uplift = riverUplift;
                }
                double r = surface * 0.1 + (rand.nextDouble() * 0.1 - 0.05);
                int code = 0;
                code = elevation + surface * 0.008 < -0.5 ? (code |= 0) : (elevation + surface * 0.008 < 0.0 ? (code |= 4) : (elevation + surface * 0.008 < 0.5 ? (code |= 8) : (code |= 0xC)));
                code = density + r < -0.5 ? (code |= 0) : (density + r < 0.0 ? (code |= 1) : (density + r < 0.5 ? (code |= 2) : (code |= 3)));
                code = uplift + r < -0.5 ? (code |= 0) : (uplift + r < 0.0 ? (code |= 0x400) : (uplift + r < 0.5 ? (code |= 0x800) : (code |= 0xC00)));
                code = volcanism + r < -0.5 ? (code |= 0) : (volcanism + r < 0.0 ? (code |= 0x40) : (volcanism + r < 0.5 ? (code |= 0x80) : (code |= 0xC0)));
                code = era + r < -0.5 ? (code |= 0) : (era + r < 0.0 ? (code |= 0x10) : (era + r < 0.5 ? (code |= 0x20) : (code |= 0x30)));
                code = erosion + r < -0.5 ? (code |= 0) : (erosion + r < 0.0 ? (code |= 0x100) : (erosion + r < 0.5 ? (code |= 0x200) : (code |= 0x300)));
                code = temperature + r < -0.5 ? (code |= 0) : (temperature + r < 0.0 ? (code |= 0x4000) : (temperature + r < 0.5 ? (code |= 0x8000) : (code |= 0xC000)));
                code = precipitation + r < -0.5 ? (code |= 0) : (precipitation + r < 0.0 ? (code |= 0x1000) : (precipitation + r < 0.5 ? (code |= 0x2000) : (code |= 0x3000)));
                double surfaceDepthPlateFactor = Math.max(Math.min((elevation + 0.02) * 25.0, 1.0), 0.08);
                int surfaceDepth = (int)(((surface + 1.0) * (uplift > -0.5 ? uplift + 0.5 : 0.0) * 6.0 + (era + 0.5) * 12.0) * surfaceDepthPlateFactor);
                if (surfaceDepth < 1) {
                    surfaceDepth = 1;
                }
                if ((erosionFactor = surface * 2.0) > 0.0) {
                    erosionFactor = -erosionFactor;
                }
                if (erosionFactor > -0.1) {
                    erosionFactor = -0.1;
                }
                erosionFactor = 1.0 + erosionFactor;
                int erosionDepth = density < -0.5 ? (erosion > 0.0 ? (int)(erosion * 50.0) : 0) : (density < 0.0 ? (erosion > 0.0 ? (int)(erosion * 40.0) : 0) : (density < 0.5 ? (erosion > 0.0 ? (int)(erosion * 32.0) : 0) : (erosion > 0.0 ? (int)(erosion * 26.0) : 0)));
                TerrainViewer.levels[1] = (int)((elevation + 1.0) / 2.0 * 128.0 + surface * 0.3);
                double upliftFactor = (erosion < 0.0 && uplift > 0.1 && uplift <= 0.6 ? Math.min(Math.max((uplift - 0.1) * (-erosion * 6.0), uplift), 0.6) : uplift) * 128.0;
                TerrainViewer.levels[2] = levels[1] + (int)(uplift > 0.0 ? upliftFactor * Math.min(surfaceDepthPlateFactor + (volcanism > 0.45 ? (volcanism - 0.45) * 4.5 : 0.0), 1.0) : 0.0);
                TerrainViewer.levels[4] = levels[2] + surfaceDepth;
                TerrainViewer.levels[3] = levels[4];
                if (erosionFactor > 0.0) {
                    levels[3] = (int)((double)levels[3] - erosionFactor * (double)erosionDepth);
                }
                if (uplift < -0.5) {
                    levels[3] = (int)((double)levels[3] - (-uplift - 0.5) * 50.0);
                }
                TerrainViewer.levels[0] = levels[2] - (int)(200.0 - (volcanism > 0.0 ? volcanism * 256.0 : 0.0));
                if (levels[0] > levels[2]) {
                    TerrainViewer.levels[0] = levels[2];
                }
                if (levels[2] >= levels[3] || uplift >= 0.5) {
                    TerrainViewer.levels[2] = levels[3] - 1;
                }
                g.setColor(view.getColor(x, z, geofactors, levels, code, dryRiver));
                g.fillRect(x, z, 1, 1);
            }
        }
        g.setColor(Color.BLACK);
        int space = 2048 / imgScale;
        for (int x = 0; x < imgWidth; ++x) {
            if ((-(imgWidth / 2) + x) % space != 0) continue;
            g.drawLine(x, 0, x, imgHeight - 1);
        }
        for (int z = 0; z < imgHeight; ++z) {
            if ((-(imgHeight / 2) + z) % space != 0) continue;
            g.drawLine(0, z, imgWidth - 1, z);
        }
        g.setColor(new Color(1.0f, 0.0f, 1.0f));
        g.fillRect(imgWidth / 2 - 4, imgHeight / 2 - 4, 8, 8);
        canvas.repaint();
    }

    static {
        imgWidth = 1024;
        imgHeight = 1024;
        rand = new Random();
        seed = rand.nextLong();
        imgScale = 16;
        seaLevel = 63;
        riverWiggleHi = 800.0;
        riverWiggleLo = riverWiggleHi * 1.3;
        riverWidthSquared = Math.pow(256.0, 2.0) * 2.0;
        riverBank = riverWidthSquared * 0.2;
        riverShore = riverWidthSquared - riverBank;
        riverChannel = riverBank * 0.2;
        riverShallow = riverBank - riverChannel;
        geofactors = new double[9];
        levels = new int[6];
    }
}

