/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.network;

import com.oblivioussp.spartanshields.item.ItemShieldBase;
import com.oblivioussp.spartanshields.util.ConfigHandler;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketShieldBash {
    protected Hand hand;
    protected int entityId;
    protected boolean attackEntity = false;

    public PacketShieldBash(Hand handIn, int entityIdIn, boolean attackEntityIn) {
        this.hand = handIn;
        this.entityId = entityIdIn;
        this.attackEntity = attackEntityIn;
    }

    public static void encode(PacketShieldBash packet, PacketBuffer buf) {
        buf.func_179249_a((Enum)packet.hand);
        buf.writeInt(packet.entityId);
        buf.writeBoolean(packet.attackEntity);
    }

    public static PacketShieldBash decode(PacketBuffer buf) {
        return new PacketShieldBash((Hand)buf.func_179257_a(Hand.class), buf.readInt(), buf.readBoolean());
    }

    public static class Handler {
        public static void handle(PacketShieldBash packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ItemStack shieldStack;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Entity victim = player.field_70170_p.func_73045_a(packet.entityId);
                if (player.func_184585_cz() && !(shieldStack = player.func_184586_b(packet.hand)).func_190926_b() && !player.func_184811_cZ().func_185141_a(shieldStack.func_77973_b()) && shieldStack.func_77973_b() instanceof ItemShieldBase) {
                    if (packet.attackEntity && victim != null && victim instanceof LivingEntity) {
                        int knockLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)shieldStack);
                        victim.field_70172_ad = 0;
                        ((LivingEntity)victim).func_70653_a((Entity)player, 1.0f + (float)knockLvl, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        victim.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 1.0f);
                        shieldStack.func_222118_a(5, (LivingEntity)player, entity -> entity.func_213334_d(packet.hand));
                        player.field_70170_p.func_184148_a((PlayerEntity)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187767_eL, player.func_184176_by(), 1.0f, 1.0f);
                        player.func_71009_b(victim);
                    } else {
                        player.field_70170_p.func_184148_a((PlayerEntity)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 0.5f, 0.01f);
                    }
                    player.func_184597_cx();
                    player.func_184609_a(packet.hand);
                    player.func_184811_cZ().func_185145_a(shieldStack.func_77973_b(), ((Integer)ConfigHandler.CONFIG.cooldownShieldBash.get()).intValue());
                }
            });
        }
    }
}

