/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.util;

import com.oblivioussp.spartanshields.init.InitItems;
import com.oblivioussp.spartanshields.util.Log;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigHandler {
    protected static boolean hasEventErrorOccured = false;
    public static final String categoryGeneral = "general";
    public static final String categoryVanilla = "vanilla";
    public static final String categoryModdedCommon = "moddedCommon";
    public static final String categoryThermalMods = "moddedThermal";
    public static final String categoryModdedBotania = "moddedBotania";
    public static final String categoryModdedAbyssalcraft = "moddedAbyssalcraft";
    public static final String categoryModdedBWM = "moddedBWM";
    public static final String categoryPowered = "moddedPowered";
    public static final Config CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;

    @SubscribeEvent
    public static void onConfigLoad(ModConfig.ModConfigEvent ev) {
        Log.info("Loading config " + ev.getConfig().getFileName());
        if (ev.getConfig().getSpec() == CONFIG_SPEC) {
            if (InitItems.shieldWood == null) {
                Log.error("Cannot load durability values for Shields because the Event Bus was shut down before/during registration, preventing Spartan Shields from registering its items! Check your log to see which mod is causing this!");
                hasEventErrorOccured = true;
                return;
            }
            Log.debug("Reloading durability values for Shields!");
            if (InitItems.shieldWood != null) {
                InitItems.shieldWood.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityWoodShield.get());
            }
            if (InitItems.shieldStone != null) {
                InitItems.shieldStone.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityStoneShield.get());
            }
            if (InitItems.shieldIron != null) {
                InitItems.shieldIron.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityIronShield.get());
            }
            if (InitItems.shieldGold != null) {
                InitItems.shieldGold.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityGoldShield.get());
            }
            if (InitItems.shieldDiamond != null) {
                InitItems.shieldDiamond.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityDiamondShield.get());
            }
            if (InitItems.shieldObsidian != null) {
                InitItems.shieldObsidian.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityObsidianShield.get());
            }
            if (InitItems.shieldCopper != null) {
                InitItems.shieldCopper.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityCopperShield.get());
            }
            if (InitItems.shieldTin != null) {
                InitItems.shieldTin.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityTinShield.get());
            }
            if (InitItems.shieldBronze != null) {
                InitItems.shieldBronze.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityBronzeShield.get());
            }
            if (InitItems.shieldSteel != null) {
                InitItems.shieldSteel.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilitySteelShield.get());
            }
            if (InitItems.shieldSilver != null) {
                InitItems.shieldSilver.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilitySilverShield.get());
            }
            if (InitItems.shieldLead != null) {
                InitItems.shieldLead.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityLeadShield.get());
            }
            if (InitItems.shieldNickel != null) {
                InitItems.shieldNickel.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityNickelShield.get());
            }
            if (InitItems.shieldInvar != null) {
                InitItems.shieldInvar.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityInvarShield.get());
            }
            if (InitItems.shieldConstantan != null) {
                InitItems.shieldConstantan.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityConstantanShield.get());
            }
            if (InitItems.shieldPlatinum != null) {
                InitItems.shieldPlatinum.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityPlatinumShield.get());
            }
            if (InitItems.shieldElectrum != null) {
                InitItems.shieldElectrum.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityElectrumShield.get());
            }
            if (InitItems.shieldTowerWood != null) {
                InitItems.shieldTowerWood.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityWoodShield.get());
            }
            if (InitItems.shieldTowerStone != null) {
                InitItems.shieldTowerStone.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityStoneShield.get());
            }
            if (InitItems.shieldTowerIron != null) {
                InitItems.shieldTowerIron.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityIronShield.get());
            }
            if (InitItems.shieldTowerGold != null) {
                InitItems.shieldTowerGold.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityGoldShield.get());
            }
            if (InitItems.shieldTowerDiamond != null) {
                InitItems.shieldTowerDiamond.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityDiamondShield.get());
            }
            if (InitItems.shieldTowerObsidian != null) {
                InitItems.shieldTowerObsidian.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityObsidianShield.get());
            }
            if (InitItems.shieldTowerCopper != null) {
                InitItems.shieldTowerCopper.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityCopperShield.get());
            }
            if (InitItems.shieldTowerTin != null) {
                InitItems.shieldTowerTin.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityTinShield.get());
            }
            if (InitItems.shieldTowerBronze != null) {
                InitItems.shieldTowerBronze.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityBronzeShield.get());
            }
            if (InitItems.shieldTowerSteel != null) {
                InitItems.shieldTowerSteel.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilitySteelShield.get());
            }
            if (InitItems.shieldTowerSilver != null) {
                InitItems.shieldTowerSilver.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilitySilverShield.get());
            }
            if (InitItems.shieldTowerLead != null) {
                InitItems.shieldTowerLead.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityLeadShield.get());
            }
            if (InitItems.shieldTowerNickel != null) {
                InitItems.shieldTowerNickel.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityNickelShield.get());
            }
            if (InitItems.shieldTowerInvar != null) {
                InitItems.shieldTowerInvar.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityInvarShield.get());
            }
            if (InitItems.shieldTowerConstantan != null) {
                InitItems.shieldTowerConstantan.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityConstantanShield.get());
            }
            if (InitItems.shieldTowerPlatinum != null) {
                InitItems.shieldTowerPlatinum.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityPlatinumShield.get());
            }
            if (InitItems.shieldTowerElectrum != null) {
                InitItems.shieldTowerElectrum.setMaxDamage((Integer)ConfigHandler.CONFIG.durabilityElectrumShield.get());
            }
        }
    }

    public static boolean hasEventErrorOccured() {
        return hasEventErrorOccured;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (Config)specPair.getLeft();
    }

    public static class Config {
        public ForgeConfigSpec.IntValue durabilityWoodShield;
        public ForgeConfigSpec.IntValue durabilityStoneShield;
        public ForgeConfigSpec.IntValue durabilityIronShield;
        public ForgeConfigSpec.IntValue durabilityGoldShield;
        public ForgeConfigSpec.IntValue durabilityDiamondShield;
        public ForgeConfigSpec.IntValue durabilityObsidianShield;
        public ForgeConfigSpec.IntValue durabilityCopperShield;
        public ForgeConfigSpec.IntValue durabilityTinShield;
        public ForgeConfigSpec.IntValue durabilityBronzeShield;
        public ForgeConfigSpec.IntValue durabilitySteelShield;
        public ForgeConfigSpec.IntValue durabilitySilverShield;
        public ForgeConfigSpec.IntValue durabilityLeadShield;
        public ForgeConfigSpec.IntValue durabilityNickelShield;
        public ForgeConfigSpec.IntValue durabilityInvarShield;
        public ForgeConfigSpec.IntValue durabilityConstantanShield;
        public ForgeConfigSpec.IntValue durabilityPlatinumShield;
        public ForgeConfigSpec.IntValue durabilityElectrumShield;
        public ForgeConfigSpec.BooleanValue vanillaOnly;
        public ForgeConfigSpec.BooleanValue forceDisableUncraftableTooltips;
        public ForgeConfigSpec.IntValue cooldownShieldBash;
        public ForgeConfigSpec.BooleanValue disableShieldBash;

        Config(ForgeConfigSpec.Builder builder) {
            builder.push(ConfigHandler.categoryGeneral);
            this.vanillaOnly = builder.comment("Set to true to have only Vanilla-based shields enabled. Note that this removes mod-based Shield recipes from the game!").translation("config.spartanshields.vanillaOnly").define("vanillaOnly", false);
            this.forceDisableUncraftableTooltips = builder.comment("Will force the uncraftable shield tooltip (highlighted in red) that show on some shields to not appear. Useful for modpack makers who wish to change recipes").translation("config.spartanshields.forceDisableUncraftableTooltips").define("forceDisableUncraftableTooltips", false);
            this.cooldownShieldBash = builder.comment("Cooldown period for Shield Bashes").translation("config.spartanshields.cooldownShieldBash").defineInRange("cooldownShieldBash", 30, 1, 1000);
            this.disableShieldBash = builder.comment("Set to true to disable the Shield Bash feature").translation("config.spartanshields.disableShieldBash").define("disableShieldBash", false);
            builder.pop();
            builder.push(ConfigHandler.categoryVanilla);
            this.durabilityWoodShield = builder.comment("Crude Wooden Shield Durability").translation("config.spartanshields.durabilityWoodShield").defineInRange("durabilityWoodShield", 104, 0, 100000);
            this.durabilityStoneShield = builder.comment("Stone Braced Shield Durability").translation("config.spartanshields.durabilityStoneShield").defineInRange("durabilityStoneShield", 230, 0, 100000);
            this.durabilityIronShield = builder.comment("Iron Plated Shield Durability").translation("config.spartanshields.durabilityIronShield").defineInRange("durabilityIronShield", 538, 0, 100000);
            this.durabilityGoldShield = builder.comment("Gold Gilded Shield Durability").translation("config.spartanshields.durabilityGoldShield").defineInRange("durabilityGoldShield", 192, 0, 100000);
            this.durabilityDiamondShield = builder.comment("Diamond Reinforced Shield Durability").translation("config.spartanshields.durabilityDiamondShield").defineInRange("durabilityDiamondShield", 2560, 0, 100000);
            this.durabilityObsidianShield = builder.comment("Bulky Obsidian Shield Durability").translation("config.spartanshields.durabilityObsidianShield").defineInRange("durabilityObsidianShield", 1600, 0, 100000);
            builder.pop();
            builder.push(ConfigHandler.categoryModdedCommon);
            this.durabilityCopperShield = builder.comment("Copper Braced Shield Durability").translation("config.spartanshields.durabilityCopperShield").defineInRange("durabilityCopperShield", 400, 0, 100000);
            this.durabilityTinShield = builder.comment("Tin Braced Shield Durability").translation("config.spartanshields.durabilityTinShield").defineInRange("durabilityTinShield", 320, 0, 100000);
            this.durabilityBronzeShield = builder.comment("Bronze Plated Shield Durability").translation("config.spartanshields.durabilityBronzeShield").defineInRange("durabilityBronzeShield", 680, 0, 100000);
            this.durabilitySteelShield = builder.comment("Steel Plated Shield Durability").translation("config.spartanshields.durabilitySteelShield").defineInRange("durabilitySteelShield", 800, 0, 100000);
            this.durabilitySilverShield = builder.comment("Silver Gilded Shield Durability").translation("config.spartanshields.durabilitySilverShield").defineInRange("durabilitySilverShield", 216, 0, 100000);
            this.durabilityLeadShield = builder.comment("Lead Plated Shield Durability").translation("config.spartanshields.durabilityLeadShield").defineInRange("durabilityLeadShield", 480, 0, 100000);
            this.durabilityNickelShield = builder.comment("Nickel Braced Shield Durability").translation("config.spartanshields.durabilityNickelShield").defineInRange("durabilityNickelShield", 420, 0, 100000);
            this.durabilityInvarShield = builder.comment("Invar Plated Shield Durability").translation("config.spartanshields.durabilityInvarShield").defineInRange("durabilityInvarShield", 720, 0, 100000);
            this.durabilityConstantanShield = builder.comment("Constantan Plated Shield Durability").translation("config.spartanshields.durabilityConstantanShield").defineInRange("durabilityConstantanShield", 640, 0, 100000);
            this.durabilityPlatinumShield = builder.comment("Platinum Plated Shield Durability").translation("config.spartanshields.durabilityPlatinumShield").defineInRange("durabilityPlatinumShield", 1536, 0, 100000);
            this.durabilityElectrumShield = builder.comment("Electrum Plated Shield Durability").translation("config.spartanshields.durabilityElectrumShield").defineInRange("durabilityElectrumShield", 320, 0, 100000);
            builder.pop();
        }
    }
}

