/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item.crafting;

import com.google.gson.JsonObject;
import com.oblivioussp.spartanshields.init.ModRecipes;
import com.oblivioussp.spartanshields.util.Log;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PoweredShieldUpgradeRecipe
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    public static final NonNullSupplier<IllegalArgumentException> CAPABILITY_EXCEPTION = () -> new IllegalArgumentException("Capability must not be null!");
    private final ShapedRecipe internalRecipe;

    public PoweredShieldUpgradeRecipe(ShapedRecipe baseRecipe) {
        this.internalRecipe = baseRecipe;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.internalRecipe.func_77569_a(inv, worldIn);
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack resultStack = this.func_77571_b().func_77946_l();
        int feToTransfer = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            LazyOptional cap = stack.getCapability(CapabilityEnergy.ENERGY);
            if (!cap.isPresent()) continue;
            feToTransfer += ((IEnergyStorage)cap.orElseThrow(CAPABILITY_EXCEPTION)).getEnergyStored();
        }
        LazyOptional resultCap = resultStack.getCapability(CapabilityEnergy.ENERGY);
        int maxFE = ((IEnergyStorage)resultCap.orElseThrow(CAPABILITY_EXCEPTION)).getMaxEnergyStored();
        feToTransfer = MathHelper.func_76125_a((int)feToTransfer, (int)0, (int)maxFE);
        resultStack.func_196082_o().func_74768_a("Energy", feToTransfer);
        return resultStack;
    }

    public boolean func_194133_a(int width, int height) {
        return this.internalRecipe.func_194133_a(width, height);
    }

    public ItemStack func_77571_b() {
        return this.internalRecipe.func_77571_b();
    }

    public ResourceLocation func_199560_c() {
        return this.internalRecipe.func_199560_c();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.POWERED_SHIELD_UPGRADE;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return this.internalRecipe.func_179532_b((IInventory)inv);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.internalRecipe.func_192400_c();
    }

    public boolean func_192399_d() {
        return this.internalRecipe.func_192399_d();
    }

    public String func_193358_e() {
        return this.internalRecipe.func_193358_e();
    }

    public ItemStack func_222128_h() {
        return this.internalRecipe.func_222128_h();
    }

    public int getRecipeWidth() {
        return this.internalRecipe.getRecipeWidth();
    }

    public int getRecipeHeight() {
        return this.internalRecipe.getRecipeHeight();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PoweredShieldUpgradeRecipe> {
        public Serializer() {
            this.setRegistryName(new ResourceLocation("spartanshields", "upgrade_powered_shield"));
        }

        public PoweredShieldUpgradeRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new PoweredShieldUpgradeRecipe((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, json));
        }

        public PoweredShieldUpgradeRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            try {
                return new PoweredShieldUpgradeRecipe((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(recipeId, buffer));
            }
            catch (Exception e) {
                Log.error("Failed to read a Powered Shield Upgrade Recipe from a packet!");
                throw e;
            }
        }

        public void write(PacketBuffer buffer, PoweredShieldUpgradeRecipe recipe) {
            try {
                IRecipeSerializer.field_222157_a.func_199427_a_(buffer, (IRecipe)recipe.internalRecipe);
            }
            catch (Exception e) {
                Log.error("Failed to write a Powered Shield Upgrade Recipe to a packet!");
            }
        }
    }
}

