/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.Config;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import de.Whitedraco.switchbow.Initial;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class CraftingConfig {
    private static File ConfigPathCraftingRecipes = new File("config/SwitchBow/Crafting-Recipes");
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;

    static String[] getResourceListing(Class<Initial> clazz, String path) throws UnsupportedEncodingException, IOException, URISyntaxException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path)) continue;
                String entry = name.substring(path.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        Path pathjar = ((ModFileResourcePack)ResourcePackLoader.getResourcePackFor((String)"switchbow").get()).getModFile().getFilePath();
        JarFile jar = new JarFile(URLDecoder.decode(pathjar.toString(), "UTF-8"));
        Enumeration<JarEntry> entries = jar.entries();
        HashSet<String> result = new HashSet<String>();
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (!name.startsWith(path)) continue;
            String entry = name.substring(path.length());
            int checkSubdir = entry.indexOf("/");
            if (checkSubdir >= 0) {
                entry = entry.substring(0, checkSubdir);
            }
            result.add(entry);
        }
        return result.toArray(new String[result.size()]);
    }

    public static void writeConfigCrafting() throws IOException, URISyntaxException {
        String[] fileNames = CraftingConfig.getResourceListing(Initial.class, "assets/switchbow/recipes_template/");
        for (int i = 0; i < fileNames.length; ++i) {
            if (!"json".equals(FilenameUtils.getExtension((String)fileNames[i]))) continue;
            String recipeName = fileNames[i];
            InputStream reader = Initial.class.getResourceAsStream("/assets/switchbow/recipes_template/" + recipeName);
            CraftingConfig.copy(reader, "config/SwitchBow/Crafting-Recipes/" + recipeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readCraftingConfig(RecipeManager recipeManager) throws IOException {
        Iterator iterator = Files.walk(ConfigPathCraftingRecipes.toPath(), new FileVisitOption[0]).iterator();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        while (iterator.hasNext()) {
            Path path1 = (Path)iterator.next();
            if (!"json".equals(FilenameUtils.getExtension((String)path1.toString()))) continue;
            Path path2 = ConfigPathCraftingRecipes.toPath().relativize(path1);
            String s = FilenameUtils.removeExtension((String)path2.toString()).replaceAll("\\\\", "/");
            ResourceLocation resourcelocation = new ResourceLocation("switchbow".toLowerCase(), s);
            BufferedReader bufferedreader = null;
            try {
                try {
                    bufferedreader = Files.newBufferedReader(path1);
                    JsonReader jsonreader = new JsonReader((Reader)bufferedreader);
                    jsonreader.setLenient(false);
                    JsonObject ob = (JsonObject)gson.getAdapter(JsonObject.class).read(jsonreader);
                    IRecipe recipe = (IRecipe)CraftingConfig.parseRecipeJson(ob, resourcelocation);
                    if (recipe == null) continue;
                    recipeManager.func_199509_a(recipe);
                }
                catch (JsonParseException jsonparseexception) {
                    System.out.println("Parsing error loading recipe " + resourcelocation);
                    System.out.println(jsonparseexception.getLocalizedMessage());
                }
                catch (IOException ioexception) {
                    System.out.println("Couldn't read recipe " + resourcelocation + " from " + path1);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)bufferedreader);
            }
        }
    }

    private static Object parseRecipeJson(JsonObject fromJson, ResourceLocation s2) {
        String s = JsonUtils.func_151200_h((JsonObject)fromJson, (String)"type");
        String activ = JsonUtils.func_151200_h((JsonObject)fromJson, (String)"activ");
        if (activ.equals("false")) {
            return null;
        }
        if (s.contains("crafting_shaped")) {
            ShapedRecipe recipe = CraftingConfig.shapedrecipe_read(s2, fromJson);
            return recipe;
        }
        if (s.contains("crafting_shapeless")) {
            ShapelessRecipe recipe = CraftingConfig.shapelessrecipe_read(s2, fromJson);
            return recipe;
        }
        throw new JsonSyntaxException("Invalid or unsupported recipe type '" + s + "'");
    }

    public static boolean copy(InputStream source, String destination) {
        boolean succeess = true;
        File tester = new File(destination);
        try {
            if (!tester.exists() && source != null) {
                System.out.println("Copying Recipe ->" + source + "\n\tto ->" + destination);
                Files.copy(source, Paths.get(destination, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            succeess = false;
        }
        return succeess;
    }

    public static ShapedRecipe shapedrecipe_read(ResourceLocation recipeId, JsonObject json) {
        String s = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        Map<String, Ingredient> map = CraftingConfig.shapedrecipe_deserializeKey(JsonUtils.func_152754_s((JsonObject)json, (String)"key"));
        String[] astring = CraftingConfig.shapedrecipe_shrink(CraftingConfig.shapedrecipe_patternFromJson(JsonUtils.func_151214_t((JsonObject)json, (String)"pattern")));
        int i = astring[0].length();
        int j = astring.length;
        NonNullList<Ingredient> nonnulllist = CraftingConfig.shapedrecipe_deserializeIngredients(astring, map, i, j);
        ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"));
        return new ShapedRecipe(recipeId, s, i, j, nonnulllist, itemstack);
    }

    private static Map<String, Ingredient> shapedrecipe_deserializeKey(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    static String[] shapedrecipe_shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, CraftingConfig.shapedrecipe_firstNonSpace(s));
            int j1 = CraftingConfig.shapedrecipe_lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int shapedrecipe_firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int shapedrecipe_lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] shapedrecipe_patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JsonUtils.func_151206_a((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static NonNullList<Ingredient> shapedrecipe_deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    public static ShapelessRecipe shapelessrecipe_read(ResourceLocation recipeId, JsonObject json) {
        String s = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> nonnulllist = CraftingConfig.shapelessrecipe_readIngredients(JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (nonnulllist.size() > MAX_WIDTH * MAX_HEIGHT) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is " + MAX_WIDTH * MAX_HEIGHT);
        }
        ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"));
        return new ShapelessRecipe(recipeId, s, itemstack, nonnulllist);
    }

    private static NonNullList<Ingredient> shapelessrecipe_readIngredients(JsonArray p_199568_0_) {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (int i = 0; i < p_199568_0_.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)p_199568_0_.get(i));
            if (ingredient.func_203189_d()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public static File getPath() {
        return ConfigPathCraftingRecipes;
    }
}

