/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.entity.arrow;

import de.Whitedraco.switchbow.EntityInit;
import de.Whitedraco.switchbow.entity.EntityArrowBase;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityArrowFirework
extends EntityArrowBase {
    private int lifetime;
    private static final DataParameter<ItemStack> FIREWORK_ITEM = EntityDataManager.func_187226_a(EntityFireworkRocket.class, (DataSerializer)DataSerializers.field_187196_f);
    private boolean exploding = false;

    public EntityArrowFirework(World worldIn) {
        super(EntityInit.TypeEntityArrowFirework, worldIn);
    }

    public EntityArrowFirework(World worldIn, double x, double y, double z, ItemStack givenItem) {
        super(EntityInit.TypeEntityArrowFirework, worldIn, x, y, z);
        int i = 1;
        if (givenItem != null && givenItem.func_77942_o()) {
            this.field_70180_af.func_187227_b(FIREWORK_ITEM, (Object)givenItem);
            NBTTagCompound nbttagcompound = givenItem.func_77978_p();
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("Fireworks");
            i += nbttagcompound1.func_74771_c("Flight");
            if (!nbttagcompound1.func_150295_c("Explosions", 10).isEmpty()) {
                this.exploding = true;
            }
        }
        this.lifetime = 10 * i + this.field_70146_Z.nextInt(5) + this.field_70146_Z.nextInt(6);
    }

    public EntityArrowFirework(World worldIn, EntityLivingBase shooter, ItemStack givenItem) {
        super(EntityInit.TypeEntityArrowFirework, worldIn, shooter);
        int i = 1;
        if (givenItem != null && givenItem.func_77942_o()) {
            this.field_70180_af.func_187227_b(FIREWORK_ITEM, (Object)givenItem);
            NBTTagCompound nbttagcompound = givenItem.func_77978_p();
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("Fireworks");
            i += nbttagcompound1.func_74771_c("Flight");
            if (!nbttagcompound1.func_150295_c("Explosions", 10).isEmpty()) {
                this.exploding = true;
            }
        }
        this.lifetime = 10 * i + this.field_70146_Z.nextInt(5) + this.field_70146_Z.nextInt(6);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FIREWORK_ITEM, (Object)ItemStack.field_190927_a);
        super.func_70088_a();
    }

    @Override
    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        IBlockState iblockstate;
        super.func_70030_z();
        boolean flag = this.func_203047_q();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f))).isAir((IBlockReader)this.field_70170_p, blockpos) || flag || (voxelshape = iblockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.field_70254_i && !flag) {
            this.arrowHitGround(new BlockPos((Entity)this));
            if (this.field_195056_av != iblockstate && this.field_70170_p.func_195586_b((Entity)null, this.func_174813_aQ().func_186662_g(0.05))) {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            } else {
                this.func_203048_f();
            }
            ++this.field_184552_b;
        } else {
            Entity entity;
            this.field_184552_b = 0;
            ++this.field_70257_an;
            this.detectinAir();
            Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_200259_a(vec3d, vec3d1, RayTraceFluidMode.NEVER, true, false);
            vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            if ((entity = this.func_184551_a(vec3d, vec3d1)) != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                Entity entity1 = this.func_212360_k();
                if (entity1 instanceof EntityPlayer && !((EntityPlayer)entity1).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null && !flag && !ForgeEventFactory.onProjectileImpact((EntityArrow)this, (RayTraceResult)raytraceresult)) {
                this.func_184549_a(raytraceresult);
                this.field_70160_al = true;
            }
            if (this.func_70241_g()) {
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197629_v, this.field_70165_t + this.field_70159_w * (double)j / 4.0, this.field_70163_u + this.field_70181_x * (double)j / 4.0, this.field_70161_v + this.field_70179_y * (double)j / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
                }
            }
            this.particleOnFlyArrow();
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-this.field_70159_w), (double)(-this.field_70179_y)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f3) * 57.2957763671875);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f4 = 0.99f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197629_v, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                if (!this.underwater) {
                    f4 = this.func_203044_p();
                }
            }
            this.field_70159_w *= (double)f4;
            this.field_70181_x *= (double)f4;
            this.field_70179_y *= (double)f4;
            if (!this.func_189652_ae() && !flag) {
                if (this.field_70257_an >= this.lifetime) {
                    if (!this.exploding) {
                        this.field_70181_x -= (double)0.05f;
                    } else {
                        this.explosion();
                    }
                } else {
                    this.field_70181_x -= 1.0E-5;
                }
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    private void explosion() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)17);
        this.func_70106_y();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 17 && this.field_70170_p.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.field_70180_af.func_187225_a(FIREWORK_ITEM);
            NBTTagCompound nbttagcompound = null;
            if (itemstack != null && itemstack.func_77942_o()) {
                nbttagcompound = itemstack.func_77978_p().func_74775_l("Fireworks");
            }
            this.field_70170_p.func_92088_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, nbttagcompound);
        }
        super.func_70103_a(id);
    }

    @Override
    protected void arrowHitGround(BlockPos blockpos) {
        if (this.field_70173_aa <= this.lifetime && this.exploding) {
            this.explosion();
            this.AOEEffekt(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
        if (this.field_70173_aa <= this.lifetime && this.exploding) {
            this.explosion();
            this.AOEEffekt(living.field_70165_t, living.field_70163_u, living.field_70161_v);
        }
        this.func_70106_y();
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("LifeTime", this.lifetime);
        ItemStack itemstack = (ItemStack)this.field_70180_af.func_187225_a(FIREWORK_ITEM);
        if (!itemstack.func_190926_b()) {
            compound.func_74782_a("FireworksItem", (INBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74757_a("exploding", this.exploding);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        ItemStack itemstack;
        super.func_70037_a(compound);
        this.lifetime = compound.func_74762_e("LifeTime");
        NBTTagCompound nbttagcompound = compound.func_74775_l("FireworksItem");
        if (nbttagcompound != null && !(itemstack = ItemStack.func_199557_a((NBTTagCompound)nbttagcompound)).func_190926_b()) {
            this.field_70180_af.func_187227_b(FIREWORK_ITEM, (Object)itemstack);
        }
        this.exploding = compound.func_74767_n("exploding");
    }

    @Override
    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)Items.field_151032_g);
    }

    @Override
    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == EntityArrow.PickupStatus.ALLOWED || this.field_70251_a == EntityArrow.PickupStatus.CREATIVE_ONLY && entityIn.func_184812_l_();
            if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED && !entityIn.field_71071_by.func_70441_a(this.func_184550_j())) {
                flag = false;
            }
            if (flag) {
                this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    @Override
    public void setUnderwatertotrue() {
        this.underwater = true;
    }

    public void func_184547_a(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            // empty if block
        }
    }

    private void AOEEffekt(double posx, double posy, double posz) {
        double Umkreis = 1.5;
        List Mobliste = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(posx - Umkreis, posy - 1.5, posz - Umkreis, posx + Umkreis, posy + 1.5, posz + Umkreis));
        if (Mobliste.size() > 0) {
            for (int a = 0; a < Mobliste.size(); ++a) {
                EntityLivingBase Mob = (EntityLivingBase)Mobliste.get(a);
                DamageSource damagesource = DamageSource.func_76353_a((EntityArrow)this, (Entity)this.getShootingEntity());
                Mob.func_70097_a(damagesource, 5.0f);
            }
        }
        this.func_70106_y();
    }
}

