/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.entity.arrow;

import de.Whitedraco.switchbow.EntityInit;
import de.Whitedraco.switchbow.Initial;
import de.Whitedraco.switchbow.ItemInit;
import de.Whitedraco.switchbow.entity.EntityArrowBase;
import de.Whitedraco.switchbow.proxy.packets.ParticleWaterDropPacket;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityArrowSprinkler
extends EntityArrowBase {
    public static final Predicate<EntityLivingBase> WATER_SENSITIVE = EntityArrowSprinkler::isWaterSensitiveEntity;

    public EntityArrowSprinkler(World worldIn) {
        super(EntityInit.TypeEntityArrowSprinkler, worldIn);
    }

    public EntityArrowSprinkler(World worldIn, double x, double y, double z) {
        super(EntityInit.TypeEntityArrowSprinkler, worldIn, x, y, z);
    }

    public EntityArrowSprinkler(World worldIn, EntityLivingBase shooter) {
        super(EntityInit.TypeEntityArrowSprinkler, worldIn, shooter);
    }

    @Override
    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)ItemInit.ArrowSprinkler);
    }

    protected void func_184548_a(EntityLivingBase living) {
        BlockPos blockpos = living.func_180425_c().func_177984_a();
        this.extinguishFireswithNeighbor(blockpos);
        this.extinguishFireswithNeighbor(blockpos.func_177978_c());
        this.extinguishFireswithNeighbor(blockpos.func_177974_f());
        this.extinguishFireswithNeighbor(blockpos.func_177976_e());
        this.extinguishFireswithNeighbor(blockpos.func_177968_d());
        this.extinguishFireswithNeighbor(blockpos.func_177984_a());
        this.extinguishFireswithNeighbor(blockpos.func_177977_b());
        this.applyWater();
    }

    private void extinguishFires(BlockPos pos) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab) {
                this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150478_aa) {
                this.field_70170_p.func_175655_b(pos, true);
            }
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_196591_bQ) {
                this.field_70170_p.func_175655_b(pos, true);
            }
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l && this.field_70170_p.func_180495_p(pos).func_185917_h()) {
                this.field_70170_p.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
            }
            for (int i = 0; i < 8; ++i) {
                Initial.network.send(PacketDistributor.ALL.noArg(), (Object)new ParticleWaterDropPacket((double)pos.func_177958_n() - 0.5 + Math.random(), (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() - 0.5 + Math.random(), 0.0, 0.0, 0.0));
            }
        }
    }

    private void applyWater() {
        List list2;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.5, 3.0, 4.5);
        List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, axisalignedbb, WATER_SENSITIVE);
        if (!list.isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                double d0 = this.func_70068_e((Entity)entitylivingbase);
                if (!(d0 < 16.0) || !EntityArrowSprinkler.isWaterSensitiveEntity(entitylivingbase)) continue;
                entitylivingbase.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
        if (!(list2 = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb)).isEmpty()) {
            for (EntityLivingBase entitylivingbase : list2) {
                double d0 = this.func_70068_e((Entity)entitylivingbase);
                if (!(d0 < 16.0) || !entitylivingbase.func_70027_ad()) continue;
                entitylivingbase.func_70066_B();
            }
        }
    }

    private static boolean isWaterSensitiveEntity(EntityLivingBase p_190544_0_) {
        return p_190544_0_ instanceof EntityEnderman || p_190544_0_ instanceof EntityBlaze;
    }

    @Override
    protected void arrowHitGround(BlockPos blockpos) {
        blockpos = new BlockPos(this.field_145791_d, this.field_145792_e + 1, this.field_145789_f);
        this.extinguishFireswithNeighbor(blockpos);
        this.extinguishFireswithNeighbor(blockpos.func_177978_c());
        this.extinguishFireswithNeighbor(blockpos.func_177974_f());
        this.extinguishFireswithNeighbor(blockpos.func_177976_e());
        this.extinguishFireswithNeighbor(blockpos.func_177968_d());
        this.extinguishFireswithNeighbor(blockpos.func_177984_a());
        this.extinguishFireswithNeighbor(blockpos.func_177977_b());
        this.applyWater();
        this.func_70106_y();
    }

    private void extinguishFireswithNeighbor(BlockPos blockpos) {
        this.extinguishFires(blockpos);
        this.extinguishFires(blockpos.func_177984_a());
        this.extinguishFires(blockpos.func_177977_b());
        this.extinguishFires(blockpos.func_177978_c());
        this.extinguishFires(blockpos.func_177974_f());
        this.extinguishFires(blockpos.func_177968_d());
        this.extinguishFires(blockpos.func_177976_e());
    }
}

