/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.entity.arrow;

import de.Whitedraco.switchbow.EntityInit;
import de.Whitedraco.switchbow.entity.EntityArrowBase;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityArrowTriple
extends EntityArrowBase {
    float offset = 7.0f;
    private boolean spawn = true;
    private float velocity;
    private float inaccuracy;
    private float pitch;
    private float yaw;

    public EntityArrowTriple(World worldIn) {
        super(EntityInit.TypeEntityArrowTriple, worldIn);
    }

    public EntityArrowTriple(World worldIn, double x, double y, double z) {
        super(EntityInit.TypeEntityArrowTriple, worldIn, x, y, z);
    }

    public EntityArrowTriple(World worldIn, EntityLivingBase shooter) {
        super(EntityInit.TypeEntityArrowTriple, worldIn, shooter);
    }

    @Override
    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)Items.field_151032_g);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.spawn) {
            this.generateArrow(this.offset);
            this.generateArrow(-this.offset);
            this.spawn = false;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("spawn", this.spawn);
        compound.func_74776_a("pitch", this.pitch);
        compound.func_74776_a("yaw", this.yaw);
        compound.func_74776_a("velocity", this.velocity);
        compound.func_74776_a("inaccuracy", this.inaccuracy);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.spawn = compound.func_74767_n("spawn");
        this.pitch = compound.func_74760_g("pitch");
        this.yaw = compound.func_74760_g("yaw");
        this.velocity = compound.func_74760_g("velocity");
        this.inaccuracy = compound.func_74760_g("inaccuracy");
    }

    public void generateArrow(float corner) {
        EntityTippedArrow generateArrow = new EntityTippedArrow(this.field_70170_p);
        generateArrow.func_184555_a(new ItemStack((IItemProvider)Items.field_151032_g, 1));
        generateArrow.field_70250_c = this.field_70250_c;
        float yawi = this.yaw + corner;
        generateArrow.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.pitch, this.pitch);
        generateArrow.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = -MathHelper.func_76126_a((float)(yawi * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(this.pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yawi * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.pitch * ((float)Math.PI / 180)));
        generateArrow.func_70186_c((double)f, (double)f1, (double)f2, this.velocity, this.inaccuracy);
        if (generateArrow.field_70250_c != null) {
            generateArrow.field_70159_w += this.getShootingEntity((UUID)generateArrow.field_70250_c).field_70159_w;
            generateArrow.field_70179_y += this.getShootingEntity((UUID)generateArrow.field_70250_c).field_70179_y;
        }
        generateArrow.func_70243_d(this.func_70241_g());
        generateArrow.func_70239_b(this.func_70242_d());
        generateArrow.field_70251_a = this.field_70251_a;
        if (this.func_70027_ad()) {
            generateArrow.func_70015_d(100);
        }
        if (this.getEntityData().func_74764_b("NoGravity")) {
            generateArrow.getEntityData().func_74768_a("NoGravity", 70);
        }
        this.field_70170_p.func_72838_d((Entity)generateArrow);
    }

    public void func_184547_a(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    @Nullable
    public Entity getShootingEntity(UUID id) {
        return id != null && this.field_70170_p instanceof WorldServer ? ((WorldServer)this.field_70170_p).func_175733_a(id) : null;
    }
}

