/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.Config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import de.Whitedraco.switchbow.Initial;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class CraftingConfig {
    private static File ConfigPathCraftingRecipes = new File("config/SwitchBow/Crafting-Recipes");
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;

    static String[] getResourceListing(Class<Initial> clazz, String path) throws UnsupportedEncodingException, IOException, URISyntaxException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path)) continue;
                String entry = name.substring(path.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        Path pathjar = ((ModFileResourcePack)ResourcePackLoader.getResourcePackFor((String)"switchbow").get()).getModFile().getFilePath();
        JarFile jar = new JarFile(URLDecoder.decode(pathjar.toString(), "UTF-8"));
        Enumeration<JarEntry> entries = jar.entries();
        HashSet<String> result = new HashSet<String>();
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (!name.startsWith(path)) continue;
            String entry = name.substring(path.length());
            int checkSubdir = entry.indexOf("/");
            if (checkSubdir >= 0) {
                entry = entry.substring(0, checkSubdir);
            }
            result.add(entry);
        }
        return result.toArray(new String[result.size()]);
    }

    public static void writeConfigCrafting() throws IOException, URISyntaxException {
        String[] fileNames = CraftingConfig.getResourceListing(Initial.class, "assets/switchbow/recipes_template/");
        for (int i = 0; i < fileNames.length; ++i) {
            if (!"json".equals(FilenameUtils.getExtension((String)fileNames[i]))) continue;
            String recipeName = fileNames[i];
            InputStream reader = Initial.class.getResourceAsStream("/assets/switchbow/recipes_template/" + recipeName);
            CraftingConfig.copy(reader, "config/SwitchBow/Crafting-Recipes/" + recipeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readCraftingConfig(RecipeManager recipeManager) throws IOException {
        Iterator iterator = Files.walk(ConfigPathCraftingRecipes.toPath(), new FileVisitOption[0]).iterator();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        while (iterator.hasNext()) {
            Path path1 = (Path)iterator.next();
            if (!"json".equals(FilenameUtils.getExtension((String)path1.toString()))) continue;
            Path path2 = ConfigPathCraftingRecipes.toPath().relativize(path1);
            String s = FilenameUtils.removeExtension((String)path2.toString()).replaceAll("\\\\", "/");
            ResourceLocation resourcelocation = new ResourceLocation("switchbow".toLowerCase(), s);
            BufferedReader bufferedreader = null;
            try {
                try {
                    bufferedreader = Files.newBufferedReader(path1);
                    JsonReader jsonreader = new JsonReader((Reader)bufferedreader);
                    jsonreader.setLenient(false);
                    JsonObject ob = (JsonObject)gson.getAdapter(JsonObject.class).read(jsonreader);
                    IRecipe<?> recipe = CraftingConfig.parseRecipeJson(ob, resourcelocation);
                    if (recipe != null) continue;
                }
                catch (JsonParseException jsonparseexception) {
                    System.out.println("Parsing error loading recipe " + resourcelocation);
                    System.out.println(jsonparseexception.getLocalizedMessage());
                }
                catch (IOException ioexception) {
                    System.out.println("Couldn't read recipe " + resourcelocation + " from " + path1);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)bufferedreader);
            }
        }
    }

    private static IRecipe<?> parseRecipeJson(JsonObject fromJson, ResourceLocation s2) {
        String activ = JSONUtils.func_151200_h((JsonObject)fromJson, (String)"activ");
        if (activ.equals("false")) {
            return null;
        }
        return RecipeManager.func_215377_a((ResourceLocation)s2, (JsonObject)fromJson);
    }

    public static boolean copy(InputStream source, String destination) {
        boolean succeess = true;
        File tester = new File(destination);
        try {
            if (!tester.exists() && source != null) {
                System.out.println("Copying Recipe ->" + source + "\n\tto ->" + destination);
                Files.copy(source, Paths.get(destination, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            succeess = false;
        }
        return succeess;
    }

    public static File getPath() {
        return ConfigPathCraftingRecipes;
    }
}

