/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.entity;

import de.Whitedraco.switchbow.Config.SwitchBowConfig;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnGlobalEntityPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityLightningBoltSwitchBow
extends LightningBoltEntity {
    private int lightningState;
    public long field_70264_a;
    private int boltLivingTime;
    private final boolean effectOnly;
    @Nullable
    private ServerPlayerEntity caster;

    public EntityLightningBoltSwitchBow(World worldIn, double x, double y, double z, boolean effectOnlyIn) {
        super(worldIn, x, y, z, true);
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.lightningState = 2;
        this.field_70264_a = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        this.effectOnly = effectOnlyIn;
        Difficulty difficulty = worldIn.func_175659_aa();
        if ((difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) && SwitchBowConfig.spawnFirewithLightning.isData()) {
            this.igniteBlocks(4);
        }
    }

    public void func_70071_h_() {
        super.func_70030_z();
        if (this.lightningState == 2) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.field_70264_a = this.field_70146_Z.nextLong();
                this.igniteBlocks(0);
            }
        }
        if (this.lightningState >= 0) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175702_c(2);
            } else {
                List list = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.field_70165_t - 3.0, this.field_70163_u - 3.0, this.field_70161_v - 3.0, this.field_70165_t + 3.0, this.field_70163_u + 6.0 + 3.0, this.field_70161_v + 3.0), Entity::func_70089_S);
                for (Entity entity : list) {
                    if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBoltEntity)this)) continue;
                    entity.func_70077_a((LightningBoltEntity)this);
                }
                if (this.caster != null) {
                    CriteriaTriggers.field_204812_E.func_204814_a(this.caster, (Collection)list);
                }
            }
        }
    }

    private void igniteBlocks(int extraIgnitions) {
        if (!this.effectOnly && !this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223598_a) && SwitchBowConfig.spawnFirewithLightning.isData()) {
            BlockState blockstate = Blocks.field_150480_ab.func_176223_P();
            BlockPos blockpos = new BlockPos((Entity)this);
            if (this.field_70170_p.func_180495_p(blockpos).func_196958_f() && blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos)) {
                this.field_70170_p.func_175656_a(blockpos, blockstate);
            }
            for (int i = 0; i < extraIgnitions; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                if (!this.field_70170_p.func_180495_p(blockpos1).func_196958_f() || !blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos1)) continue;
                this.field_70170_p.func_175656_a(blockpos1, blockstate);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * EntityLightningBoltSwitchBow.func_184183_bd();
        return distance < d0 * d0;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnGlobalEntityPacket((Entity)this);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.WEATHER;
    }

    public void func_204809_d(@Nullable ServerPlayerEntity p_204809_1_) {
        this.caster = p_204809_1_;
    }
}

