/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.block;

import com.mojang.authlib.GameProfile;
import de.Whitedraco.switchbow.tileentity.TileEntityArrowDispenser;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockArrowDispenser
extends ContainerBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.field_208197_x;
    private static final Map<Item, IDispenseItemBehavior> DISPENSE_BEHAVIOR_REGISTRY = (Map)Util.func_200696_a((Object)new Object2ObjectOpenHashMap(), p_212564_0_ -> p_212564_0_.defaultReturnValue((Object)new DefaultDispenseItemBehavior()));
    private Random rand = new Random();
    private static Block.Properties prop = Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200942_a();
    protected static final VoxelShape AABB_BLOCK = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockArrowDispenser(String Name) {
        super(prop);
        this.setRegistryName(new ResourceLocation("switchbow", Name));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB_BLOCK;
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 4;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB_BLOCK;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityArrowDispenser) {
            TileEntityArrowDispenser tet = (TileEntityArrowDispenser)te;
            tet.setCount(9);
            tet.setShootangle(45.5f);
            tet.setRange(0.8f);
            tet.setCanshoot(false);
            worldIn.func_184138_a(pos, (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 3);
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, TRIGGERED, WATERLOGGED});
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityArrowDispenser();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_184614_ca() != ItemStack.field_190927_a && player.func_184614_ca().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA)) {
            this.dispense(worldIn, pos);
            return ActionResultType.SUCCESS;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        ServerPlayerEntity playermp = (ServerPlayerEntity)player;
        if (tileentity instanceof TileEntityArrowDispenser) {
            TileEntityArrowDispenser arrowDispenser = (TileEntityArrowDispenser)tileentity;
            NetworkHooks.openGui((ServerPlayerEntity)playermp, (INamedContainerProvider)arrowDispenser, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    private boolean shooting(World worldIn, BlockPos pos, TileEntityArrowDispenser TileEntityArrowDispenser2) {
        int i = TileEntityArrowDispenser2.getDispenseSlot();
        if (i < 0) {
            worldIn.func_217379_c(1001, pos, 0);
            return false;
        }
        ItemStack itemstack = TileEntityArrowDispenser2.func_70301_a(i);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockState block = worldIn.func_180495_p(pos);
        Direction facing = null;
        if (block.func_177230_c() instanceof BlockArrowDispenser) {
            facing = ((Direction)block.func_177229_b((IProperty)FACING)).func_176734_d();
        }
        float shootangle = TileEntityArrowDispenser2.getShootangle();
        float range = TileEntityArrowDispenser2.getRange();
        float k = 0.0f;
        double posx = 0.0;
        double posz = 0.0;
        if (facing.equals((Object)Direction.SOUTH)) {
            k = 180.0f;
            posx = (double)x + 0.5;
            posz = (double)z - 0.1;
        }
        if (facing.equals((Object)Direction.WEST)) {
            k = -90.0f;
            posx = (double)x + 1.1;
            posz = (double)z + 0.5;
        }
        if (facing.equals((Object)Direction.NORTH)) {
            k = 0.0f;
            posx = (double)x + 0.5;
            posz = (double)z + 1.1;
        }
        if (facing.equals((Object)Direction.EAST)) {
            k = 90.0f;
            posx = (double)x - 0.1;
            posz = (double)z + 0.5;
        }
        double posy = (double)y + 0.8;
        float ran = 0.0f;
        float ran2 = 0.0f;
        float ran3 = 0.0f;
        boolean Rechnung1 = this.rand.nextBoolean();
        ran = (float)this.rand.nextInt(10) + this.rand.nextFloat();
        if (Rechnung1) {
            ran = k + ran;
        } else if (!Rechnung1) {
            ran = k - ran;
        }
        boolean Rechnung2 = this.rand.nextBoolean();
        ran2 = (float)this.rand.nextInt(5) + this.rand.nextFloat();
        if (Rechnung2) {
            ran2 = shootangle + ran2;
        } else if (!Rechnung2) {
            ran2 = shootangle - ran2;
        }
        boolean Rechnung3 = this.rand.nextBoolean();
        float Anzahl = (float)(this.rand.nextInt(100) + 1) / 1000.0f;
        if (Rechnung3) {
            ran3 = range + Anzahl;
        } else if (!Rechnung3) {
            ran3 = range - Anzahl;
        }
        ArrowItem itemarrow = (ArrowItem)(itemstack.func_77973_b() instanceof ArrowItem ? itemstack.func_77973_b() : Items.field_151032_g);
        FakePlayer fakeCannon = new FakePlayer((ServerWorld)worldIn, new GameProfile(UUID.fromString("7b00550d-f6d4-4bfe-95bd-d0ae9ffe0992"), "Arrowluncher"));
        fakeCannon.func_70107_b(posx, posy, posz);
        AbstractArrowEntity arrow = itemarrow.func_200887_a(worldIn, itemstack, (LivingEntity)fakeCannon);
        arrow.func_70107_b(posx, posy, posz);
        arrow.func_184547_a((Entity)fakeCannon, -ran2, ran, 0.0f, ran3 * 1.5f, 1.0f);
        arrow.func_70243_d(true);
        arrow.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
        arrow.field_70250_c = null;
        worldIn.func_217376_c((Entity)arrow);
        itemstack.func_190918_g(1);
        TileEntityArrowDispenser2.func_70299_a(i, itemstack.func_190916_E() <= 0 ? ItemStack.field_190927_a : itemstack);
        return true;
    }

    protected void dispense(World worldIn, BlockPos pos) {
        ProxyBlockSource blocksourceimpl = new ProxyBlockSource(worldIn, pos);
        TileEntityArrowDispenser TileEntityArrowLancher = (TileEntityArrowDispenser)blocksourceimpl.func_150835_j();
        if (TileEntityArrowLancher != null) {
            for (int a = 0; a < TileEntityArrowLancher.getCount() && this.shooting(worldIn, pos, TileEntityArrowLancher); ++a) {
            }
        }
    }

    protected IDispenseItemBehavior getBehavior(ItemStack stack) {
        return DISPENSE_BEHAVIOR_REGISTRY.get(stack.func_77973_b());
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        boolean flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(pos.func_177984_a());
        boolean flag1 = ((TileEntityArrowDispenser)worldIn.func_175625_s(pos)).isCanshoot();
        if (flag && !flag1) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
            ((TileEntityArrowDispenser)worldIn.func_175625_s(pos)).setCanshoot(true);
        } else if (!flag && flag1) {
            ((TileEntityArrowDispenser)worldIn.func_175625_s(pos)).setCanshoot(false);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!worldIn.field_72995_K) {
            this.dispense((World)worldIn, pos);
        }
        super.func_225534_a_(state, worldIn, pos, rand);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntityArrowDispenser) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityArrowDispenser)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }
}

