/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.entity.arrow;

import de.Whitedraco.switchbow.Config.ArrowConfig;
import de.Whitedraco.switchbow.EntityInit;
import de.Whitedraco.switchbow.entity.EntityArrowBase;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class EntityArrowTriple
extends EntityArrowBase {
    float offset = 7.0f;
    private boolean spawn = true;
    private float velocity;
    private float inaccuracy;
    private float pitch;
    private float yaw;
    private double damagesetter = ArrowConfig.DamageArrowTriple.getDoub();

    public EntityArrowTriple(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(EntityInit.TypeEntityArrowTriple, worldIn);
        this.func_70239_b(this.damagesetter);
    }

    public EntityArrowTriple(EntityType<? extends AbstractArrowEntity> arrow, World worldIn) {
        super(EntityInit.TypeEntityArrowTriple, worldIn);
        this.func_70239_b(this.damagesetter);
    }

    public EntityArrowTriple(World worldIn, double x, double y, double z) {
        super(EntityInit.TypeEntityArrowTriple, worldIn, x, y, z);
        this.func_70239_b(this.damagesetter);
    }

    public EntityArrowTriple(World worldIn, LivingEntity shooter) {
        super(EntityInit.TypeEntityArrowTriple, worldIn, shooter);
        this.func_70239_b(this.damagesetter);
    }

    @Override
    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)Items.field_151032_g);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.spawn) {
            this.generateArrow(this.offset);
            this.generateArrow(-this.offset);
            this.spawn = false;
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("spawn", this.spawn);
        compound.func_74776_a("pitch", this.pitch);
        compound.func_74776_a("yaw", this.yaw);
        compound.func_74776_a("velocity", this.velocity);
        compound.func_74776_a("inaccuracy", this.inaccuracy);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.spawn = compound.func_74767_n("spawn");
        this.pitch = compound.func_74760_g("pitch");
        this.yaw = compound.func_74760_g("yaw");
        this.velocity = compound.func_74760_g("velocity");
        this.inaccuracy = compound.func_74760_g("inaccuracy");
    }

    public void generateArrow(float corner) {
        AbstractArrowEntity generateArrow = (AbstractArrowEntity)EntityType.field_200790_d.func_200721_a(this.field_70170_p);
        generateArrow.field_70250_c = this.field_70250_c;
        float yawi = this.yaw + corner;
        generateArrow.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.pitch, this.pitch);
        generateArrow.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        float f = -MathHelper.func_76126_a((float)(yawi * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(this.pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yawi * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.pitch * ((float)Math.PI / 180)));
        generateArrow.func_70186_c((double)f, (double)f1, (double)f2, this.velocity, this.inaccuracy);
        if (generateArrow.field_70250_c != null) {
            generateArrow.func_213293_j(generateArrow.func_213322_ci().field_72450_a + this.getShootingEntity((UUID)generateArrow.field_70250_c).func_213322_ci().field_72450_a, generateArrow.func_213322_ci().field_72448_b, generateArrow.func_213322_ci().field_72449_c + this.getShootingEntity((UUID)generateArrow.field_70250_c).func_213322_ci().field_72449_c);
        }
        generateArrow.func_70243_d(this.func_70241_g());
        generateArrow.func_70239_b(this.func_70242_d());
        generateArrow.field_70251_a = this.field_70251_a;
        if (this.func_70027_ad()) {
            generateArrow.func_70015_d(100);
        }
        if (this.getPersistentData().func_74764_b("NoGravity")) {
            generateArrow.getPersistentData().func_74768_a("NoGravity", 70);
        }
        this.field_70170_p.func_217376_c((Entity)generateArrow);
    }

    public void func_184547_a(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        double motionY = this.func_213322_ci().field_72448_b;
        if (!shooter.field_70122_E) {
            motionY += shooter.func_213322_ci().field_72448_b;
        }
        this.func_213293_j(this.func_213322_ci().field_72450_a + shooter.func_213322_ci().field_72450_a, motionY, this.func_213322_ci().field_72449_c + shooter.func_213322_ci().field_72449_c);
    }

    @Nullable
    public Entity getShootingEntity(UUID id) {
        return id != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(id) : null;
    }
}

