/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.proxy.packets;

import de.Whitedraco.switchbow.Initial;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ParticleFirePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final double d0;
    private final double d1;
    private final double d2;
    private final double entityposx;
    private final double entityposy;
    private final int winkel;

    public ParticleFirePacket(double posX, double posY, double posZ, double d0, double d1, double d2, double entityx, double entityy, int winkel) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.d0 = d0;
        this.d1 = d1;
        this.d2 = d2;
        this.entityposx = entityx;
        this.entityposy = entityy;
        this.winkel = winkel;
    }

    public static void encode(ParticleFirePacket msg, PacketBuffer buf) {
        buf.writeDouble(msg.posX);
        buf.writeDouble(msg.posY);
        buf.writeDouble(msg.posZ);
        buf.writeDouble(msg.d0);
        buf.writeDouble(msg.d1);
        buf.writeDouble(msg.d2);
        buf.writeDouble(msg.entityposx);
        buf.writeDouble(msg.entityposy);
        buf.writeInt(msg.winkel);
    }

    public static ParticleFirePacket decode(PacketBuffer buf) {
        return new ParticleFirePacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readInt());
    }

    public static class Handler {
        public static void handle(ParticleFirePacket pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Initial.proxy.SpawnFireParticle(pkt.posX, pkt.posY, pkt.posZ, pkt.d0, pkt.d1, pkt.d2, pkt.entityposx, pkt.entityposy, pkt.winkel));
            ctx.get().setPacketHandled(true);
        }
    }
}

