/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.entity.arrow;

import de.Whitedraco.switchbow.Config.ArrowConfig;
import de.Whitedraco.switchbow.EntityInit;
import de.Whitedraco.switchbow.entity.EntityArrowBase;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class EntityArrowFirework
extends EntityArrowBase {
    private int lifetime;
    private static final DataParameter<ItemStack> FIREWORK_ITEM = EntityDataManager.func_187226_a(FireworkRocketEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private boolean exploding = false;
    private double damagesetter = ArrowConfig.DamageArrowFirework.getDoub();

    public EntityArrowFirework(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(EntityInit.TypeEntityArrowFirework, worldIn);
        this.func_70239_b(this.damagesetter);
    }

    public EntityArrowFirework(EntityType<? extends AbstractArrowEntity> arrow, World worldIn) {
        super(EntityInit.TypeEntityArrowFirework, worldIn);
        this.func_70239_b(this.damagesetter);
    }

    public EntityArrowFirework(World worldIn, double x, double y, double z, ItemStack givenItem) {
        super(EntityInit.TypeEntityArrowFirework, worldIn, x, y, z);
        int i = 1;
        if (givenItem != null && givenItem.func_77942_o()) {
            this.field_70180_af.func_187227_b(FIREWORK_ITEM, (Object)givenItem);
            CompoundNBT nbttagcompound = givenItem.func_77978_p();
            CompoundNBT nbttagcompound1 = nbttagcompound.func_74775_l("Fireworks");
            i += nbttagcompound1.func_74771_c("Flight");
            if (!nbttagcompound1.func_150295_c("Explosions", 10).isEmpty()) {
                this.exploding = true;
            }
        }
        this.func_70239_b(this.damagesetter);
        this.lifetime = 10 * i + this.field_70146_Z.nextInt(5) + this.field_70146_Z.nextInt(6);
    }

    public EntityArrowFirework(World worldIn, LivingEntity shooter, ItemStack givenItem) {
        super(EntityInit.TypeEntityArrowFirework, worldIn, shooter);
        int i = 1;
        if (givenItem != null && givenItem.func_77942_o()) {
            this.field_70180_af.func_187227_b(FIREWORK_ITEM, (Object)givenItem);
            CompoundNBT nbttagcompound = givenItem.func_77978_p();
            CompoundNBT nbttagcompound1 = nbttagcompound.func_74775_l("Fireworks");
            i += nbttagcompound1.func_74771_c("Flight");
            if (!nbttagcompound1.func_150295_c("Explosions", 10).isEmpty()) {
                this.exploding = true;
            }
        }
        this.func_70239_b(this.damagesetter);
        this.lifetime = 10 * i + this.field_70146_Z.nextInt(5) + this.field_70146_Z.nextInt(6);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FIREWORK_ITEM, (Object)ItemStack.field_190927_a);
        super.func_70088_a();
    }

    @Override
    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        super.func_70030_z();
        boolean flag = this.func_203047_q();
        Vector3d vec3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)EntityArrowFirework.func_213296_b((Vector3d)vec3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()))).isAir((IBlockReader)this.field_70170_p, blockpos) || flag || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()))) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.field_70254_i && !flag) {
            this.arrowHitGround(new BlockPos((IPosition)this));
            if (this.field_195056_av != blockstate && this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_186662_g(0.06))) {
                this.field_70254_i = false;
                this.func_213317_d(vec3d.func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
                this.field_70252_j = 0;
                this.ticksInAir = 0;
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70623_bb();
            }
            ++this.field_184552_b;
        } else {
            this.field_184552_b = 0;
            ++this.ticksInAir;
            this.detectinAir();
            Vector3d vec3d1 = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            Vector3d vec3d2 = vec3d1.func_178787_e(vec3d);
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d1, vec3d2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vec3d2 = raytraceresult.func_216347_e();
            }
            while (this.func_70089_S()) {
                EntityRayTraceResult entityraytraceresult = this.func_213866_a(vec3d1, vec3d2);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.func_234616_v_();
                    if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && !flag && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)raytraceresult)) {
                    this.onHit((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.func_213874_s() <= 0) break;
                raytraceresult = null;
            }
            vec3d = this.func_213322_ci();
            double d1 = vec3d.field_72450_a;
            double d2 = vec3d.field_72448_b;
            double d0 = vec3d.field_72449_c;
            if (this.func_70241_g()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + d1 * (double)i / 4.0, this.func_226278_cu_() + d2 * (double)i / 4.0, this.func_226281_cx_() + d0 * (double)i / 4.0, -d1, -d2 + 0.2, -d0);
                }
            }
            this.particleOnFlyArrow();
            this.func_70107_b(this.func_226277_ct_() + d1, this.func_226278_cu_() + d2, this.func_226281_cx_() + d0);
            float f4 = MathHelper.func_76133_a((double)EntityArrowFirework.func_213296_b((Vector3d)vec3d));
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-d1), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d2, (double)f4) * 57.2957763671875);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
            float f1 = 0.99f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197629_v, this.func_226277_ct_() - d1 * 0.25, this.func_226278_cu_() - d2 * 0.25, this.func_226281_cx_() - d0 * 0.25, d1, d2, d0);
                }
                if (!this.underwater) {
                    f1 = this.func_203044_p();
                }
            }
            this.func_213317_d(vec3d.func_186678_a((double)f1));
            if (!this.func_189652_ae() && !flag) {
                Vector3d vec3d3 = this.func_213322_ci();
                if (this.ticksInAir >= this.lifetime) {
                    if (!this.exploding) {
                        this.func_213293_j(vec3d3.field_72450_a, vec3d3.field_72448_b - (double)0.05f, vec3d3.field_72449_c);
                    } else {
                        this.explosion();
                    }
                } else {
                    this.func_213293_j(vec3d3.field_72450_a, vec3d3.field_72448_b - (double)1.0E-5f, vec3d3.field_72449_c);
                }
            }
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            this.func_145775_I();
        }
    }

    private void explosion() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)17);
        this.func_70106_y();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 17 && this.field_70170_p.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.field_70180_af.func_187225_a(FIREWORK_ITEM);
            CompoundNBT nbttagcompound = null;
            if (itemstack != null && itemstack.func_77942_o()) {
                nbttagcompound = itemstack.func_77978_p().func_74775_l("Fireworks");
            }
            this.field_70170_p.func_92088_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c, nbttagcompound);
        }
        super.func_70103_a(id);
    }

    @Override
    protected void arrowHitGround(BlockPos blockpos) {
        if (this.field_70173_aa <= this.lifetime && this.exploding) {
            this.explosion();
            this.AOEEffekt(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    protected void func_184548_a(LivingEntity living) {
        if (this.field_70173_aa <= this.lifetime && this.exploding) {
            this.explosion();
            this.AOEEffekt(living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_());
        }
        this.func_70106_y();
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("LifeTime", this.lifetime);
        ItemStack itemstack = (ItemStack)this.field_70180_af.func_187225_a(FIREWORK_ITEM);
        if (!itemstack.func_190926_b()) {
            compound.func_218657_a("FireworksItem", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74757_a("exploding", this.exploding);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        ItemStack itemstack;
        super.func_70037_a(compound);
        this.lifetime = compound.func_74762_e("LifeTime");
        CompoundNBT nbttagcompound = compound.func_74775_l("FireworksItem");
        if (nbttagcompound != null && !(itemstack = ItemStack.func_199557_a((CompoundNBT)nbttagcompound)).func_190926_b()) {
            this.field_70180_af.func_187227_b(FIREWORK_ITEM, (Object)itemstack);
        }
        this.exploding = compound.func_74767_n("exploding");
    }

    @Override
    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)Items.field_151032_g);
    }

    @Override
    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED || this.field_70251_a == AbstractArrowEntity.PickupStatus.CREATIVE_ONLY && entityIn.func_184812_l_();
            if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED && !entityIn.field_71071_by.func_70441_a(this.func_184550_j())) {
                flag = false;
            }
            if (flag) {
                this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    @Override
    public void setUnderwatertotrue() {
        this.underwater = true;
    }

    public void func_234612_a_(Entity shooter, float pitch, float yaw, float p_234612_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.func_213293_j(this.func_213322_ci().field_72450_a + shooter.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c + shooter.func_213322_ci().field_72449_c);
    }

    private void AOEEffekt(double posx, double posy, double posz) {
        double Umkreis = 1.5;
        List Mobliste = this.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(posx - Umkreis, posy - 1.5, posz - Umkreis, posx + Umkreis, posy + 1.5, posz + Umkreis));
        if (Mobliste.size() > 0) {
            for (int a = 0; a < Mobliste.size(); ++a) {
                LivingEntity Mob = (LivingEntity)Mobliste.get(a);
                DamageSource damagesource = DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this.func_234616_v_());
                Mob.func_70097_a(damagesource, 5.0f);
            }
        }
        this.func_70106_y();
    }
}

