/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.entity.arrow;

import de.Whitedraco.switchbow.Config.ArrowConfig;
import de.Whitedraco.switchbow.EntityInit;
import de.Whitedraco.switchbow.entity.EntityArrowBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class EntityArrowTriple
extends EntityArrowBase {
    float offset = 7.0f;
    private boolean spawn = true;
    private float velocity;
    private float inaccuracy;
    private float pitch;
    private float yaw;
    private double damagesetter = ArrowConfig.DamageArrowTriple.getDoub();

    public EntityArrowTriple(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(EntityInit.TypeEntityArrowTriple, worldIn);
        this.func_70239_b(this.damagesetter);
    }

    public EntityArrowTriple(EntityType<? extends AbstractArrowEntity> arrow, World worldIn) {
        super(EntityInit.TypeEntityArrowTriple, worldIn);
        this.func_70239_b(this.damagesetter);
    }

    public EntityArrowTriple(World worldIn, double x, double y, double z) {
        super(EntityInit.TypeEntityArrowTriple, worldIn, x, y, z);
        this.func_70239_b(this.damagesetter);
    }

    public EntityArrowTriple(World worldIn, LivingEntity shooter) {
        super(EntityInit.TypeEntityArrowTriple, worldIn, shooter);
        this.func_70239_b(this.damagesetter);
    }

    @Override
    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)Items.field_151032_g);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.spawn) {
            this.generateArrow(this.offset);
            this.generateArrow(-this.offset);
            this.spawn = false;
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("spawn", this.spawn);
        compound.func_74776_a("pitch", this.pitch);
        compound.func_74776_a("yaw", this.yaw);
        compound.func_74776_a("velocity", this.velocity);
        compound.func_74776_a("inaccuracy", this.inaccuracy);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.spawn = compound.func_74767_n("spawn");
        this.pitch = compound.func_74760_g("pitch");
        this.yaw = compound.func_74760_g("yaw");
        this.velocity = compound.func_74760_g("velocity");
        this.inaccuracy = compound.func_74760_g("inaccuracy");
    }

    public void generateArrow(float corner) {
        float yawi = this.yaw + corner;
        ArrowItem arrowitem = (ArrowItem)Items.field_151032_g;
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_70170_p));
        fakePlayer.func_70080_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_189653_aC().field_189982_i, this.func_189653_aC().field_189983_j);
        AbstractArrowEntity generateArrow = arrowitem.func_200887_a(this.field_70170_p, new ItemStack((IItemProvider)Items.field_151032_g), (LivingEntity)fakePlayer);
        generateArrow = this.customArrow(generateArrow);
        generateArrow.func_234612_a_((Entity)fakePlayer, this.pitch, yawi, 0.0f, this.velocity, this.inaccuracy);
        generateArrow.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        generateArrow.func_212361_a(this.func_234616_v_());
        generateArrow.func_70243_d(this.func_70241_g());
        generateArrow.func_70239_b(this.func_70242_d());
        generateArrow.field_70251_a = this.field_70251_a;
        if (this.func_70027_ad()) {
            generateArrow.func_70015_d(100);
        }
        if (this.getPersistentData().func_74764_b("NoGravity")) {
            generateArrow.getPersistentData().func_74768_a("NoGravity", 70);
        }
        this.field_70170_p.func_217376_c((Entity)generateArrow);
    }

    public void func_234612_a_(Entity p_234612_1_, float pitch, float yaw, float p_234612_4_, float velocity, float inaccuracy) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((pitch + p_234612_4_) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        Vector3d vector3d = p_234612_1_.func_213322_ci();
        this.func_213317_d(this.func_213322_ci().func_72441_c(vector3d.field_72450_a, p_234612_1_.func_233570_aj_() ? 0.0 : vector3d.field_72448_b, vector3d.field_72449_c));
    }

    public AbstractArrowEntity customArrow(AbstractArrowEntity arrow) {
        return arrow;
    }
}

