/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.renderer.living;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.Whitedraco.switchbow.entity.living.EntityLittleIronGolem;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelLittleIronGolem<T extends EntityLittleIronGolem>
extends SegmentedModel<T> {
    private final ModelRenderer ironGolemHead;
    private final ModelRenderer ironGolemBody;
    private final ModelRenderer ironGolemRightArm;
    private final ModelRenderer ironGolemLeftArm;
    private final ModelRenderer ironGolemLeftLeg;
    private final ModelRenderer ironGolemRightLeg;

    public ModelLittleIronGolem() {
        int i = 128;
        int j = 128;
        this.ironGolemHead = new ModelRenderer((Model)this).func_78787_b(128, 128);
        this.ironGolemHead.func_78793_a(0.0f, -7.0f, -2.0f);
        this.ironGolemHead.func_78784_a(0, 0).func_228301_a_(-4.0f, -12.0f, -5.5f, 8.0f, 10.0f, 8.0f, 0.0f);
        this.ironGolemHead.func_78784_a(24, 0).func_228301_a_(-1.0f, -5.0f, -7.5f, 2.0f, 4.0f, 2.0f, 0.0f);
        this.ironGolemBody = new ModelRenderer((Model)this).func_78787_b(128, 128);
        this.ironGolemBody.func_78793_a(0.0f, -7.0f, 0.0f);
        this.ironGolemBody.func_78784_a(0, 40).func_228301_a_(-9.0f, -2.0f, -6.0f, 18.0f, 12.0f, 11.0f, 0.0f);
        this.ironGolemBody.func_78784_a(0, 70).func_228301_a_(-4.5f, 10.0f, -3.0f, 9.0f, 5.0f, 6.0f, 0.5f);
        this.ironGolemRightArm = new ModelRenderer((Model)this).func_78787_b(128, 128);
        this.ironGolemRightArm.func_78793_a(0.0f, -7.0f, 0.0f);
        this.ironGolemRightArm.func_78784_a(60, 21).func_228301_a_(-13.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, 0.0f);
        this.ironGolemLeftArm = new ModelRenderer((Model)this).func_78787_b(128, 128);
        this.ironGolemLeftArm.func_78793_a(0.0f, -7.0f, 0.0f);
        this.ironGolemLeftArm.func_78784_a(60, 58).func_228301_a_(9.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, 0.0f);
        this.ironGolemLeftLeg = new ModelRenderer((Model)this, 0, 22).func_78787_b(128, 128);
        this.ironGolemLeftLeg.func_78793_a(-4.0f, 11.0f, 0.0f);
        this.ironGolemLeftLeg.func_78784_a(37, 0).func_228301_a_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, 0.0f);
        this.ironGolemRightLeg = new ModelRenderer((Model)this, 0, 22).func_78787_b(128, 128);
        this.ironGolemRightLeg.field_78809_i = true;
        this.ironGolemRightLeg.func_78784_a(60, 0).func_78793_a(5.0f, 11.0f, 0.0f);
        this.ironGolemRightLeg.func_228301_a_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, 0.0f);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.ironGolemHead, (Object)this.ironGolemBody, (Object)this.ironGolemLeftLeg, (Object)this.ironGolemRightLeg, (Object)this.ironGolemRightArm, (Object)this.ironGolemLeftArm);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStackIn.func_227861_a_(0.0, 1.5, 0.0);
        super.func_225598_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.ironGolemHead.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.ironGolemHead.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.ironGolemLeftLeg.field_78795_f = -1.5f * this.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
        this.ironGolemRightLeg.field_78795_f = 1.5f * this.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
        this.ironGolemLeftLeg.field_78796_g = 0.0f;
        this.ironGolemRightLeg.field_78796_g = 0.0f;
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        int i = ((EntityLittleIronGolem)((Object)entityIn)).func_70854_o();
        if (i > 0) {
            this.ironGolemRightArm.field_78795_f = -2.0f + 1.5f * this.triangleWave((float)i - partialTick, 10.0f);
            this.ironGolemLeftArm.field_78795_f = -2.0f + 1.5f * this.triangleWave((float)i - partialTick, 10.0f);
        } else {
            this.ironGolemRightArm.field_78795_f = (-0.2f + 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
            this.ironGolemLeftArm.field_78795_f = (-0.2f - 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
        }
    }

    private float triangleWave(float p_78172_1_, float p_78172_2_) {
        return (Math.abs(p_78172_1_ % p_78172_2_ - p_78172_2_ * 0.5f) - p_78172_2_ * 0.25f) / (p_78172_2_ * 0.25f);
    }
}

