/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealthmod;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.torocraft.torohealthmod.CommonProxy;
import net.torocraft.torohealthmod.config.ConfigurationHandler;
import net.torocraft.torohealthmod.gui.GuiEntityStatus;
import net.torocraft.torohealthmod.render.DamageParticle;

public class ClientProxy
extends CommonProxy {
    GuiEntityStatus entityStatusGUI;

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        this.entityStatusGUI = new GuiEntityStatus();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        MinecraftForge.EVENT_BUS.register((Object)this.entityStatusGUI);
    }

    @Override
    public void displayDamageDealt(EntityLivingBase entity) {
        int entityHealth;
        if (!entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!ConfigurationHandler.showDamageParticles) {
            return;
        }
        int currentHealth = (int)Math.ceil(entity.func_110143_aJ());
        if (entity.getEntityData().func_74764_b("health") && (entityHealth = ((NBTTagInt)entity.getEntityData().func_74781_a("health")).func_150287_d()) != currentHealth) {
            this.displayParticle((Entity)entity, entityHealth - currentHealth);
        }
        entity.getEntityData().func_74782_a("health", (NBTBase)new NBTTagInt(currentHealth));
    }

    private void displayParticle(Entity entity, int damage) {
        if (damage == 0) {
            return;
        }
        World world = entity.field_70170_p;
        double motionX = world.field_73012_v.nextGaussian() * 0.02;
        double motionY = 0.5;
        double motionZ = world.field_73012_v.nextGaussian() * 0.02;
        DamageParticle damageIndicator = new DamageParticle(damage, world, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v, motionX, motionY, motionZ);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)damageIndicator);
    }

    @Override
    public void setEntityInCrosshairs() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world = player.field_70170_p;
        EntityLivingBase entity = this.findEntityLookedAt((EntityPlayer)player, world);
        if (entity != null) {
            this.entityStatusGUI.setEntity(entity);
        }
    }

    private EntityLivingBase findEntityLookedAt(EntityPlayer player, World world) {
        BlockPos prevPos = null;
        for (double d = 0.0; d < 50.0; d += 1.0) {
            RayTraceResult rtr = player.func_174822_a(d, 1.0f);
            if (rtr == null) continue;
            BlockPos pos = new BlockPos(rtr.field_72307_f);
            if (prevPos != null && this.isSolidBlock(pos, prevPos)) {
                return null;
            }
            prevPos = pos;
            AxisAlignedBB scan = new AxisAlignedBB(pos);
            List entities = world.func_72839_b((Entity)player, scan);
            for (Entity entity : entities) {
                if (!(entity instanceof EntityLivingBase)) continue;
                return (EntityLivingBase)entity;
            }
        }
        return null;
    }

    private boolean isSolidBlock(BlockPos pos, BlockPos prevPos) {
        return prevPos.compareTo((Vec3i)pos) == 0;
    }
}

